/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.AnalysisEngineWrapper;
import com.ibm.ws.ffdc.FFDCHelper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class AnalysisEngineTool {
    private static FileInputStream fis = null;
    private static int readLineCount = 0;
    private static String databaseName = null;
    private static final String startHeader = "------Start";
    private static final String startCallStack = "Stack Dump = ";
    private static final String atString = "at ";
    private static final String exHeader = "Exception =";
    private static final String srcHeader = "Source =";
    private static final String prbHeader = "probeid =";
    private static int verbose = 0;
    private static String filename = null;
    private static boolean calledByDMTest = false;
    private static Vector vector = new Vector(100, 100);

    private static BufferedReader openFile() {
        BufferedReader bufferedReader = null;
        try {
            if (filename != null) {
                fis = new FileInputStream(filename);
                bufferedReader = new BufferedReader(new InputStreamReader(fis));
            }
        }
        catch (Exception exception) {
            AnalysisEngineTool.error("Error occured opening the file : " + filename);
            AnalysisEngineTool.error(exception.toString());
            System.exit(0);
        }
        return bufferedReader;
    }

    public static void closeFile(BufferedReader bufferedReader) {
        try {
            bufferedReader.close();
            fis.close();
        }
        catch (IOException iOException) {
            AnalysisEngineTool.error(iOException.toString());
        }
    }

    public static String readLine(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            AnalysisEngineTool.debug("debug read : " + ++readLineCount + " " + string);
            return string;
        }
        catch (IOException iOException) {
            AnalysisEngineTool.error(iOException.toString());
            return null;
        }
    }

    private static void usage(String string) {
        System.out.println(string);
        System.out.println("Usage : java -Djava.ext.dirs=<install_root>\\lib com.ibm.ws.ffdc.AnalysisEngineTool <install_root>\\logs\\ffdc\\<filename> <instal_root>\\properties\\logbr\\ffdc\\adv\\ffdcdb.xml");
        System.out.println("\t<install_root> - location of the websphere install");
        System.out.println("\t<filename> - name of the ffdc file which will be processed");
        System.out.println("\tAlternately, a different database can be specified for the last parameter");
    }

    private static void msg(String string) {
        if (verbose != 0) {
            System.out.println("***** " + string + " ******");
        }
    }

    private static void error(String string) {
        System.out.println("----- " + string + "------");
    }

    private static void debug(String string) {
        if (verbose == 2) {
            System.out.println("!!!!! " + string + " !!!!!");
        }
    }

    private static boolean parseParams(String[] stringArray) {
        switch (stringArray.length) {
            case 3: {
                if (stringArray[2].equalsIgnoreCase("verbose")) {
                    verbose = 1;
                }
                if (stringArray[2].equalsIgnoreCase("debug")) {
                    verbose = 2;
                }
                if (stringArray[2].equalsIgnoreCase("directives")) {
                    verbose = 1;
                }
            }
            case 2: {
                databaseName = !stringArray[1].equalsIgnoreCase("default") ? stringArray[1] : null;
            }
            case 1: {
                if (stringArray[0].indexOf("txt") == -1) {
                    AnalysisEngineTool.error("Filename specified is not a FFDC txt file: " + stringArray[0]);
                    return false;
                }
                filename = stringArray[0];
                break;
            }
            default: {
                AnalysisEngineTool.error("Wrong number of parameters specified");
                AnalysisEngineTool.usage("Number of parameter specified was : " + stringArray.length + ", should be at least 1");
                return false;
            }
        }
        return true;
    }

    private static String processHeader(String string) {
        AnalysisEngineTool.msg("This is the header : " + string);
        return string;
    }

    private static String processException(String string) {
        AnalysisEngineTool.msg("This is the exception : " + string);
        int n = 0;
        int n2 = 0;
        String string2 = " = ";
        int n3 = 58;
        String string3 = null;
        AnalysisEngineTool.debug("Start to look for the = sign");
        n = string.indexOf(string2);
        AnalysisEngineTool.debug("The value of the index is : " + n);
        if (n == -1) {
            AnalysisEngineTool.msg("Something seems wrong");
            return null;
        }
        AnalysisEngineTool.debug("The index value is : " + (n += string2.length()));
        n2 = string.indexOf(n3);
        if (n2 == -1) {
            n2 = string.length();
        }
        string3 = string.substring(n, n2);
        AnalysisEngineTool.debug("The exception name is : |" + string3 + '|');
        return string3;
    }

    private static String processExceptionHeader(String string) {
        AnalysisEngineTool.msg("Look for the exception in : " + string);
        int n = 0;
        String string2 = null;
        n = string.indexOf(exHeader);
        if (n != -1) {
            string2 = string.substring(n += exHeader.length());
        }
        return string2;
    }

    private static String processSourceHeader(String string) {
        AnalysisEngineTool.msg("Look for the Source in : " + string);
        int n = 0;
        String string2 = null;
        n = string.indexOf(srcHeader);
        if (n != -1) {
            string2 = string.substring(n += srcHeader.length());
        }
        return string2;
    }

    private static String processProbeHeader(String string) {
        AnalysisEngineTool.msg("Look for the Probe in : " + string);
        int n = 0;
        String string2 = null;
        n = string.indexOf(prbHeader);
        if (n != -1) {
            string2 = string.substring(n += prbHeader.length());
        }
        return string2;
    }

    private static String processMethodName(String string) {
        AnalysisEngineTool.debug("This is the method name : " + string);
        int n = 0;
        int n2 = 0;
        String string2 = null;
        n = string.indexOf(atString);
        if (n == -1) {
            return null;
        }
        n += atString.length();
        n2 = string.indexOf(40);
        if (n2 == -1) {
            n2 = string.length();
        }
        string2 = string.substring(n, n2);
        AnalysisEngineTool.debug("The name of the method is : " + string2);
        return string2;
    }

    private static String[] convertVectorToCallStack(Vector vector) {
        AnalysisEngineTool.msg("Convert the vector to a call stack array");
        int n = 0;
        n = vector.size();
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        vector.removeAllElements();
        return objectArray;
    }

    private static String[] checkKnowledgeBase(String string, String[] stringArray, String string2, String string3) {
        String[] stringArray2 = null;
        AnalysisEngineTool.msg("Check the knowlege base");
        stringArray2 = AnalysisEngineWrapper.checkKnowledgeBase(string, stringArray, string2, string3, 0x100000, 1);
        if (stringArray2 != null) {
            AnalysisEngineTool.debug("Directives do exist here");
            for (int i = 0; i < stringArray2.length; ++i) {
                AnalysisEngineTool.msg("directive[" + i + "] = " + stringArray2[i]);
            }
        }
        AnalysisEngineTool.msg("Return from knowledgebase");
        return stringArray2;
    }

    public static String[] processFile() {
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        String string3 = "";
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String[] stringArray = null;
        Object var9_9 = null;
        String string8 = " ";
        String[] stringArray2 = null;
        bufferedReader = AnalysisEngineTool.openFile();
        String string9 = null;
        if (string9 == null) {
            string9 = FFDCHelper.getSystemProperty("line.separator");
        }
        while (true) {
            if ((string = AnalysisEngineTool.readLine(bufferedReader)) == null) break;
            if (string.indexOf(startHeader) != -1) {
                AnalysisEngineTool.processHeader(string);
            }
            if (string.indexOf(exHeader) != -1) {
                string4 = AnalysisEngineTool.processExceptionHeader(string);
            }
            if (string.indexOf(srcHeader) != -1) {
                string5 = AnalysisEngineTool.processSourceHeader(string);
            }
            if (string.indexOf(prbHeader) != -1) {
                string6 = AnalysisEngineTool.processProbeHeader(string);
            }
            if (string.indexOf(startCallStack) == -1) continue;
            string2 = AnalysisEngineTool.processException(string);
            while (string.trim().indexOf(atString) != 0) {
                string3 = string3 + string;
                string = AnalysisEngineTool.readLine(bufferedReader);
            }
            string8 = string3;
            while (string.indexOf(atString) != -1) {
                string8 = string8 + string9 + string;
                string7 = AnalysisEngineTool.processMethodName(string);
                vector.add(string7);
                string = AnalysisEngineTool.readLine(bufferedReader);
                if (string != null) continue;
            }
            stringArray = AnalysisEngineTool.convertVectorToCallStack(vector);
            String[] stringArray3 = AnalysisEngineTool.checkKnowledgeBase(string2, stringArray, string4 + string5 + string6, string8);
            if (!calledByDMTest || stringArray3 == null || stringArray3.length <= 0) continue;
            if (stringArray2 != null) {
                AnalysisEngineTool.error("Directives from previous call stack are being overwritten");
                AnalysisEngineTool.error("This test environment should only be used to process a single call stack");
                AnalysisEngineTool.error("Modify the input file to contain only a single call stack and reissue command");
                AnalysisEngineTool.error("Processing of the last set of directives will continue");
            }
            stringArray2 = stringArray3;
        }
        AnalysisEngineTool.msg("Reached the end of the file");
        return stringArray2;
    }

    public static String[] unitTestDMCall(String string, String string2, String string3) {
        String[] stringArray = new String[3];
        String[] stringArray2 = null;
        calledByDMTest = true;
        if (string == null) {
            System.err.println("Filename was null, need to specify a file for processing");
            return null;
        }
        stringArray[0] = string;
        stringArray[1] = string2 == null ? "default" : string2;
        stringArray[2] = string3 == null ? "nooutput" : string3;
        try {
            AnalysisEngineTool.parseParams(stringArray);
            AnalysisEngineWrapper.setUpForCommandLineCall(databaseName);
            stringArray2 = AnalysisEngineTool.processFile();
        }
        catch (Throwable throwable) {
            System.err.println("A problem was encountered with the tool");
            throwable.printStackTrace();
            return null;
        }
        return stringArray2;
    }

    public static void main(String[] stringArray) {
        if (!AnalysisEngineTool.parseParams(stringArray)) {
            AnalysisEngineTool.msg("problem encountered with the parameters");
            return;
        }
        AnalysisEngineTool.msg("Start of parsing file : " + filename);
        try {
            AnalysisEngineWrapper.setUpForCommandLineCall(databaseName);
            AnalysisEngineTool.processFile();
        }
        catch (Throwable throwable) {
            AnalysisEngineTool.error("Problem has been encountered during the execution of the program");
            throwable.printStackTrace();
        }
    }
}

