/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ws.genericbnf.impl.ErrorHeaderKey;
import com.ibm.wsspi.genericbnf.GenericKeys;

public class AsciiTreeNode {
    private static final int DEFAULT_MINLIMIT = 0;
    private static final int DEFAULT_MAXLIMIT = 255;
    private static final int DEFAULT_BYTERANGE = 256;
    private int minByteLimit;
    private int maxByteLimit;
    private int byteRange;
    private AsciiTreeNode[] child;
    private GenericKeys target = null;
    private int nChildren = 0;

    public AsciiTreeNode(GenericKeys genericKeys, int n, int n2) {
        this.target = genericKeys;
        this.minByteLimit = n;
        this.maxByteLimit = n2;
        this.byteRange = n2 - n + 1;
        this.child = new AsciiTreeNode[this.byteRange];
    }

    public AsciiTreeNode(GenericKeys genericKeys) {
        this.target = genericKeys;
        this.minByteLimit = 0;
        this.maxByteLimit = 255;
        this.byteRange = 256;
        this.child = new AsciiTreeNode[this.byteRange];
    }

    public final GenericKeys getTarget() {
        return this.target;
    }

    protected final int getMinByteLimit() {
        return this.minByteLimit;
    }

    protected final int getMaxByteLimit() {
        return this.maxByteLimit;
    }

    public AsciiTreeNode add(GenericKeys genericKeys, int n) {
        if ((n -= this.getMinByteLimit()) > this.byteRange || 0 > n) {
            return null;
        }
        if (null != this.child[n]) {
            if (null != genericKeys && !(genericKeys instanceof ErrorHeaderKey)) {
                this.child[n].target = genericKeys;
            }
        } else {
            this.child[n] = new AsciiTreeNode(genericKeys, this.getMinByteLimit(), this.getMaxByteLimit());
            ++this.nChildren;
        }
        return this.child[n];
    }

    public AsciiTreeNode addNode(AsciiTreeNode asciiTreeNode, int n) {
        if ((n -= this.getMinByteLimit()) > this.byteRange || 0 > n) {
            return null;
        }
        if (null != this.child[n]) {
            if (null != asciiTreeNode.getTarget()) {
                this.child[n].target = asciiTreeNode.getTarget();
            }
        } else {
            this.child[n] = asciiTreeNode;
            ++this.nChildren;
        }
        return this.child[n];
    }

    public AsciiTreeNode traverse(int n) {
        if ((n -= this.getMinByteLimit()) > this.byteRange || 0 > n) {
            return null;
        }
        return this.child[n];
    }

    public boolean remove(String string, int n) {
        if (0 == n) {
            return true;
        }
        char c = string.charAt(string.length() - n);
        int n2 = c - this.getMinByteLimit();
        if (n2 > this.byteRange || 0 > n2) {
            return false;
        }
        boolean bl = false;
        if (null != this.child[n2] && this.child[n2].remove(string, n - 1)) {
            if (1 == n && 0 < this.child[n2].nChildren) {
                this.child[n2].target = null;
            } else {
                this.child[n2] = null;
                --this.nChildren;
                if (0 == this.nChildren && null == this.target) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void print() {
        if (0 < this.nChildren) {
            for (int i = 0; i < this.byteRange; ++i) {
                if (null == this.child[i]) continue;
                this.child[i].print("" + (char)(i + this.minByteLimit));
            }
        } else {
            System.out.println("No valid paths on this tree");
        }
    }

    private void print(String string) {
        if (0 < this.nChildren) {
            for (int i = 0; i < this.byteRange; ++i) {
                if (null == this.child[i]) continue;
                this.child[i].print(string + (char)(i + this.minByteLimit));
            }
        } else {
            System.out.println(string + " Target : " + this.target);
        }
    }
}

