/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.matcher.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.QuickCaseSensitiveMatcher;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.MethodValues;
import java.util.Iterator;

public class MethodMatcher
extends QuickCaseSensitiveMatcher {
    private static final TraceComponent tc = Tr.register(MethodMatcher.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static MethodMatcher myInstance = null;

    private MethodMatcher() {
        this.init();
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new MethodMatcher();
        }
    }

    public static final MethodMatcher getRef() {
        if (null == myInstance) {
            MethodMatcher.createSingleton();
        }
        return myInstance;
    }

    public MethodValues matchMethod(String string) {
        return (MethodValues)super.match(string);
    }

    public MethodValues matchMethod(StringBuffer stringBuffer) {
        return (MethodValues)super.match(stringBuffer);
    }

    public MethodValues matchMethod(byte[] byArray) {
        return (MethodValues)super.match(byArray);
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing the Method matcher");
        }
        MethodValues methodValues = HttpConstants.METHOD_GET;
        Iterator iterator = MethodValues.getAllKeys().iterator();
        while (iterator.hasNext()) {
            methodValues = (MethodValues)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matcher storing " + methodValues);
            }
            super.add(methodValues);
        }
        super.init();
    }

    public static void main(String[] stringArray) {
        System.out.println("Started");
        MethodMatcher methodMatcher = MethodMatcher.getRef();
        System.out.println("matching...");
        System.out.println();
        System.out.println("Following should find matches...");
        System.out.println("Matching (String) POST " + methodMatcher.matchMethod("POST"));
        String string = "GET";
        System.out.println("Matching (String) " + string + " " + methodMatcher.matchMethod(string));
        string = "CONNECT";
        System.out.println("Matching (byte[]) " + string + " " + methodMatcher.matchMethod(string.getBytes()));
        System.out.println();
        System.out.println("Following should return null responses...");
        string = "Disconnect";
        System.out.println("Matching (StringBuffer) " + string + " " + methodMatcher.matchMethod(new StringBuffer(string)));
        string = "Options";
        System.out.println("Matching (byte[]) " + string + " " + methodMatcher.matchMethod(string.getBytes()));
        string = "gET";
        System.out.println("Matching (String) " + string + " " + methodMatcher.matchMethod(string));
        string = "$wsZIP";
        System.out.println("Matching (String) " + string + " " + methodMatcher.matchMethod(string));
    }
}

