/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.RepositoryLock;
import java.lang.reflect.Method;

public class RepositoryLockFactory {
    private static RepositoryLock repositoryLock = null;
    private static boolean initialized = false;
    private static TraceComponent tc = Tr.register(RepositoryLockFactory.class, "RepositoryLock", "com.ibm.ws.management.resources.repository");

    public static synchronized RepositoryLock createRepositoryLock() throws AdminException {
        if (initialized) {
            throw new AdminException("RepositoryLock is already created.");
        }
        RepositoryLockFactory.initialize();
        initialized = true;
        return repositoryLock;
    }

    private static void initialize() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Load XDRepositoryLock");
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.management.repository.XDRepositoryLock");
            Method method = clazz.getMethod("getRepositoryLock", null);
            repositoryLock = (RepositoryLock)method.invoke(null, null);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Load DefaultRepositoryLock");
            }
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.repository.DefaultRepositoryLock");
                Method method = clazz.getMethod("getRepositoryLock", null);
                repositoryLock = (RepositoryLock)method.invoke(null, null);
            }
            catch (Exception exception2) {
                FFDCFilter.processException(exception2, "com.ibm.ws.management.repository.RepositoryLockFactory.initialize", "2");
                throw new AdminException(exception2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public static RepositoryLock getRepositoryLock() {
        return repositoryLock;
    }
}

