/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import javax.security.auth.Subject;

public final class SyncToOSThreadHelper {
    private static final TraceComponent tc = Tr.register(SyncToOSThreadHelper.class, "Security", "com.ibm.ejs.resources.security");
    private ContextManager _contextManager = null;
    private WSLoginLocalOSExtension _localSecurity = null;
    private boolean _syncEnabled = false;

    public SyncToOSThreadHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this._contextManager = ContextManagerFactory.getInstance();
        if (this._contextManager.processIsServer()) {
            this._localSecurity = WSLoginLocalOSExtensionFactory.getInstance();
        }
        if (this._localSecurity != null) {
            this._syncEnabled = this._localSecurity.isApplicationSyncToOSThreadEnabled();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public Object setAppSyncToThread(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAppSynctothread", subject);
        }
        Object object = null;
        if (this._syncEnabled) {
            object = this._localSecurity.setAppLocalOSThreadID(subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAppSyncToThread", object);
        }
        return object;
    }

    public void restoreAppSyncToThread(Object object) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreAppSyncToThread", object);
        }
        if (object != null && this._syncEnabled) {
            this._localSecurity.restoreAppLocalOSThreadID(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreAppSyncToThread");
        }
    }

    public boolean isThreadLocalApplicationSyncEnabled() {
        boolean bl = false;
        if (this._syncEnabled) {
            bl = this._localSecurity.isThreadLocalApplicationSyncEnabled();
        }
        return bl;
    }

    public void setThreadLocalApplicationSyncEnabled(boolean bl) {
        if (this._syncEnabled) {
            this._localSecurity.setThreadLocalApplicationSyncEnabled(bl);
        }
    }

    public boolean isCurrentComponentAppSyncEnabled() {
        boolean bl = false;
        if (this._syncEnabled) {
            bl = this._localSecurity.getAppSyncEnabledFromComponentMetaData();
        }
        return bl;
    }
}

