/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.exception.ReadNeededInternalException;
import com.ibm.ws.ssl.channel.exception.SessionClosedException;
import com.ibm.ws.ssl.channel.impl.SSLBaseServiceContext;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import javax.net.ssl.SSLException;

public class SSLReadServiceContext
extends SSLBaseServiceContext
implements TCPReadRequestContext {
    protected static final TraceComponent tc = Tr.register(SSLReadServiceContext.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.imp.SSLReadServiceContext";
    protected TCPReadCompletedCallback callback = null;
    private boolean callerRequiredAllocation = false;
    private int jITAllocateSize = 0;
    protected WsByteBuffer[] netBuffers = null;
    private WsByteBuffer[] decryptedNetBuffers = null;
    private int[] decryptedNetLimitInfo = null;
    private WsByteBuffer[] unconsumedDecData = null;
    private boolean decryptedNetBufferReleaseRequired = false;
    protected TCPReadRequestContext deviceReadContext;
    protected long bytesProduced = 0L;
    protected long bytesRequested = 0L;
    protected int netBufferMark = 0;
    private QueuedWork queuedWork = null;
    private SSLReadCompletedCallback readCallback = null;
    ReadNeededInternalException readNeededInternalException = null;
    SessionClosedException sessionClosedException = null;

    public SSLReadServiceContext(SSLConnectionLink sSLConnectionLink) {
        super(sSLConnectionLink);
        this.queuedWork = new QueuedWork();
        this.readCallback = new SSLReadCompletedCallback(this);
        this.readNeededInternalException = new ReadNeededInternalException("All available data read, but more needed, read again");
        this.sessionClosedException = new SessionClosedException("SSL engine is closed");
    }

    public SSLReadServiceContext() {
    }

    public long read(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "read, numbytes=" + l + ", vc=" + this.getVCHash());
        }
        if (this.deviceReadContext == null) {
            this.deviceReadContext = this.getConnLink().getDeviceReadInterface();
        }
        if (n == -2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested to timeout former request.  Calling device side.");
            }
            this.deviceReadContext.read(l, n);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "read");
            }
            return 0L;
        }
        this.decryptedNetBufferReleaseRequired = false;
        this.callerRequiredAllocation = false;
        IOException iOException = this.checkRequest(l, false);
        if (iOException != null) {
            throw iOException;
        }
        this.bytesRequested = l;
        this.bytesProduced = this.readUnconsumedDecData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Decrypted data left over from previous request: " + this.bytesProduced);
        }
        if (this.bytesRequested > this.bytesProduced || this.bytesRequested == 0L) {
            long l2 = 0L;
            int n2 = 0;
            long l3 = 0L;
            long l4 = 0L;
            if (this.bytesProduced > 0L) {
                SSLUtils.positionToLimit(this.decryptedNetBuffers);
                SSLUtils.limitToCapacity(this.decryptedNetBuffers);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adjusted left over decNetBuffers: " + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
                }
            }
            if (this.netBuffers != null) {
                l3 = WsByteBufferUtils.lengthOf(this.netBuffers);
            }
            if (this.bytesRequested != 0L) {
                l4 = this.bytesRequested - this.bytesProduced;
            }
            this.netBuffers = this.getNetworkBuffers(l4);
            this.deviceReadContext.setBuffers(this.netBuffers);
            while (this.bytesProduced < this.bytesRequested || this.bytesRequested == 0L) {
                if (l3 > 0L && ++n2 == 1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No read needed.  Encrypted bytes already available: " + l3);
                    }
                } else {
                    SSLUtils.limitToCapacity(this.netBuffers);
                    long l5 = 0L;
                    if (this.bytesRequested != 0L && this.bytesRequested > this.bytesProduced) {
                        l5 = this.bytesRequested - this.bytesProduced - l3;
                        if (0L >= l5) {
                            l5 = 1L;
                        }
                    } else {
                        l5 = this.bytesRequested == 0L ? 0L : 1L;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "do sync read of : " + l5 + " bytes into netBuffers..." + SSLUtils.getBufferTraceInfo(this.netBuffers));
                    }
                    try {
                        if (l5 == 0L && (l2 += this.deviceReadContext.read(l5, n)) == 0L) {
                            this.bytesProduced = 0L;
                            break;
                        }
                    }
                    catch (IOException iOException2) {
                        SSLUtils.flipBuffersToMark(this.netBuffers, this.netBufferMark, 0);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Reset buffers after read error: vc=" + this.getVCHash() + ", netBuffers:" + SSLUtils.getBufferTraceInfo(this.netBuffers));
                        }
                        throw iOException2;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "read bytes (total): " + l2);
                    }
                }
                SSLUtils.flipBuffersToMark(this.netBuffers, this.netBufferMark, 0);
                Exception exception = this.decryptMessage(false, false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, this.bytesProduced + " bytes produced of " + this.bytesRequested + " bytes requested");
                }
                l3 = WsByteBufferUtils.lengthOf(this.netBuffers);
                if (exception == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Decryption succeeded.");
                    }
                    if (this.bytesRequested == 0L) break;
                    if (this.bytesProduced >= this.bytesRequested) continue;
                    this.netBuffers = this.getNetworkBuffers(this.bytesRequested - this.bytesProduced);
                    this.deviceReadContext.setBuffers(this.netBuffers);
                    continue;
                }
                if (exception instanceof ReadNeededInternalException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "More data needs to be read, loop to another read");
                    }
                    if (this.bytesRequested == 0L) break;
                    this.netBuffers = this.getNetworkBuffers(1L);
                    this.deviceReadContext.setBuffers(this.netBuffers);
                    continue;
                }
                if (exception instanceof SessionClosedException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSL Session has been closed.");
                    }
                    throw new IOException("SSL connection was closed by peer");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decryption unsuccessful, exception resulted: " + exception);
                }
                exception.printStackTrace();
                FFDCFilter.processException((Throwable)exception, CLASS_NAME, "118", this);
                throw new IOException("Unable to decrypt message");
            }
        }
        if (this.bytesProduced > 0L) {
            this.prepareDataForNextChannel();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "read: " + this.bytesProduced);
        }
        return this.bytesProduced;
    }

    public VirtualConnection read(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n) {
        return this.read(l, tCPReadCompletedCallback, bl, n, false);
    }

    protected VirtualConnection read(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n, boolean bl2) {
        VirtualConnection virtualConnection;
        block34: {
            WsByteBuffer[] wsByteBufferArray;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "readAsynch, numBytes=" + l + ", fromQueue=" + bl2 + ", vc=" + this.getVCHash());
            }
            if (this.deviceReadContext == null) {
                this.deviceReadContext = this.getConnLink().getDeviceReadInterface();
            }
            if (n == -2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Requested to timeout former request.  Calling device side.");
                }
                this.readCallback.setCallBack(tCPReadCompletedCallback);
                this.deviceReadContext.read(l, this.readCallback, bl, n);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "readAsynch");
                }
                return this.getVC();
            }
            this.decryptedNetBufferReleaseRequired = false;
            this.callerRequiredAllocation = false;
            IOException iOException = this.checkRequest(l, true);
            if (iOException != null) {
                this.handleAsyncError(bl, iOException, tCPReadCompletedCallback);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "readAsynch");
                }
                return null;
            }
            this.callback = tCPReadCompletedCallback;
            virtualConnection = null;
            this.bytesRequested = l;
            this.bytesProduced = this.readUnconsumedDecData();
            long l2 = this.bytesRequested - this.bytesProduced;
            boolean bl3 = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Data left over from previous request: " + this.bytesProduced);
            }
            if (this.bytesRequested > this.bytesProduced || this.bytesRequested == 0L) {
                if (this.deviceReadContext == null) {
                    this.deviceReadContext = this.getConnLink().getDeviceReadInterface();
                }
                if (this.bytesProduced > 0L) {
                    SSLUtils.positionToLimit(this.decryptedNetBuffers);
                    SSLUtils.limitToCapacity(this.decryptedNetBuffers);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adjusted left over decNetBuffers: " + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
                    }
                }
                if ((wsByteBufferArray = this.deviceReadContext.getBuffers()) != null && SSLUtils.anyPositionsNonZero(wsByteBufferArray) && WsByteBufferUtils.lengthOf(wsByteBufferArray) > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found data in existing network buffer, " + SSLUtils.getBufferTraceInfo(wsByteBufferArray));
                    }
                    this.netBuffers = wsByteBufferArray;
                    virtualConnection = this.getConnLink().getVirtualConnection();
                } else {
                    l2 = this.bytesRequested == 0L ? 0L : this.bytesRequested - this.bytesProduced;
                    this.netBuffers = this.getNetworkBuffers(l2);
                    this.deviceReadContext.setBuffers(this.netBuffers);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "do async read of : " + l2 + " bytes");
                    }
                    this.readCallback.setCallBack(tCPReadCompletedCallback);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling device side read with netBuffers, " + SSLUtils.getBufferTraceInfo(this.netBuffers));
                    }
                    if ((virtualConnection = this.deviceReadContext.read(l2, this.readCallback, bl, n)) != null) {
                        SSLUtils.flipBuffersToMark(this.netBuffers, this.netBufferMark, 0);
                    }
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Left over data was enough to satisfy the request.");
                }
                virtualConnection = this.getConnLink().getVirtualConnection();
                bl3 = true;
                this.prepareDataForNextChannel();
            }
            if (!bl3 && virtualConnection != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Data is ready, no callback necessary.");
                }
                wsByteBufferArray = null;
                while (true) {
                    if ((wsByteBufferArray = this.decryptMessage(true, bl)) == null) {
                        this.prepareDataForNextChannel();
                    } else {
                        if (!(wsByteBufferArray instanceof ReadNeededInternalException)) break;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "More data needs to be read, loop to another read.  vc=" + this.getVCHash());
                        }
                        this.getNetworkBuffers(1L);
                        this.readCallback.setCallBack(tCPReadCompletedCallback);
                        virtualConnection = this.deviceReadContext.read(1L, this.readCallback, bl, n);
                        if (virtualConnection != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Read done.  No callback necessary, buffers " + SSLUtils.getBufferTraceInfo(this.netBuffers));
                            }
                            SSLUtils.flipBuffersToMark(this.netBuffers, this.netBufferMark, 0);
                            continue;
                        }
                    }
                    break block34;
                    break;
                }
                if (wsByteBufferArray instanceof SessionClosedException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSL Session has been closed.");
                    }
                    this.handleAsyncError(bl, new IOException("SSL connection closed by peer"), tCPReadCompletedCallback);
                    virtualConnection = null;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception during unwrap, " + wsByteBufferArray);
                    }
                    FFDCFilter.processException((Throwable)wsByteBufferArray, CLASS_NAME, "192", this);
                    this.handleAsyncError(bl, new IOException("SSL decryption failed: " + wsByteBufferArray.getMessage()), tCPReadCompletedCallback);
                    virtualConnection = null;
                }
            }
        }
        if (virtualConnection != null && (bl2 || bl)) {
            this.handleAsyncComplete(bl, this.callback);
            virtualConnection = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readAsynch");
        }
        return virtualConnection;
    }

    private void handleAsyncComplete(boolean bl, TCPReadCompletedCallback tCPReadCompletedCallback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAsyncComplete");
        }
        if (bl) {
            this.queuedWork.setCompleteParameters(this.getConnLink().getVirtualConnection(), this, tCPReadCompletedCallback);
            ChannelException channelException = null;
            try {
                int n = this.getConnLink().getThreadPool().execute(this.queuedWork, 2);
                if (n != 0) {
                    channelException = new ChannelException("threadpool at capacity, request rejected");
                }
            }
            catch (ChannelException channelException2) {
                channelException = channelException2;
            }
            if (channelException != null) {
                FFDCFilter.processException((Throwable)channelException, CLASS_NAME, "471", this);
                tCPReadCompletedCallback.error(this.getConnLink().getVirtualConnection(), this, new IOException(channelException.toString()));
            }
        } else {
            tCPReadCompletedCallback.complete(this.getConnLink().getVirtualConnection(), this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAsyncComplete");
        }
    }

    private void handleAsyncError(boolean bl, IOException iOException, TCPReadCompletedCallback tCPReadCompletedCallback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAsyncError");
        }
        if (bl) {
            this.queuedWork.setErrorParameters(this.getConnLink().getVirtualConnection(), this, tCPReadCompletedCallback, iOException);
            ChannelException channelException = null;
            try {
                int n = this.getConnLink().getThreadPool().execute(this.queuedWork, 2);
                if (n != 0) {
                    channelException = new ChannelException("threadpool at capacity, request rejected");
                }
            }
            catch (ChannelException channelException2) {
                channelException = channelException2;
            }
            if (channelException != null) {
                FFDCFilter.processException((Throwable)channelException, CLASS_NAME, "503", this);
                tCPReadCompletedCallback.error(this.getConnLink().getVirtualConnection(), this, iOException);
            }
        } else {
            tCPReadCompletedCallback.error(this.getConnLink().getVirtualConnection(), this, iOException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAsyncError");
        }
    }

    private IOException checkRequest(long l, boolean bl) {
        WsByteBuffer[] wsByteBufferArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRequest");
        }
        IOException iOException = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "numBytes=" + l + " jitsize=" + this.jITAllocateSize + " buffers=" + SSLUtils.getBufferTraceInfo(this.getBuffers()));
        }
        if ((wsByteBufferArray = this.getBuffers()) == null || wsByteBufferArray.length == 0) {
            if (this.jITAllocateSize <= 0 || (long)this.jITAllocateSize < l) {
                iOException = new IOException("No buffer(s) provided for reading data into.");
            }
        } else if (l == 0L) {
            iOException = bl ? new IOException("Number of bytes requested, " + l + " is less than minimum allowed (async).") : null;
        } else if (l < 0L) {
            iOException = new IOException("Number of bytes requested, " + l + " is less than minimum allowed.");
        } else {
            int n = WsByteBufferUtils.lengthOf(wsByteBufferArray);
            if ((long)n < l) {
                iOException = new IOException("Number of bytes requested, " + l + " exceeds space remaining in the buffers provided: " + n);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequest: " + iOException);
        }
        return iOException;
    }

    public int readUnconsumedDecData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readUnconsumedDecData");
        }
        int n = 0;
        if (this.unconsumedDecData != null) {
            if (this.getBuffer() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "caller needs a buffer.");
                    Tr.debug(tc, "Left over data exists: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
                this.callerRequiredAllocation = true;
                for (int i = 0; i < this.unconsumedDecData.length; ++i) {
                    n += this.unconsumedDecData[i].remaining();
                }
                if (this.decryptedNetBuffers != null) {
                    WsByteBufferUtils.releaseBufferArray(this.decryptedNetBuffers);
                }
                this.decryptedNetBuffers = this.unconsumedDecData;
                this.unconsumedDecData = null;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caller provided buffers, left over data exists: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
                if (this.decryptedNetBuffers != null) {
                    WsByteBufferUtils.releaseBufferArray(this.decryptedNetBuffers);
                }
                this.decryptedNetBuffers = this.unconsumedDecData;
                n = this.copyDataToCallerBuffers();
                this.decryptedNetBuffers = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readUnconsumedDecData");
        }
        return n;
    }

    protected WsByteBuffer[] getNetworkBuffers(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNetworkBuffers");
        }
        this.netBufferMark = 0;
        if (this.netBuffers == null) {
            int n = this.jITAllocateSize;
            int n2 = this.getConnLink().getSSLEngine().getPacketBufferSize();
            if (n <= 0 || n > n2) {
                n = n2;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Allocating a new networkBuffer");
            }
            if (l == 0L) {
                l = n;
            }
            this.netBuffers = SSLUtils.allocateByteBuffers(n, l, true, false);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found existing netbuffers, " + SSLUtils.getBufferTraceInfo(this.netBuffers));
            }
            int n = -1;
            WsByteBuffer wsByteBuffer = null;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < this.netBuffers.length; ++i) {
                wsByteBuffer = this.netBuffers[i];
                n3 = wsByteBuffer.remaining();
                n4 += n3;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found " + n3 + " bytes in netBuffer array index " + i);
                }
                if (n3 == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found unused netBuffer at array index " + i);
                    }
                    wsByteBuffer.clear();
                    continue;
                }
                if (n == -1) {
                    n = i;
                    this.netBufferMark = wsByteBuffer.position();
                }
                wsByteBuffer.position(wsByteBuffer.limit());
                wsByteBuffer.limit(wsByteBuffer.capacity());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Partially used buffer, array index " + i + ", mark " + this.netBufferMark);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "After adjusting for pre-existing data, netBuffers ..." + SSLUtils.getBufferTraceInfo(this.netBuffers));
            }
            if (n > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found data from previous request in index " + n);
                }
                WsByteBuffer[] wsByteBufferArray = this.netBuffers;
                this.netBuffers = new WsByteBuffer[this.netBuffers.length];
                for (int i = 0; i < this.netBuffers.length; ++i) {
                    this.netBuffers[i] = wsByteBufferArray[n++];
                    if (n != this.netBuffers.length) continue;
                    n = 0;
                }
                this.deviceReadContext.setBuffers(this.netBuffers);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "After updating netBuffers order ..." + SSLUtils.getBufferTraceInfo(this.netBuffers));
                }
            }
            if (l != 0L) {
                this.expandNetBuffers(l);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "netBuffers: " + SSLUtils.getBufferTraceInfo(this.netBuffers));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNetworkBuffers");
        }
        return this.netBuffers;
    }

    private WsByteBuffer[] getDecryptedNetworkBuffers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDecryptedNetworkBuffers");
        }
        if (this.decryptedNetBuffers == null) {
            this.decryptedNetBuffers = this.getBuffers();
            if (this.decryptedNetBuffers == null) {
                this.callerRequiredAllocation = true;
                int n = this.jITAllocateSize;
                if (n <= 0) {
                    n = this.getConnLink().getSSLEngine().getApplicationBufferSize();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "allocate new getAppIn, app channel has responsibility to release unless error");
                }
                this.decryptedNetBuffers = SSLUtils.allocateByteBuffers(n, this.bytesRequested, this.getConfig().getDecryptBuffersDirect(), true);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using decNetworkBuffer from getBuffers()");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Using decNetworkBuffer previously set");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDecryptedNetworkBuffers");
        }
        return this.decryptedNetBuffers;
    }

    private IOException expandDecryptedNetBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "expandDecryptedNetBuffer");
        }
        IOException iOException = null;
        int n = this.jITAllocateSize;
        int n2 = this.getConnLink().getSSLEngine().getApplicationBufferSize();
        if (n <= 0 || n > n2) {
            n = n2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "callerRequiredAlloc=" + this.callerRequiredAllocation + ", decNetReleaseReq=" + this.decryptedNetBufferReleaseRequired);
        }
        if (!this.callerRequiredAllocation) {
            if (this.decryptedNetBufferReleaseRequired) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default allocation size not big enough for SSL output.");
                }
                iOException = new IOException("Default allocation size not big enough for SSL output.");
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Allocating substitue decNetworkBuffer, we must release this buffer.");
                }
                this.decryptedNetBuffers = new WsByteBuffer[1];
                this.decryptedNetBuffers[0] = SSLUtils.allocateByteBuffer(n, this.getConfig().getDecryptBuffersDirect());
                this.decryptedNetBufferReleaseRequired = true;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Expanding set of decryptedNetBuffers by one.");
            }
            WsByteBuffer[] wsByteBufferArray = this.decryptedNetBuffers;
            this.decryptedNetBuffers = new WsByteBuffer[wsByteBufferArray.length + 1];
            int n3 = 0;
            for (n3 = 0; n3 < wsByteBufferArray.length; ++n3) {
                this.decryptedNetBuffers[n3] = wsByteBufferArray[n3];
            }
            this.decryptedNetBuffers[n3] = SSLUtils.allocateByteBuffer(n2, this.getConfig().getDecryptBuffersDirect());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "decryptedNetBuffers changed to ..." + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "expandDecryptedNetBuffer");
        }
        return iOException;
    }

    public WsByteBuffer[] expandNetBuffers(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "expandNetBuffer");
        }
        int n = WsByteBufferUtils.lengthOf(this.netBuffers);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "currentSize=" + n + " netBuffers=" + SSLUtils.getBufferTraceInfo(this.netBuffers));
        }
        if ((long)n < l || l == 0L) {
            int n2;
            int n3 = this.jITAllocateSize;
            int n4 = this.getConnLink().getSSLEngine().getPacketBufferSize();
            if (n3 <= 0 || n3 > n4) {
                n3 = n4;
            }
            long l2 = 0L;
            l2 = l == 0L ? (long)n3 : l - (long)n;
            int n5 = this.getConnLink().getSSLEngine().getPacketBufferSize();
            int n6 = (int)(l2 / (long)n5);
            if (l2 % (long)n5 > 0L) {
                ++n6;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "NetBuffers space " + n + " not big enough. Must add " + n6 + " more buffer(s).");
            }
            WsByteBuffer[] wsByteBufferArray = this.netBuffers;
            this.netBuffers = new WsByteBuffer[wsByteBufferArray.length + n6];
            for (n2 = 0; n2 < wsByteBufferArray.length; ++n2) {
                this.netBuffers[n2] = wsByteBufferArray[n2];
            }
            for (n2 = wsByteBufferArray.length; n2 < this.netBuffers.length; ++n2) {
                this.netBuffers[n2] = SSLUtils.allocateByteBuffer(n5, true);
            }
        }
        this.deviceReadContext.setBuffers(this.netBuffers);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "expandNetBuffer");
        }
        return this.netBuffers;
    }

    private int copyDataToCallerBuffers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDataToCallerBuffers");
        }
        WsByteBuffer[] wsByteBufferArray = this.decryptedNetBuffers;
        WsByteBuffer[] wsByteBufferArray2 = this.getBuffers();
        WsByteBuffer wsByteBuffer = null;
        WsByteBuffer wsByteBuffer2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "\r\nsrc: " + SSLUtils.getBufferTraceInfo(wsByteBufferArray) + "\r\ndst: " + SSLUtils.getBufferTraceInfo(wsByteBufferArray2));
        }
        block0: for (n2 = 0; n2 < wsByteBufferArray.length && n < wsByteBufferArray2.length; ++n2) {
            wsByteBuffer2 = wsByteBufferArray[n2];
            n3 = wsByteBuffer2.remaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Current src buffer index is, " + n2 + ", remaining " + n3);
            }
            while (n3 > 0 && n < wsByteBufferArray2.length) {
                wsByteBuffer = wsByteBufferArray2[n];
                n4 = wsByteBuffer.remaining();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current dst buffer index is, " + n + ", remaining " + n4);
                }
                if (n3 <= n4) {
                    SSLUtils.copyBuffer(wsByteBuffer2, wsByteBuffer, n3);
                    n5 += n3;
                    n4 = wsByteBuffer.remaining();
                    if (n4 != 0) continue block0;
                    ++n;
                    continue block0;
                }
                if (n4 <= 0) continue;
                SSLUtils.copyBuffer(wsByteBuffer2, wsByteBuffer, n4);
                n5 += n4;
                ++n;
                n3 = wsByteBuffer2.remaining();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "\r\nsrc: " + SSLUtils.getBufferTraceInfo(wsByteBufferArray) + "\r\ndst: " + SSLUtils.getBufferTraceInfo(wsByteBufferArray2));
        }
        if (this.decryptedNetBufferReleaseRequired) {
            if (WsByteBufferUtils.lengthOf(wsByteBufferArray) > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The src buffer was allocated by us, save results for a future read.");
                }
                n3 = wsByteBuffer2.remaining();
                if (this.unconsumedDecData == null) {
                    int n6 = this.getConnLink().getSSLEngine().getApplicationBufferSize();
                    this.unconsumedDecData = SSLUtils.allocateByteBuffers(n6, n6, this.getConfig().getDecryptBuffersDirect(), false);
                } else {
                    WsByteBufferUtils.clearBufferArray(this.unconsumedDecData);
                }
                SSLUtils.copyBuffer(wsByteBuffer2, this.unconsumedDecData[0], n3);
                this.unconsumedDecData[0].flip();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "unconsumedDecData: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
                WsByteBufferUtils.releaseBufferArray(this.decryptedNetBuffers);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The src buffer was allocated by us, but completely read.");
                }
                WsByteBufferUtils.releaseBufferArray(this.decryptedNetBuffers);
            }
        } else if (this.unconsumedDecData != null && wsByteBuffer2.hashCode() == this.unconsumedDecData[0].hashCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The src buffer is the unconsumedDecData.");
            }
            if (wsByteBuffer2.hasRemaining()) {
                WsByteBuffer wsByteBuffer3 = this.unconsumedDecData[0];
                this.unconsumedDecData[0] = this.unconsumedDecData[0].slice();
                wsByteBuffer3.release();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Data left in unconsumedDecData: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Entire unconsumedDecData buffer drained.  Release and null out.");
                }
                WsByteBufferUtils.releaseBufferArray(this.unconsumedDecData);
                this.unconsumedDecData = null;
            }
        } else if (wsByteBuffer2.hasRemaining()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using left over buffer to save results that couldn't fit into dst buffers");
            }
            n3 = wsByteBuffer2.remaining();
            if (this.unconsumedDecData == null) {
                int n7 = this.getConnLink().getSSLEngine().getApplicationBufferSize();
                this.unconsumedDecData = SSLUtils.allocateByteBuffers(n7, n7, this.getConfig().getDecryptBuffersDirect(), false);
            } else {
                WsByteBufferUtils.clearBufferArray(this.unconsumedDecData);
            }
            SSLUtils.copyBuffer(wsByteBuffer2, this.unconsumedDecData[0], n3);
            this.unconsumedDecData[0].flip();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "unconsumedDecData: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
            }
            WsByteBufferUtils.clearBufferArray(wsByteBufferArray);
        } else {
            WsByteBufferUtils.clearBufferArray(wsByteBufferArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDataToCallerBuffers");
        }
        return n5;
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close, vc=" + this.getVCHash());
        }
        if (this.netBuffers != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Releasing netBuffers during close " + SSLUtils.getBufferTraceInfo(this.netBuffers));
            }
            WsByteBufferUtils.releaseBufferArray(this.netBuffers);
            this.netBuffers = null;
        }
        if (this.decryptedNetBuffers != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Releasing decryptedNetBuffers during close " + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
            }
            WsByteBufferUtils.releaseBufferArray(this.decryptedNetBuffers);
            this.decryptedNetBuffers = null;
        }
        if (this.unconsumedDecData != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Releasing unconsumedDecData during close, hc=" + this.unconsumedDecData.hashCode());
            }
            WsByteBufferUtils.releaseBufferArray(this.unconsumedDecData);
            this.unconsumedDecData = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void setJITAllocateSize(int n) {
        this.jITAllocateSize = n;
    }

    public boolean getJITAllocateAction() {
        return this.callerRequiredAllocation;
    }

    public int getJITAllocateSize() {
        return this.jITAllocateSize;
    }

    protected Exception decryptMessage(boolean bl, boolean bl2) {
        Exception exception;
        block33: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "decryptMessage");
            }
            int n = 0;
            exception = null;
            ProtoSSLEngineResult protoSSLEngineResult = null;
            ProtoSSLEngineResult.Status status = null;
            this.decryptedNetBuffers = this.getDecryptedNetworkBuffers();
            try {
                while (exception == null) {
                    n = WsByteBufferUtils.lengthOf(this.netBuffers);
                    int[] nArray = SSLUtils.adjustBuffersForJSSE(this.netBuffers, this.getConnLink().getSSLEngine().getPacketBufferSize());
                    if (this.decryptedNetLimitInfo == null || this.decryptedNetLimitInfo.length != this.decryptedNetBuffers.length) {
                        this.decryptedNetLimitInfo = new int[this.decryptedNetBuffers.length];
                    }
                    SSLUtils.getBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "before unwrap:\r\nnetBuffers" + SSLUtils.getBufferTraceInfo(this.netBuffers) + "\r\ndecNetworkBuffers" + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
                    }
                    protoSSLEngineResult = this.getConnLink().getSSLEngine().unwrap(SSLUtils.getWrappedByteBuffers(this.netBuffers), SSLUtils.getWrappedByteBuffers(this.decryptedNetBuffers));
                    status = protoSSLEngineResult.getStatus();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "after unwrap:\r\nnetBuffers" + SSLUtils.getBufferTraceInfo(this.netBuffers) + "\r\ndecNetworkBuffers" + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers) + "\r\nstatus=" + status + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                    }
                    if (nArray != null) {
                        SSLUtils.resetBuffersAfterJSSE(this.netBuffers, nArray);
                    }
                    this.bytesProduced += (long)protoSSLEngineResult.outBytesProduced();
                    if (status == ProtoSSLEngineResult.Status.OK) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "OK result from the SSL engine, callerReqAlloc=" + this.callerRequiredAllocation + " decNetBuffRelReq=" + this.decryptedNetBufferReleaseRequired + "\n");
                        }
                        exception = null;
                        if (this.bytesRequested > this.bytesProduced) {
                            SSLUtils.positionToLimit(this.decryptedNetBuffers);
                            SSLUtils.setBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
                            if (WsByteBufferUtils.lengthOf(this.netBuffers) != 0) continue;
                            exception = this.readNeededInternalException;
                        }
                        break;
                    }
                    if (status == ProtoSSLEngineResult.Status.BUFFER_OVERFLOW) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "BUFFER_OVERFLOW result from the SSL engine");
                        }
                        if ((exception = this.expandDecryptedNetBuffer()) == null) {
                            continue;
                        }
                        break;
                    }
                    if (status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "BUFFER_UNDERFLOW result from the SSL engine");
                        }
                        exception = this.readNeededInternalException;
                        break;
                    }
                    if (status == ProtoSSLEngineResult.Status.CLOSED) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "CLOSED result from the SSL engine, closing connection.");
                        }
                        exception = this.sessionClosedException;
                        break;
                    }
                    if (status == ProtoSSLEngineResult.Status.HS_NEED_TASK || status == ProtoSSLEngineResult.Status.HS_NEED_WRAP || status == ProtoSSLEngineResult.Status.HS_NEED_UNWRAP) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Handshake needed.");
                        }
                        try {
                            protoSSLEngineResult = this.doHandshake(bl, n, bl2);
                        }
                        catch (IOException iOException) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Caught exception during SSL handshake, " + iOException);
                            }
                            exception = iOException;
                            break;
                        }
                        if (protoSSLEngineResult != null) {
                            status = protoSSLEngineResult.getStatus();
                            if (status == ProtoSSLEngineResult.Status.HS_FINISHED) {
                                exception = this.readNeededInternalException;
                            } else if (status == ProtoSSLEngineResult.Status.OK) {
                                this.prepareDataForNextChannel();
                                exception = null;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Unhandled result from SSL engine: " + status);
                                }
                                exception = new SSLException("Unhandled result from SSL engine: " + status);
                            }
                        } else {
                            exception = null;
                        }
                        break;
                    }
                    exception = new SSLException("Unknown result from ssl engine not handled yet: " + status);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unknown result from ssl engine not handled yet: " + status);
                    }
                    break;
                }
            }
            catch (SSLException sSLException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception during decryption, " + sSLException);
                }
                exception = sSLException;
                if (!this.callerRequiredAllocation || this.decryptedNetBuffers == null) break block33;
                WsByteBufferUtils.releaseBufferArray(this.decryptedNetBuffers);
                this.decryptedNetBuffers = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptMessage");
        }
        return exception;
    }

    private ProtoSSLEngineResult doHandshake(boolean bl, int n, boolean bl2) throws IOException {
        ProtoSSLEngineResult protoSSLEngineResult;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doHandshake");
        }
        ProtoSSLEngine protoSSLEngine = this.getConnLink().getSSLEngine();
        WsByteBuffer wsByteBuffer = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), true);
        WsByteBuffer wsByteBuffer2 = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), false);
        WsByteBuffer wsByteBuffer3 = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), false);
        WsByteBuffer wsByteBuffer4 = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), true);
        MyHandshakeCompletedCallback myHandshakeCompletedCallback = null;
        if (bl) {
            myHandshakeCompletedCallback = new MyHandshakeCompletedCallback(this, this.callback, n, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4);
        }
        try {
            protoSSLEngineResult = SSLUtils.handleHandshake(this.getConnLink(), wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, null, myHandshakeCompletedCallback, false);
        }
        catch (IOException iOException) {
            wsByteBuffer.release();
            wsByteBuffer = null;
            wsByteBuffer2.release();
            wsByteBuffer2 = null;
            wsByteBuffer3.release();
            wsByteBuffer3 = null;
            wsByteBuffer4.release();
            wsByteBuffer4 = null;
            throw iOException;
        }
        if (protoSSLEngineResult != null) {
            wsByteBuffer.release();
            wsByteBuffer = null;
            wsByteBuffer2.release();
            wsByteBuffer2 = null;
            wsByteBuffer3.release();
            wsByteBuffer3 = null;
            wsByteBuffer4.release();
            wsByteBuffer4 = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "doHandshake");
        }
        return protoSSLEngineResult;
    }

    protected void prepareDataForNextChannel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareDataForNextChannel");
        }
        if (this.callerRequiredAllocation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Allocation was done here, adjust and hand off buffers, JIT=" + this.jITAllocateSize);
            }
            int n = WsByteBufferUtils.lengthOf(this.decryptedNetBuffers);
            if (this.decryptedNetBuffers.length == 1) {
                if (n <= this.jITAllocateSize) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "single decNetBuffer is okay to pass to caller");
                    }
                    SSLUtils.positionToLimit(this.decryptedNetBuffers);
                    SSLUtils.setBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
                    this.setBuffer(this.decryptedNetBuffers[0]);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "only one decNetBuffer, but too big (" + n + ")for JIT.  Need to copy.");
                    }
                    this.setBuffer(SSLUtils.allocateByteBuffer(this.jITAllocateSize, false));
                    this.copyDataToCallerBuffers();
                }
            } else if (this.decryptedNetBuffers[0].remaining() == this.jITAllocateSize) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "multiple buffers, first of which matches the JIT size");
                }
                this.decryptedNetBuffers[0].position(this.decryptedNetBuffers[0].limit());
                this.setBuffer(this.decryptedNetBuffers[0]);
                int n2 = this.decryptedNetBuffers.length;
                this.unconsumedDecData = new WsByteBuffer[n2 - 1];
                for (int i = 0; i < this.unconsumedDecData.length; ++i) {
                    this.unconsumedDecData[i] = this.decryptedNetBuffers[i + 1];
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "unconsumedDecData:" + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "multiple buffers, first does not match the JIT size.");
                }
                this.setBuffer(SSLUtils.allocateByteBuffer(this.jITAllocateSize, false));
                for (int i = 0; i < this.decryptedNetBuffers.length; ++i) {
                    this.decryptedNetBuffers[i].position(0);
                }
                this.copyDataToCallerBuffers();
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling channel provided buffers");
            }
            if (this.decryptedNetBufferReleaseRequired) {
                for (int i = 0; i < this.decryptedNetBuffers.length; ++i) {
                    if (null == this.decryptedNetBuffers[i]) continue;
                    this.decryptedNetBuffers[i].position(0);
                }
                this.copyDataToCallerBuffers();
            } else {
                SSLUtils.positionToLimit(this.decryptedNetBuffers);
                SSLUtils.setBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
            }
        }
        this.decryptedNetBuffers = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Buffers being sent to next channel: " + SSLUtils.getBufferTraceInfo(this.getBuffers()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareDataForNextChannel");
        }
    }

    private class QueuedWork
    implements Runnable {
        private long numBytes = 0L;
        private TCPReadCompletedCallback userCallback = null;
        private int timeout = 0;
        private VirtualConnection vc = null;
        private TCPReadRequestContext tcpReadRequestContext = null;
        private IOException exception = null;
        private static final int READ = 0;
        private static final int ERROR = 1;
        private static final int COMPLETE = 2;
        private int action = 0;

        protected QueuedWork() {
        }

        public void setReadParameters(long l, TCPReadCompletedCallback tCPReadCompletedCallback, int n) {
            this.numBytes = l;
            this.userCallback = tCPReadCompletedCallback;
            this.timeout = n;
            this.action = 0;
        }

        public void setErrorParameters(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, TCPReadCompletedCallback tCPReadCompletedCallback, IOException iOException) {
            this.vc = virtualConnection;
            this.tcpReadRequestContext = tCPReadRequestContext;
            this.userCallback = tCPReadCompletedCallback;
            this.exception = iOException;
            this.action = 1;
        }

        public void setCompleteParameters(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, TCPReadCompletedCallback tCPReadCompletedCallback) {
            this.vc = virtualConnection;
            this.tcpReadRequestContext = tCPReadRequestContext;
            this.userCallback = tCPReadCompletedCallback;
            this.action = 2;
        }

        public void run() {
            if (this.action == 0) {
                SSLReadServiceContext.this.read(this.numBytes, this.userCallback, false, this.timeout, true);
            } else if (this.action == 1) {
                this.userCallback.error(this.vc, this.tcpReadRequestContext, this.exception);
            } else {
                this.userCallback.complete(this.vc, this.tcpReadRequestContext);
            }
        }
    }

    private class SSLReadCompletedCallback
    implements TCPReadCompletedCallback {
        TCPReadCompletedCallback myCallback = null;
        SSLReadServiceContext readContext = null;

        public SSLReadCompletedCallback(SSLReadServiceContext sSLReadServiceContext2) {
            this.readContext = sSLReadServiceContext2;
        }

        public void setCallBack(TCPReadCompletedCallback tCPReadCompletedCallback) {
            this.myCallback = tCPReadCompletedCallback;
        }

        public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
            Exception exception;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "complete, vc=" + SSLReadServiceContext.this.getVCHash());
            }
            SSLReadServiceContext.this.netBuffers = tCPReadRequestContext.getBuffers();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "just after async read, but before flip\n" + SSLUtils.getBufferTraceInfo(SSLReadServiceContext.this.netBuffers));
            }
            SSLUtils.flipBuffersToMark(SSLReadServiceContext.this.netBuffers, SSLReadServiceContext.this.netBufferMark, 0);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read bytes: " + WsByteBufferUtils.lengthOf(SSLReadServiceContext.this.netBuffers));
            }
            if ((exception = SSLReadServiceContext.this.decryptMessage(true, false)) == null) {
                if (SSLReadServiceContext.this.bytesRequested > SSLReadServiceContext.this.bytesProduced) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Some data decrypted, more data required, do a read. vc=" + SSLReadServiceContext.this.getVCHash());
                    }
                    tCPReadRequestContext.read(1L, this, true, 0);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "data decrypted: bytesRequested=" + SSLReadServiceContext.this.bytesRequested + " bytesProduced=" + SSLReadServiceContext.this.bytesProduced);
                    }
                    SSLReadServiceContext.this.prepareDataForNextChannel();
                    this.myCallback.complete(virtualConnection, this.readContext);
                }
            } else if (exception instanceof ReadNeededInternalException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No data was decrypted, more data required, do a read. vc=" + SSLReadServiceContext.this.getVCHash());
                }
                SSLReadServiceContext.this.netBuffers = SSLReadServiceContext.this.getNetworkBuffers(1L);
                tCPReadRequestContext.setBuffers(SSLReadServiceContext.this.netBuffers);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling device side read with netBuffers, " + SSLUtils.getBufferTraceInfo(SSLReadServiceContext.this.netBuffers));
                }
                tCPReadRequestContext.read(1L, this, true, 0);
            } else if (exception instanceof SessionClosedException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSL Session has been closed.");
                }
                SSLReadServiceContext.this.callback.error(virtualConnection, this.readContext, new IOException("SSL connection was closed by peer"));
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception during unwrap, " + exception);
                }
                FFDCFilter.processException((Throwable)exception, SSLReadServiceContext.CLASS_NAME, "798", this);
                SSLReadServiceContext.this.callback.error(virtualConnection, this.readContext, new IOException("SSL decryption failed: " + exception.getMessage()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete");
            }
        }

        public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "error, vc=" + SSLReadServiceContext.this.getVCHash());
            }
            SSLUtils.flipBuffersToMark(SSLReadServiceContext.this.netBuffers, SSLReadServiceContext.this.netBufferMark, 0);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset buffers after read error: netBuffers:" + SSLUtils.getBufferTraceInfo(SSLReadServiceContext.this.netBuffers));
            }
            SSLReadServiceContext.this.callback.error(virtualConnection, this.readContext, iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "error");
            }
        }
    }

    public class MyHandshakeCompletedCallback
    implements SSLHandshakeCompletedCallback {
        private TCPReadRequestContext readContext;
        private TCPReadCompletedCallback readCallback;
        private int dataToUnwrap;
        private WsByteBuffer netBuffer;
        private WsByteBuffer decryptedNetBuffer;
        private WsByteBuffer appBuffer;
        private WsByteBuffer encryptedAppBuffer;

        public MyHandshakeCompletedCallback(TCPReadRequestContext tCPReadRequestContext, TCPReadCompletedCallback tCPReadCompletedCallback, int n, WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, WsByteBuffer wsByteBuffer4) {
            this.readContext = tCPReadRequestContext;
            this.readCallback = tCPReadCompletedCallback;
            this.dataToUnwrap = n;
            this.netBuffer = wsByteBuffer;
            this.decryptedNetBuffer = wsByteBuffer2;
            this.appBuffer = wsByteBuffer3;
            this.encryptedAppBuffer = wsByteBuffer4;
        }

        public void complete(ProtoSSLEngineResult protoSSLEngineResult) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "handshake complete");
            }
            this.netBuffer.release();
            this.netBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            this.appBuffer.release();
            this.appBuffer = null;
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = null;
            ProtoSSLEngineResult.Status status = protoSSLEngineResult.getStatus();
            if (status == ProtoSSLEngineResult.Status.HS_FINISHED) {
                SSLReadServiceContext.this.read(1L, this.readCallback, true, 0);
            } else if (status == ProtoSSLEngineResult.Status.OK) {
                SSLReadServiceContext.this.prepareDataForNextChannel();
                SSLReadServiceContext.this.callback.complete(SSLReadServiceContext.this.getConnLink().getVirtualConnection(), this.readContext);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unhandled result from SSL engine: " + status);
                }
                IOException iOException = new IOException("Unhandled result from SSL engine: " + status);
                FFDCFilter.processException((Throwable)iOException, SSLReadServiceContext.CLASS_NAME, "750", this);
                SSLReadServiceContext.this.callback.error(SSLReadServiceContext.this.getConnLink().getVirtualConnection(), this.readContext, iOException);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handshake complete");
            }
        }

        public void error(IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "handshake error");
            }
            this.netBuffer.release();
            this.netBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            this.appBuffer.release();
            this.appBuffer = null;
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during encryption, " + iOException);
            }
            FFDCFilter.processException((Throwable)iOException, SSLReadServiceContext.CLASS_NAME, "762", this);
            SSLReadServiceContext.this.callback.error(SSLReadServiceContext.this.getConnLink().getVirtualConnection(), this.readContext, iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handshake error");
            }
        }
    }
}

