/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class KeyManagerData {
    private static final TraceComponent tc = Tr.register(KeyManagerData.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String kmName;
    String kmProvider;
    String kmAlgorithm;
    String kmCustomClass;
    Properties kmCustomProps;
    String kmScope;

    public KeyManagerData(String string, String string2, String string3, String string4, List list, String string5) {
        this.kmName = string;
        this.kmProvider = string2;
        this.kmAlgorithm = string3;
        this.kmCustomClass = string4;
        this.kmCustomProps = this.convertListToProperties(list);
        this.kmScope = string5;
    }

    public Properties convertListToProperties(List list) {
        if (list != null) {
            Properties properties = new Properties();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (property == null) continue;
                properties.setProperty(property.getName(), property.getValue());
            }
            return properties;
        }
        return null;
    }

    public String getName() {
        return this.kmName;
    }

    public void setName(String string) {
        this.kmName = string;
    }

    public String getProvider() {
        return this.kmProvider;
    }

    public void setProvider(String string) {
        this.kmProvider = string;
    }

    public String getAlgorithm() {
        return this.kmAlgorithm;
    }

    public void setAlgorithm(String string) {
        this.kmAlgorithm = string;
    }

    public String getKeyManagerClass() {
        return this.kmCustomClass;
    }

    public void setKeyManagerClass(String string) {
        this.kmCustomClass = string;
    }

    public Properties getAdditionalKeyManagerAttrs() {
        return this.kmCustomProps;
    }

    public void setAdditionalKeyManagerAttrs(List list) {
        this.kmCustomProps = this.convertListToProperties(list);
    }

    public String getManagementScope() {
        return this.kmScope;
    }

    public void setManagementScope(String string) {
        this.kmScope = string;
    }

    public String getKeyManagerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyManagerString");
        }
        if (this.kmCustomClass != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyManagerString -> " + this.kmCustomClass);
            }
            return this.kmCustomClass;
        }
        if (this.kmAlgorithm != null && this.kmProvider != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyManagerString -> " + this.kmAlgorithm + "|" + this.kmProvider);
            }
            return this.kmAlgorithm + "|" + this.kmProvider;
        }
        if (this.kmAlgorithm != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyManagerString -> " + this.kmAlgorithm);
            }
            return this.kmAlgorithm;
        }
        String string = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyManagerString (default) -> " + string);
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("KeyManagerData: name=");
        stringBuffer.append(this.kmName);
        stringBuffer.append(", algorithm=");
        stringBuffer.append(this.kmAlgorithm);
        stringBuffer.append(", provider=");
        stringBuffer.append(this.kmProvider);
        stringBuffer.append(", customClass=");
        stringBuffer.append(this.kmCustomClass);
        stringBuffer.append(", scope=");
        stringBuffer.append(this.kmScope);
        return stringBuffer.toString();
    }
}

