/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.X509KeyManager;

public final class CustomKeyManager
implements X509KeyManager,
KeyManagerExtendedInfo {
    private static final TraceComponent tc = Tr.register(CustomKeyManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private Properties props = null;
    private KeyStore ks = null;
    private X509KeyManager km = null;
    private Properties sslConfig = null;
    private String clientAlias = null;
    private String serverAlias = null;
    private int clientslotnum = 0;
    private int serverslotnum = 0;

    public void setCustomProperties(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCustomProperties", new Object[]{properties});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCustomProperties");
        }
        this.props = properties;
    }

    public void setSSLConfig(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSSLConfig");
        }
        this.sslConfig = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSSLConfig");
        }
    }

    public void setDefaultX509KeyManager(X509KeyManager x509KeyManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultX509KeyManager", new Object[]{x509KeyManager});
        }
        this.km = x509KeyManager;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultX509KeyManager");
        }
    }

    public void setKeyStore(KeyStore keyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyStore");
        }
        this.ks = keyStore;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyStore");
        }
    }

    public void setKeyStoreServerAlias(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyStoreServerAlias", new Object[]{string});
        }
        this.serverAlias = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyStoreServerAlias");
        }
    }

    public void setKeyStoreClientAlias(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyStoreClientAlias", new Object[]{string});
        }
        this.clientAlias = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyStoreClientAlias");
        }
    }

    public void setClientAlias(String string, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientAlias", new Object[]{string, new Integer(n)});
        }
        if (!this.ks.containsAlias(string)) {
            throw new IllegalArgumentException("Client alias " + string + " not found in keystore.");
        }
        this.clientAlias = string;
        this.clientslotnum = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClientAlias");
        }
    }

    public void setServerAlias(String string, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerAlias", new Object[]{string, new Integer(n)});
        }
        if (!this.ks.containsAlias(string)) {
            throw new IllegalArgumentException("Server alias " + string + " not found in keystore.");
        }
        this.serverAlias = string;
        this.serverslotnum = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerAlias");
        }
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias", new Object[]{stringArray, principalArray, socket});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias");
        }
        return this.chooseClientAlias(stringArray[0], principalArray);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{string, principalArray, socket});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias");
        }
        return this.chooseServerAlias(string, principalArray);
    }

    public String chooseClientAlias(String string, Principal[] principalArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias", new Object[]{string, principalArray});
        }
        if (this.clientAlias != null && !this.clientAlias.equals("")) {
            String[] stringArray = this.km.getClientAliases(string, principalArray);
            String string2 = "";
            if (stringArray != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                    if (!this.clientAlias.equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                }
                if (bl) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "chooseClientAlias", new Object[]{this.clientAlias});
                    }
                    return this.clientAlias.toLowerCase();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseClientAlias (default)", new Object[]{this.clientAlias});
            }
            return this.clientAlias;
        }
        String[] stringArray = new String[]{string};
        String string3 = this.km.chooseClientAlias(stringArray, principalArray, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseClientAlias (from JSSE)", new Object[]{string3});
        }
        return string3.toLowerCase();
    }

    public String chooseServerAlias(String string, Principal[] principalArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{string, principalArray});
        }
        if (this.serverAlias != null && !this.serverAlias.equals("")) {
            String[] stringArray = this.km.getServerAliases(string, principalArray);
            String string2 = "";
            if (stringArray != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                    if (!this.serverAlias.equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                }
                if (bl) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "chooseServerAlias", new Object[]{this.serverAlias});
                    }
                    return this.serverAlias.toLowerCase();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseServerAlias (default)", new Object[]{this.serverAlias});
            }
            return this.serverAlias;
        }
        String string3 = this.km.chooseServerAlias(string, principalArray, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseServerAlias (from JSSE)", new Object[]{string3});
        }
        return string3.toLowerCase();
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAliases", new Object[]{string, principalArray});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAliases");
        }
        return this.km.getClientAliases(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerAliases", new Object[]{string, principalArray});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAliases");
        }
        return this.km.getServerAliases(string, principalArray);
    }

    public PrivateKey getPrivateKey(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateKey", new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateKey");
        }
        return this.km.getPrivateKey(string);
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateChain", new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateChain");
        }
        return this.km.getCertificateChain(string);
    }

    public X509KeyManager getX509KeyManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509KeyManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509KeyManager");
        }
        return this.km;
    }

    public CustomKeyManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CustomKeyManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CustomKeyManager");
        }
    }
}

