/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.FilterList;
import com.ibm.ws.tcp.channel.impl.FilterListFastStr;
import com.ibm.ws.tcp.channel.impl.FilterListSlowStr;
import com.ibm.ws.tcp.channel.impl.FilterListStr;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import java.net.Inet6Address;
import java.net.InetAddress;

public class AccessLists {
    protected FilterList excludeAccess = null;
    protected FilterList includeAccess = null;
    protected FilterListStr excludeAccessNames = null;
    protected FilterListStr includeAccessNames = null;
    private static final TraceComponent tc = Tr.register(AccessLists.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public AccessLists(FilterList filterList, FilterListStr filterListStr, FilterList filterList2, FilterListStr filterListStr2) {
        this.excludeAccess = filterList;
        this.includeAccess = filterList2;
        this.excludeAccessNames = filterListStr;
        this.includeAccessNames = filterListStr2;
    }

    protected static AccessLists getInstance(TCPChannelConfiguration tCPChannelConfiguration) {
        AccessLists accessLists = null;
        boolean bl = false;
        FilterList filterList = null;
        FilterList filterList2 = null;
        FilterListStr filterListStr = null;
        FilterListStr filterListStr2 = null;
        String[] stringArray = tCPChannelConfiguration.getAddressExcludeList();
        filterList = new FilterList();
        if (stringArray != null) {
            filterList.buildData(stringArray, false);
            filterList.setActive(true);
            bl = true;
        }
        stringArray = tCPChannelConfiguration.getHostNameExcludeList();
        filterListStr = new FilterListFastStr();
        if (stringArray != null) {
            if (!filterListStr.buildData(stringArray)) {
                filterListStr = new FilterListSlowStr();
                filterListStr.buildData(stringArray);
            }
            filterListStr.setActive(true);
            bl = true;
        }
        String[] stringArray2 = tCPChannelConfiguration.getAddressIncludeList();
        filterList2 = new FilterList();
        if (stringArray2 != null && !stringArray2.equals("")) {
            filterList2.buildData(stringArray2, false);
            filterList2.setActive(true);
            bl = true;
        }
        stringArray2 = tCPChannelConfiguration.getHostNameIncludeList();
        filterListStr2 = new FilterListFastStr();
        if (stringArray2 != null && !stringArray2.equals("")) {
            if (!filterListStr2.buildData(stringArray2)) {
                filterListStr2 = new FilterListSlowStr();
                filterListStr2.buildData(stringArray2);
            }
            filterListStr2.setActive(true);
            bl = true;
        }
        if (bl) {
            accessLists = new AccessLists(filterList, filterListStr, filterList2, filterListStr2);
        }
        return accessLists;
    }

    public boolean accessDenied(InetAddress inetAddress) {
        boolean bl;
        if (this.includeAccess.getActive() || this.includeAccessNames.getActive()) {
            bl = true;
            if (this.includeAccess.getActive()) {
                if (inetAddress instanceof Inet6Address) {
                    if (this.includeAccess.findInList6(inetAddress.getAddress())) {
                        bl = false;
                    }
                } else if (this.includeAccess.findInList(inetAddress.getAddress())) {
                    bl = false;
                }
            }
            if (bl && this.includeAccessNames.getActive() && this.includeAccessNames.findInList(inetAddress.getHostName())) {
                bl = false;
            }
            if (bl) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Address and host name not in include list, address: " + inetAddress.getHostAddress() + " host name: " + inetAddress.getHostName());
                }
                return true;
            }
        }
        if (this.excludeAccess.getActive() || this.excludeAccessNames.getActive()) {
            bl = false;
            if (this.excludeAccess.getActive()) {
                if (inetAddress instanceof Inet6Address) {
                    if (this.excludeAccess.findInList6(inetAddress.getAddress())) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Address (IPv6) in exclude list, address: " + inetAddress.getHostAddress());
                        }
                        return true;
                    }
                } else if (this.excludeAccess.findInList(inetAddress.getAddress())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Address in exclude list, address: " + inetAddress.getHostAddress());
                    }
                    return true;
                }
            }
            if (!bl && this.excludeAccessNames.getActive() && this.excludeAccessNames.findInList(inetAddress.getHostName())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Host name in exclude list, host name: " + inetAddress.getHostName());
                }
                return true;
            }
        }
        return false;
    }
}

