/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class MetaDataChannelHelper {
    protected static final TraceComponent tc = Tr.register(MetaDataChannelHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private TransportChannelService transportChannelService;
    public static final String secure_http_protocol = "https";
    public static final String http_protocol = "http";

    public MetaDataChannelHelper(TransportChannelService transportChannelService) {
        this.transportChannelService = transportChannelService;
    }

    public Map getEndPointMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPointMap");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EList eList = this.transportChannelService.getChains();
        Iterator iterator = eList.iterator();
        for (int i = 0; i < eList.size(); ++i) {
            Chain chain = (Chain)eList.get(i);
            if (!this.isTCPInbound(chain) || !this.isWebContainerInbound(chain)) continue;
            if (this.isSSLInbound(chain)) {
                hashMap.put(this.getEndPointName(chain), secure_http_protocol);
                continue;
            }
            hashMap.put(this.getEndPointName(chain), http_protocol);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPointMap");
        }
        return hashMap;
    }

    private TransportChannel getFirstChannel(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null || chain.getTransportChannels().isEmpty()) {
            return null;
        }
        return (TransportChannel)chain.getTransportChannels().get(0);
    }

    private TransportChannel getLastChannel(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null || chain.getTransportChannels().isEmpty()) {
            return null;
        }
        EList eList = chain.getTransportChannels();
        return (TransportChannel)eList.get(eList.size() - 1);
    }

    private boolean isTCPInbound(Chain chain) {
        TransportChannel transportChannel = this.getFirstChannel(chain);
        return transportChannel != null && transportChannel instanceof TCPInboundChannel;
    }

    private boolean isWebContainerInbound(Chain chain) {
        TransportChannel transportChannel = this.getLastChannel(chain);
        return transportChannel != null && transportChannel instanceof WebContainerInboundChannel;
    }

    private String getEndPointName(Chain chain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPointMap");
        }
        String string = "";
        TransportChannel transportChannel = this.getFirstChannel(chain);
        if (transportChannel != null && transportChannel instanceof TCPInboundChannel) {
            string = ((TCPInboundChannel)transportChannel).getEndPointName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPointMap, endPointName: " + string);
        }
        return string;
    }

    private boolean isSSLInbound(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null || chain.getTransportChannels().isEmpty()) {
            return false;
        }
        EList eList = chain.getTransportChannels();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TransportChannel transportChannel = (TransportChannel)iterator.next();
            if (!(transportChannel instanceof SSLInboundChannel)) continue;
            return true;
        }
        return false;
    }
}

