/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.discovery.DiscoverNamesInManagedProperties;
import com.ibm.ws.webservices.engine.components.discovery.DiscoverServiceNames;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.DiscoverClasses;
import org.apache.commons.discovery.resource.names.DiscoverMappedNames;
import org.apache.commons.discovery.resource.names.DiscoverNamesInAlternateManagedProperties;
import org.apache.commons.discovery.resource.names.NameDiscoverers;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.discovery.tools.ManagedProperties;
import org.apache.commons.logging.Log;

public class WebServicesProperties {
    protected static Log log = LogFactory.getLog(WebServicesProperties.class.getName());
    private static DiscoverNamesInAlternateManagedProperties altNameDiscoverer;
    private static DiscoverMappedNames mappedNames;

    public static void setClassOverrideProperty(Class clazz, String string) {
        WebServicesProperties.getAlternatePropertyNameDiscoverer().addClassToPropertyNameMapping(clazz.getName(), string);
    }

    public static void setClassDefault(Class clazz, String string) {
        WebServicesProperties.getMappedNames().map(clazz.getName(), string);
    }

    public static void setClassDefaults(Class clazz, String[] stringArray) {
        WebServicesProperties.getMappedNames().map(clazz.getName(), stringArray);
    }

    public static ResourceNameDiscover getSPINameDiscoverer() {
        NameDiscoverers nameDiscoverers = new NameDiscoverers();
        nameDiscoverers.addResourceNameDiscover(WebServicesProperties.getAlternatePropertyNameDiscoverer());
        nameDiscoverers.addResourceNameDiscover(new DiscoverNamesInManagedProperties("com.ibm.wsspi.webservices.", null));
        nameDiscoverers.addResourceNameDiscover(new DiscoverServiceNames(WebServicesProperties.getLibClassLoaders(), "com.ibm.wsspi.webservices.", null));
        nameDiscoverers.addResourceNameDiscover(WebServicesProperties.getMappedNames());
        return nameDiscoverers;
    }

    public static ResourceClassIterator getSPIResourceClassIterator(Class clazz) {
        ResourceNameIterator resourceNameIterator = WebServicesProperties.getSPINameDiscoverer().findResourceNames(clazz.getName());
        return new DiscoverClasses(WebServicesProperties.getLibClassLoaders()).findResourceClasses(resourceNameIterator);
    }

    public static ResourceNameDiscover getNameDiscoverer() {
        NameDiscoverers nameDiscoverers = new NameDiscoverers();
        nameDiscoverers.addResourceNameDiscover(WebServicesProperties.getAlternatePropertyNameDiscoverer());
        nameDiscoverers.addResourceNameDiscover(new DiscoverNamesInManagedProperties("com.ibm.wsspi.webservices.", null));
        nameDiscoverers.addResourceNameDiscover(new DiscoverServiceNames(WebServicesProperties.getLibClassLoaders(), "com.ibm.wsspi.webservices.", null));
        nameDiscoverers.addResourceNameDiscover(new DiscoverNamesInManagedProperties());
        nameDiscoverers.addResourceNameDiscover(new DiscoverServiceNames(WebServicesProperties.getAppClassLoaders()));
        nameDiscoverers.addResourceNameDiscover(WebServicesProperties.getMappedNames());
        return nameDiscoverers;
    }

    public static ResourceClassIterator getResourceClassIterator(Class clazz) {
        ResourceNameIterator resourceNameIterator = WebServicesProperties.getNameDiscoverer().findResourceNames(clazz.getName());
        return new DiscoverClasses(WebServicesProperties.getAppClassLoaders()).findResourceClasses(resourceNameIterator);
    }

    private static ClassLoaders getAppClassLoaders() {
        return ClassLoaders.getAppLoaders(WebServicesProperties.class, null, true);
    }

    private static ClassLoaders getLibClassLoaders() {
        return ClassLoaders.getLibLoaders(WebServicesProperties.class, null, true);
    }

    private static DiscoverMappedNames getMappedNames() {
        if (mappedNames == null) {
            mappedNames = new DiscoverMappedNames();
        }
        return mappedNames;
    }

    private static DiscoverNamesInAlternateManagedProperties getAlternatePropertyNameDiscoverer() {
        if (altNameDiscoverer == null) {
            altNameDiscoverer = new DiscoverNamesInAlternateManagedProperties();
        }
        return altNameDiscoverer;
    }

    public static Object newInstance(Class clazz) {
        return WebServicesProperties.newInstance(clazz, null, null);
    }

    public static Object newInstance(final Class clazz, final Class[] classArray, final Object[] objectArray) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator resourceClassIterator = WebServicesProperties.getResourceClassIterator(clazz);
                Object object = null;
                while (object == null && resourceClassIterator.hasNext()) {
                    Class clazz2 = resourceClassIterator.nextResourceClass().loadClass();
                    if (clazz2 == null) continue;
                    try {
                        ClassUtils.verifyAncestory(clazz, clazz2);
                        object = ClassUtils.newInstance(clazz2, classArray, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.webservices.engine.WebServicesProperties.run", "219", this);
                        if (invocationTargetException.getTargetException() instanceof NoClassDefFoundError) {
                            log.debug(Messages.getMessage("exception00"), invocationTargetException);
                            continue;
                        }
                        log.warn(Messages.getMessage("exception00"), invocationTargetException);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.WebServicesProperties.run", "226", this);
                        log.warn(Messages.getMessage("exception00"), exception);
                    }
                }
                return object;
            }
        });
    }

    public static Object newSPIInstance(Class clazz) {
        return WebServicesProperties.newSPIInstance(clazz, null, null);
    }

    public static Object newSPIInstance(final Class clazz, final Class[] classArray, final Object[] objectArray) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator resourceClassIterator = WebServicesProperties.getSPIResourceClassIterator(clazz);
                Object object = null;
                while (object == null && resourceClassIterator.hasNext()) {
                    Class clazz2 = resourceClassIterator.nextResourceClass().loadClass();
                    if (clazz2 == null) continue;
                    try {
                        ClassUtils.verifyAncestory(clazz, clazz2);
                        object = ClassUtils.newInstance(clazz2, classArray, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.webservices.engine.WebServicesProperties.run", "219", this);
                        if (invocationTargetException.getTargetException() instanceof NoClassDefFoundError) {
                            log.debug(Messages.getMessage("exception00"), invocationTargetException);
                            continue;
                        }
                        log.warn(Messages.getMessage("exception00"), invocationTargetException);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.WebServicesProperties.run", "226", this);
                        log.warn(Messages.getMessage("exception00"), exception);
                    }
                }
                return object;
            }
        });
    }

    public static String getProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ManagedProperties.getProperty(string);
            }
        });
    }

    public static String getProperty(final String string, final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ManagedProperties.getProperty(string, string2);
            }
        });
    }

    public static void setProperty(String string, String string2) {
        ManagedProperties.setProperty(string, string2);
    }

    public static void setProperty(String string, String string2, boolean bl) {
        ManagedProperties.setProperty(string, string2, bl);
    }

    public static void setProperties(Map map) {
        ManagedProperties.setProperties(map);
    }

    public static void setProperties(Map map, boolean bl) {
        ManagedProperties.setProperties(map, bl);
    }

    public static Enumeration propertyNames() {
        return ManagedProperties.propertyNames();
    }

    public static Properties getProperties() {
        return ManagedProperties.getProperties();
    }
}

