/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.commons.logging.Log;

public abstract class BaseSerializerFactory
implements SerializerFactory {
    private static Log log = LogFactory.getLog(BaseSerializerFactory.class.getName());
    static Vector mechanisms = null;
    protected Class serClass = null;
    protected Serializer ser = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected boolean initialized = false;
    protected Constructor serClassConstructor = null;
    protected Method getSerializer = null;
    private Configurable _configurable = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$lang$String;

    public BaseSerializerFactory(Class clazz, QName qName, Class clazz2) {
        this.serClass = clazz;
        this.xmlType = qName;
        this.javaType = clazz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.xml.rpc.encoding.Serializer getSerializerAs(String string) throws JAXRPCException {
        BaseSerializerFactory baseSerializerFactory = this;
        synchronized (baseSerializerFactory) {
            if (this.ser == null) {
                this.ser = this.getSerializerAsInternal(string);
            }
            return this.ser;
        }
    }

    protected void lazyInitialization() {
        this.serClassConstructor = this.getConstructor(this.serClass);
        this.getSerializer = this.getSerializerMethod(this.javaType);
        this.initialized = true;
    }

    protected Serializer getSerializerAsInternal(String string) throws JAXRPCException {
        Serializer serializer;
        if (!this.initialized) {
            this.lazyInitialization();
        }
        if ((serializer = this.getSpecialized(string)) == null) {
            serializer = this.getGeneralPurpose(string);
        }
        return serializer;
    }

    protected Serializer getGeneralPurpose(String string) {
        if (this.serClassConstructor != null) {
            try {
                return (Serializer)this.serClassConstructor.newInstance(this.javaType, this.xmlType);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        return (Constructor)AccessController.doPrivileged(new getConstructorPRIV(clazz));
    }

    protected Serializer getSpecialized(String string) {
        if (this.getSerializer != null) {
            try {
                return (Serializer)this.getSerializer.invoke(null, string, this.javaType, this.xmlType);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Method getSerializerMethod(Class clazz) {
        return (Method)AccessController.doPrivileged(new getSerializerMethodPRIV(clazz));
    }

    public Iterator getSupportedMechanismTypes() {
        if (mechanisms == null) {
            mechanisms = new Vector();
            mechanisms.add("WebServices SAX Mechanism");
        }
        return mechanisms.iterator();
    }

    public QName getXMLType() {
        return this.xmlType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public static SerializerFactory createFactory(Class clazz, Class clazz2, QName qName) {
        return BaseSerializerFactory.createFactory(clazz, clazz2, qName, null, null, null);
    }

    public static SerializerFactory createFactory(Class clazz, Class clazz2, QName qName, String string) {
        return BaseSerializerFactory.createFactory(clazz, clazz2, qName, string, null, null);
    }

    public static SerializerFactory createFactory(Class clazz, Class clazz2, QName qName, QName qName2, QName qName3) {
        return BaseSerializerFactory.createFactory(clazz, clazz2, qName, null, qName2, qName3);
    }

    public static SerializerFactory createFactory(Class clazz, Class clazz2, QName qName, String string, QName qName2, QName qName3) {
        return (SerializerFactory)AccessController.doPrivileged(new CreateFactoryPRIV(clazz, clazz2, qName, string, qName2, qName3));
    }

    private void makeConfigurable() {
        if (this._configurable == null) {
            this._configurable = new ConfigurableImpl();
        }
    }

    private String toStringConfigurable(String string) {
        String string2 = "";
        if (this._configurable != null) {
            Object object;
            Iterator iterator = null;
            Map map = this.getOptions();
            if (map != null && (object = map.entrySet()) != null) {
                iterator = map.entrySet().iterator();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object = (Map.Entry)iterator.next();
                    string2 = string2 + string + "KEY(" + object.getKey() + ")\n";
                    string2 = string2 + string + " VALUE(" + object.getValue() + ")\n";
                }
            }
        }
        return string2;
    }

    public final void setOptionsDefault(Configured configured) {
        this.makeConfigurable();
        this._configurable.setOptionsDefault(configured);
    }

    public final void setOption(String string, Object object) {
        this.makeConfigurable();
        this._configurable.setOption(string, object);
    }

    public final void setOption(String string, Object object, boolean bl) {
        this.makeConfigurable();
        this._configurable.setOption(string, object, bl);
    }

    public final boolean setOptionDefault(String string, Object object) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(string, object);
    }

    public final boolean setOptionDefault(String string, Object object, boolean bl) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(string, object, bl);
    }

    public final void setOptions(Map map) {
        this.makeConfigurable();
        this._configurable.setOptions(map);
    }

    public final Object getOption(String string) {
        this.makeConfigurable();
        return this._configurable.getOption(string);
    }

    public final void removeOption(String string) {
        if (this._configurable != null) {
            this._configurable.removeOption(string);
        }
    }

    public final Map getOptions() {
        this.makeConfigurable();
        return this._configurable.getOptions();
    }

    public Set getOptionsBooleanNames() {
        this.makeConfigurable();
        return this._configurable.getOptionsBooleanNames();
    }

    public String toString() {
        return "BaseSerializerFactory: SerClass=" + (this.serClass != null ? this.serClass.toString() : "<null>") + ", XmlType=" + (this.xmlType != null ? this.xmlType.toString() : "<null>") + ", JavaType=" + (this.javaType != null ? this.javaType.toString() : "<null>");
    }

    private static class CreateFactoryPRIV
    implements PrivilegedAction {
        private Class factory;
        private Class javaType;
        private QName xmlType;
        private String binderName;
        private QName compQName;
        private QName compTypeQName;

        CreateFactoryPRIV(Class clazz, Class clazz2, QName qName, String string, QName qName2, QName qName3) {
            this.factory = clazz;
            this.javaType = clazz2;
            this.xmlType = qName;
            this.binderName = string;
            this.compQName = qName2;
            this.compTypeQName = qName3;
        }

        public Object run() {
            GenericDeclaration genericDeclaration;
            SerializerFactory serializerFactory = null;
            try {
                if (this.binderName != null) {
                    genericDeclaration = Class.forName(this.binderName, true, Thread.currentThread().getContextClassLoader());
                    serializerFactory = new CustomSerializerFactory(this.javaType, this.xmlType, (Class)genericDeclaration);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "410", this);
                log.error(Messages.getMessage("noBinderFound00", this.binderName), classNotFoundException);
            }
            if (serializerFactory == null) {
                try {
                    genericDeclaration = this.factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                    serializerFactory = (SerializerFactory)((Method)genericDeclaration).invoke(null, this.javaType, this.xmlType, this.compQName, this.compTypeQName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (serializerFactory == null) {
                try {
                    genericDeclaration = this.factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                    serializerFactory = (SerializerFactory)((Constructor)genericDeclaration).newInstance(this.javaType, this.xmlType, this.compQName, this.compTypeQName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (serializerFactory == null) {
                try {
                    genericDeclaration = this.factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                    serializerFactory = (SerializerFactory)((Method)genericDeclaration).invoke(null, this.javaType, this.xmlType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (serializerFactory == null) {
                try {
                    genericDeclaration = this.factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                    serializerFactory = (SerializerFactory)((Constructor)genericDeclaration).newInstance(this.javaType, this.xmlType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (serializerFactory == null) {
                try {
                    serializerFactory = (SerializerFactory)this.factory.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return serializerFactory;
        }
    }

    private class getSerializerMethodPRIV
    implements PrivilegedAction {
        private Class clazz;

        getSerializerMethodPRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() {
            Method method = null;
            try {
                Class clazz = ClassUtils.forName(this.clazz.getName() + "_Helper");
                method = clazz.getMethod("getSerializer", class$java$lang$String == null ? (class$java$lang$String = BaseSerializerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return method;
        }
    }

    private class getConstructorPRIV
    implements PrivilegedAction {
        private Class clazz;

        getConstructorPRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() {
            try {
                return this.clazz.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }
}

