/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.encoding.Base64;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.OutboundOutputStream;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundCFCallbackImpl;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPSender;
import com.ibm.ws.webservices.engine.transport.http.HTTPSessionContext;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class HttpOutboundChannelConnection
implements WSOutboundConnection {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(HttpOutboundChannelConnection.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    protected String chainname = null;
    protected OutboundVirtualConnection oConn = null;
    protected HttpOutboundServiceContext httpOutSC = null;
    protected WSAddress addrToConnect = null;
    protected long lastAccessTime = 0L;
    protected boolean usedAlready = false;
    protected boolean toBeClosed = false;
    private long createTime = System.currentTimeMillis();

    public long lifetime() {
        return System.currentTimeMillis() - this.createTime;
    }

    public boolean isMessageSent() {
        boolean bl = false;
        if (this.httpOutSC != null) {
            bl = this.httpOutSC.isMessageSent();
        }
        return bl;
    }

    public boolean hasbeenUsed() {
        return this.usedAlready;
    }

    public void updateEndpoint(WSAddress wSAddress) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateEndpoint()");
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("updateEndpoint00", this.addrToConnect.toString(), wSAddress.toString()));
        }
        this.addrToConnect = wSAddress;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateEndpoint()");
        }
    }

    public void updateConnectionCfg(Object object, Object object2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateConnectionCfg()");
        }
        if (this.oConn != null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("updateOCCObject", String.valueOf(object)));
            }
            this.oConn.getStateMap().put(object, object2);
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("channelframework01", "null OutboundVirtualConnection."));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateConnectionCfg()");
        }
    }

    public void sendSOAPRequest(OutboundOutputStream outboundOutputStream) throws Exception {
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "Enter sendSOAPRequest(): " + this);
            }
            WsByteBuffer[] wsByteBufferArray = this.prepareHttpRequestHeaders(outboundOutputStream);
            if (this.httpOutSC.getRequest().isExpect100Continue()) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("httpExpect100SC", String.valueOf(this.addrToConnect)));
                }
                this.httpOutSC.sendRequestHeaders();
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("finishHttpMessage", String.valueOf(this.addrToConnect)));
            }
            this.httpOutSC.finishRequestMessage(wsByteBufferArray);
            if (!this.usedAlready) {
                this.usedAlready = true;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "Exit sendSOAPRequest(): " + this);
            }
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.sendSOAPRequest", "297", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
            throw exception;
        }
        finally {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    public WSOutboundCFCallbackImpl sendSOAPRequestAsync(OutboundOutputStream outboundOutputStream) throws Exception {
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "Enter sendSOAPRequestAsync(): " + this);
            }
            WsByteBuffer[] wsByteBufferArray = this.prepareHttpRequestHeaders(outboundOutputStream);
            HttpRequestMessage httpRequestMessage = this.httpOutSC.getRequest();
            httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Override " + HttpConstants.HDR_CONNECTION.toString() + " to " + HttpConstants.CONN_CLOSE.getName() + " for asynchronous response delivery ");
            }
            WSOutboundCFCallbackImpl wSOutboundCFCallbackImpl = new WSOutboundCFCallbackImpl(this, this.addrToConnect);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("Created " + wSOutboundCFCallbackImpl + " with " + this.oConn));
            }
            this.httpOutSC.finishRequestMessage(wsByteBufferArray, wSOutboundCFCallbackImpl, true);
            if (!this.usedAlready) {
                this.usedAlready = true;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "Exit sendSOAPRequestAsync(): " + this);
            }
            WSOutboundCFCallbackImpl wSOutboundCFCallbackImpl2 = wSOutboundCFCallbackImpl;
            return wSOutboundCFCallbackImpl2;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.sendSOAPRequest", "359", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
            throw exception;
        }
        finally {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    public void receiveSOAPResponse() throws Exception {
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "Enter receiveSOAPResponse(): " + this);
            }
            MessageContext messageContext = MessageContext.getCurrentThreadsContext();
            Message message = messageContext.getResponseMessage();
            HttpResponseMessage httpResponseMessage = this.httpOutSC.getResponse();
            if (httpResponseMessage.isIncoming()) {
                HashMap hashMap;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object[] objectArray;
                CharSequence charSequence;
                StatusCodes statusCodes;
                String string = null;
                byte[] byArray = null;
                String string2 = "iso-8859-1";
                byArray = httpResponseMessage.getReasonPhraseBytes();
                if (byArray != null) {
                    string = new String(byArray, string2);
                    messageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, string);
                }
                if ((statusCodes = httpResponseMessage.getStatusCode()) != null) {
                    messageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(statusCodes.getIntCode()));
                    if (statusCodes.equals(HttpConstants.STATUS_FOUND)) {
                        if (HTTPSender.isHttpRedirectEnabled() && (byArray = httpResponseMessage.getHeaderAsByteArray(HttpConstants.HDR_LOCATION)) != null && JavaUtils.hasValue(string = new String(byArray, string2))) {
                            charSequence = this.addrToConnect.toString();
                            if (!JavaUtils.hasValue((String)charSequence)) {
                                charSequence = messageContext.getTargetEndpointAddress();
                            }
                            if (!string.equals(charSequence)) {
                                messageContext.setProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED, string);
                            }
                        }
                    } else if (statusCodes.equals(HttpConstants.STATUS_UNAUTHORIZED) && (byArray = httpResponseMessage.getHeaderAsByteArray(HttpConstants.HDR_WWW_AUTHENTICATE)) != null) {
                        charSequence = new StringBuffer(new String(byArray, string2));
                        string = ((StringBuffer)charSequence).substring(((StringBuffer)charSequence).indexOf("\"") + 1, ((StringBuffer)charSequence).lastIndexOf("\""));
                        messageContext.setProperty("WWW-Authenticate", string);
                    }
                }
                charSequence = new StringBuffer(32);
                String string3 = null;
                String string4 = null;
                Vector vector = httpResponseMessage.getHeaderByteArrayValues("Content-Type");
                Object object6 = vector.iterator();
                while (object6.hasNext()) {
                    objectArray = (byte[])object6.next();
                    ((StringBuffer)charSequence).append(new String((byte[])objectArray, string2));
                }
                byArray = httpResponseMessage.getHeaderAsByteArray("Content-Location");
                if (byArray != null) {
                    string3 = new String(byArray, string2);
                }
                if ((byArray = httpResponseMessage.getHeaderAsByteArray(HTTPConstants.HEADER_TRANSFER_ENCODING)) != null) {
                    string4 = new String(byArray, string2);
                }
                object6 = null;
                if (httpResponseMessage.getContentLength() > 0) {
                    object6 = String.valueOf(httpResponseMessage.getContentLength());
                }
                objectArray = this.httpOutSC.getResponseBodyBuffers();
                byte[] byArray2 = null;
                if (objectArray != null) {
                    byArray2 = WsByteBufferUtils.asByteArray((WsByteBuffer[])objectArray);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "One-way ? " + messageContext.isOneWay());
                }
                ByteArrayInputStream byteArrayInputStream = null;
                if (byArray2 != null && byArray2.length != 0) {
                    byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    object5 = new Message(byteArrayInputStream, ((StringBuffer)charSequence).toString(), string3);
                    ((Message)object5).setMessageType(MessageType.RESPONSE);
                    messageContext.setResponseMessage((Message)object5);
                    if (MessageTrace.isTraceEnabled()) {
                        MessageTrace.log(MessageTrace.INBOUND_HTTP_RESPONSE, ((StringBuffer)charSequence).toString(), byArray2);
                    }
                } else if (!messageContext.isOneWay()) {
                    object5 = messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                    object4 = messageContext.getProperty("com.ibm.ws.wsaddressing.NoneURI");
                    if (object5 != null || object4 != null) {
                        Tr.debug(_tc, "This message contained WSAddressing data indicating a redirected or discarded reply.  So, no data received in HTTP response as expected.");
                    } else {
                        Tr.error(_tc, Messages.getMessage("httpChannelError00", String.valueOf(this.addrToConnect)));
                    }
                }
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == null) continue;
                        objectArray[i].release();
                    }
                    byArray2 = null;
                }
                if (messageContext.getMaintainSession()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    object4 = null;
                    vector = httpResponseMessage.getHeaderByteArrayValues(HTTPConstants.HEADER_SET_COOKIE);
                    if (vector != null && !vector.isEmpty()) {
                        object3 = vector.iterator();
                        while (object3.hasNext()) {
                            object2 = (byte[])object3.next();
                            if (object3.hasNext()) {
                                stringBuffer.append(new String((byte[])object2, string2)).append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
                                continue;
                            }
                            stringBuffer.append(new String((byte[])object2, string2));
                        }
                        object4 = stringBuffer.toString();
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("cookieReceived", HTTPConstants.HEADER_SET_COOKIE + ": " + (String)object4, this.addrToConnect.toString()));
                        }
                    }
                    object3 = null;
                    stringBuffer = new StringBuffer();
                    vector = httpResponseMessage.getHeaderByteArrayValues(HTTPConstants.HEADER_SET_COOKIE2);
                    if (vector != null && !vector.isEmpty()) {
                        object2 = vector.iterator();
                        while (object2.hasNext()) {
                            object = (byte[])object2.next();
                            if (object2.hasNext()) {
                                stringBuffer.append(new String((byte[])object, string2)).append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
                                continue;
                            }
                            stringBuffer.append(new String((byte[])object, string2));
                        }
                        object3 = stringBuffer.toString();
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("cookieReceived", HTTPConstants.HEADER_SET_COOKIE2 + ": " + (String)object3, this.addrToConnect.toString()));
                        }
                    }
                    if (JavaUtils.hasValue((String)object4) || JavaUtils.hasValue((String)object3)) {
                        object2 = new HTTPSessionContext((String)object4, (String)object3);
                        messageContext.setProperty("com.ibm.ws.webservices.engine.session.context", object2);
                    }
                }
                if ((hashMap = (HashMap)messageContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties")) != null) {
                    object4 = null;
                    if (hashMap.isEmpty()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "receiveSOAPResponse(): Empty response header hasmap - returning ALL headers!");
                        }
                        object4 = httpResponseMessage.getAllHeaders().iterator();
                    } else {
                        object4 = hashMap.keySet().iterator();
                    }
                    object3 = null;
                    object2 = null;
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        if (object3 == "Cookie" || object3 == "Cookie2") {
                            object = httpResponseMessage.getHeaderByteArrayValues((String)object3);
                            StringBuffer stringBuffer = new StringBuffer();
                            if (object != null && !((Vector)object).isEmpty()) {
                                Iterator iterator = ((Vector)object).iterator();
                                while (iterator.hasNext()) {
                                    byte[] byArray3 = (byte[])iterator.next();
                                    if (iterator.hasNext()) {
                                        stringBuffer.append(new String(byArray3, string2)).append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
                                        continue;
                                    }
                                    stringBuffer.append(new String(byArray3, string2));
                                }
                                object2 = stringBuffer.toString();
                            }
                        } else {
                            object2 = httpResponseMessage.getHeaderAsString((String)object3);
                        }
                        if (JavaUtils.hasValue((String)object2)) {
                            hashMap.put(object3, object2);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "HttpOutboundChannelConnection.receiveSOAPResponse(): Rsp headerKey = " + (String)object3 + ", responseHeader = " + (String)object2);
                            }
                        }
                        object2 = null;
                    }
                }
                if (_tc.isDebugEnabled()) {
                    ((HttpResponseMessageImpl)httpResponseMessage).debug();
                }
            } else if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("invalidHttpResponse", String.valueOf(this.addrToConnect)));
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "Exit receiveSOAPResponse(): " + this);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.receiveSOAPResponse", "670", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
            throw exception;
        }
        finally {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    public void connect() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter connect() of: " + this);
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("connectingAddr", String.valueOf(this.addrToConnect)));
        }
        try {
            if (!this.toBeClosed && this.httpOutSC == null) {
                int n;
                this.oConn.connect(this.addrToConnect);
                this.httpOutSC = (HttpOutboundServiceContext)this.oConn.getChannelAccessor();
                if (this.httpOutSC != null && (n = MessageContext.getCurrentThreadsContext().getTimeout()) != 0) {
                    this.httpOutSC.setReadTimeout(n);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("syncTimeoutValue", String.valueOf(n / 1000), this.addrToConnect.getSchemaInString()));
                    }
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("newConnection", String.valueOf(this.oConn)));
                }
            } else if (!this.toBeClosed && this.httpOutSC != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("connectedAddr", String.valueOf(this.addrToConnect)));
                    Tr.event(_tc, Messages.getMessage("reuseConnection", String.valueOf(this.oConn)));
                }
            } else {
                throw new WebServicesFault(Messages.getMessage("closedOCobject00", String.valueOf(this.oConn)));
            }
            this.lastAccessTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.connect", "748", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
            throw new WebServicesFault(Messages.getMessage("failConnect00", this.addrToConnect.getHostname(), exception.getMessage()));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit connect() of: " + this);
        }
    }

    public void disconnect(Exception exception) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter disconnect() of: " + this);
        }
        if (!this.toBeClosed) {
            this.markToBeClosed();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("disconnectAddr", String.valueOf(this.addrToConnect), this.toString()));
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("disconnectedAddr", String.valueOf(this.addrToConnect), this.toString()));
        }
        if (exception != null) {
            this.release(exception);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit disconnect() of: " + this);
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void reset() {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter reset() of: " + this);
        }
        boolean bl2 = bl = this.httpOutSC == null ? false : this.httpOutSC.isPersistent();
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("resetConnection", String.valueOf(this.addrToConnect), String.valueOf(bl)));
        }
        if (!this.toBeClosed) {
            if (bl) {
                this.httpOutSC.clear();
                this.lastAccessTime = System.currentTimeMillis();
            } else {
                this.disconnect(null);
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("disconnectedAddr", String.valueOf(this.addrToConnect), this.toString()));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit reset() of: " + this);
        }
    }

    public boolean isClosed() {
        return this.toBeClosed;
    }

    public long timeFromLastAccess() {
        return System.currentTimeMillis() - this.lastAccessTime;
    }

    public synchronized void markToBeClosed() {
        this.toBeClosed = true;
    }

    public String getChannelChainName() {
        return this.chainname;
    }

    public WSAddress getTargetAddress() {
        return this.addrToConnect;
    }

    public synchronized void release(Exception exception) {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter release() of: " + this);
        }
        if (exception != null && _tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("releaseOCobjectEx", String.valueOf(exception), String.valueOf(this.oConn), String.valueOf(this.httpOutSC)));
        }
        boolean bl2 = bl = this.httpOutSC != null;
        if (bl) {
            this.httpOutSC.clear();
            this.httpOutSC = null;
        }
        if (this.oConn != null) {
            if (bl) {
                this.oConn.close(exception);
            }
            this.oConn = null;
        }
        this.lastAccessTime = 0L;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit release() of: " + this);
        }
    }

    protected String getHeaderFromResponse(HttpHeaderKeys httpHeaderKeys) throws WebServicesFault {
        HttpResponseMessage httpResponseMessage;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getHeaderFromResponse()");
        }
        String string = null;
        if (this.oConn != null && this.httpOutSC != null && (httpResponseMessage = this.httpOutSC.getResponse()) != null) {
            string = httpResponseMessage.getHeaderAsString(httpHeaderKeys);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getHeaderFromResponse()");
        }
        this.lastAccessTime = System.currentTimeMillis();
        return string;
    }

    public HttpOutboundChannelConnection(OutboundVirtualConnection outboundVirtualConnection, WSAddress wSAddress, String string) {
        this.addrToConnect = wSAddress;
        this.oConn = outboundVirtualConnection;
        this.lastAccessTime = System.currentTimeMillis();
        this.chainname = string;
    }

    private static void addValueToOutboundHeader(String string, String string2, HttpRequestMessage httpRequestMessage) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg): transportHeaderKey = " + string + ", transportHeaderValue = " + string2 + ", httpReqMsg" + httpRequestMessage);
        }
        if (!JavaUtils.hasValue(string)) {
            Tr.error(_tc, "invalid.transportheader.key");
            return;
        }
        if (!JavaUtils.hasValue(string2)) {
            Tr.error(_tc, "invalid.transportheader.value", new Object[]{string});
            return;
        }
        if (httpRequestMessage == null) {
            Tr.error(_tc, "internal.error", "HTTP Request message is null");
        }
        String string3 = httpRequestMessage.getHeaderAsString(string);
        StringTokenizer stringTokenizer = null;
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ";");
        }
        if (stringTokenizer != null && stringTokenizer.countTokens() > 0) {
            Object object;
            int n;
            CharSequence charSequence;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ";");
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            while (stringTokenizer2 != null && stringTokenizer2.countTokens() > 0) {
                charSequence = stringTokenizer2.nextToken();
                n = ((String)charSequence).indexOf("=");
                object = ((String)charSequence).substring(0, n);
                String string4 = ((String)charSequence).substring(n + 1);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader() New tokenName = " + (String)object + " , tokenValue" + string4);
                }
                hashMap.put(object, string4);
            }
            while (stringTokenizer.countTokens() > 0) {
                charSequence = stringTokenizer.nextToken();
                n = ((String)charSequence).indexOf("=");
                object = ((String)charSequence).substring(0, n);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader() removing " + (String)object + " from new header values if it exists = " + hashMap.containsKey(object));
                }
                hashMap.remove(object);
            }
            charSequence = new StringBuffer(httpRequestMessage.getHeaderAsString(string));
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                ((StringBuffer)charSequence).append(";");
                ((StringBuffer)charSequence).append((String)object.getKey());
                ((StringBuffer)charSequence).append("=");
                ((StringBuffer)charSequence).append((String)object.getValue());
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader() adding request header ;" + (String)object.getKey() + "=" + (String)object.getValue());
            }
            httpRequestMessage.setHeader(string, new String((StringBuffer)charSequence));
        } else {
            httpRequestMessage.setHeader(string, string2);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader(): Header did not already exist. Adding " + string + " value " + string2);
            }
        }
    }

    private WsByteBuffer[] prepareHttpRequestHeaders(OutboundOutputStream outboundOutputStream) throws WebServicesFault, UnsupportedMethodException, UnsupportedProtocolVersionException, MalformedURLException {
        Integer n;
        Object object;
        Object object2;
        Map.Entry entry;
        Object object3;
        Object object4;
        boolean bl;
        int n2;
        String string;
        Object object5;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter prepareHttpRequestHeaders(): " + this);
        }
        String string2 = null;
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        HttpRequestMessage httpRequestMessage = this.httpOutSC.getRequest();
        int n3 = messageContext.getTimeout();
        this.httpOutSC.setReadTimeout(n3);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("syncTimeoutValue", String.valueOf(n3 / 1000), this.addrToConnect.getSchemaInString()));
        }
        boolean bl2 = true;
        if (messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            string2 = messageContext.getStrProp("soap12.webmethod");
        }
        if (string2 == null) {
            string2 = "POST";
        } else {
            bl2 = string2.equals("POST");
        }
        httpRequestMessage.setMethod(string2);
        string2 = ((HttpChannelAddress)this.addrToConnect).getTargetEndPoint();
        httpRequestMessage.setRequestURL(string2);
        String string3 = httpRequestMessage.getURLHost();
        if (string3 == null || string3 != null && string3.equals("")) {
            throw new WebServicesFault(Messages.getMessage("invalidHttpHost", string3, string2));
        }
        int n4 = httpRequestMessage.getURLPort();
        if (n4 <= 0) {
            throw new WebServicesFault(Messages.getMessage("invalidHttpPort", "" + n4, string2));
        }
        String string4 = string3 + ":" + n4;
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_HOST, string4);
        string2 = messageContext.getStrProp(MessageContext.HTTP_TRANSPORT_VERSION);
        boolean bl3 = true;
        if (string2 != null) {
            if (string2.equalsIgnoreCase(HTTPConstants.HEADER_PROTOCOL_11) || string2.equalsIgnoreCase(HTTPConstants.HEADER_PROTOCOL_10)) {
                httpRequestMessage.setVersion(string2);
                if (string2.equalsIgnoreCase(HTTPConstants.HEADER_PROTOCOL_10)) {
                    bl3 = false;
                }
            } else {
                throw new WebServicesFault(Messages.getMessage("unsupportedHttpVersion", string2));
            }
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("httpVersion", String.valueOf(this.addrToConnect), httpRequestMessage.getVersion()));
        }
        String string5 = "application/soap+xml,multipart/related,text/*";
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT, string5);
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_USER_AGENT, "IBM WebServices/1.0");
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_CACHE_CONTROL, "no-cache");
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_PRAGMA, "no-cache");
        String string6 = messageContext.getSOAPActionURI();
        if (!messageContext.useSOAPAction() || string6 == null) {
            httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_SOAPACTION, "");
        } else {
            httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_SOAPACTION, "\"" + string6 + "\"");
        }
        StringBuffer stringBuffer = null;
        if (!JavaUtils.hasValue(messageContext.getUsername())) {
            object5 = new URL(this.addrToConnect.toString());
            if (((URL)object5).getUserInfo() != null) {
                string = ((URL)object5).getUserInfo();
                int n5 = string.indexOf(58);
                if (n5 >= 0 && n5 + 1 < string.length()) {
                    stringBuffer = new StringBuffer(string.substring(0, n5));
                    stringBuffer.append(":").append(string.substring(n5 + 1));
                } else {
                    stringBuffer = new StringBuffer(string);
                }
            }
        } else {
            stringBuffer = new StringBuffer(messageContext.getUsername());
            stringBuffer.append(":").append(messageContext.getPassword());
        }
        if (stringBuffer != null && JavaUtils.hasValue(stringBuffer.toString())) {
            int n6 = stringBuffer.length();
            stringBuffer.replace(0, n6, Base64.encode(stringBuffer.toString().getBytes()));
            httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_AUTHORIZATION, stringBuffer.insert(0, "Basic ").toString());
        }
        if (messageContext.getMaintainSession()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): maintain session TRUE");
            }
            object5 = messageContext.getProperty("com.ibm.ws.webservices.engine.session.context");
            string = null;
            String string7 = null;
            if (object5 != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): SessionContext property not NULL = " + object5);
                }
                string = ((HTTPSessionContext)object5).getCookie();
                string7 = ((HTTPSessionContext)object5).getCookie2();
            }
            if (string != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Setting Cookie for maintain session = " + string);
                }
                httpRequestMessage.setHeader("Cookie", string);
            }
            if (string7 != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Setting Cookie2 for maintain session = " + string7);
                }
                httpRequestMessage.setHeader("Cookie2", string7);
            }
        }
        object5 = (DefaultHTTPTransportClientProperties)((HttpChannelAddress)this.addrToConnect).getTCproperties();
        if (((HttpChannelAddress)this.addrToConnect).isProxy() && this.addrToConnect.getSchema() == 1) {
            string = ((DefaultHTTPTransportClientProperties)object5).getProxyUser();
            String string8 = ((DefaultHTTPTransportClientProperties)object5).getProxyPassword();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, Messages.getMessage("httpProxyConfiguration00", ((DefaultHTTPTransportClientProperties)object5).getProxyHost(), ((DefaultHTTPTransportClientProperties)object5).getProxyPort(), string, JavaUtils.hasValue(string8) ? "******" : ""));
            }
            if (JavaUtils.hasValue(string) && JavaUtils.hasValue(string8)) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append(":").append(string8);
                n2 = stringBuffer.length();
                stringBuffer.replace(0, n2, Base64.encode(stringBuffer.toString().getBytes()));
                httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_PROXY_AUTHORIZATION, stringBuffer.insert(0, "Basic ").toString());
            }
        }
        if (!(bl = ((DefaultHTTPTransportClientProperties)object5).isResendEnabled())) {
            this.httpOutSC.disallowRewrites();
        } else {
            this.httpOutSC.allowRewrites();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.requestResendEnabled: " + bl);
        }
        if (((DefaultHTTPTransportClientProperties)object5).isKeepAlivePropSet()) {
            bl = ((DefaultHTTPTransportClientProperties)object5).toKeepAlive();
            if (bl) {
                httpRequestMessage.setConnection(HttpConstants.CONN_KEEPALIVE);
            } else {
                httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionKeepAlive = " + bl);
            }
        } else if (bl3) {
            httpRequestMessage.setConnection(HttpConstants.CONN_KEEPALIVE);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionKeepAlive not set. Set default for HTTP 1.1 - Connection: " + HttpConstants.CONN_KEEPALIVE.getName());
            }
        } else {
            httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionKeepAlive not set. Set default for HTTP 1.0 - Connection: " + HttpConstants.CONN_CLOSE.getName());
            }
        }
        string2 = ((DefaultHTTPTransportClientProperties)object5).encodeRequestMessage();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.requestContentEncoding = " + string2);
        }
        if (JavaUtils.hasValue(string2)) {
            if (this.httpOutSC.isGZipEncodingSupported() && string2.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_GZIP)) {
                this.httpOutSC.setGZipEncoded(true);
                if (this.httpOutSC.isGZipEncoded()) {
                    httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, HTTPConstants.HEADER_C_ENC_GZIP);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, Messages.getMessage("gzipCompressionEnabled", String.valueOf(this.httpOutSC.isGZipEncoded())));
                }
            } else if (this.httpOutSC.isXGZipEncodingSupported() && string2.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_XGZIP)) {
                this.httpOutSC.setXGZipEncoded(true);
                if (this.httpOutSC.isXGZipEncoded()) {
                    httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, HTTPConstants.HEADER_C_ENC_XGZIP);
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("gzipCompressionEnabled", String.valueOf(this.httpOutSC.isGZipEncoded())));
                }
            } else if (this.httpOutSC.isZlibEncodingSupported() && string2.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_DEFLATE)) {
                this.httpOutSC.setZlibEncoded(true);
                if (this.httpOutSC.isZlibEncoded()) {
                    httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, HTTPConstants.HEADER_C_ENC_DEFLATE);
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("deflateCompressionEnabled", String.valueOf(this.httpOutSC.isZlibEncoded())));
                }
            }
        }
        if (!this.httpOutSC.isGZipEncoded() && !this.httpOutSC.isZlibEncoded() && !this.httpOutSC.isXGZipEncoded() && _tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("noCompression"));
        }
        Hashtable hashtable = (Hashtable)messageContext.getProperty("HTTP-Request-Headers");
        n2 = 0;
        boolean bl4 = false;
        if (hashtable != null) {
            object4 = null;
            object3 = null;
            entry = null;
            object2 = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): deprecated REQUEST_HEADERS property used = " + hashtable);
            }
            object = hashtable.entrySet().iterator();
            while (object.hasNext()) {
                entry = object.next();
                object2 = entry.getKey();
                if (object2 == null) continue;
                object4 = object2.toString().trim();
                ((String)object4).intern();
                if (object4 == HTTPConstants.HEADER_TRANSFER_ENCODING) {
                    if (!bl3 || null == (object3 = entry.getValue().toString()) || !((String)object3).trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    n2 = 1;
                    continue;
                }
                if (object4 == "Connection") {
                    if (bl3) {
                        object3 = entry.getValue().toString();
                        if (object3 == null || ((String)object3).length() == 0) continue;
                        ((String)object3).intern();
                        if (object3 == HTTPConstants.HEADER_CONNECTION_CLOSE) {
                            httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
                            continue;
                        }
                        if (object3 != HTTPConstants.HEADER_CONNECTION_KEEPALIVE) continue;
                        httpRequestMessage.setConnection(HttpConstants.CONN_KEEPALIVE);
                        continue;
                    }
                    httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
                    continue;
                }
                if (object4 == "Expect") {
                    if (!bl3 || null == (object3 = entry.getValue().toString()) || !((String)object3).trim().equalsIgnoreCase(HTTPConstants.HEADER_EXPECT_100_Continue) || (n = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE)) != null && n == 100) continue;
                    httpRequestMessage.setExpect(HttpConstants.EXPECT_100CONTINUE);
                    bl4 = true;
                    continue;
                }
                if (object4 == "Host" || object4 == "Content-Type" || object4 == "SOAPAction" || object4 == "Content-Length" || object4 == "Cookie" || object4 == "Cookie2") continue;
                httpRequestMessage.setHeader((String)object4, entry.getValue().toString());
            }
        }
        if ((object4 = (HashMap)messageContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties")) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): REQUEST_TRANSPORT_PROPERTIES used = " + object4);
            }
            if (hashtable != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "*** PERFORMANCE DEGREDATION WARNING ***: Both the com.ibm.websphere.webservices.Constants.REQUEST_TRANSPORT_PROPERTIES and the now deprecated HTTPConstants.REQUEST_HEADERS support are being used.  This results in each outgoing Web services HTTP message being processed two times.  For performance reasons only the REQUEST_TRANSPORT_PROPERTIES should be used.");
            }
            object3 = ((HashMap)object4).entrySet().iterator();
            while (object3.hasNext()) {
                entry = (Map.Entry)object3.next();
                object2 = ((String)entry.getKey()).trim();
                if (!JavaUtils.hasValue((String)object2)) {
                    Tr.warning(_tc, "invalid.transportheader.key");
                    continue;
                }
                object = ((String)entry.getValue()).trim();
                if (!JavaUtils.hasValue((String)object)) {
                    Tr.warning(_tc, "invalid.transportheader.value", (Object)new Object[]{object2});
                    continue;
                }
                ((String)object2).intern();
                if (object2 == HTTPConstants.HEADER_TRANSFER_ENCODING) {
                    if (!bl3 || !object.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    n2 = 1;
                    continue;
                }
                if (object2 == "Connection") {
                    if (bl3) {
                        if (object.equals(HTTPConstants.HEADER_CONNECTION_CLOSE)) {
                            httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
                            continue;
                        }
                        if (!object.equals(HTTPConstants.HEADER_CONNECTION_KEEPALIVE)) continue;
                        httpRequestMessage.setConnection(HttpConstants.CONN_KEEPALIVE);
                        continue;
                    }
                    httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
                    continue;
                }
                if (object2 == "Expect") {
                    if (!bl3 || !object.equalsIgnoreCase(HTTPConstants.HEADER_EXPECT_100_Continue) || (n = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE)) != null && n == 100) continue;
                    httpRequestMessage.setExpect(HttpConstants.EXPECT_100CONTINUE);
                    bl4 = true;
                    continue;
                }
                if (object2 == "Host") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + (String)object2);
                    continue;
                }
                if (object2 == "Content-Type") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + (String)object2);
                    continue;
                }
                if (object2 == "SOAPAction") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + (String)object2);
                    continue;
                }
                if (object2 == "Content-Length") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + (String)object2);
                    continue;
                }
                if (object2 == "Cookie") {
                    HttpOutboundChannelConnection.addValueToOutboundHeader((String)object2, (String)object, httpRequestMessage);
                    continue;
                }
                if (object2 == "Cookie2") {
                    HttpOutboundChannelConnection.addValueToOutboundHeader((String)object2, (String)object, httpRequestMessage);
                    continue;
                }
                if (object2 == "Authorization") {
                    HttpOutboundChannelConnection.addValueToOutboundHeader((String)object2, (String)object, httpRequestMessage);
                    continue;
                }
                if (object2 == "Proxy-Authorization") {
                    HttpOutboundChannelConnection.addValueToOutboundHeader((String)object2, (String)object, httpRequestMessage);
                    continue;
                }
                HttpOutboundChannelConnection.addValueToOutboundHeader((String)object2, (String)object, httpRequestMessage);
            }
        }
        object3 = "";
        if (bl2) {
            object3 = outboundOutputStream.getContentType();
            httpRequestMessage.setHeader("Content-Type", (String)object3);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HTTP Content-Type: " + (String)object3);
            }
            if (n2 != 0) {
                httpRequestMessage.setTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "One-way ? " + messageContext.isOneWay());
        }
        if (JavaUtils.hasValue((String)((Object)(entry = httpRequestMessage.getHeaderAsString(HttpConstants.HDR_AUTHORIZATION)))) && ((String)((Object)entry)).startsWith("Negotiate")) {
            messageContext.setProperty("com.ibm.ws.webservices.spnegoUsed", Boolean.TRUE);
        } else {
            messageContext.setProperty("com.ibm.ws.webservices.spnegoUsed", Boolean.FALSE);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Is SPNEGO used? " + (Boolean)messageContext.getProperty("com.ibm.ws.webservices.spnegoUsed"));
        }
        object2 = null;
        try {
            object2 = WSChannelManager.getInstance().getWsByteBufferPoolManager();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.prepareHttpRequestHeaders", "1712", this);
            throw WebServicesFault.makeFault(exception);
        }
        object = new WsByteBuffer[]{object2.wrap(outboundOutputStream.toByteArray())};
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit prepareHttpRequestHeaders(): " + this);
        }
        return object;
    }
}

