/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.jms.JMSCacheData;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.JMSException;

public class JMSConnectionCache {
    private static final TraceComponent _tc = Tr.register(JMSConnectionCache.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private static JMSConnectionCache singleton = null;
    private Hashtable activeConnections = new Hashtable();

    private JMSConnectionCache() {
    }

    public static JMSConnectionCache newInstance() {
        if (singleton == null) {
            singleton = new JMSConnectionCache();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "JMSConnectionCache created.");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSConnectionCache doesn't need created.");
        }
        return singleton;
    }

    public JMSCacheData get(String string) {
        return (JMSCacheData)this.activeConnections.get(string);
    }

    public void put(String string, JMSCacheData jMSCacheData) {
        this.activeConnections.put(string, jMSCacheData);
    }

    public void put(String string, Connection connection) {
        JMSCacheData jMSCacheData = new JMSCacheData(connection);
        this.put(string, jMSCacheData);
    }

    public void closeConnection(String string) throws WebServicesFault {
        Connection connection;
        JMSCacheData jMSCacheData = this.get(string);
        if (jMSCacheData != null && (connection = jMSCacheData.getConnection()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "JMSConnectionCache closing connection " + string);
            }
            try {
                connection.close();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache.closeConnection", "102", this);
                Tr.error(_tc, "JMS.JMSError01", jMSException.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", jMSException.toString()), null, null);
            }
        }
    }

    public void closeConnections() throws WebServicesFault {
        Enumeration enumeration = this.activeConnections.keys();
        while (enumeration.hasMoreElements()) {
            this.closeConnection((String)enumeration.nextElement());
        }
    }
}

