/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.jms.MQDestination;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPSender;
import com.ibm.ws.webservices.engine.transport.jms.JMSSender;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.ws.webservices.trace.UserExceptionTrace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;

public class JMSListenerMDB
implements MessageDrivenBean,
MessageListener {
    private static final TraceComponent _tc = Tr.register(JMSListenerMDB.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private MessageDrivenContext fMessageDrivenCtx = null;
    private ServerEngine serverEngine = null;
    private InitialContext initialContext = null;
    private QueueConnectionFactory replyQCF = null;

    public MessageDrivenContext getMessageDrivenContext() {
        return this.fMessageDrivenCtx;
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        this.fMessageDrivenCtx = messageDrivenContext;
    }

    private InitialContext getInitialContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext");
        }
        try {
            if (this.initialContext == null) {
                this.initialContext = new InitialContext();
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.getInitialContext", "154", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Failed to create initial context!");
            }
            throw namingException;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext");
            }
        }
        return this.initialContext;
    }

    private synchronized QueueConnectionFactory getReplyQCF() throws Exception {
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getReplyQCF");
            }
            if (this.replyQCF == null) {
                InitialContext initialContext = this.getInitialContext();
                String string = "java:comp/env/jms/WebServicesReplyQCF";
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "About to look up QCF: " + string);
                }
                this.replyQCF = (QueueConnectionFactory)initialContext.lookup(string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found the QCF!");
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.getReplyQCF", "205", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Failed to locate my reply QCF, exception = " + exception.toString());
            }
            throw exception;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getReplyQCF");
            }
        }
        return this.replyQCF;
    }

    public void ejbCreate() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ejbCreate");
        }
        try {
            HashMap hashMap = new HashMap();
            this.serverEngine = ServerEngine.getServer(null, hashMap);
            if (this.serverEngine == null) {
                throw new WebServicesFault(Messages.getMessage("JMS.ServerEngine"));
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.ejbCreate", "248", this);
            Tr.error(_tc, "JMS.Fault01", webServicesFault.toString());
            throw new EJBException(webServicesFault.toString());
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ejbCreate");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message message) {
        block78: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "onMessage");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Received JMS Message: " + message.toString());
            }
            MessageContext messageContext = new MessageContext(this.serverEngine);
            Message message2 = null;
            Message message3 = null;
            Queue queue = null;
            String string = null;
            boolean bl = false;
            boolean bl2 = true;
            TransactionSuspender transactionSuspender = null;
            try {
                object8 = message.getStringProperty("enableTransaction");
                bl2 = JavaUtils.isFalse((String)object8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl2) {
                transactionSuspender = new TransactionSuspender();
            }
            try {
                if (bl2) {
                    transactionSuspender.suspendTransaction();
                }
                string = message.getJMSMessageID();
                queue = (Queue)message.getJMSReplyTo();
                object8 = message.getStringProperty("targetService");
                if (object8 == null || ((String)object8).length() == 0) {
                    Tr.error(_tc, "JMS.NoTargetService", "targetService");
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTargetService", "targetService"), null, null);
                }
                messageContext.setTargetPort((String)object8);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Set target port on message context to: " + (String)object8);
                }
                if ((object7 = message.getStringProperty("endpointURL")) != null && ((String)object7).length() > 0) {
                    messageContext.setProperty("inbound.url", object7);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Set inbound.url property on MessageContext to: " + (String)object7);
                    }
                }
                object6 = (object6 = message.getStringProperty("contentType")) == null ? null : ((String)object6).trim();
                object5 = null;
                if (message instanceof BytesMessage) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Got BytesMessage, contentType=" + (String)object6);
                    }
                    object4 = (BytesMessage)message;
                    bl = true;
                    object3 = new ByteArrayOutputStream();
                    object2 = new byte[4096];
                    int n = 1;
                    while (n > 0) {
                        n = object4.readBytes((byte[])object2);
                        if (n <= 0) continue;
                        ((ByteArrayOutputStream)object3).write((byte[])object2, 0, n);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Extracted the following SOAP message from the JMS request message:\n" + ((ByteArrayOutputStream)object3).toString());
                    }
                    object5 = ((ByteArrayOutputStream)object3).toByteArray();
                    object = new ByteArrayInputStream((byte[])object5);
                    message2 = new Message(object, (String)object6, null);
                } else if (message instanceof TextMessage) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Got TextMessage, contentType=" + (String)object6);
                    }
                    object4 = ((TextMessage)message).getText();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Extracted the following SOAP text message from the JMS request message:\n" + (String)object4);
                    }
                    message2 = new Message(object4, (String)object6, null);
                    if (MessageTrace.isTraceEnabled()) {
                        object5 = ((String)object4).getBytes();
                    }
                } else {
                    Tr.error(_tc, "JMS.BadMsgType");
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.BadMsgType"), null, null);
                }
                messageContext.setRequestMessage(message2);
                messageContext.setTransportName("jms");
                messageContext.setProperty("transport.jms.requestMessage", message);
                this.handleSoapAction(message, messageContext);
                if (MessageTrace.isTraceEnabled() && object5 != null) {
                    MessageTrace.log(MessageTrace.INBOUND_JMS_REQUEST, (String)object6, (byte[])object5);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Calling ServerEngine.invoke()...");
                }
                this.serverEngine.invoke(messageContext);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Returned from ServerEngine.invoke()...");
                }
            }
            catch (Exception exception) {
                boolean bl3 = false;
                if (UserExceptionTrace.isUserDefinedException(exception)) {
                    UserExceptionTrace.log(exception);
                    bl3 = true;
                }
                object8 = WebServicesFault.makeFault(exception);
                if (!bl3) {
                    FFDCFilter.processException((Throwable)object8, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "485", this);
                    Tr.error(_tc, "JMS.JMSError03", ((Throwable)object8).toString());
                }
                if (queue != null || messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null) {
                    message3 = new Message(object8);
                    messageContext.setResponseMessage(message3);
                }
                if (queue == null && !bl3) {
                    throw new RuntimeException(((Throwable)object8).getMessage());
                }
            }
            finally {
                if (bl2) {
                    transactionSuspender.resumeTransaction();
                }
            }
            try {
                if (messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null) {
                    object8 = messageContext.getTargetEndpointAddress();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = _tc.isDebugEnabled();
                    if (object8 != null && ((String)object8).toLowerCase().startsWith("jms")) {
                        bl4 = true;
                        if (bl6) {
                            Tr.debug(_tc, "Redirect directive to JMS found.");
                        }
                    }
                    if (object8 != null && ((String)object8).toLowerCase().startsWith("http")) {
                        bl5 = true;
                        if (bl6) {
                            Tr.debug(_tc, "Redirect directive to http/https found.");
                        }
                    }
                    if (messageContext.isOneWay()) {
                        Tr.error(_tc, Messages.getMessage("servlet.unexpected.oneway.response00"));
                        if (bl6) {
                            Tr.debug(_tc, "No Response Sent");
                        }
                        break block78;
                    }
                    if (messageContext.getProperty("com.ibm.ws.wsaddressing.NoneURI") != null) {
                        if (bl6) {
                            Tr.debug(_tc, "Discard Response : WSAddressing NoneURI specified.");
                        }
                        if (bl6) {
                            Tr.debug(_tc, "No Response Sent");
                        }
                        break block78;
                    }
                    if (bl4) {
                        object4 = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
                        if (object4 != null && (object3 = (SimpleTargetedChain)object4.getTransport(QNameTable.createQName(null, "jms"))) != null) {
                            object2 = (JMSSender)((SimpleTargetedChain)object3).getPivotHandler();
                            MessageContext.setCurrentThreadsContext(messageContext);
                            if (object2 != null) {
                                object = messageContext.getTargetEndpointAddressAsURL();
                                if (bl6) {
                                    Tr.debug(_tc, "Attempting to redirect to JMS to " + object);
                                }
                                ((JMSSender)object2).invoke(messageContext);
                            }
                        }
                        break block78;
                    }
                    if (!bl5) break block78;
                    try {
                        object4 = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
                        if (object4 != null) {
                            object3 = (SimpleTargetedChain)object4.getTransport(QNameTable.createQName(null, "http"));
                            object2 = (HTTPSender)((SimpleTargetedChain)object3).getPivotHandler();
                            MessageContext.setCurrentThreadsContext(messageContext);
                            messageContext.setProperty(HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE, "yes".intern());
                            ((HTTPSender)object2).invoke(messageContext);
                        }
                        break block78;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "1:584:1.38", this);
                        throw new SOAPException(exception);
                    }
                }
                if (queue == null || (message3 = messageContext.getResponseMessage()) == null) break block78;
                object8 = this.getReplyQCF();
                object7 = object8.createQueueConnection();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Created the queue connection.");
                }
                try {
                    long l;
                    object6 = object7.createQueueSession(false, 1);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created the queue session.");
                    }
                    if (message.getJMSDestination() == null) {
                        try {
                            if (queue instanceof MQDestination) {
                                ((MQDestination)queue).setTargetClient(1);
                            }
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            // empty catch block
                        }
                    }
                    object5 = object6.createSender(queue);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created the queue sender.");
                    }
                    object4 = null;
                    object3 = message3.getContentType(messageContext.getSOAPConstants());
                    if (bl || message3.countAttachments() > 0) {
                        object4 = object6.createBytesMessage();
                        object2 = new ByteArrayOutputStream();
                        message3.writeTo((OutputStream)object2, (String)object3);
                        message3.removeAllAttachments();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to write the following reply message into the JMS response message:\n" + ((ByteArrayOutputStream)object2).toString());
                        }
                        ((BytesMessage)object4).writeBytes(((ByteArrayOutputStream)object2).toByteArray());
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, (String)object3, ((ByteArrayOutputStream)object2).toByteArray());
                        }
                    } else {
                        object4 = object6.createTextMessage();
                        object2 = message3.getSOAPPartAsString();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to write the following reply message into the JMS response message:\n" + (String)object2);
                        }
                        ((TextMessage)object4).setText((String)object2);
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, (String)object3, (String)object2);
                        }
                    }
                    object4.setStringProperty("contentType", (String)object3);
                    object4.setStringProperty("transportVersion", "1");
                    object2 = null;
                    object2 = (HashMap)messageContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                    if (object2 != null) {
                        this.setResponseHandlerTransportProperties((javax.jms.Message)object4, (HashMap)object2);
                    }
                    object4.setJMSCorrelationID(string);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to send the following reply message:\n" + object4.toString());
                    }
                    if ((l = message.getJMSExpiration() - message.getJMSTimestamp()) < 0L) {
                        l = 0L;
                    }
                    object5.send((javax.jms.Message)object4, message.getJMSDeliveryMode(), message.getJMSPriority(), l);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Sent the reply message with a time-to-live of " + l);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Sent the reply message.");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "756", this);
                    WebServicesFault webServicesFault = WebServicesFault.makeFault(exception);
                    Tr.error(_tc, "JMS.unexpected", ((Throwable)webServicesFault).toString());
                }
                finally {
                    object7.close();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Closed the queue connection.");
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "774", this);
                WebServicesFault webServicesFault = WebServicesFault.makeFault(exception);
                Tr.error(_tc, "JMS.unexpected", ((Throwable)webServicesFault).toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "onMessage");
        }
    }

    private void handleSoapAction(javax.jms.Message message, MessageContext messageContext) throws JMSException {
        String string = message.getStringProperty("soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve soapAction property from JMS message: " + (string == null ? "<null>" : string));
        }
        if (string == null || string.length() == 0) {
            messageContext.setUseSOAPAction(false);
            messageContext.setSOAPActionURI(null);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling soapAction on MessageContext...");
            }
        } else {
            messageContext.setUseSOAPAction(true);
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            messageContext.setSOAPActionURI(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting soapAction on MessageContext to: " + string);
            }
        }
    }

    public void ejbRemove() {
    }

    private void setResponseHandlerTransportProperties(javax.jms.Message message, HashMap hashMap) throws WebServicesFault {
        try {
            if (hashMap != null) {
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getKey() == null || !(entry.getKey() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    String string = ((String)entry.getKey()).trim();
                    if (!JavaUtils.hasValue(string)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    if (entry.getValue() == null || !(entry.getValue() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.value", (Object)new Object[]{entry.getValue()});
                        continue;
                    }
                    String string2 = ((String)entry.getValue()).trim();
                    if (!JavaUtils.hasValue(string2)) {
                        Tr.warning(_tc, "invalid.transportheader.value", (Object)new Object[]{string2});
                        continue;
                    }
                    if (message.propertyExists(string)) continue;
                    message.setStringProperty(string, string2);
                }
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.setResponseHandlerTransportProperties", "886", this);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Messages.getMessage("JMS.JMSError01", jMSException.toString()));
            Exception exception = jMSException.getLinkedException();
            while (exception != null) {
                stringBuffer.append("\n");
                stringBuffer.append(Messages.getMessage("JMS.JMSError02", exception.toString()));
                if (exception instanceof JMSException) {
                    exception = ((JMSException)exception).getLinkedException();
                    continue;
                }
                exception = null;
            }
            Tr.error(_tc, stringBuffer.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, stringBuffer.toString());
            }
            throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
        }
    }
}

