/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.InputStream;
import javax.xml.soap.SOAPException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPBuilder
extends DEventProcessor {
    protected SOAPElement myElement = null;
    protected SOAPElement myChildElement = null;
    protected int lazyParseLevel = 0;

    public void elementEvent(SOAPElement sOAPElement) {
        this.myElement = sOAPElement;
    }

    public void childElementEvent(SOAPElement sOAPElement) {
        this.myChildElement = sOAPElement;
    }

    public void setMyElement(SOAPElement sOAPElement) {
        this.myElement = sOAPElement;
    }

    public void setLazyParseLevel(int n) {
        this.lazyParseLevel = n;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (this.myElement == null) {
            throw new SAXException(Messages.getMessage("noElementInBuilder00", this.getClass().getName()));
        }
        if (this.myElement.rebuildTagQName()) {
            this.myElement.setQName(string, string3);
        }
        if (this.myElement.rebuildAttributesAndMapping()) {
            this.myElement.setAttributes(attributes);
            this.myElement.setMappingScope(mappingScope);
        }
        if (this.lazyParseLevel == 1 && !deserializationContext.isSimpleEventEnabled()) {
            try {
                InputStream inputStream = deserializationContext.getLazyParse();
                if (inputStream != null) {
                    WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(inputStream);
                    MessageContext messageContext = deserializationContext.getMessageContext();
                    if (messageContext != null && messageContext.getCurrentMessage() != null) {
                        String string4 = messageContext.getCurrentMessage().getCharacterEncoding();
                        webServicesInputSource.setEncoding(string4);
                    }
                    this.myElement.setAlternateContent(XMLInputSourceAlternateContent.createContentOnly(webServicesInputSource));
                }
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder.startElement", "152", this);
                throw new SAXException(sOAPException);
            }
        }
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
    }

    public void characters(String string) throws SAXException {
        if (this.myElement != null) {
            try {
                this.myElement.addTextNode(string);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder.characters", "197", this);
                throw new SAXException(sOAPException);
            }
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.myElement != null) {
            try {
                this.myElement.addComment(string);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder.comment", "216", this);
                throw new SAXException(sOAPException);
            }
        }
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        try {
            SOAPBuilder sOAPBuilder = new SOAPBuilder();
            this.myChildElement = this.myElement.getSOAPFactory().createSOAPElement(string, string2, string3, attributes, mappingScope, deserializationContext, this.myElement);
            sOAPBuilder.setMyElement(this.myChildElement);
            if (this.lazyParseLevel > 1) {
                sOAPBuilder.setLazyParseLevel(this.lazyParseLevel - 1);
            }
            return sOAPBuilder;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder.onStartChild", "206", this);
            throw new SAXException(sOAPException);
        }
    }
}

