/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.adapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.DetailedCFEndPointCriteria;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;

public class IdentityMapping {
    private static final TraceComponent tc = Tr.register(IdentityMapping.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    public static final String CFENDPOINT_CACHE_KEY = "CFEndPoint_Cache_Key";
    private static final String SCOPE_IDENTIFIER = "Scope";
    private static final String SCOPE_VALUE = "App";
    private static final String CELL_IDENTIFIER = "cell";
    private static final String NAME_IDENTIFIER = "name";
    private static final String MODULE_IDENTIFIER = "module";
    static /* synthetic */ Class class$com$ibm$wsspi$channel$framework$ChannelFrameworkService;

    public long getUID(Identity identity) {
        long l = ((Object)identity.getProperties()).hashCode();
        l <<= 16;
        l |= (long)identity.hashCode();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "getUID " + l, identity);
        }
        return l;
    }

    public static String getClusterNameFromClusterIdentity(Identity identity) {
        Map map = identity.getProperties();
        String string = (String)map.get("CLUSTERNAME");
        return string;
    }

    public static Identity getClusterIdentityFromClusterName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentityFromClusterName", new Object[]{string, string2});
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CELLNAME", string);
        hashMap.put("CLUSTERNAME", string2);
        Identity identity = clusterService.getIdentity(hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterIdentityFromClusterName", identity);
        }
        return identity;
    }

    public static Identity getApplicationCluster(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SCOPE_IDENTIFIER, SCOPE_VALUE);
        hashMap.put(CELL_IDENTIFIER, string);
        hashMap.put(NAME_IDENTIFIER, string2);
        Identity identity = clusterService.getIdentity(hashMap);
        return identity;
    }

    public static Identity getApplicationCluster(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SCOPE_IDENTIFIER, SCOPE_VALUE);
        hashMap.put(CELL_IDENTIFIER, string);
        hashMap.put(NAME_IDENTIFIER, string2);
        hashMap.put(MODULE_IDENTIFIER, string3);
        Identity identity = clusterService.getIdentity(hashMap);
        return identity;
    }

    public static Identity getApplicationServerCluster(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CELLNAME", string);
        hashMap.put("CLUSTERNAME", string2);
        Identity identity = clusterService.getIdentity(hashMap);
        return identity;
    }

    public static Identity getSessionCluster(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jsession", string);
        return clusterService.getIdentity(hashMap);
    }

    public static Identity getGenericClusterIdentityFromClusterName(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CELLNAME", string);
        hashMap.put("CLUSTERNAME", string2);
        hashMap.put("CLUSTER_TYPE", "GENERIC");
        Identity identity = clusterService.getIdentity(hashMap);
        return identity;
    }

    public static Identity stringToIdentity(String string) {
        return clusterService.stringToIdentity(string);
    }

    public static CFEndPoint getCFEndPoint(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndPoint", identity);
        }
        DescriptionManager descriptionManager = DescriptionManagerFactory.getDescriptionManager();
        Description description = descriptionManager.getDescription((DescriptionKey)identity);
        EndPoint endPoint = null;
        if (description == null || !(description instanceof EndPoint)) {
            throw new IllegalArgumentException("The Identity object passed did not identify an endpoint.");
        }
        endPoint = (EndPoint)((Object)description);
        CFEndPoint cFEndPoint = (CFEndPoint)((EndPointImpl)endPoint).getCachedData(CFENDPOINT_CACHE_KEY);
        if (cFEndPoint != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "found cached " + cFEndPoint);
            }
            return cFEndPoint;
        }
        byte[] byArray = endPoint.getData();
        if (byArray == null || byArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "zero length myBytes, returning null");
            }
            return null;
        }
        WsObjectInputStream wsObjectInputStream = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The ByteArrayInputStream is " + byteArrayInputStream.available() + " bytes long and is: ", byteArrayInputStream);
        }
        try {
            wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
            wsObjectInputStream.readByte();
            cFEndPoint = (CFEndPoint)wsObjectInputStream.readObject();
            ((EndPointImpl)endPoint).putCachedData(CFENDPOINT_CACHE_KEY, cFEndPoint);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", cFEndPoint);
            }
            return cFEndPoint;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, IdentityMapping.class.getName() + ".getCFEndPoint", "221");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception ", iOException);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("An internal error occurred while trying to serialize the CFEndPoint object.");
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, IdentityMapping.class.getName() + ".getCFEndPoint", "229");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception ", classNotFoundException);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("A required class could not be found while serailizing a CFEndPoint object.");
            illegalArgumentException.initCause(classNotFoundException);
            throw illegalArgumentException;
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The object identified by the passed in Identity is not a CFEndPoint object.");
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
    }

    public static CFEndPoint getCFEndPoint(Identity identity, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndPoint", new Object[]{identity, cFEndPointCriteria});
        }
        EndPoint[] endPointArray = clusterService.matchEndPoints(identity, ChannelTargetImpl.distinction);
        CFEndPoint[] cFEndPointArray = new CFEndPoint[endPointArray.length];
        boolean bl = false;
        for (int i = 0; i < endPointArray.length; ++i) {
            cFEndPointArray[i] = IdentityMapping.getCFEndPoint(endPointArray[i].getIdentity());
            if (cFEndPointArray[i] == null) continue;
            bl = true;
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "containing member had no endpoints available, returning null");
            }
            return null;
        }
        try {
            Serializable serializable;
            ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object = WsServiceRegistry.getService(class$com$ibm$wsspi$cluster$adapter$IdentityMapping == null ? (class$com$ibm$wsspi$cluster$adapter$IdentityMapping = IdentityMapping.class$("com.ibm.wsspi.cluster.adapter.IdentityMapping")) : class$com$ibm$wsspi$cluster$adapter$IdentityMapping, class$com$ibm$wsspi$channel$framework$ChannelFrameworkService == null ? (class$com$ibm$wsspi$channel$framework$ChannelFrameworkService = IdentityMapping.class$("com.ibm.wsspi.channel.framework.ChannelFrameworkService")) : class$com$ibm$wsspi$channel$framework$ChannelFrameworkService);
                    return object;
                }
            });
            if (tc.isDebugEnabled()) {
                serializable = new StringBuffer(cFEndPointCriteria.toString());
                ((StringBuffer)serializable).append("[");
                if (cFEndPointCriteria instanceof DetailedCFEndPointCriteria) {
                    ((StringBuffer)serializable).append(((DetailedCFEndPointCriteria)cFEndPointCriteria).getChainProperties() + ":");
                } else {
                    ((StringBuffer)serializable).append("Not DetailedCFEndPointCriteria:");
                }
                ((StringBuffer)serializable).append(cFEndPointCriteria.getChainName() + ":");
                ((StringBuffer)serializable).append(cFEndPointCriteria.getChannelAccessor() + ":");
                ((StringBuffer)serializable).append(String.valueOf(cFEndPointCriteria.isSSLRequired()));
                ((StringBuffer)serializable).append("]");
                Tr.debug(tc, "getCFEndPoint CFEndPointCriteria= ", serializable);
                Tr.debug(tc, "getCFEndPoint CFEndpoints= ", cFEndPointArray);
            }
            serializable = channelFrameworkService.determineBestEndPoint(cFEndPointArray, cFEndPointCriteria);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "the determined best endpoint is: " + serializable);
            }
            return serializable;
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to retrieve the Channel Framework service.");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public static Identity getServerInstanceCluster(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerInstanceCluster", new Object[]{string, string2, string3});
        }
        Identity identity = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CELLNAME", string);
        hashMap.put("CLUSTERNAME", string2 + ":" + string3);
        identity = clusterService.getIdentity(hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerInstanceCluster", identity);
        }
        return identity;
    }

    public static String getCellNameFromIdentity(Identity identity) {
        String string = null;
        Map map = identity.getProperties();
        string = (String)map.get("CELLNAME");
        if (string == null) {
            string = (String)map.get(CELL_IDENTIFIER);
        }
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Identity passed in must be an identity of a cluster or cluster member");
            }
            throw new IllegalArgumentException("Identity passed in must be an identity of a cluster or cluster member");
        }
        return string;
    }

    public static String getNodeNameFromClusterMemberIdentity(Identity identity) throws IllegalArgumentException {
        String string = null;
        Map map = identity.getProperties();
        string = (String)map.get("NODENAME");
        if (string == null) {
            throw new IllegalArgumentException("Identity passed in must be an identity of a cluster or cluster member");
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "nodeName " + string);
        }
        return string;
    }

    public static String getServerNameFromClusterMemberIdentity(Identity identity) throws IllegalArgumentException {
        String string = null;
        Map map = identity.getProperties();
        string = (String)map.get("MEMBERNAME");
        if (string == null) {
            throw new IllegalArgumentException("Identity passed in must be an identity of a cluster or cluster member");
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "serverName " + string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.28 ");
        }
    }
}

