/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.util.ArrayList;
import java.util.List;

public class MethodValues
extends GenericKeys {
    private static final int NUM_REQUIRED = 1;
    private static int numDefined = 1;
    private static List allKeys = new ArrayList();
    private byte[] bytesSpace = null;
    private boolean bBodyAllowed = true;
    private boolean undefined = false;

    public MethodValues(String string, boolean bl) {
        super(string, numDefined);
        ++numDefined;
        allKeys.add(this);
        this.initSpecialArrays();
        this.setBodyAllowed(bl);
    }

    public MethodValues(String string, boolean bl, int n) {
        super(string, n);
        if (n > 1) {
            throw new IllegalArgumentException("Illegal input ordinal " + n);
        }
        this.initSpecialArrays();
        this.setBodyAllowed(bl);
    }

    private MethodValues(MethodValues methodValues) {
        super(methodValues.getName(), methodValues.getOrdinal());
    }

    private void initSpecialArrays() {
        int n = this.getByteArray().length;
        this.bytesSpace = new byte[n + 1];
        System.arraycopy(this.getByteArray(), 0, this.bytesSpace, 0, n);
        this.bytesSpace[n] = 32;
    }

    public final byte[] getMethodSpace() {
        return this.bytesSpace;
    }

    public final boolean isBodyAllowed() {
        return this.bBodyAllowed;
    }

    public final void setBodyAllowed(boolean bl) {
        this.bBodyAllowed = bl;
    }

    public static MethodValues makeUndefinedValue(byte[] byArray) {
        MethodValues methodValues = new MethodValues(HttpConstants.METHOD_UNDEF);
        methodValues.byteArray = byArray;
        methodValues.name = HttpChannelUtils.getEnglishString(byArray);
        methodValues.initSpecialArrays();
        methodValues.hashcode = methodValues.ordinal + methodValues.name.hashCode();
        methodValues.undefined = true;
        return methodValues;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public static List getAllKeys() {
        return allKeys;
    }

    public static MethodValues getByOrdinal(int n) {
        if (0 > n || n >= numDefined) {
            throw new IndexOutOfBoundsException("MethodValues index " + n + " is out of bounds");
        }
        return (MethodValues)allKeys.get(n - 1);
    }
}

