/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.sax;

import com.ibm.xml.xlxp.api.event.ScannerEvent;
import com.ibm.xml.xlxp.api.event.ScannerEventConsumer;
import com.ibm.xml.xlxp.api.event.SimpleDTDScannerEventQueue;
import com.ibm.xml.xlxp.api.sax.impl.SAX2DTDScanner;
import com.ibm.xml.xlxp.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.api.sax.impl.SAX2ParserBase;
import com.ibm.xml.xlxp.api.sax.impl.SAX2ParserCallbacks;
import com.ibm.xml.xlxp.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp.scan.DocumentEntityScanner;
import com.ibm.xml.xlxp.scan.util.DTDGrammar;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.XMLString;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;

public class SAX2Parser
extends SAX2ParserBase
implements ScannerEventConsumer,
SAX2ParserCallbacks {
    protected DocumentEntityScanner fScanner = new DocumentEntityScanner();
    protected SAX2ParsedEntityFactory fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory, this.fStringBuffer);
    protected SAX2DTDScanner fDTDScanner;
    protected DTDGrammar fDTDGrammar;
    protected SimpleDTDScannerEventQueue fEventQueue;
    private boolean[] fInElementContentStack = new boolean[16];
    private XMLString[] fErrorParams = new XMLString[8];

    public SAX2Parser() {
        this(true);
    }

    protected SAX2Parser(boolean bl) {
        if (bl) {
            this.initialize();
        }
    }

    protected void initialize() {
        this.fEventQueue = this.createDTDScannerEventQueue();
        this.fDTDScanner = this.createSAX2DTDScanner();
    }

    protected void reset(boolean bl) {
        super.reset(bl);
        this.fEventQueue.reset(bl);
        this.fDTDScanner.reset(bl);
        this.fEntityFactory.reset(bl);
        this.fElementDepth = 0;
    }

    protected SimpleDTDScannerEventQueue createDTDScannerEventQueue() {
        SimpleDTDScannerEventQueue simpleDTDScannerEventQueue = new SimpleDTDScannerEventQueue(this.fScanner, this.fBufferFactory, this.fSymbolTable, this.fStringBuffer);
        simpleDTDScannerEventQueue.setEventConsumer(this);
        return simpleDTDScannerEventQueue;
    }

    protected SAX2DTDScanner createSAX2DTDScanner() {
        return new SAX2DTDScanner(this.fEventQueue, this.fScanner, this.fSymbolTable, this.fStringBuffer, this.fEntityFactory, this.fBufferFactory, this, this.fSymbolStringMappings);
    }

    private XMLString[] copyErrorParams(ScannerEvent.Error error) {
        XMLString[] xMLStringArray;
        int n = error.errorParamsCount();
        int n2 = n;
        if (n2 > (xMLStringArray = this.fErrorParams).length) {
            int n3;
            for (n3 = xMLStringArray.length << 1; n2 > n3; n3 <<= 1) {
            }
            this.fErrorParams = new XMLString[n3];
            xMLStringArray = this.fErrorParams;
        }
        while (n2-- > 0) {
            xMLStringArray[n2] = error.errorParam(n2);
        }
        return xMLStringArray;
    }

    private void reportWarning(ScannerEvent.Error error) {
        XMLString[] xMLStringArray = this.copyErrorParams(error);
        this.reportWarning(error.errorURI(), error.errorCode(), error.errorParamsCount(), xMLStringArray);
    }

    private void reportRecoverableError(ScannerEvent.Error error) {
        XMLString[] xMLStringArray = this.copyErrorParams(error);
        this.reportRecoverableError(error.errorURI(), error.errorCode(), error.errorParamsCount(), xMLStringArray);
    }

    private void reportFatalError(ScannerEvent.Error error) {
        XMLString[] xMLStringArray = this.copyErrorParams(error);
        this.reportFatalError(error.errorURI(), error.errorCode(), error.errorParamsCount(), xMLStringArray);
    }

    private void startElementEvent(ScannerEvent.StartElement startElement, boolean bl) {
        this.startElementEvent(startElement.elementType(), startElement.nsDecls(), startElement.attributes(), bl);
    }

    private void endElementEvent(ScannerEvent.EndElement endElement) {
        this.endElementEvent(endElement.elementType(), endElement.nsDecls());
    }

    public boolean consumeEvents() {
        ScannerEvent scannerEvent = this.fEventQueue.nextEvent(-1);
        while (scannerEvent != null) {
            switch (scannerEvent.eventType) {
                case 20: {
                    this.reportWarning(scannerEvent.asError());
                    break;
                }
                case 21: {
                    this.reportRecoverableError(scannerEvent.asError());
                    break;
                }
                case 22: {
                    this.reportFatalError(scannerEvent.asError());
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    return false;
                }
                case 4: {
                    this.startElementEvent(scannerEvent.asStartElement(), true);
                    break;
                }
                case 5: {
                    this.startElementEvent(scannerEvent.asStartElement(), false);
                    break;
                }
                case 7: {
                    this.endElementEvent(scannerEvent.asEndElement());
                    break;
                }
                case 2: {
                    this.xmlDeclEvent();
                    break;
                }
                case 3: {
                    this.textDeclEvent();
                    break;
                }
                case 8: {
                    this.characters(scannerEvent.asCharacters().content());
                    break;
                }
                case 9: {
                    this.whitespace(scannerEvent.asCharacters().content());
                    break;
                }
                case 10: {
                    this.character(scannerEvent.asCharacter().singleCh(), false);
                    break;
                }
                case 11: {
                    this.character(scannerEvent.asCharacter().singleCh(), true);
                    break;
                }
                case 12: {
                    this.processingInstruction(scannerEvent.asProcessingInstruction().target(), scannerEvent.asProcessingInstruction().content());
                    break;
                }
                case 13: {
                    this.comment(scannerEvent.asComment().content());
                    break;
                }
                case 14: {
                    this.startCDATASection();
                    break;
                }
                case 15: {
                    this.endCDATASection();
                    break;
                }
                case 16: {
                    this.startDTD(scannerEvent.asDoctype().rootElementType(), scannerEvent.asDoctype().publicID(), scannerEvent.asDoctype().systemID(), scannerEvent.asDoctype().internalSubset());
                    break;
                }
                case 17: {
                    this.startEntity(scannerEvent.asEntity().entityName());
                    break;
                }
                case 18: {
                    this.endEntity(scannerEvent.asEntity().entityName());
                }
            }
            scannerEvent = this.fEventQueue.nextEvent(-1);
        }
        return true;
    }

    protected void parseEvents(InputSource inputSource) {
        this.fEventQueue.setNamespaceAwareness(this.fNamespaces);
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource);
        if (parsedEntity != null) {
            this.fEventQueue.parseDocumentEntity(parsedEntity);
        }
    }

    protected boolean pushInElementContent(boolean bl) {
        if (this.fElementDepth == this.fInElementContentStack.length) {
            boolean[] blArray = new boolean[this.fElementDepth << 1];
            System.arraycopy(this.fInElementContentStack, 0, blArray, 0, this.fElementDepth);
            this.fInElementContentStack = blArray;
        }
        this.fInElementContentStack[this.fElementDepth] = this.fInElementContent;
        return bl;
    }

    protected boolean popInElementContent() {
        boolean bl = this.fInElementContentStack[this.fElementDepth];
        return bl;
    }

    public void setGrammar(DTDGrammar dTDGrammar) {
        this.fDTDGrammar = dTDGrammar;
    }

    public void endDTD() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endDTD();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public boolean skippedExternalSubsetEntity() {
        if (this.fContentHandler != null) {
            try {
                this.fContentHandler.skippedEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        return true;
    }

    public boolean skippedEntityInContent(int n) {
        if (this.fContentHandler != null) {
            try {
                this.fContentHandler.skippedEntity(this.handleToString(n));
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        return true;
    }

    public void startDTDEntity() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endDTDEntity() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void startPE(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                String string = xMLString.toString();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('%');
                stringBuffer.append(string);
                string = stringBuffer.toString();
                this.fLexicalHandler.startEntity(string);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endPE(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                String string = xMLString.toString();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('%');
                stringBuffer.append(string);
                string = stringBuffer.toString();
                this.fLexicalHandler.endEntity(string);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    protected void pushElement(QName qName) {
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.fInElementContent = this.pushInElementContent(this.fDTDGrammar.hasElementContent(qName.handle));
        }
    }

    protected void popElement() {
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.fInElementContent = this.popInElementContent();
        }
    }

    protected boolean getScanExternalGeneralEntities(String string) {
        return this.fDTDScanner.getScanExternalGeneralEntities();
    }

    protected void setScanExternalGeneralEntities(String string, boolean bl) {
        this.fDTDScanner.setScanExternalGeneralEntities(bl);
    }

    protected boolean getScanExternalParameterEntities(String string) {
        return this.fDTDScanner.getScanExternalParameterEntities();
    }

    protected void setScanExternalParameterEntities(String string, boolean bl) {
        this.fDTDScanner.setScanExternalParameterEntities(bl);
    }

    protected DeclHandler getDeclHandler() {
        return this.fDTDScanner.getDeclHandler();
    }

    protected void setDeclHandler(DeclHandler declHandler) {
        this.fDTDScanner.setDeclHandler(declHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDScanner.getDTDHandler();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDScanner.setDTDHandler(dTDHandler);
    }

    public EntityResolver getEntityResolver() {
        return this.fEntityFactory.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityFactory.setEntityResolver(entityResolver);
    }
}

