/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataSource;
import com.ibm.xml.xlxp.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp.scan.util.XMLString;

public class ParsedEntity {
    public XMLString baseURI = new XMLString();
    public DataBuffer buffer;
    public byte[] bytes;
    public int offset;
    public int endOffset;
    public int startOffset = 0;
    public int id;
    public boolean lineBreaksNormalized;
    public boolean unbuffered;
    public CharConversionError error;
    private ParsedEntityFactory fEntityFactory;
    private DataSource fSource;
    private int[] fIntPointer;
    private int fMarkCount;
    private DataBuffer fMarkedBuffer;
    private int fMarkedOffset;
    private int fMarkedStartOffset;
    private int fMarkedEndOffset;
    private DataBuffer fContentLastBuffer;
    private int fContentEndOffset;
    private DataBuffer[] fMarkedBuffers;
    private int[] fMarkedOffsets;
    private int[] fMarkedStartOffsets;
    private int[] fMarkedEndOffsets;

    public ParsedEntity(ParsedEntityFactory parsedEntityFactory) {
        this.fEntityFactory = parsedEntityFactory;
        this.fIntPointer = new int[2];
    }

    public void clear() {
        this.baseURI.clear();
        this.bytes = null;
        this.startOffset = 0;
        this.lineBreaksNormalized = false;
        this.unbuffered = false;
        this.error = null;
        if (this.fSource != null) {
            this.fSource.release();
            this.fSource = null;
        }
        if (this.buffer != null) {
            this.buffer.removeReference();
            this.buffer = null;
        } else {
            UntestedCode.needTest("unknown(4)");
        }
        this.fMarkCount = 0;
        this.fContentLastBuffer = null;
    }

    public boolean load() {
        if (this.buffer.next == null) {
            if (this.fSource != null) {
                this.error = this.fSource.load(this);
                return false;
            }
            return true;
        }
        if (this.buffer != this.fContentLastBuffer) {
            this.advanceBuffer(0);
            return false;
        }
        return true;
    }

    public void setValues(DataBuffer dataBuffer, int n, int n2, DataSource dataSource) {
        if (this.buffer != null) {
            this.buffer.removeReference();
        }
        this.buffer = dataBuffer;
        dataBuffer.addReference();
        this.bytes = dataBuffer.bytes;
        this.offset = n;
        this.endOffset = n2;
        this.startOffset = n;
        this.unbuffered = dataSource == null;
        this.fSource = dataSource;
    }

    public void setContent(XMLString xMLString) {
        if (this.buffer != null) {
            UntestedCode.needTest("unknown(16)");
            this.buffer.removeReference();
        }
        this.buffer = xMLString.firstBuffer;
        this.buffer.addReference();
        this.bytes = this.buffer.bytes;
        this.startOffset = this.offset = xMLString.startOffset;
        if (xMLString.bytes != null) {
            this.endOffset = xMLString.endOffset;
            this.unbuffered = true;
            this.fContentLastBuffer = this.buffer;
            this.fContentEndOffset = this.endOffset;
        } else {
            DataBuffer dataBuffer = this.buffer;
            this.fContentLastBuffer = xMLString.lastBuffer;
            this.fContentEndOffset = xMLString.endOffset;
            do {
                dataBuffer = dataBuffer.next;
                dataBuffer.addReference();
            } while (dataBuffer != this.fContentLastBuffer);
            this.endOffset = this.buffer.endOffset;
            this.unbuffered = false;
        }
        this.fSource = null;
    }

    public void release() {
        this.fEntityFactory.releaseParsedEntity(this);
    }

    public void getEntireContents(XMLString xMLString) {
        DataBuffer dataBuffer = this.buffer;
        xMLString.setStartPos(this.buffer, this.offset);
        while (!this.load()) {
        }
        xMLString.setEndPos(this.buffer, this.endOffset, 0);
        if (!this.lineBreaksNormalized) {
            xMLString.flags |= 4;
        } else {
            UntestedCode.needTest("unknown(24)");
        }
    }

    private void pushMark() {
        int n = this.fMarkCount - 1;
        if (this.fMarkedBuffers == null) {
            this.fMarkedBuffers = new DataBuffer[4];
            this.fMarkedOffsets = new int[4];
            this.fMarkedStartOffsets = new int[4];
            this.fMarkedEndOffsets = new int[4];
        } else if (n == this.fMarkedBuffers.length) {
            UntestedCode.needTest("unknown(26)");
            int n2 = n << 1;
            DataBuffer[] dataBufferArray = new DataBuffer[n2];
            int[] nArray = new int[n2];
            System.arraycopy(this.fMarkedBuffers, 0, dataBufferArray, 0, n);
            this.fMarkedBuffers = dataBufferArray;
            System.arraycopy(this.fMarkedOffsets, 0, nArray, 0, n);
            this.fMarkedOffsets = nArray;
            nArray = new int[n2];
            System.arraycopy(this.fMarkedStartOffsets, 0, nArray, 0, n);
            this.fMarkedStartOffsets = nArray;
            nArray = new int[n2];
            System.arraycopy(this.fMarkedEndOffsets, 0, nArray, 0, n);
            this.fMarkedEndOffsets = nArray;
        }
        this.fMarkedBuffers[n] = this.fMarkedBuffer;
        this.fMarkedOffsets[n] = this.fMarkedOffset;
        this.fMarkedStartOffsets[n] = this.fMarkedStartOffset;
        this.fMarkedEndOffsets[n] = this.fMarkedEndOffset;
    }

    private void popMark() {
        int n = this.fMarkCount - 1;
        this.fMarkedBuffer = this.fMarkedBuffers[n];
        this.fMarkedOffset = this.fMarkedOffsets[n];
        this.fMarkedStartOffset = this.fMarkedStartOffsets[n];
        this.fMarkedEndOffset = this.fMarkedEndOffsets[n];
        this.fMarkedBuffers[n] = null;
    }

    public void setMark() {
        if (this.fMarkCount > 0) {
            this.pushMark();
        }
        this.fMarkedBuffer = this.buffer;
        this.buffer.addReference();
        this.fMarkedOffset = this.offset;
        this.fMarkedStartOffset = this.startOffset;
        this.fMarkedEndOffset = this.endOffset;
        ++this.fMarkCount;
    }

    public void clearMark() {
        this.fMarkedBuffer.removeReference();
        this.fMarkedBuffer = null;
        if (--this.fMarkCount > 0) {
            this.popMark();
        }
    }

    public void resetToMark() {
        if (this.buffer != this.fMarkedBuffer) {
            DataBuffer dataBuffer = this.fMarkedBuffer.next;
            while (dataBuffer != this.buffer) {
                dataBuffer.addReference();
                dataBuffer = dataBuffer.next;
            }
            this.buffer = this.fMarkedBuffer;
            this.bytes = this.buffer.bytes;
            this.unbuffered = false;
        } else {
            this.fMarkedBuffer.removeReference();
        }
        this.offset = this.fMarkedOffset;
        this.startOffset = this.fMarkedStartOffset;
        this.endOffset = this.fMarkedEndOffset;
        this.fMarkedBuffer = null;
        if (--this.fMarkCount > 0) {
            this.popMark();
        }
    }

    private void advanceBuffer(int n) {
        this.buffer = this.buffer.next;
        this.bytes = this.buffer.bytes;
        this.startOffset = this.buffer.startOffset;
        if (this.buffer == this.fContentLastBuffer) {
            this.endOffset = this.fContentEndOffset;
            this.unbuffered = true;
        } else {
            this.endOffset = this.buffer.endOffset;
            this.unbuffered = this.buffer.next == null && this.fSource == null;
        }
        this.offset = this.startOffset + n;
    }

    private void advanceOffset(int n) {
        this.offset += n;
        if (this.offset > this.endOffset) {
            n = this.offset - this.endOffset;
            this.advanceBuffer(n);
        }
    }

    public boolean skippedValidCharacter() {
        if (this.offset < this.endOffset || this.fSource != null) {
            UTF8Support.decodeCharacter(this, this.fIntPointer);
            if (this.error == null) {
                if (XMLCharacterProperties.validChar(this.fIntPointer[0])) {
                    this.advanceOffset(this.fIntPointer[1]);
                    return true;
                }
                return false;
            }
            return false;
        }
        UntestedCode.needTest("unknown(51)");
        return false;
    }

    public boolean skippedNameStartCharacter() {
        UTF8Support.decodeCharacter(this, this.fIntPointer);
        if (this.error == null) {
            if (XMLCharacterProperties.nameStartChar(this.fIntPointer[0])) {
                this.advanceOffset(this.fIntPointer[1]);
                return true;
            }
            return false;
        }
        UntestedCode.needTest("unknown(55)");
        return false;
    }

    public boolean skippedNameCharacter() {
        UTF8Support.decodeCharacter(this, this.fIntPointer);
        if (this.error == null) {
            if (XMLCharacterProperties.nameChar(this.fIntPointer[0])) {
                this.advanceOffset(this.fIntPointer[1]);
                return true;
            }
            return false;
        }
        UntestedCode.needTest("unknown(59)");
        return false;
    }

    public int decodeInvalidCharacter() {
        UTF8Support.decodeCharacter(this, this.fIntPointer);
        if (this.error == null) {
            return this.fIntPointer[0];
        }
        return -1;
    }
}

