#!/bin/ksh

# **************************************************************************
# *
# * File:  customerProfileEnterpriseDB.sh
# *
# * This file is for creating the Enterprise tables for the CustomerProfile AC
# *
# * Updated: November 30th, 2000
# *
# **************************************************************************

USAGE="\nUsage: customerProfileEnterpriseDB.sh database [userid password] [qualifier]"
qualifier=$1

function ErrorMessage
{
  print "$USAGE"
}

function DirectConnectWithCurrentUserid
{
  db2 connect to $1
  qualifier=$USER
  CreateTables
}

function DirectConnectWithQualifier1
{
  db2 connect to $1
  qualifier=$2
  CreateTables
}

function ConnectWithParWithUserid
{
  db2 connect to $1 user $2 using $3
  qualifier=$2
  CreateTables
}

function ConnectWithParWithQualifier2
{
  db2 connect to $1 user $2 using $3
  qualifier=$4
  CreateTables
}

function CreateTables
{

print ""
print "Creating Code Tables"
print ""
db2 drop table $qualifier.code_category
db2 drop table $qualifier.code_group
db2 drop table $qualifier.code
db2 drop table $qualifier.category_group

db2 create table $qualifier.code_category"(category_id char(5) not null primary key,description varchar(50))"
db2 insert into $qualifier.code_category values"('CON','Contact Information')"
db2 insert into $qualifier.code_category values"('CI' ,'Customer Information')"
db2 insert into $qualifier.code_category values"('TEL','Telephone Information')"
db2 insert into $qualifier.code_category values"('PI' ,'Personal Information')"
db2 insert into $qualifier.code_category values"('PN' ,'Person Name Information')"
db2 insert into $qualifier.code_category values"('BC' ,'Basic Customer Information')"
db2 insert into $qualifier.code_category values"('ADI','Address Information')"
db2 insert into $qualifier.code_category values"('EAI','Electronic Address Information')"
db2 insert into $qualifier.code_category values"('ENI','Enterprise Information')"

db2 create table $qualifier.code_group"(property_id char(5) not null primary key,description varchar(50))"
db2 insert into $qualifier.code_group values"('TEU','Telephone Usage')"
db2 insert into $qualifier.code_group values"('LA' ,'Language')"
db2 insert into $qualifier.code_group values"('AU' ,'Address Usage')"
db2 insert into $qualifier.code_group values"('NU' ,'Name Usage')"
db2 insert into $qualifier.code_group values"('EAU','Email Address Usage')"
db2 insert into $qualifier.code_group values"('COU','Country')"
db2 insert into $qualifier.code_group values"('REG','Region')"
db2 insert into $qualifier.code_group values"('CST','Customer Status')"
db2 insert into $qualifier.code_group values"('GEN','Gender')"
db2 insert into $qualifier.code_group values"('TTL','Title')"
 
db2 create table $qualifier.code"(code_id char(5) not null primary key, group char(5) not null, dependency_code char(5) default null, description varchar(50) default null, constraint codes_f_key foreign key(group) references $qualifier.code_group)"
db2 insert into $qualifier.code values"('BUF','TEU','ENT','Business Fax')"
db2 insert into $qualifier.code values"('BUP','TEU','ENT','Business Phone')"
db2 insert into $qualifier.code values"('REP','TEU','PER','Residential Phone')"
db2 insert into $qualifier.code values"('BPH','TEU','PER','Business Phone')"
db2 insert into $qualifier.code values"('HFX','TEU','PER','Home Fax')"
db2 insert into $qualifier.code values"('CEL','TEU','PER','Cellular')"
db2 insert into $qualifier.code values"('BFX','TEU','PER','Business Fax')"
db2 insert into $qualifier.code values"('ENG','LA' ,' '  ,'English')"
db2 insert into $qualifier.code values"('FRE','LA' ,' '  ,'French')"
db2 insert into $qualifier.code values"('USA','COU',' '  ,'United States of America')"
db2 insert into $qualifier.code values"('CAN','COU',' '  ,'Canada')"
db2 insert into $qualifier.code values"('ALB','REG','CAN','Alberta')"
db2 insert into $qualifier.code values"('MAN','REG','CAN','Manitoba')"
db2 insert into $qualifier.code values"('BC' ,'REG','CAN','British Columbia')"
db2 insert into $qualifier.code values"('NFL','REG','CAN','Newfoundland')"
db2 insert into $qualifier.code values"('NBR','REG','CAN','New Brunswick')"
db2 insert into $qualifier.code values"('NWT','REG','CAN','NW Territories')"
db2 insert into $qualifier.code values"('NSC','REG','CAN','Nova Scotia')"
db2 insert into $qualifier.code values"('ONT','REG','CAN','Ontario')"
db2 insert into $qualifier.code values"('PEI','REG','CAN','Prince Edward Island')"
db2 insert into $qualifier.code values"('QUE','REG','CAN','Quebec')"
db2 insert into $qualifier.code values"('SAS','REG','CAN','Saskatchewan')"
db2 insert into $qualifier.code values"('YKN','REG','CAN','Yukon')"
db2 insert into $qualifier.code values"('AL' ,'REG','USA','Alabama')"
db2 insert into $qualifier.code values"('AK' ,'REG','USA','Alaska')"
db2 insert into $qualifier.code values"('AR' ,'REG','USA','Arkansas')"
db2 insert into $qualifier.code values"('NC' ,'REG','USA','North Carolina')"
db2 insert into $qualifier.code values"('SC' ,'REG','USA','South Carolina')"
db2 insert into $qualifier.code values"('VI' ,'REG','USA','Virgin Islands')"
db2 insert into $qualifier.code values"('IL' ,'REG','USA','Illinois')"
db2 insert into $qualifier.code values"('SD' ,'REG','USA','South Dakota')"
db2 insert into $qualifier.code values"('ND' ,'REG','USA','North Dakota')"
db2 insert into $qualifier.code values"('WV' ,'REG','USA','West Virginia')"
db2 insert into $qualifier.code values"('OH' ,'REG','USA','Ohio')"
db2 insert into $qualifier.code values"('FL' ,'REG','USA','Florida')"
db2 insert into $qualifier.code values"('NY' ,'REG','USA','New York')"
db2 insert into $qualifier.code values"('IN' ,'REG','USA','Indiana')"
db2 insert into $qualifier.code values"('KY' ,'REG','USA','Kentucky')"
db2 insert into $qualifier.code values"('WI' ,'REG','USA','Wisconsin')"
db2 insert into $qualifier.code values"('UT' ,'REG','USA','Utah')"
db2 insert into $qualifier.code values"('WY' ,'REG','USA','Wyoming')"
db2 insert into $qualifier.code values"('CO' ,'REG','USA','Colorado')"
db2 insert into $qualifier.code values"('AZ' ,'REG','USA','Arizona')"
db2 insert into $qualifier.code values"('CA' ,'REG','USA','California')"
db2 insert into $qualifier.code values"('NV' ,'REG','USA','Nevada')"
db2 insert into $qualifier.code values"('ID' ,'REG','USA','Idaho')"
db2 insert into $qualifier.code values"('MS' ,'REG','USA','Mississippi')"
db2 insert into $qualifier.code values"('TX' ,'REG','USA','Texas')"
db2 insert into $qualifier.code values"('NM' ,'REG','USA','New Mexico')"
db2 insert into $qualifier.code values"('WA' ,'REG','USA','Washington')"
db2 insert into $qualifier.code values"('OR' ,'REG','USA','Oregon')"
db2 insert into $qualifier.code values"('NH' ,'REG','USA','New Hampshire')"
db2 insert into $qualifier.code values"('MD' ,'REG','USA','Maryland')"
db2 insert into $qualifier.code values"('VA' ,'REG','USA','Virginia')"
db2 insert into $qualifier.code values"('RI' ,'REG','USA','Rhode Island')"
db2 insert into $qualifier.code values"('DE' ,'REG','USA','Delaware')"
db2 insert into $qualifier.code values"('NJ' ,'REG','USA','New Jersey')"
db2 insert into $qualifier.code values"('MT' ,'REG','USA','Montana')"
db2 insert into $qualifier.code values"('OK' ,'REG','USA','Oklahoma')"
db2 insert into $qualifier.code values"('CT' ,'REG','USA','Conneticut')"
db2 insert into $qualifier.code values"('GA' ,'REG','USA','Georgia')"
db2 insert into $qualifier.code values"('GU' ,'REG','USA','Guam')"
db2 insert into $qualifier.code values"('HI' ,'REG','USA','Hawaii')"
db2 insert into $qualifier.code values"('IA' ,'REG','USA','Iowa')"
db2 insert into $qualifier.code values"('KS' ,'REG','USA','Kansas')"
db2 insert into $qualifier.code values"('LA' ,'REG','USA','Louisianna')"
db2 insert into $qualifier.code values"('ME' ,'REG','USA','Maine')"
db2 insert into $qualifier.code values"('MA' ,'REG','USA','Massachusetts')"
db2 insert into $qualifier.code values"('MI' ,'REG','USA','Michigan')"
db2 insert into $qualifier.code values"('MO' ,'REG','USA','Missouri')"
db2 insert into $qualifier.code values"('PA' ,'REG','USA','Pennsylvania')"
db2 insert into $qualifier.code values"('PR' ,'REG','USA','Puerto Rico')"
db2 insert into $qualifier.code values"('TN' ,'REG','USA','Tennessee')"
db2 insert into $qualifier.code values"('VT' ,'REG','USA','Vermont')"
db2 insert into $qualifier.code values"('DC' ,'REG','USA','District of Columbia')"
db2 insert into $qualifier.code values"('NE' ,'REG','USA','Nebraska')"
db2 insert into $qualifier.code values"('MN' ,'REG','USA','Minnesota')"
db2 insert into $qualifier.code values"('PRP','CST',' '  ,'Prospect')"
db2 insert into $qualifier.code values"('ACT','CST',' '  ,'Active')"
db2 insert into $qualifier.code values"('DMT','CST',' '  ,'Dormant')"
db2 insert into $qualifier.code values"('FMR','CST',' '  ,'Former')"
db2 insert into $qualifier.code values"('MAL','GEN',' '  ,'Male')"
db2 insert into $qualifier.code values"('FEM','GEN',' '  ,'Female')"
db2 insert into $qualifier.code values"('UKN','GEN',' '  ,'Unknown')"
db2 insert into $qualifier.code values"('MAI','AU' ,'ENT','Mailing')"
db2 insert into $qualifier.code values"('PPL','AU' ,'ENT','Principle')"
db2 insert into $qualifier.code values"('HOM','AU' ,'PER','Home')"
db2 insert into $qualifier.code values"('BUS','AU' ,'PER','Business')"
db2 insert into $qualifier.code values"('VAC','AU' ,'PER','Vacation')"
db2 insert into $qualifier.code values"('MAG','AU' ,'PER','Mailing')"
db2 insert into $qualifier.code values"('MAD','NU' ,'PER','Maiden Name')"
db2 insert into $qualifier.code values"('FOR','NU' ,'PER','Former Name')"
db2 insert into $qualifier.code values"('LGL','NU' ,'PER','Legal Name')"
db2 insert into $qualifier.code values"('NBI','NU' ,'PER','Name at Birth')"
db2 insert into $qualifier.code values"('MLG','NU' ,'PER','Mailing Name')"
db2 insert into $qualifier.code values"('LEG','NU' ,'ENT','Legal Name')"
db2 insert into $qualifier.code values"('FOM','NU' ,'ENT','Former Name')"
db2 insert into $qualifier.code values"('MNG','NU' ,'ENT','Mailing Name')"
db2 insert into $qualifier.code values"('PRI','NU' ,'ENT','Primary Name')"
db2 insert into $qualifier.code values"('HME','EAU','PER','Home')"
db2 insert into $qualifier.code values"('BSN','EAU','PER','Business')"
db2 insert into $qualifier.code values"('OTR','EAU','ENT','Other')"
db2 insert into $qualifier.code values"('PRM','EAU','ENT','Primary')"
db2 insert into $qualifier.code values"('MSS','TTL',' '  ,'Ms.')"
db2 insert into $qualifier.code values"('MIS','TTL',' '  ,'Miss')"
db2 insert into $qualifier.code values"('MR' ,'TTL',' '  ,'Mr.')"
db2 insert into $qualifier.code values"('MRS','TTL',' '  ,'Mrs.')"
db2 insert into $qualifier.code values"('DOC','TTL',' '  ,'Doctor')"
db2 insert into $qualifier.code values"('REV','TTL',' '  ,'Reverend')"
db2 insert into $qualifier.code values"('FTH','TTL',' '  ,'Father')"

db2 create table $qualifier.category_group"(id timestamp not null primary key,category char(5) not null,group char(5) not null, constraint category_f_key foreign key(category) references $qualifier.code_category, constraint group_f_key foreign key(group) references $qualifier.code_group)"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000002','CI' ,'LA')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000003','CI' ,'CST')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000005','CI' ,'GEN')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000007','CI' ,'TTL')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000009','CI' ,'NU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000013','CON','EAU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000014','CON','AU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000015','CON','TEU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000016','CON','COU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000017','CON','REG')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000023','TEL','TEU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000024','PI' ,'TTL')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000025','PI' ,'GEN')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000026','PI' ,'LA')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000029','PI' ,'CST')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000033','PN' ,'NU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000034','PN' ,'TTL')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000036','BC' ,'GEN')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000037','BC' ,'CST')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000038','BC' ,'LA')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000039','BC' ,'TEU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000047','ADI','AU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000048','ADI','REG')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000049','ADI','COU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000050','EAI','EAU')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000051','ENI','LA')"
db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000052','ENI','CST')"

db2 grant all on $qualifier.code_category to public
db2 grant all on $qualifier.code_group to public
db2 grant all on $qualifier.code to public
db2 grant all on $qualifier.category_group to public
print ""
print "Code Tables Created"
print ""


print ""
print "Creating Enterprise Tables"
print ""
db2 drop table $qualifier.customer
db2 drop table $qualifier.enterprise_info
db2 drop table $qualifier.enterprise_name

db2 create table $qualifier.customer"(id char(40) not null, synchKey timestamp not null, maintenanceFlag char(1) default null, status char(5) default null, type char(20) not null, add_col1 char(10) default null, add_col2 char(10) default null)"
db2 alter table $qualifier.customer add constraint customer_p_key primary key"(id)"
db2 alter table $qualifier.customer add constraint customer_f_key foreign key"(status)" references $qualifier.code

db2 create table  $qualifier.enterprise_info"( id char(40) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, start_date date default null, fiscal_year_end date default null, prefer_lang char(5) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
db2 alter table  $qualifier.enterprise_info add constraint ent_info_p_key primary key"(id)"
db2 alter table  $qualifier.enterprise_info add constraint ent_info_f_key  foreign key"(customer_id)" references $qualifier.customer on delete cascade 
db2 alter table  $qualifier.enterprise_info add constraint ent_info_f_key1 foreign key"(prefer_lang)" references $qualifier.code 

db2 create table  $qualifier.enterprise_name"( id char(40) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, full_name char(35) default null,  usage char(5) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
db2 alter table  $qualifier.enterprise_name add constraint ent_name_p_key primary key"(id)"
db2 alter table  $qualifier.enterprise_name add constraint ent_name_f_key  foreign key"(customer_id)" references $qualifier.customer on delete cascade 
db2 alter table  $qualifier.enterprise_name add constraint ent_name_f_key2 foreign key"(usage)" references $qualifier.code 

db2 grant all on $qualifier.customer to public
db2 grant all on $qualifier.enterprise_info to public
db2 grant all on $qualifier.enterprise_name to public
print ""
print "Enterprise Tables Created"
print ""


print ""
print "Creating Contact Points Tables"
print ""
db2 drop table $qualifier.postal_address
db2 drop table $qualifier.address_usage
db2 drop table $qualifier.phone_number
db2 drop table $qualifier.email_address

db2 create table  $qualifier.postal_address"( id char(30) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, city char(20) default null, country char(5) default null, address_lines varchar(80) default null, box_number char(12) default null, street_name char(30) default null, street_number char(12) default null, region char(5) default null, postal_code char(10) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
db2 alter table  $qualifier.postal_address add constraint address_p_key primary key"(id)"
db2 alter table  $qualifier.postal_address add constraint address_f_key  foreign key"(customer_id)"  references $qualifier.customer on delete cascade
db2 alter table  $qualifier.postal_address add constraint address_f_key1 foreign key"(country)" references $qualifier.code
db2 alter table  $qualifier.postal_address add constraint address_f_key2 foreign key"(region)" references $qualifier.code

db2 create table  $qualifier.address_usage"( id char(30) not null, maintenanceFlag char(1) default null, usage char(5) not null, address_id char(40) not null) "
db2 alter table  $qualifier.address_usage add constraint usage_p_key primary key"(id)"
db2 alter table  $qualifier.address_usage add constraint usage_f_key  foreign key"(address_id)"  references $qualifier.postal_address on delete cascade
db2 alter table  $qualifier.address_usage add constraint usage_f_key1 foreign key"(usage)" references $qualifier.code

db2 create table  $qualifier.phone_number"( id char(30) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, country_code char(4) default null, in_country_pref char(4) default null, area_code char(4) default null, local_number char(8) default null, extension char(4) default null, usage char(5) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
db2 alter table  $qualifier.phone_number add constraint phone_p_key primary key"(id)"
db2 alter table  $qualifier.phone_number add constraint phone_f_key foreign key"(customer_id)" references $qualifier.customer on delete cascade
db2 alter table  $qualifier.phone_number add constraint phone_f_key1 foreign key"(usage)" references $qualifier.code

db2 create table  $qualifier.email_address"( id char(30) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, user_name char(25) default null, domain_name char(25) default null, usage char(5) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
db2 alter table  $qualifier.email_address add constraint email_p_key primary key"(id)"
db2 alter table  $qualifier.email_address add constraint email_f_key foreign key"(customer_id)" references $qualifier.customer on delete cascade
db2 alter table  $qualifier.email_address add constraint email_f_key1 foreign key"(usage)" references $qualifier.code

db2 grant all on $qualifier.postal_address to public
db2 grant all on $qualifier.address_usage to public
db2 grant all on $qualifier.phone_number to public
db2 grant all on $qualifier.email_address to public
print ""
print "Contact Points Tables Created"
print ""
}

# *
# * Following block is for connecting to database and setting qualifier depending 
# * on number of parameters.
# *

if [[ $# = 0 ]]
then ErrorMessage
elif [[ $# = 1 ]]
then DirectConnectWithCurrentUserid $1
elif [[ $# = 2 ]]
then DirectConnectWithQualifier1 $1 $2
elif [[ $# = 3 ]]
then ConnectWithParWithUserid $1 $2 $3
elif [[ $# = 4 ]]
then ConnectWithParWithQualifier2 $1 $2 $3 $4
elif [[ $# > 4 ]]
then ErrorMessage
fi

db2 grant connect on database to public
db2 connect reset