/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.cdi.archive;

import com.ibm.rational.cdi.archive.ArchiveHandler;
import com.ibm.rational.cdi.archive.CDIInstallArchive;
import com.ibm.rational.cdi.util.Messages;
import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ArchiveHandler {
    private CDIInstallArchive cib;
    private Messages msgs;
    private TreeSet files;
    private TreeSet directories;
    int[] index;
    int totalNumberOfFiles = 0;
    int totalSize = 0;

    public ArchiveHandler(CDIInstallArchive bean) {
        this.cib = bean;
        this.msgs = new Messages("com.ibm.rational.cdi.archive.archivehandler");
        this.files = new TreeSet();
        this.directories = new TreeSet();
    }

    public void build(ProductBuilderSupport support) {
        Object[] zipfiles = this.validateArchiveDirectory(support);
        Arrays.sort(zipfiles);
        if (zipfiles.length == 0) {
            support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + this.msgs.getString("CDIInstallArchive.ERR_EmptyArchiveDirectory"));
        } else {
            this.index = new int[zipfiles.length];
            int i = 0;
            while (i < zipfiles.length) {
                Object zf = zipfiles[i];
                this.addZipfile((File)zf, support, i);
                ++i;
            }
            this.expandDirectories();
        }
    }

    private void expandDirectories() {
        Iterator iter = this.files.iterator();
        while (iter.hasNext()) {
            String filename = (String)iter.next();
            File f = new File(filename);
            this.addSubDirectories(f, this.directories);
        }
    }

    private void addSubDirectories(File f, Set dirset) {
        String parent = f.getParent();
        if (parent != null) {
            File p = new File(parent);
            String npath = FileUtils.appendSeparator(FileUtils.normalizeFileName(p.getPath(), '/'), "/");
            if (!dirset.contains(npath)) {
                dirset.add(npath);
            }
            this.addSubDirectories(p, dirset);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addZipfile(File zf, ProductBuilderSupport support, int fileNum) {
        try {
            ZipEntry ze;
            FileService fs = (FileService)this.cib.getServices().getService("fileService");
            if (!fs.fileExists(zf.getPath())) {
                support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + this.msgs.getString("CDIInstallArchive.ERR_CompressedFileMissing", zf.getPath()));
            }
            URI zipUri = zf.toURI();
            ZipInputStream in = new ZipInputStream(zipUri.toURL().openStream());
            while ((ze = in.getNextEntry()) != null) {
                void var7_8;
                in.closeEntry();
                ++this.totalNumberOfFiles;
                this.totalSize = (int)((long)this.totalSize + var7_8.getSize());
                if (var7_8.isDirectory()) {
                    this.directories.add(FileUtils.appendSeparator(FileUtils.normalizeFileName(var7_8.getName(), '/'), "/"));
                    continue;
                }
                this.files.add(FileUtils.normalizeFileName(var7_8.getName(), '/'));
            }
            in.close();
            String resrcId = this.cib.getBeanId() + "_compressed_" + fileNum;
            ArchiveIndexEntry entry = support.putNormalResource(zf.getPath(), resrcId);
            this.index[fileNum] = entry.entryNumber;
            support.excludeUninstallerResource(resrcId);
        }
        catch (Exception e) {
            support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean install(ProductActionSupport support, int[] indices, int totalTime, int fileCount) throws IOException {
        boolean cancel = false;
        if (indices != null) {
            this.index = indices;
            byte[] buffer = new byte[16384];
            int i = 0;
            while (i < indices.length) {
                ZipEntry ze;
                URL zipUrl = null;
                try {
                    zipUrl = this.cib.getNormalResource(this.index[i]);
                }
                catch (ServiceException se) {
                    throw new IOException(se.toString());
                }
                ZipInputStream in = new ZipInputStream(zipUrl.openStream());
                while ((ze = in.getNextEntry()) != null) {
                    void var10_11;
                    if (support.getOperationState().isCanceled()) {
                        support.logEvent(this.cib, "wrn", this.cib.getBeanId() + ":" + this.msgs.getString("ArchiveHandler.WRN_installCancelled"));
                        cancel = true;
                        break;
                    }
                    String filename = var10_11.getName();
                    File f = new File(this.cib.getInstallLocation(), filename);
                    support.logEvent(this.cib, "dbg", this.cib.getBeanId() + ":" + this.msgs.getString("CDIInstallArchive.MSG_Extracting", f.getAbsolutePath()));
                    support.getOperationState().setStatusDetail(f.getPath());
                    if (!var10_11.isDirectory()) {
                        int len;
                        buffer = new byte[16384];
                        FileOutputStream os = new FileOutputStream(new File(this.cib.getInstallLocation(), filename));
                        while ((len = in.read(buffer)) != -1) {
                            void var13_14;
                            ((OutputStream)os).write(buffer, 0, (int)var13_14);
                        }
                        ((OutputStream)os).close();
                    }
                    in.closeEntry();
                    support.getOperationState().updatePercentComplete(totalTime, 1L, fileCount);
                }
                in.close();
                ++i;
            }
        }
        return cancel;
    }

    public void uninstall(ProductActionSupport support) {
    }

    private File[] validateArchiveDirectory(ProductBuilderSupport support) throws IllegalArgumentException {
        File[] fileList = null;
        if (this.cib.getArchiveDirectory().equals("")) {
            support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + this.msgs.getString("ArchiveHandler.ERR_ArchiveDirPropNotSet"));
            throw new IllegalArgumentException(this.cib.getBeanId() + ":" + this.msgs.getString("ArchiveHandler.ERR_ArchiveDirPropNotSet"));
        }
        File srcDir = new File(this.cib.getServices().resolveString(this.cib.getArchiveDirectory()));
        fileList = srcDir.listFiles((FilenameFilter)new ArchiveDirectoryZipFileFilter(this));
        if (fileList == null) {
            support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + this.msgs.getString("CDIInstallArchive.ERR_ArchiveDirectoryNotDir", srcDir.getAbsolutePath()));
            throw new IllegalArgumentException(this.cib.getBeanId() + ":" + this.msgs.getString("CDIInstallArchive.ERR_ArchiveDirectoryNotDir", srcDir.getAbsolutePath()));
        }
        return fileList;
    }

    public TreeSet getDirectories() {
        return this.directories;
    }

    public TreeSet getFiles() {
        return this.files;
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getTotalNumberOfFiles() {
        return this.totalNumberOfFiles;
    }

    public int getTotalSize() {
        return this.totalSize;
    }
}

