/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.cdi.archive;

import com.ibm.rational.cdi.archive.CDIInstallArchive;
import com.ibm.rational.cdi.archive.SymLink;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StoredFileList {
    private String filename = null;
    private TreeSet fileList = null;
    private TreeSet dirList = null;
    private int[] index = null;
    private int totalSize = 0;
    private int totalNumberOfFiles = 0;
    private TreeSet symbolicLinks = null;
    private CDIInstallArchive cib = null;

    public StoredFileList(CDIInstallArchive bean, String store_filename) {
        this.cib = bean;
        this.dirList = new TreeSet(new FileComparator());
        this.fileList = new TreeSet(new FileComparator());
        this.symbolicLinks = new TreeSet();
        this.filename = store_filename;
    }

    public boolean store(ProductBuilderSupport support) {
        boolean rc = false;
        Document doc = this.createDocument(support);
        rc = this.write(doc, support);
        return rc;
    }

    private Document createDocument(ProductBuilderSupport support) {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = fac.newDocumentBuilder();
            doc = builder.newDocument();
            this.buildDocument(doc, support);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return doc;
    }

    private void buildDocument(Document doc, ProductBuilderSupport support) {
        Element top = doc.createElement("common_install_bean");
        top.setAttribute("id", this.cib.getBeanId());
        top.setAttribute("totalSize", Integer.toString(this.totalSize));
        top.setAttribute("totalFiles", Integer.toString(this.totalNumberOfFiles));
        this.addFiles(doc, top);
        this.addDirectories(doc, top);
        this.addArchiveIndices(doc, top);
        this.addLinks(doc, top);
        doc.appendChild(top);
        doc.normalize();
    }

    private void addArchiveIndices(Document doc, Element top) {
        if (this.index != null) {
            int i = 0;
            while (i < this.index.length) {
                String archive = Integer.toString(this.index[i]);
                Element ae = doc.createElement("archive");
                ae.setAttribute("id", archive);
                top.appendChild(ae);
                top.appendChild(doc.createTextNode("\n"));
                ++i;
            }
        }
    }

    private void addLinks(Document doc, Element top) {
        if (this.symbolicLinks != null) {
            Iterator iter = this.symbolicLinks.iterator();
            while (iter.hasNext()) {
                SymLink sl = (SymLink)iter.next();
                Element le = doc.createElement("link");
                le.setAttribute("from", sl.getFrom());
                le.setAttribute("to", sl.getTo());
                top.appendChild(le);
                top.appendChild(doc.createTextNode("\n"));
            }
        }
    }

    private void addDirectories(Document doc, Element top) {
        if (this.dirList != null) {
            Iterator iter = this.dirList.iterator();
            while (iter.hasNext()) {
                String d = (String)iter.next();
                Element de = doc.createElement("directory");
                de.setAttribute("name", d);
                top.appendChild(de);
                top.appendChild(doc.createTextNode("\n"));
            }
        }
    }

    private void addFiles(Document doc, Element top) {
        if (this.fileList != null) {
            Iterator iter = this.fileList.iterator();
            while (iter.hasNext()) {
                String f = (String)iter.next();
                Element ef = doc.createElement("file");
                ef.setAttribute("name", f);
                top.appendChild(ef);
                top.appendChild(doc.createTextNode("\n"));
            }
        }
    }

    private boolean write(Document doc, ProductBuilderSupport support) {
        boolean rc = false;
        try {
            File fxml = new File(FileUtils.createTempFile());
            StreamResult sr = new StreamResult(fxml);
            DOMSource ds = new DOMSource(doc);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(ds, sr);
            support.putApplicationResource(fxml.getAbsolutePath(), this.cib.getBeanId() + ".store.xml");
            rc = true;
        }
        catch (TransformerConfigurationException e) {
            support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + "Store error" + e.getMessage());
        }
        catch (TransformerException e) {
            support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + "Store error" + e.getMessage());
        }
        catch (IOException e) {
            support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + "Store error" + e.getMessage());
        }
        return rc;
    }

    public File load(ProductActionSupport support) throws ProductException {
        boolean rc = false;
        File file = null;
        try {
            URL storedFile = this.cib.getResource(this.filename);
            String location = FileUtils.createTempFile(storedFile);
            file = new File(location);
            Document doc = this.loadDocument(file);
            rc = this.loadLists(doc);
        }
        catch (IOException e) {
            support.logEvent(this.cib, "err", this.cib.getBeanId() + ":" + e.getMessage());
            throw new ProductException(e);
        }
        return file;
    }

    private boolean loadLists(Document doc) {
        boolean rc = false;
        if (doc != null) {
            String name;
            Element e;
            int i;
            rc = true;
            Element bean = doc.getDocumentElement();
            String ssize = bean.getAttribute("totalSize");
            String scount = bean.getAttribute("totalFiles");
            this.totalNumberOfFiles = Integer.parseInt(scount);
            this.totalSize = Integer.parseInt(ssize);
            NodeList nl = doc.getElementsByTagName("file");
            if (nl.getLength() > 0) {
                i = 0;
                while (i < nl.getLength()) {
                    e = (Element)nl.item(i);
                    name = e.getAttribute("name");
                    this.fileList.add(name);
                    ++i;
                }
            }
            if ((nl = doc.getElementsByTagName("directory")).getLength() > 0) {
                i = 0;
                while (i < nl.getLength()) {
                    e = (Element)nl.item(i);
                    name = e.getAttribute("name");
                    this.dirList.add(name);
                    ++i;
                }
            }
            if ((nl = doc.getElementsByTagName("archive")).getLength() > 0) {
                this.index = new int[nl.getLength()];
                i = 0;
                while (i < nl.getLength()) {
                    e = (Element)nl.item(i);
                    String id = e.getAttribute("id");
                    this.index[i] = Integer.parseInt(id);
                    ++i;
                }
            }
            if ((nl = doc.getElementsByTagName("link")).getLength() > 0) {
                i = 0;
                while (i < nl.getLength()) {
                    e = (Element)nl.item(i);
                    String from = e.getAttribute("from");
                    String to = e.getAttribute("to");
                    this.symbolicLinks.add(new SymLink(from, to));
                    ++i;
                }
            }
        }
        return rc;
    }

    private Document loadDocument(File file) throws ProductException {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = fac.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (SAXException e) {
            throw new ProductException(e);
        }
        catch (IOException e) {
            throw new ProductException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ProductException(e);
        }
        return doc;
    }

    public TreeSet getDirlist() {
        return this.dirList;
    }

    public void setDirlist(TreeSet dirlist) {
        this.dirList = dirlist;
    }

    public TreeSet getFileList() {
        return this.fileList;
    }

    public void setFileList(TreeSet fileList) {
        this.fileList = fileList;
    }

    public int[] getIndex() {
        return this.index;
    }

    public void setIndex(int[] index) {
        this.index = index;
    }

    public int getTotalNumberOfFiles() {
        return this.totalNumberOfFiles;
    }

    public void setTotalNumberOfFiles(int totalNumberOfFiles) {
        this.totalNumberOfFiles = totalNumberOfFiles;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public void setSymbolicLinks(TreeSet symlinks) {
        this.symbolicLinks = symlinks;
    }

    public TreeSet getSymbolicLinks() {
        return this.symbolicLinks;
    }

    class FileComparator
    implements Comparator {
        FileComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int rc = -1;
            rc = s1.compareTo(s2);
            if (rc < 0) {
                rc = 1;
            } else if (rc > 0) {
                rc = -1;
            }
            return rc;
        }
    }
}

