/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.cdi.archive;

import com.ibm.rational.cdi.archive.CDIInstallArchive;
import com.installshield.product.ProductException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.IOException;

public class SymLink
implements Comparable {
    private String from;
    private String to;

    public SymLink(String from, String to) {
        this.to = to;
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public int compareTo(Object o) {
        int rc = -1;
        SymLink so = (SymLink)o;
        rc = (this.from + "=" + this.to).compareTo(so.getFrom() + "=" + so.getTo());
        return rc;
    }

    private String validateLinkCommand(CDIInstallArchive cdi) throws ProductException {
        String cmd;
        block4: {
            cmd = null;
            try {
                FileService fs = (FileService)cdi.getServices().getService("fileService");
                if (fs.fileExists("/bin/ln")) {
                    cmd = "/bin/ln";
                    break block4;
                }
                if (fs.fileExists("/usr/bin/ln")) {
                    cmd = "/usr/bin/ln";
                    break block4;
                }
                throw new ProductException(601, "err", "ln command was not found.");
            }
            catch (ServiceException se) {
                throw new ProductException(601, "err", "Could not instantiate the FileService");
            }
        }
        return cmd;
    }

    public boolean performLink(CDIInstallArchive cdi) throws ProductException {
        boolean rc;
        block3: {
            rc = false;
            if (System.getProperty("os.name").startsWith("Windows")) break block3;
            String linkcmd = this.validateLinkCommand(cdi);
            String toLink = cdi.getServices().resolveString(this.to);
            String fromLink = cdi.getServices().resolveString(this.from);
            String[] args = new String[]{linkcmd, "-fs", toLink, fromLink};
            cdi.logEvent(cdi, "dbg", "Linking: " + toLink + " to " + fromLink);
            File installDir = new File(cdi.getInstallLocation());
            try {
                Process p = Runtime.getRuntime().exec(args, null, installDir);
                p.waitFor();
                rc = true;
            }
            catch (IOException e) {
                cdi.logEvent(cdi, "err", cdi.getBeanId() + ":symlink:" + e.getMessage());
            }
            catch (InterruptedException e) {
                cdi.logEvent(cdi, "err", cdi.getBeanId() + ":symlink:" + e.getMessage());
            }
        }
        return rc;
    }
}

