/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.cdi.common;

import com.ibm.rational.cdi.cib.Registry;
import com.ibm.rational.cdi.exception.CDIException;
import com.ibm.rational.cdi.util.Messages;
import com.installshield.product.service.product.ProductService;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;

public class FindCIBLocation
extends WizardAction {
    private String cdiInstallArchiveBeanId = "";
    private String installLocation = "";
    private String cdiHome = "";
    private Messages msgs = new Messages("com.ibm.rational.cdi.common.common");
    private String component;

    public void execute(WizardBeanEvent event) {
        this.installLocation = this.resolveString("$D(install)");
        try {
            ProductService ps = (ProductService)event.getWizard().getServices().getService("productService");
            this.installLocation = (String)ps.getProductBeanProperty("/product.xml", this.cdiInstallArchiveBeanId, "installLocation");
            this.cdiHome = (String)ps.getProductBeanProperty("/product.xml", this.cdiInstallArchiveBeanId, "commonInstallHome");
            ps.getProductTreeRoot("/product.xml");
            if (this.cdiHome.length() > 0) {
                String ret;
                this.cdiHome = this.resolveString(this.cdiHome);
                this.component = this.resolveString(this.component);
                Registry reg = new Registry(this.cdiHome);
                reg.setPrimaryBeanId(this.component);
                this.installLocation = ret = reg.getBeanInstallLocation(this.cdiInstallArchiveBeanId);
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (CDIException e) {
            e.printStackTrace();
        }
    }

    public void build(WizardBuilderSupport support) {
        if (this.cdiInstallArchiveBeanId.equals("")) {
            this.logEvent(support, "err", this.msgs.getString("FindCIBLocation.CIBNotSet"));
            throw new IllegalArgumentException(this.getBeanId() + ":" + this.msgs.getString("FindCIBLocation.CIBNotSet"));
        }
        try {
            support.putClass("com.ibm.rational.cdi.cib.Registry");
            support.putClass("com.ibm.rational.cdi.cib.StringSet");
            support.putClass("com.ibm.rational.cdi.util.Messages");
            support.putClass("com.ibm.rational.cdi.exception.RegistryInvalid");
            support.putClass("com.ibm.rational.cdi.exception.CDIException");
            support.putClassResource("com/ibm/rational/cdi/cib/registry.properties");
            support.putClassResource("com/ibm/rational/cdi/common/common.properties");
            support.putRequiredService("productService");
        }
        catch (IOException e1) {
            support.logEvent(this, "err", this.getBeanId() + ":" + e1.getMessage());
        }
    }

    public String getCdiInstallArchiveBeanId() {
        return this.cdiInstallArchiveBeanId;
    }

    public void setCdiInstallArchiveBeanId(String commonInstallBeanId) {
        this.cdiInstallArchiveBeanId = commonInstallBeanId;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public void setInstallLocation(String installLocation) {
        this.installLocation = installLocation;
    }

    public String getCdiHome() {
        return this.cdiHome;
    }

    public void setCdiHome(String cdiHome) {
        this.cdiHome = cdiHome;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String commonInstallComponent) {
        this.component = commonInstallComponent;
    }
}

