/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.archive.ArchiveBuilderSupport;
import com.installshield.product.Locatable;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanCondition;
import com.installshield.product.ProductTree;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.SoftwareVersion;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.ConditionSet;
import com.installshield.util.OperationRejectedException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;

public class GenericSoftwareObject
extends ProductBean
implements SoftwareObject,
PropertyAccessible,
Locatable {
    private String localizedDisplayName = null;
    private SoftwareObjectKey key = new SoftwareObjectKey();
    private long built = 0L;
    private String name = null;
    private String description = null;
    private String vendor = null;
    private String vendorWebsite = null;
    private String productNumber = null;
    private boolean activeForUninstall = true;
    private String installLocation = null;
    private String[] sources = new String[0];
    private RequiredTree required = null;
    private SoftwareVersion[] compatibleVersions = new SoftwareVersion[0];
    private boolean publiclyShareable = false;
    private String uninstaller = null;
    private int status = 0;
    private int replaceOption = 0;
    private int removeOption = 0;
    private int installFailureOption = 3;
    private int replaceFailureOption = 1;
    private String locale = null;
    private ConditionSet conditionSet = new ConditionSet();
    private SoftwareObjectKey[] parents = new SoftwareObjectKey[0];
    private String conditionOperator = "AND";

    public void addRequired(GenericSoftwareObject genericSoftwareObject) {
        block3: {
            Enumeration enumeration = this.getRequiredTree().children(this.getRequiredTree().getRoot());
            boolean bl = true;
            while (bl && enumeration.hasMoreElements()) {
                SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)enumeration.nextElement();
                bl = softwareObjectReference.getKey().equals(genericSoftwareObject.getKey()) ^ true;
            }
            if (!bl) break block3;
            try {
                this.getRequiredTree().add(this.getRequiredTree().getRoot(), new SoftwareObjectReference(genericSoftwareObject));
            }
            catch (OperationRejectedException operationRejectedException) {}
        }
    }

    public void build(ArchiveBuilderSupport archiveBuilderSupport) {
        this.built = System.currentTimeMillis();
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        Enumeration enumeration = this.conditionNames();
        while (enumeration.hasMoreElements()) {
            ProductBeanCondition productBeanCondition = this.getCondition((String)enumeration.nextElement());
            Enumeration enumeration2 = productBeanCondition.buildCategories().keys();
            while (enumeration2.hasMoreElements()) {
                dictionary.put(enumeration2.nextElement(), "");
            }
        }
        return dictionary;
    }

    public Enumeration conditionNames() {
        return this.conditionSet.names();
    }

    public boolean conditionsMet() {
        return this.conditionSet.isMet();
    }

    public void evaluateImmutableConditions() {
        this.conditionSet.evaluateImmutableConditions();
    }

    public String getAbsoluteInstallLocation() {
        if (this.getProductTree() != null) {
            return this.getProductTree().getInstallLocation(this);
        }
        return this.getInstallLocation();
    }

    public SoftwareVersion[] getCompatibleVersions() {
        return this.compatibleVersions;
    }

    public ProductBeanCondition getCondition(String string) {
        return (ProductBeanCondition)this.conditionSet.get(string);
    }

    public String getConditionOperator() {
        return this.conditionOperator;
    }

    public Date getDateBuilt() {
        return new Date(this.built);
    }

    public String getDescription() {
        return this.description;
    }

    public int getInstallFailureOption() {
        return this.installFailureOption;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public int getInstallStatus() {
        return this.status;
    }

    public SoftwareObjectKey getKey() {
        return this.key;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getLocalizedDisplayName() {
        return this.localizedDisplayName;
    }

    public String getName() {
        return this.name;
    }

    public GenericSoftwareObject getParent() {
        ProductBean productBean = this.getProductTree().getParent(this);
        if (productBean != null && !(productBean instanceof GenericSoftwareObject)) {
            throw new Error();
        }
        return (GenericSoftwareObject)productBean;
    }

    public SoftwareObjectKey[] getParents() {
        return this.parents;
    }

    public String getProductNumber() {
        return this.productNumber;
    }

    public int getRemoveOption() {
        return this.removeOption;
    }

    public int getReplaceFailureOption() {
        return this.replaceFailureOption;
    }

    public int getReplaceOption() {
        return this.replaceOption;
    }

    public SoftwareObjectReference[] getRequired() {
        if (this.required == null) {
            return new SoftwareObjectReference[0];
        }
        SoftwareObjectReference[] softwareObjectReferenceArray = new SoftwareObjectReference[this.required.getChildCount(this.required.getRoot())];
        SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)this.required.getFirstChild(this.required.getRoot());
        int n = 0;
        while (softwareObjectReference != null) {
            softwareObjectReferenceArray[n++] = softwareObjectReference;
            softwareObjectReference = (SoftwareObjectReference)this.required.getNextSibling(softwareObjectReference);
        }
        return softwareObjectReferenceArray;
    }

    public ProductTree getRequiredTree() {
        if (this.required == null) {
            this.required = new RequiredTree(this);
        }
        return this.required;
    }

    public String[] getSources() {
        return this.sources;
    }

    public String getUninstaller() {
        return this.uninstaller;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVendorWebsite() {
        return this.vendorWebsite;
    }

    public boolean immutableConditionsMet() {
        return this.conditionSet.isImmutableMet();
    }

    public boolean isActiveForUninstall() {
        return this.activeForUninstall;
    }

    public boolean isPubliclyShareable() {
        return this.publiclyShareable;
    }

    public void putCondition(String string, ProductBeanCondition productBeanCondition) {
        this.conditionSet.put(string, productBeanCondition);
        productBeanCondition.setProductBean(this);
    }

    public void removeCondition(String string) {
        this.conditionSet.remove(string);
    }

    public void setActiveForUninstall(boolean bl) {
        this.activeForUninstall = bl;
    }

    public void setCompatibleVersions(SoftwareVersion[] softwareVersionArray) {
        if (softwareVersionArray == null) {
            throw new IllegalArgumentException("versions cannot be null");
        }
        this.compatibleVersions = softwareVersionArray;
    }

    public void setConditionOperator(String string) {
        this.conditionOperator = string;
        this.conditionSet.setOperator(this.conditionOperator);
    }

    public void setDateBuilt(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        this.built = date.getTime();
    }

    public void setDescription(String string) {
        this.description = string;
        if (this.description != null && this.description.trim().length() == 0) {
            this.description = null;
        }
    }

    public void setInstallFailureOption(int n) {
        this.installFailureOption = n;
    }

    public void setInstallLocation(String string) {
        this.installLocation = string != null && string.trim().length() == 0 ? null : string;
    }

    public void setInstallStatus(int n) {
        this.status = n;
    }

    public void setKey(SoftwareObjectKey softwareObjectKey) {
        if (softwareObjectKey == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.key = softwareObjectKey;
    }

    public void setLocale(String string) {
        this.locale = string;
        if (this.locale != null && this.locale.trim().length() == 0) {
            this.locale = null;
        }
    }

    public void setLocalizedDisplayName(String string) {
        this.localizedDisplayName = string;
    }

    public void setName(String string) {
        this.name = string;
        if (this.name != null && this.name.trim().length() == 0) {
            this.name = null;
        }
    }

    public void setParents(SoftwareObjectKey[] softwareObjectKeyArray) {
        if (softwareObjectKeyArray == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        this.parents = softwareObjectKeyArray;
    }

    public void setProductNumber(String string) {
        this.productNumber = string;
        if (this.productNumber != null && this.productNumber.trim().length() == 0) {
            this.productNumber = null;
        }
    }

    public void setPubliclyShareable(boolean bl) {
        this.publiclyShareable = bl;
    }

    public void setRemoveOption(int n) {
        this.removeOption = n;
    }

    public void setReplaceFailureOption(int n) {
        this.replaceFailureOption = n;
    }

    public void setReplaceOption(int n) {
        this.replaceOption = n;
    }

    public void setRequired(SoftwareObjectReference[] softwareObjectReferenceArray) {
        this.required = null;
        if (softwareObjectReferenceArray.length > 0) {
            try {
                this.required = new RequiredTree(this);
                int n = 0;
                while (n < softwareObjectReferenceArray.length) {
                    this.required.add(this.required.getRoot(), softwareObjectReferenceArray[n]);
                    ++n;
                }
            }
            catch (OperationRejectedException operationRejectedException) {
                throw new Error();
            }
        }
    }

    public void setSources(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("sources cannot be null");
        }
        this.sources = stringArray;
    }

    public void setUninstaller(String string) {
        this.uninstaller = string;
        if (this.uninstaller != null && this.uninstaller.trim().length() == 0) {
            this.uninstaller = null;
        }
    }

    public void setVendor(String string) {
        this.vendor = string;
        if (this.vendor != null && this.vendor.trim().length() == 0) {
            this.vendor = null;
        }
    }

    public void setVendorWebsite(String string) {
        this.vendorWebsite = string;
        if (this.vendorWebsite != null && this.vendorWebsite.trim().length() == 0) {
            this.vendorWebsite = null;
        }
    }

    class RequiredTree
    extends ProductTree {
        private GenericSoftwareObject dependant;

        RequiredTree(GenericSoftwareObject genericSoftwareObject2) {
            this.dependant = genericSoftwareObject2;
            try {
                this.setRoot(new RequiredTreeRoot());
            }
            catch (OperationRejectedException operationRejectedException) {
                throw new Error();
            }
        }

        public boolean canAdd(ProductBean productBean, ProductBean productBean2) {
            return true;
        }

        GenericSoftwareObject getDependant() {
            return this.dependant;
        }

        public ProductBean getParent(ProductBean productBean) {
            ProductBean productBean2 = super.getParent(productBean);
            if (productBean2 instanceof RequiredTreeRoot) {
                productBean2 = this.getDependant();
            }
            return productBean2;
        }

        public SoftwareObject resolveKey(SoftwareObjectKey softwareObjectKey) {
            return this.dependant.getProductTree().resolveKey(softwareObjectKey);
        }
    }

    class RequiredTreeRoot
    extends ProductBean {
        RequiredTreeRoot() {
        }
    }
}

