/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

public class ProductException
extends Exception {
    public static final int JAVA_EXCEPTION = 200;
    public static final int PRODUCT_ACTION_LOAD_ERROR = 401;
    public static final int PRODUCT_ACTION_INSTALL_FAILED = 601;
    private int code = 0;
    private String msg = null;
    private Object data = null;

    public ProductException(int n) {
        this.code = n;
    }

    public ProductException(int n, Object object) {
        this(n, null, object);
    }

    public ProductException(int n, String string) {
        this.code = n;
        this.msg = string;
    }

    public ProductException(int n, String string, Object object) {
        this(n, string);
        this.data = object;
    }

    public ProductException(Throwable throwable) {
        this(throwable, throwable.getMessage());
    }

    public ProductException(Throwable throwable, String string) {
        this.code = 200;
        string = throwable.getMessage();
        this.data = throwable;
    }

    public Object getData() {
        return this.data;
    }

    private String getDataDesc() {
        if (this.code == 200) {
            return "exception";
        }
        return "additional data";
    }

    public int getErrorCode() {
        return this.code;
    }

    public static String getErrorMsg(int n) {
        switch (n) {
            case 401: {
                return "error loading product action";
            }
            case 601: {
                return "error installing product action";
            }
            case 200: {
                return "Java error";
            }
        }
        return "unknown error code";
    }

    public String getMessage() {
        return this.msg != null ? this.msg : ProductException.getErrorMsg(this.code);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("usage: ProductException error_code");
            System.exit(-1);
        }
        try {
            System.out.println(ProductException.getErrorMsg(Integer.parseInt(stringArray[0])));
        }
        catch (Exception exception) {
            System.out.println("invalid error code: " + stringArray[0]);
        }
    }

    public String toString() {
        return "ProductException: (error code = " + this.code + "; message=\"" + this.getMessage() + "\"" + (this.data != null ? "; " + this.getDataDesc() + " = [" + this.data + "]" : "") + ")";
    }
}

