/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.WizardException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AsciiFileUpdateProductAction
extends ProductAction
implements AsciiFileUpdateSupport {
    private String asciiFile = "";
    private String commentChars = "";
    private boolean rebootRequired = false;
    private Vector installActionsList = new Vector();
    private Update[] installActions = null;
    private Vector uninstallActionsList = new Vector();
    private Update[] uninstallActions = null;
    private boolean backupAsciiFile = true;
    private boolean overwriteExistingFile = false;
    private boolean deleteFileOnUninstall = false;
    private String[] createdDirs = new String[0];
    private boolean enableOnReinstalls = false;
    private String installedFileName = null;
    static /* synthetic */ Class class$com$installshield$product$actions$AsciiFileUpdateProductActionBeanInfo;

    public void addInstallAction(Update update) {
        this.installActionsList.addElement(update);
    }

    public void addUninstallAction(Update update) {
        this.uninstallActionsList.addElement(update);
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        Update update;
        try {
            productBuilderSupport.putPackage("com.installshield.wizardx.ascii");
            productBuilderSupport.putClass((class$com$installshield$product$actions$AsciiFileUpdateProductActionBeanInfo != null ? class$com$installshield$product$actions$AsciiFileUpdateProductActionBeanInfo : (class$com$installshield$product$actions$AsciiFileUpdateProductActionBeanInfo = AsciiFileUpdateProductAction.class$("com.installshield.product.actions.AsciiFileUpdateProductActionBeanInfo"))).getName());
            productBuilderSupport.putRequiredService("fileService");
            productBuilderSupport.putRequiredService("systemUtilService");
        }
        catch (IOException iOException) {
            productBuilderSupport.logEvent(this, "err", iOException);
        }
        if (this.asciiFile == null || this.asciiFile.trim().length() <= 0) {
            productBuilderSupport.logEvent(this, "wrn", "Ascii File property is required for " + this.getDisplayName() + ".");
        }
        if (this.installActionsList.isEmpty() && this.uninstallActionsList.isEmpty()) {
            productBuilderSupport.logEvent(this, "wrn", "There must be at least one entry in the Install Actions list or the Uninstall Actions list for " + this.getDisplayName() + ".");
        }
        Enumeration enumeration = this.installActionsList.elements();
        while (enumeration.hasMoreElements()) {
            update = (Update)enumeration.nextElement();
            update.verify(this);
        }
        enumeration = this.uninstallActionsList.elements();
        while (enumeration.hasMoreElements()) {
            update = (Update)enumeration.nextElement();
            update.verify(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void execute(ProductActionSupport productActionSupport, Vector vector, String string) throws ProductException {
        try {
            Object object;
            FileService fileService = (FileService)this.getService("fileService");
            ModifyFile modifyFile = new ModifyFile(this);
            modifyFile.setFile(string);
            modifyFile.setCommentChar(this.resolveString(this.getCommentChars()));
            modifyFile.setFileService((FileService)this.getService("fileService"));
            modifyFile.setOverwriteExisting(this.getOverwriteExistingFile());
            boolean bl = modifyFile.loadFile();
            if (!bl) {
                this.createdDirs = fileService.createDirectoryReturnNew(fileService.getParent(modifyFile.getFile()));
            }
            boolean bl2 = false;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Update)enumeration.nextElement();
                bl2 |= object.execute(modifyFile);
            }
            modifyFile.logChanges();
            if (bl2) {
                if (bl && this.getBackupAsciiFile() && vector != null && vector.size() > 0) {
                    modifyFile.backupFile();
                }
                modifyFile.writeFile();
                if (this.isRebootRequired()) {
                    object = (SystemUtilService)this.getService("systemUtilService");
                    object.setRebootRequired(true);
                }
            }
        }
        catch (ServiceException serviceException) {
            throw new ProductException(serviceException);
        }
        catch (WizardException wizardException) {
            throw new ProductException(wizardException);
        }
    }

    private Update[] getActionsFromList(Vector vector) {
        Update[] updateArray = new Update[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            updateArray[n] = (Update)vector.elementAt(n);
            ++n;
        }
        return updateArray;
    }

    public String getAsciiFile() {
        return this.asciiFile;
    }

    public boolean getBackupAsciiFile() {
        return this.backupAsciiFile;
    }

    public String getCommentChars() {
        return this.commentChars;
    }

    public String[] getCreatedDirs() {
        return this.createdDirs;
    }

    public boolean getDeleteFileOnUninstall() {
        return this.deleteFileOnUninstall;
    }

    public Update[] getInstallActions() {
        this.installActions = this.getActionsFromList(this.installActionsList);
        return this.installActions;
    }

    public Vector getInstallActionsList() {
        return this.installActionsList;
    }

    public String getInstalledFileName() {
        return this.installedFileName;
    }

    public boolean getOverwriteExistingFile() {
        return this.overwriteExistingFile;
    }

    public Update[] getUninstallActions() {
        this.uninstallActions = this.getActionsFromList(this.uninstallActionsList);
        return this.uninstallActions;
    }

    public Vector getUninstallActionsList() {
        return this.uninstallActionsList;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        this.installedFileName = this.resolveAsciiFile();
        this.execute(productActionSupport, this.installActionsList, this.installedFileName);
    }

    public boolean isEnableOnReinstalls() {
        return this.enableOnReinstalls;
    }

    public boolean isRebootRequired() {
        return this.rebootRequired;
    }

    public void logEvent(Object object, String string, Object object2) {
        super.logEvent(object, string, object2);
    }

    public void replace(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        if (this.enableOnReinstalls) {
            this.install(productActionSupport);
        }
    }

    private String resolveAsciiFile() throws ProductException {
        String string = this.resolveString(this.getAsciiFile());
        try {
            FileService fileService = (FileService)this.getService("fileService");
            string = fileService.normalizeFileName(string);
            if (!fileService.isAbsolute(string)) {
                String string2 = this.getProductTree().getInstallLocation(this);
                string = fileService.createFileName(string2, string);
            }
        }
        catch (ServiceException serviceException) {
            throw new ProductException(serviceException);
        }
        return string;
    }

    public String resolveString(String string) {
        return super.resolveString(string);
    }

    public void setAsciiFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("asciiFileName cannot be null");
        }
        this.asciiFile = string;
    }

    public void setBackupAsciiFile(boolean bl) {
        this.backupAsciiFile = bl;
    }

    public void setCommentChars(String string) {
        if (string == null) {
            throw new IllegalArgumentException("commentChars cannot be null");
        }
        this.commentChars = string;
    }

    public void setCreatedDirs(String[] stringArray) {
        if (stringArray != null) {
            this.createdDirs = stringArray;
        }
    }

    public void setDeleteFileOnUninstall(boolean bl) {
        this.deleteFileOnUninstall = bl;
    }

    public void setEnableOnReinstalls(boolean bl) {
        this.enableOnReinstalls = bl;
    }

    public void setInstallActions(Update[] updateArray) {
        this.installActionsList.removeAllElements();
        int n = 0;
        while (n < updateArray.length) {
            this.installActionsList.addElement(updateArray[n]);
            ++n;
        }
        this.installActions = this.getActionsFromList(this.installActionsList);
    }

    public void setInstallActionsList(Vector vector) {
        this.installActionsList = vector;
    }

    public void setInstalledFileName(String string) {
        this.installedFileName = string;
    }

    public void setOverwriteExistingFile(boolean bl) {
        this.overwriteExistingFile = bl;
    }

    public void setRebootRequired(boolean bl) {
        this.rebootRequired = bl;
    }

    public void setUninstallActions(Update[] updateArray) {
        this.uninstallActionsList.removeAllElements();
        int n = 0;
        while (n < updateArray.length) {
            this.uninstallActionsList.addElement(updateArray[n]);
            ++n;
        }
        this.uninstallActions = this.getActionsFromList(this.uninstallActionsList);
    }

    public void setUninstallActionsList(Vector vector) {
        this.uninstallActionsList = vector;
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (this.getDeleteFileOnUninstall()) {
            try {
                FileService fileService = (FileService)this.getService("fileService");
                if (this.installedFileName == null) {
                    this.installedFileName = this.resolveAsciiFile();
                }
                if (fileService.fileExists(this.installedFileName)) {
                    fileService.deleteFile(this.installedFileName);
                }
                int n = this.createdDirs.length;
                while (n > 0) {
                    if (fileService.isDirectory(this.createdDirs[n - 1])) {
                        fileService.deleteDirectory(this.createdDirs[n - 1]);
                    }
                    --n;
                }
            }
            catch (ServiceException serviceException) {
                throw new ProductException(serviceException);
            }
        }
        if (this.uninstallActionsList.size() > 0) {
            if (this.installedFileName == null) {
                this.installedFileName = this.resolveAsciiFile();
            }
            this.execute(productActionSupport, this.uninstallActionsList, this.installedFileName);
        }
    }
}

