/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;

public class SetProductBeanPropertyAction
extends WizardAction {
    private String productBeanId = "";
    private String productBeanPropertyName = "";
    private String value = "";

    public SetProductBeanPropertyAction() {
        this.setCancelable(false);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        boolean bl = true;
        if (this.productBeanId == null || this.productBeanId.length() <= 0) {
            wizardBuilderSupport.logEvent(this, "err", "You must specify a value for the product bean id");
            bl = false;
        }
        if (this.productBeanPropertyName == null || this.productBeanPropertyName.length() <= 0) {
            wizardBuilderSupport.logEvent(this, "err", "You must specify a value for the product bean property name");
            bl = false;
        }
        if (bl) {
            wizardBuilderSupport.putRequiredService("productService");
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            productService.setRetainedProductBeanProperty("/product.xml", this.resolveString(this.productBeanId), this.resolveString(this.productBeanPropertyName), this.resolveString(this.value));
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "wrn", "Unable to set product bean property " + this.resolveString(this.productBeanId) + "." + this.resolveString(this.productBeanPropertyName) + " " + serviceException);
        }
    }

    public String getProductBeanId() {
        return this.productBeanId;
    }

    public String getProductBeanPropertyName() {
        return this.productBeanPropertyName;
    }

    public String getValue() {
        return this.value;
    }

    public void setProductBeanId(String string) {
        this.productBeanId = string;
    }

    public void setProductBeanPropertyName(String string) {
        this.productBeanPropertyName = string;
    }

    public void setValue(String string) {
        this.value = string;
    }
}

