/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.service.ServiceException;
import java.util.Properties;

public class SummaryPanel
extends WizardPanel {
    private int type = 1;
    private final String productURL = "/product.xml";
    private String busyMessage = "";

    public SummaryPanel() {
        this.setDescription("$L(com.installshield.product.i18n.ProductResources, SummaryPanel.description)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        wizardBuilderSupport.putRequiredService("productService");
    }

    public String getBusyMessage() {
        return this.busyMessage;
    }

    String getSummary() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            if (this.type == 2) {
                if (!this.isLast()) {
                    this.type = 5;
                }
            } else if (this.type == 4 && !this.isLast()) {
                this.type = 6;
            }
            Properties properties = productService.getProductSummary("/product.xml", this.type, "html");
            return properties.getProperty("summary.msg");
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return String.valueOf(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "errorOccured")) + serviceException;
        }
    }

    public int getType() {
        return this.type;
    }

    private boolean isLast() {
        boolean bl = true;
        if (this.getWizard() != null && this.getWizard().getIterator() != null && this.getWizard().getCurrentBean() != null) {
            bl = this.getWizard().getIterator().getNext(this.getWizard().getCurrentBean()) == this.getWizard().getIterator().end();
        }
        return bl;
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        String string = this.resolveString(this.busyMessage);
        if (string != null && string.length() > 0) {
            wizardBeanEvent.getUserInterface().setBusy(this.resolveString(string));
        }
        return super.queryEnter(wizardBeanEvent);
    }

    public void setBusyMessage(String string) {
        this.busyMessage = string;
    }

    public void setType(int n) {
        this.type = n;
    }
}

