/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.ClassLocator;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassDependencyResolver {
    private ClassLocator locator;
    private Hashtable cachedDependencies = new Hashtable();
    private Hashtable cachedClassRefs = new Hashtable();

    public ClassDependencyResolver(ClassLocator classLocator) {
        if (classLocator == null) {
            throw new IllegalArgumentException("locator cannot be null");
        }
        this.locator = classLocator;
    }

    private void classError(String string, String string2, Object object) throws IOException {
        throw new IOException(String.valueOf(string) + " for class " + string2 + " in " + object);
    }

    public Enumeration dependencies(String string) throws IOException {
        Hashtable hashtable = (Hashtable)this.cachedDependencies.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.resolveDependencies(string, hashtable);
            this.cachedDependencies.put(string, hashtable);
        }
        return hashtable.keys();
    }

    private Vector getClassReferences(String string) throws IOException {
        Vector<String> vector = (Vector<String>)this.cachedClassRefs.get(string);
        if (vector == null) {
            String string2 = this.locator.findClass(string);
            if (string2 == null) {
                throw new FileNotFoundException("cannot find source for class " + string);
            }
            InputStream inputStream = ClassLocator.operResourceStream(string2);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (dataInputStream.readInt() != -889275714) {
                this.classError("invalid magic", string, string2);
            }
            dataInputStream.skipBytes(2);
            if (dataInputStream.readShort() != 45) {
                this.classError("unsupported class format", string, string2);
            }
            int n = dataInputStream.readShort();
            String[] stringArray = new String[n];
            Vector<Short> vector2 = new Vector<Short>();
            int n2 = 1;
            while (n2 < n) {
                byte by = dataInputStream.readByte();
                switch (by) {
                    case 7: {
                        vector2.addElement(new Short(dataInputStream.readShort()));
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        dataInputStream.skipBytes(4);
                        break;
                    }
                    case 8: {
                        dataInputStream.skipBytes(2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        dataInputStream.skipBytes(4);
                        break;
                    }
                    case 5: 
                    case 6: {
                        dataInputStream.skipBytes(8);
                        ++n2;
                        break;
                    }
                    case 12: {
                        dataInputStream.skipBytes(4);
                        break;
                    }
                    case 1: {
                        stringArray[n2] = dataInputStream.readUTF();
                        break;
                    }
                    default: {
                        this.classError("unknown tag value " + by, string, string2);
                    }
                }
                ++n2;
            }
            inputStream.close();
            vector = new Vector<String>();
            int n3 = 0;
            while (n3 < vector2.size()) {
                short s = (Short)vector2.elementAt(n3);
                String string3 = this.stripArray(stringArray[s]);
                if (string3 != null && !string3.startsWith("java/")) {
                    vector.addElement(string3.replace('/', '.'));
                }
                ++n3;
            }
            this.cachedClassRefs.put(string, vector);
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        ClassDependencyResolver classDependencyResolver = new ClassDependencyResolver(new ClassLocator(System.getProperty("java.class.path")));
        try {
            int n = 0;
            while (n < stringArray.length) {
                System.out.println("Non-Java dependencies for " + stringArray[n] + ":");
                Enumeration enumeration = classDependencyResolver.dependencies(stringArray[n]);
                while (enumeration.hasMoreElements()) {
                    System.out.println((String)enumeration.nextElement());
                }
                System.out.println();
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void resolveDependencies(String string, Hashtable hashtable) throws IOException {
        if (hashtable.containsKey(string)) {
            return;
        }
        hashtable.put(string, "");
        Vector vector = null;
        vector = this.getClassReferences(string);
        int n = 0;
        while (vector != null && n < vector.size()) {
            this.resolveDependencies((String)vector.elementAt(n), hashtable);
            ++n;
        }
    }

    private String stripArray(String string) {
        int n = -1;
        int n2 = 0;
        while (n == -1 && n2 < string.length()) {
            if (string.charAt(n2) != '[') {
                n = n2;
            }
            ++n2;
        }
        if (n > 0) {
            if (string.endsWith(";")) {
                return string.substring(n + 1, string.length() - n + 1);
            }
            return null;
        }
        return string;
    }
}

