/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.FileUtils;
import com.installshield.util.ProcessExecException;
import com.installshield.util.ProcessOutputHandler;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class ProcessExec {
    public static final int NOT_STARTED = 0;
    public static final int STARTED = 1;
    public static final int FINISHED = 2;
    public static final int ERROR = 3;
    private long processExecDelay = 500L;
    private String command = "";
    private String[] arguments = new String[0];
    private String outputDestination = null;
    private String errDestination = null;
    private ProcessOutputHandler outputHandler = null;
    private String[] createdDirsAndFiles = new String[0];
    private Process process;
    private ProcessStatus processStatus = new ProcessStatus();
    private final int CAPTURE_OUTPUT = 0;
    private final int CAPTURE_ERROR = 1;
    private int exitCode;
    private int status = 0;

    public ProcessExec(String string) {
        this(string, null);
    }

    public ProcessExec(String string, String[] stringArray) {
        this(string, stringArray, null, null);
    }

    public ProcessExec(String string, String[] stringArray, String string2, String string3) {
        this.command = string;
        if (stringArray != null) {
            this.arguments = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.arguments, 0, stringArray.length);
        }
        this.outputDestination = string2;
        this.errDestination = string3;
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void executeProcess() throws ProcessExecException {
        try {
            String[] stringArray = new String[this.arguments.length + 1];
            stringArray[0] = this.command;
            System.arraycopy(this.arguments, 0, stringArray, 1, this.arguments.length);
            this.process = Runtime.getRuntime().exec(stringArray);
            this.status = 1;
            try {
                Thread.sleep(this.processExecDelay);
            }
            catch (InterruptedException interruptedException) {}
            this.processStatus.setProcessStarted();
            if (this.outputHandler == null) {
                this.outputHandler = new DefaultProcessOutputHandler();
            }
            ProcessOutputThread processOutputThread = new ProcessOutputThread(this.process.getInputStream(), 0);
            ProcessOutputThread processOutputThread2 = new ProcessOutputThread(this.process.getErrorStream(), 1);
            processOutputThread.start();
            processOutputThread2.start();
            this.process.waitFor();
            processOutputThread.join();
            processOutputThread2.join();
            this.exitCode = this.process.exitValue();
            this.status = 2;
        }
        catch (Exception exception) {
            this.status = 3;
            throw new ProcessExecException(exception.getMessage());
        }
    }

    public String[] getCreatedDirectories() {
        return this.createdDirsAndFiles;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public synchronized boolean getProcessStarted() {
        return this.processStatus.getProcessStarted();
    }

    public int getStatus() {
        return this.status;
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setProcessExecDelay(long l) {
        if (l >= 0L) {
            this.processExecDelay = l;
        }
    }

    public void setProcessOutputHandler(ProcessOutputHandler processOutputHandler) {
        this.outputHandler = processOutputHandler;
    }

    private synchronized void updateCreatedDirsAndFiles(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = this.createdDirsAndFiles;
            this.createdDirsAndFiles = new String[this.createdDirsAndFiles.length + stringArray.length];
            System.arraycopy(stringArray2, 0, this.createdDirsAndFiles, 0, stringArray2.length);
            System.arraycopy(stringArray, 0, this.createdDirsAndFiles, stringArray2.length, stringArray.length);
        }
    }

    class ProcessOutputThread
    extends Thread {
        private int type = -1;
        private InputStream stream = null;

        public ProcessOutputThread(InputStream inputStream, int n) {
            this.stream = inputStream;
            this.type = n;
        }

        public void run() {
            if (this.stream != null && this.type == 0) {
                ProcessExec.this.outputHandler.processOutputData(this.stream);
            } else if (this.stream != null && this.type == 1) {
                ProcessExec.this.outputHandler.processErrorData(this.stream);
            }
        }
    }

    class ProcessStatus {
        boolean processStarted = false;

        ProcessStatus() {
        }

        public synchronized boolean getProcessStarted() {
            return this.processStarted;
        }

        public synchronized void setProcessStarted() {
            this.processStarted = true;
        }
    }

    class DefaultProcessOutputHandler
    implements ProcessOutputHandler {
        DefaultProcessOutputHandler() {
        }

        private synchronized OutputStreamWriter createOutputStreamWriter(String string) {
            OutputStreamWriter outputStreamWriter;
            block2: {
                int n;
                outputStreamWriter = null;
                if (string == null || string.length() <= 0 || (n = (string = FileUtils.normalizeFileName(string, '/')).lastIndexOf("/")) == -1) break block2;
                File file = new File(string.substring(0, n + 1));
                try {
                    String[] stringArray = FileUtils.createDirs(file);
                    ProcessExec.this.updateCreatedDirsAndFiles(stringArray);
                    ProcessExec.this.updateCreatedDirsAndFiles(new String[]{string});
                    outputStreamWriter = new OutputStreamWriter(new FileOutputStream(new File(string)));
                }
                catch (Exception exception) {
                    outputStreamWriter = null;
                }
            }
            return outputStreamWriter;
        }

        public void processErrorData(InputStream inputStream) {
            if (ProcessExec.this.errDestination != null) {
                this.writeData(inputStream, ProcessExec.this.errDestination);
            } else {
                this.writeData(inputStream);
            }
        }

        public void processOutputData(InputStream inputStream) {
            if (ProcessExec.this.outputDestination != null) {
                this.writeData(inputStream, ProcessExec.this.outputDestination);
            } else {
                this.writeData(inputStream);
            }
        }

        private void writeData(InputStream inputStream) {
            try {
                byte[] byArray = new byte[1024];
                while (inputStream.read(byArray) != -1) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception exception) {}
        }

        private void writeData(InputStream inputStream, String string) {
            InputStreamReader inputStreamReader = null;
            CharArrayWriter charArrayWriter = null;
            try {
                try {
                    OutputStreamWriter outputStreamWriter = this.createOutputStreamWriter(string);
                    inputStreamReader = new InputStreamReader(inputStream);
                    char[] cArray = new char[1024];
                    int n = 0;
                    charArrayWriter = new CharArrayWriter();
                    while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                        charArrayWriter.write(cArray, 0, n);
                    }
                    if (outputStreamWriter != null) {
                        charArrayWriter.writeTo(outputStreamWriter);
                        outputStreamWriter.close();
                    } else {
                        System.out.print(charArrayWriter.toCharArray());
                    }
                    charArrayWriter.close();
                    inputStreamReader.close();
                    inputStream.close();
                }
                catch (Exception exception) {
                }
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    charArrayWriter.close();
                    inputStreamReader.close();
                    inputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                charArrayWriter.close();
                inputStreamReader.close();
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

