/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.MD5;
import com.installshield.util.MetaInf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Dictionary;

public abstract class SecureMetaInf
extends MetaInf {
    private static final String DIGEST_KEY = "INF_ID";
    private byte[] key;

    public SecureMetaInf(InputStream inputStream, byte[] byArray) throws IOException {
        this.key = byArray;
        this.read(this.getData(inputStream));
    }

    public SecureMetaInf(URL uRL, byte[] byArray) throws IOException {
        this(uRL.openStream(), byArray);
    }

    public SecureMetaInf(byte[] byArray) {
        this.key = byArray;
    }

    private String createDigest() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        this.writeObjectDigest(printWriter);
        printWriter.flush();
        MD5 mD5 = new MD5();
        mD5.write(byteArrayOutputStream.toByteArray());
        mD5.write(this.key);
        printWriter.close();
        byteArrayOutputStream.close();
        return MD5.toHex(mD5.toHash());
    }

    public void read(Dictionary dictionary) throws IOException {
        this.readObject(dictionary);
        boolean bl = false;
        String string = (String)dictionary.get(DIGEST_KEY);
        try {
            if (string != null && this.createDigest().equals(string)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            if (System.getProperty("is.debug") != null) {
                exception.printStackTrace();
            }
            bl = false;
        }
        if (!bl) {
            throw new IOException("file has changed since it was created");
        }
    }

    protected abstract void readObject(Dictionary var1) throws IOException;

    public void write(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        this.writeDigest(printWriter);
        this.writeObject(printWriter);
    }

    private void writeDigest(PrintWriter printWriter) throws IOException {
        printWriter.println("INF_ID: " + this.createDigest());
    }

    protected abstract void writeObject(PrintWriter var1) throws IOException;

    protected abstract void writeObjectDigest(PrintWriter var1) throws IOException;
}

