/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYPrompt;
import com.installshield.util.TTYTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TTYDisplay {
    private static PrintWriter depr_outWriter;
    private static BufferedReader depr_inReader;
    private static int depr_consoleWidth;
    private static boolean depr_accessibilityEnabled;
    public static final int DEFAULT_WIDTH = 79;
    private static final int DEFAULT_LINES = 20;
    public static final int DEFAULT_INDENT = 3;
    public static final int DEFAULT_TABLE_PADDING = 2;
    private PrintWriter out;
    private BufferedReader in;
    private int width;
    private int pageLineCount = 20;
    private boolean accessibilityEnabled = false;
    private int baseIndent = 0;

    static {
        depr_consoleWidth = 79;
        depr_accessibilityEnabled = false;
        TTYDisplay.initialize();
    }

    public TTYDisplay() {
        this(System.in, System.out, 79);
    }

    public TTYDisplay(int n) {
        this(System.in, System.out, n);
    }

    public TTYDisplay(InputStream inputStream, OutputStream outputStream, int n) {
        this.setStreams(inputStream, outputStream);
        this.setWidth(n);
    }

    public static boolean accessbilityEnabled() {
        return depr_accessibilityEnabled;
    }

    private static int arrayLargest(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2] > nArray[n] ? n2 : n;
            ++n2;
        }
        return n;
    }

    private int[] calcColWidths(TTYTable tTYTable) {
        int[] nArray = new int[tTYTable.getColCount()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (tTYTable.getColWeight(n3) == 0) {
                nArray[n3] = tTYTable.getColWidth(n3);
                n += nArray[n3];
            } else {
                n2 += tTYTable.getColWeight(n3);
            }
            ++n3;
        }
        double d = this.width - tTYTable.getIndent() - n - (tTYTable.getColSpacing() & tTYTable.getColCount() - 1);
        int n4 = 0;
        while (n4 < nArray.length) {
            if (tTYTable.getColWeight(n4) > 0) {
                nArray[n4] = Math.max(0, (int)(d * ((double)tTYTable.getColWeight(n4) / (double)n2)));
            }
            ++n4;
        }
        return nArray;
    }

    public static void clear() {
        TTYDisplay.clear(20);
    }

    public static void clear(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.println("");
            ++n2;
        }
    }

    private static String createTable(Vector vector) {
        int n;
        Object object;
        String string = new String();
        int n2 = vector.size();
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Vector)enumeration.nextElement();
            if (((Vector)object).size() <= n3) continue;
            n3 = ((Vector)object).size();
        }
        String[][] stringArray = new String[n2][n3];
        object = new int[n3];
        int n4 = 0;
        while (n4 < ((Object)object).length) {
            object[n4] = false;
            ++n4;
        }
        int n5 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration2.nextElement();
            Enumeration enumeration3 = vector2.elements();
            n = 0;
            while (n < n3) {
                String string2 = "";
                if (enumeration3.hasMoreElements()) {
                    string2 = (String)enumeration3.nextElement();
                }
                if (string2 == null || string2.equals("")) {
                    string2 = " ";
                }
                stringArray[n5][n] = string2;
                if (string2.length() > object[n]) {
                    object[n] = string2.length();
                }
                ++n;
            }
            ++n5;
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < ((Object)object).length) {
            n6 += object[n7] + 2;
            ++n7;
        }
        while (n6 > depr_consoleWidth) {
            Object object2 = object;
            int n8 = TTYDisplay.arrayLargest((int[])object);
            object2[n8] = object2[n8] - true;
            --n6;
        }
        n = 0;
        while (n < stringArray.length) {
            int n9 = 0;
            while (n9 < stringArray[0].length) {
                Object object3 = object[n9];
                String string3 = stringArray[n][n9];
                int n10 = string3.length();
                if (n10 > object3) {
                    string3 = string3.substring(0, (int)object3);
                }
                if (n10 < object3) {
                    int n11 = n10;
                    while (n11 < object3) {
                        string3 = String.valueOf(string3) + " ";
                        ++n11;
                    }
                }
                string3 = " " + string3 + " ";
                string = String.valueOf(string) + string3;
                ++n9;
            }
            string = String.valueOf(string) + "\n";
            ++n;
        }
        return string;
    }

    public static void displayTable(Vector vector) {
        depr_outWriter.print(TTYDisplay.createTable(vector));
        depr_outWriter.flush();
    }

    public static void enableAccessbility(boolean bl) {
        depr_accessibilityEnabled = bl;
    }

    public static void exit() {
        System.exit(-1);
    }

    private void fill(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.out.print(' ');
            ++n2;
        }
    }

    public int getBaseIndent() {
        return this.baseIndent;
    }

    public static int getConsoleWidth() {
        return depr_consoleWidth;
    }

    public int getPageLineCount() {
        return this.pageLineCount;
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public int getWidth() {
        return this.width;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public static void initialize() {
        TTYDisplay.initialize(System.in, System.out, depr_consoleWidth);
    }

    public static void initialize(int n) {
        TTYDisplay.initialize(System.in, System.out, n);
    }

    public static void initialize(InputStream inputStream, OutputStream outputStream, int n) {
        depr_outWriter = new PrintWriter(outputStream, true);
        depr_inReader = new BufferedReader(new InputStreamReader(inputStream));
        depr_consoleWidth = n;
    }

    public boolean isAccessibilityEnabled() {
        return this.accessibilityEnabled;
    }

    public static void oldprint(String string) {
        depr_outWriter.print(string);
    }

    public static void pageText(String string) {
        boolean bl = false;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (!bl) {
            if (!stringTokenizer.hasMoreTokens()) {
                bl = true;
                continue;
            }
            String string2 = stringTokenizer.nextToken();
            TTYDisplay.showText(string2);
            if (++n % 20 != 0) continue;
            String string3 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayCharQ");
            if (!TTYDisplay.promptForNextLine().equalsIgnoreCase(string3)) continue;
            bl = true;
        }
    }

    private String[] parseLines(String string, int n) {
        Object object;
        if (n <= 0) {
            return new String[0];
        }
        Vector<Object> vector = new Vector<Object>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() > n) {
                    object = "";
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (object.length() + string3.length() + 1 > n) {
                            vector.addElement(object);
                            object = string3;
                            continue;
                        }
                        object = !object.equals("") ? String.valueOf(object) + " " + string3 : string3;
                    }
                    vector.addElement(object);
                    continue;
                }
                vector.addElement(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public boolean pauseToRead() {
        this.printLine();
        String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayCharQ");
        String string2 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayReadText");
        String string3 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayQuit", new String[]{string});
        String string4 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayContinue", new String[]{string2});
        String string5 = this.prompt(string4, string3);
        this.printLine();
        return string5.equalsIgnoreCase(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayCharQ")) ^ true;
    }

    private static void prettyPrintText(String string, boolean bl, int n) {
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = String.valueOf(string2) + " ";
            ++n2;
        }
        string = String.valueOf(string2) + string;
        int n3 = depr_consoleWidth - n;
        if (string.length() < n3) {
            depr_outWriter.print(string);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < stringBuffer.length()) {
                ++n4;
                if (stringBuffer.charAt(n6) == '\n') {
                    stringBuffer.insert(n6 + 1, string2);
                    n5 = n6 += string2.length();
                    n4 = 0;
                }
                if (n4 == n3) {
                    while (stringBuffer.charAt(n6) != ' ' && stringBuffer.charAt(n6) != '\n' && n6 > n5) {
                        --n6;
                    }
                    if (n6 == n5) {
                        stringBuffer.insert((n6 += n3) + 1, "\n" + string2);
                        n5 = n6 += "\n".length() + string2.length();
                    } else if (stringBuffer.charAt(n6) == '\n') {
                        stringBuffer.insert(n6 + 1, string2);
                        n5 = n6 += string2.length();
                    } else {
                        stringBuffer.setCharAt(n6, '\n');
                        stringBuffer.insert(n6 + 1, string2);
                        n5 = n6 += string2.length();
                    }
                    n4 = 0;
                }
                ++n6;
            }
            depr_outWriter.print(stringBuffer.toString());
        }
        if (bl) {
            depr_outWriter.print("\n");
        }
        depr_outWriter.flush();
    }

    public void print(String string) {
        this.printImpl(string, 0);
    }

    public void printHRule() {
        if (!this.accessibilityEnabled) {
            int n = 0;
            while (n < this.width) {
                this.out.print('-');
                ++n;
            }
            this.out.println();
        }
    }

    private void printImpl(String string, int n) {
        n = Math.max(0, n + this.baseIndent);
        String[] stringArray = this.parseLines(string, Math.max(1, this.width - n));
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = 0;
            while (n3 < n) {
                this.out.print(' ');
                ++n3;
            }
            this.out.print(stringArray[n2]);
            if (n2 < stringArray.length - 1) {
                this.out.println();
            }
            ++n2;
        }
        this.out.flush();
    }

    public void printIndented(String string) {
        this.printImpl(string, 3);
    }

    public void printIndented(String string, int n) {
        this.printImpl(string, n);
    }

    public void printIndentedLine(String string) {
        this.printIndented(string);
        this.printLine();
    }

    public void printIndentedLine(String string, int n) {
        this.printIndented(string, n);
        this.printLine();
    }

    public void printLine() {
        this.out.println();
    }

    public void printLine(String string) {
        this.printImpl(string, 0);
        this.printLine();
    }

    public void printLines(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.printLine();
            ++n2;
        }
    }

    public void printMessage(String string) {
        this.printMessage(string, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDefaultMessagePrompt"));
    }

    public void printMessage(String string, String string2) {
        this.printLine(string);
        this.printLine();
        this.prompt("", string2);
    }

    private void printOptions(TTYPrompt tTYPrompt) {
        String[] stringArray = tTYPrompt.getOptions();
        int n = 0;
        while (n < stringArray.length) {
            this.printIndentedLine(String.valueOf(n + 1) + ". " + stringArray[n], tTYPrompt.getIndent() + 3);
            String string = tTYPrompt.getOptionDescription(n);
            if (string.length() > 0) {
                this.printLine();
                this.printIndentedLine(string, tTYPrompt.getIndent() + 6);
                this.printLine();
            }
            ++n;
        }
    }

    public void printPage() {
        this.printLines(this.pageLineCount);
    }

    public void printPage(String string) {
        int n = this.getPageLineCount();
        String[] stringArray = this.parseLines(string, this.width);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0 && n2 % n == 0 && !this.pauseToRead()) break;
            this.out.println(stringArray[n2]);
            ++n2;
        }
    }

    public void printTable(TTYTable tTYTable) {
        int[] nArray = this.calcColWidths(tTYTable);
        int n = 0;
        while (n < tTYTable.getRowCount()) {
            Vector<String[]> vector = new Vector<String[]>();
            int n2 = 1;
            int n3 = 0;
            while (n3 < tTYTable.getColCount()) {
                String[] stringArray = this.parseLines(tTYTable.getValue(n, n3), nArray[n3]);
                vector.addElement(stringArray);
                n2 = Math.max(n2, stringArray.length);
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                this.fill(tTYTable.getIndent() + this.baseIndent);
                int n5 = 0;
                while (n5 < vector.size()) {
                    String[] stringArray = (String[])vector.elementAt(n5);
                    if (n5 > 0) {
                        this.fill(tTYTable.getColSpacing());
                    }
                    if (n4 < stringArray.length) {
                        this.out.print(stringArray[n4]);
                        if (n5 < vector.size() - 1) {
                            this.fill(nArray[n5] - stringArray[n4].length());
                        }
                    } else {
                        this.fill(nArray[n5]);
                    }
                    ++n5;
                }
                this.out.println();
                ++n4;
            }
            ++n;
        }
    }

    public String prompt(TTYPrompt tTYPrompt) {
        String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayQuestionMark");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(tTYPrompt.getText());
        if (stringBuffer.length() > 0) {
            stringBuffer.append(" ");
        }
        if (tTYPrompt.hasDefaultValue()) {
            stringBuffer.append("[" + tTYPrompt.getDefaultValue() + "] ");
        }
        if (tTYPrompt.hasDescription()) {
            this.printIndentedLine(tTYPrompt.getDescription(), tTYPrompt.getIndent());
            this.printLine();
        }
        if (tTYPrompt.hasLegalOptions() && tTYPrompt.getPromptForOptionIndex()) {
            this.printOptions(tTYPrompt);
            this.printLine();
        }
        String string2 = null;
        boolean bl = false;
        while (!bl) {
            this.printIndented(stringBuffer.toString(), tTYPrompt.getIndent());
            try {
                boolean bl2;
                String string3 = this.in.readLine();
                if (string3 == null) {
                    System.exit(-1);
                }
                if (bl2 = string3.equals(string)) {
                    this.printLine();
                    if (tTYPrompt.hasHelpText()) {
                        this.printIndentedLine(tTYPrompt.getHelpText(), tTYPrompt.getIndent());
                    } else {
                        this.printIndentedLine(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayNoHelp"), tTYPrompt.getIndent());
                    }
                    this.printLine();
                } else {
                    string2 = string3.equals("") && tTYPrompt.hasDefaultValue() ? tTYPrompt.getDefaultValue() : string3;
                }
                if (bl2) continue;
                if (tTYPrompt.hasLegalOptions()) {
                    bl = this.validateOptions(tTYPrompt, string2);
                    continue;
                }
                if (tTYPrompt.hasMinMaxValues()) {
                    bl = this.validateMinMaxValues(tTYPrompt, string2);
                    continue;
                }
                bl = true;
            }
            catch (IOException iOException) {
                System.err.println("Read exception: " + iOException);
                string2 = "";
                bl = true;
            }
        }
        return string2;
    }

    public String prompt(String string) {
        return this.prompt(new TTYPrompt(string));
    }

    public String prompt(String string, String string2) {
        return this.prompt(new TTYPrompt(string, string2));
    }

    public String prompt(String string, String string2, String string3) {
        return this.prompt(new TTYPrompt(string, string2, string3));
    }

    private static String promptForNextLine() {
        TTYDisplay.showNewline();
        String string = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayCharQ");
        String string2 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayReadText");
        String string3 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayQuit", new String[]{string});
        String string4 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayContinue", new String[]{string2});
        String string5 = TTYDisplay.queryValue(string4, string3, "");
        TTYDisplay.showNewline();
        return string5;
    }

    public int promptInt(TTYPrompt tTYPrompt) {
        String string = this.prompt(tTYPrompt);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int promptInt(String string) {
        return this.promptInt(string, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
    }

    public int promptInt(String string, int n, int n2, int n3) {
        return this.promptInt(string, n, n2, n3, "");
    }

    public int promptInt(String string, int n, int n2, int n3, String string2) {
        TTYPrompt tTYPrompt = new TTYPrompt(string);
        tTYPrompt.setDefaultValue(n);
        tTYPrompt.setMinLegalValue(n2);
        tTYPrompt.setMaxLegalValue(n3);
        tTYPrompt.setHelpText(string2);
        return this.promptInt(tTYPrompt);
    }

    public String promptPassword(String string) {
        if (System.getProperty("os.name").equals("OS/400")) {
            return this.prompt(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        PasswordThread passwordThread = new PasswordThread(string);
        passwordThread.start();
        block2: while (true) {
            try {
                while (true) {
                    char c;
                    if ((c = (char)System.in.read()) == '\n' || c == '\r') {
                        passwordThread.setStop();
                        while (System.in.available() > 0) {
                            System.in.read();
                        }
                        break block2;
                    }
                    stringBuffer.append(c);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        return stringBuffer.toString();
    }

    public static String queryValue(String string) {
        return TTYDisplay.queryValue(string, "");
    }

    public static int queryValue(String string, int n, int n2, int n3, String string2) {
        int n4 = TTYDisplay.queryValue(string, n, n2, n3, string2, 0);
        return n4;
    }

    public static int queryValue(String string, int n, int n2, int n3, String string2, int n4) {
        while (true) {
            String string3 = "";
            string3 = TTYDisplay.queryValue(string, String.valueOf(n), string2, n4);
            try {
                int n5 = Integer.parseInt(string3);
                if (n5 >= n2 && n5 <= n3) {
                    return n5;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            String[] stringArray = new String[]{String.valueOf(n2), String.valueOf(n3)};
            TTYDisplay.showNewline();
            TTYDisplay.showText(TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayEnterValueRange", stringArray));
            TTYDisplay.showNewline();
        }
    }

    public static String queryValue(String string, String string2) {
        String string3 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayNoDefault");
        return TTYDisplay.queryValue(string, string3, string2);
    }

    public static String queryValue(String string, String string2, String string3) {
        String string4 = TTYDisplay.queryValue(string, string2, string3, 0);
        return string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static String queryValue(String string, String string2, String string3, int n) {
        String string4 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayNoHelp");
        String string5 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayQuestionMark");
        String string6 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayNoDefault");
        if (string3 == null) {
            string3 = string4;
        } else if (string3.length() > 0) {
            TTYDisplay.showNewline();
            TTYDisplay.prettyPrintText(string3, true, n);
            TTYDisplay.showNewline();
        }
        String string7 = string5;
        if (string2 == null) {
            string2 = "";
        }
        while (true) {
            String string8 = "";
            if (string2.equals("")) {
                string8 = " []";
            } else if (!string2.equals(string6)) {
                string8 = " [" + string2 + "]";
            }
            if (string.trim().endsWith(string7)) {
                string = string.trim().substring(0, string.trim().length() - 1);
                string8 = String.valueOf(string8) + "? ";
            } else if (string.trim().endsWith(":")) {
                string = string.trim().substring(0, string.trim().length() - 1);
                string8 = String.valueOf(string8) + ": ";
            } else if (!string8.equals("")) {
                string8 = String.valueOf(string8) + " ";
            }
            TTYDisplay.prettyPrintText(String.valueOf(string) + string8, false, 3 + n);
            try {
                String string9 = depr_inReader.readLine();
                if (string9 == null) {
                    System.exit(-1);
                }
                if (!string9.equals(string7)) {
                    if (!string9.equals("")) return string9;
                    if (string2.equals(string6)) return string9;
                    return string2;
                }
                if (string3.length() <= 0) continue;
                TTYDisplay.showNewline();
                TTYDisplay.prettyPrintText(string3, true, n);
                TTYDisplay.showNewline();
            }
            catch (IOException iOException) {
                System.err.println("Read exception: " + iOException);
                return null;
            }
        }
    }

    public static int queryValue(String string, String string2, String[] stringArray, int n, int n2, int n3, String string3, int n4) {
        TTYDisplay.showNewline();
        if (string3 != null && string3.length() > 0) {
            TTYDisplay.showText(string3);
            TTYDisplay.showNewline();
        }
        if (string2 != null && !string2.equals("")) {
            TTYDisplay.showText(string2);
            TTYDisplay.showNewline();
        }
        int n5 = 0;
        while (n5 < stringArray.length) {
            TTYDisplay.showText(String.valueOf(n5 + 1) + ". " + stringArray[n5], n4);
            ++n5;
        }
        TTYDisplay.showNewline();
        int n6 = TTYDisplay.queryValue(string, n3, n, n2, string3, n4);
        return n6;
    }

    public static int queryValue(String string, String string2, String[] stringArray, int n, String string3) {
        TTYDisplay.showNewline();
        if (string3 != null && string3.length() > 0) {
            TTYDisplay.showText(string3);
            TTYDisplay.showNewline();
        }
        if (string2 != null && !string2.equals("")) {
            TTYDisplay.showText(string2);
            TTYDisplay.showNewline();
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            TTYDisplay.showText(String.valueOf(n2 + 1) + ". " + stringArray[n2]);
            ++n2;
        }
        TTYDisplay.showNewline();
        int n3 = TTYDisplay.queryValue(string, n + 1, 1, stringArray.length, string3);
        return n3 - 1;
    }

    public static String queryValue(String string, String string2, String[] stringArray, String string3) {
        return TTYDisplay.queryValue(string, string2, stringArray, true, string3);
    }

    public static String queryValue(String string, String string2, String[] stringArray, boolean bl, String string3) {
        while (true) {
            String string4 = "";
            string4 = TTYDisplay.queryValue(string, string2, string3);
            if (stringArray.length == 1) {
                return stringArray[0];
            }
            int n = 0;
            while (n < stringArray.length) {
                if (bl ? string4.equalsIgnoreCase(stringArray[n]) : string4.equals(stringArray[n])) {
                    return stringArray[n];
                }
                ++n;
            }
            String string5 = "";
            int n2 = 0;
            while (n2 < stringArray.length - 2) {
                string5 = String.valueOf(string5) + "'" + stringArray[n2] + "' ";
                ++n2;
            }
            string5 = String.valueOf(string5) + "'" + stringArray[stringArray.length - 2] + "'";
            String string6 = "'" + stringArray[stringArray.length - 1] + "'";
            String[] stringArray2 = new String[]{string5, string6};
            String string7 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplaySelectChoice", stringArray2);
            TTYDisplay.showNewline();
            TTYDisplay.showText(string7);
            TTYDisplay.showNewline();
        }
    }

    public static int queryValue(String string, String string2, String[] stringArray, String[] stringArray2, int n) {
        TTYDisplay.showNewline();
        if (string2 != null && !string2.equals("")) {
            TTYDisplay.showText(string2);
            TTYDisplay.showNewline();
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            TTYDisplay.showText(String.valueOf(n2 + 1) + ". " + stringArray[n2]);
            TTYDisplay.showText(stringArray2[n2], 6);
            TTYDisplay.showNewline();
            ++n2;
        }
        TTYDisplay.showNewline();
        int n3 = TTYDisplay.queryValue(string, n + 1, 1, stringArray.length, "");
        return n3 - 1;
    }

    private static String resolveString(String string, String string2) {
        return LocalizedStringResolver.resolve(string, string2);
    }

    private static String resolveString(String string, String string2, String[] stringArray) {
        return LocalizedStringResolver.resolve(string, string2, stringArray);
    }

    public void setAccessibilityEnabled(boolean bl) {
        this.accessibilityEnabled = bl;
    }

    public void setBaseIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("indent cannot be negative");
        }
        this.baseIndent = n;
    }

    public static void setConsoleWidth(int n) {
        depr_consoleWidth = n;
    }

    public void setPageLineCount(int n) {
        this.pageLineCount = n;
    }

    public void setStreams(InputStream inputStream, OutputStream outputStream) {
        this.out = new PrintWriter(outputStream, true);
        this.in = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void setWidth(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("width must be greater or equal to 1");
        }
        this.width = n;
    }

    public static void showHrule() {
        if (!TTYDisplay.accessbilityEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(depr_consoleWidth);
            int n = 0;
            while (n < depr_consoleWidth) {
                stringBuffer.append('-');
                ++n;
            }
            stringBuffer.append("\n");
            depr_outWriter.print(stringBuffer.toString());
        }
    }

    public void showMessage(String string) {
        this.showMessage(string, TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDefaultMessagePrompt"));
    }

    public void showMessage(String string, String string2) {
        TTYDisplay.showNewline();
        TTYDisplay.showText(string);
        TTYDisplay.showNewline();
        TTYDisplay.queryValue(string2);
    }

    public static void showNewline() {
        TTYDisplay.prettyPrintText("", true, 0);
    }

    public static void showText(String string) {
        TTYDisplay.showText(string, 0);
    }

    public static void showText(String string, int n) {
        TTYDisplay.prettyPrintText(string, true, n);
    }

    private boolean validateMinMaxValues(TTYPrompt tTYPrompt, String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= tTYPrompt.getMinLegalValue() && n <= tTYPrompt.getMaxLegalValue()) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.printLine();
        this.printIndentedLine(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayEnterValueRange", new String[]{String.valueOf(tTYPrompt.getMinLegalValue()), String.valueOf(tTYPrompt.getMaxLegalValue())}), tTYPrompt.getIndent());
        this.printLine();
        return false;
    }

    private boolean validateOptions(TTYPrompt tTYPrompt, String string) {
        String[] stringArray = tTYPrompt.getOptions();
        if (tTYPrompt.getPromptForOptionIndex()) {
            int n = tTYPrompt.hasMinLegalValue() ? Math.min(1, tTYPrompt.getMinLegalValue()) : 1;
            int n2 = tTYPrompt.hasMaxLegalValue() ? Math.max(stringArray.length, tTYPrompt.getMaxLegalValue()) : stringArray.length;
            try {
                int n3 = Integer.parseInt(string);
                if (n3 >= n && n3 <= n2) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            this.printLine();
            this.printIndentedLine(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayEnterValueRange", new String[]{String.valueOf(n), String.valueOf(n2)}), tTYPrompt.getIndent());
            this.printLine();
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (tTYPrompt.getIgnoreCase() && string.equalsIgnoreCase(stringArray[n]) || !tTYPrompt.getIgnoreCase() && string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < stringArray.length - 1) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("'" + stringArray[n4] + "'");
            ++n4;
        }
        String string2 = "'" + stringArray[stringArray.length - 1] + "'";
        this.printLine();
        this.printIndentedLine(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplaySelectChoice", new String[]{stringBuffer.toString(), string2}), tTYPrompt.getIndent());
        this.printLine();
        return false;
    }

    private class PasswordThread
    extends Thread {
        private boolean stop = false;
        private String caption = "";

        public PasswordThread(String string) {
            this.caption = string;
        }

        public synchronized boolean getStop() {
            return this.stop;
        }

        public void run() {
            String string = this.caption.trim().endsWith(":") ? this.caption.substring(0, this.caption.lastIndexOf(58)) : this.caption;
            String string2 = "\r" + string + ": \r" + string + ":";
            while (!this.getStop()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                if (!this.getStop()) {
                    System.out.print(string2);
                }
                System.out.flush();
            }
        }

        public synchronized void setStop() {
            this.stop = true;
        }
    }
}

