/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.jvm;

import com.installshield.util.jvm.LauncherEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Instructions
extends LauncherEntry {
    Vector statements = new Vector();

    public Instructions() {
        this.setName("instructions.txt");
    }

    public void add(String string) {
        this.statements.addElement(string);
    }

    public void add(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.add(stringArray[n]);
            ++n;
        }
    }

    public long calculateSize() throws IOException {
        byte[] byArray = this.write();
        return byArray.length;
    }

    public String createComment(String string) {
        return "// " + string;
    }

    public String createDeleteLauncherCommand() {
        return "DELETE_LAUNCHER";
    }

    public String[] createElseExpression(String string) {
        return new String[]{"GOTO " + string + "_DONE", ":" + string + "_ELSE"};
    }

    public String[] createEndIfExpression(String string) {
        return new String[]{":" + string + "_DONE"};
    }

    public String createExecuteLauncherCommand(String string) {
        return "EXECUTE_LAUNCHER " + string;
    }

    public String createFindJVMCommand(String string, String string2) {
        return "FIND_JVM " + string + " " + string2;
    }

    public String createILaunchCommand(String string, String string2) {
        return "ILAUNCH " + string + " " + string2;
    }

    public String[] createIfExpression(String string, String string2) {
        return new String[]{"JMP0 " + string + " " + string2 + "_ELSE"};
    }

    public String createInitializeUICommand() {
        return "INITIALIZE_UI";
    }

    public String createInstallJVMCommand(String string) {
        return "INSTALL_JVM " + string;
    }

    public String createLaunchCommand(String string, String string2) {
        return "LAUNCH " + string + " " + string2;
    }

    public String createSetCommand(String string, String string2) {
        return "SET " + string + " = " + string2;
    }

    public String createVerifyCommand(String string, String string2, String string3) {
        return "VERIFY " + string + " " + string2 + " " + string3;
    }

    public InputStream getInputStream() throws IOException {
        byte[] byArray = this.write();
        return new ByteArrayInputStream(byArray);
    }

    public int getType() {
        return 0;
    }

    private byte[] write() throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        Enumeration enumeration = this.statements.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (object == null) continue;
            printWriter.println((String)object);
        }
        printWriter.flush();
        object = byteArrayOutputStream.toByteArray();
        printWriter.close();
        byteArrayOutputStream.close();
        return object;
    }
}

