/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.wizard.NavigatableWizardBean;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanelImpl;
import com.installshield.wizard.WizardUI;

public class WizardPanel
extends WizardBean
implements NavigatableWizardBean {
    private String title = "";
    private String description = "";
    private int navigation = 0;
    private WizardPanelImpl impl = null;
    private boolean notifyImpl = true;
    private boolean entered = false;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        WizardUI[] wizardUIArray = wizardBuilderSupport.getWizard().getInterfaces();
        int n = 0;
        while (n < wizardUIArray.length) {
            Class clazz = this.getWizardPanelImpl(wizardUIArray[n].getName());
            if (clazz != null) {
                try {
                    wizardBuilderSupport.putClass(clazz.getName());
                    WizardPanelImpl wizardPanelImpl = (WizardPanelImpl)clazz.newInstance();
                    wizardPanelImpl.setPanel(this);
                    wizardPanelImpl.build(wizardBuilderSupport);
                }
                catch (Exception exception) {
                    wizardBuilderSupport.logEvent(this, "err", exception);
                }
            }
            ++n;
        }
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    public void exited(WizardBeanEvent wizardBeanEvent) {
    }

    public String getDescription() {
        return this.description;
    }

    public int getNavigationOptions() {
        return this.navigation;
    }

    public boolean getPropertyNotification() {
        return this.notifyImpl;
    }

    public String getTitle() {
        return this.title;
    }

    public WizardPanelImpl getWizardPanelImpl() {
        return this.impl;
    }

    public Class getWizardPanelImpl(String string) {
        String string2;
        if (string.equals("awt")) {
            string2 = "AWTImpl";
        } else if (string.equals("swing")) {
            string2 = "SwingImpl";
        } else if (string.equals("console")) {
            string2 = "ConsoleImpl";
        } else {
            return null;
        }
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = null;
        while (clazz != null && clazz2 == null) {
            try {
                clazz2 = Class.forName(String.valueOf(clazz.getName()) + string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = clazz.getSuperclass();
            }
        }
        if (clazz2 == null) {
            this.logEvent(this, "dbg", "could not find " + string + " impl for " + this.getClass());
        }
        return clazz2;
    }

    public boolean isEntered() {
        return this.entered;
    }

    public void propertyChanged(String string) {
        if (this.notifyImpl && this.impl != null) {
            this.impl.propertyChanged(string);
        }
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    public void selectImplField(String string) {
        if (this.impl != null) {
            this.impl.selectField(string);
        }
    }

    public void setDescription(String string) {
        this.description = string;
        this.propertyChanged("description");
    }

    public void setEntered(boolean bl) {
        this.entered = bl;
    }

    public void setNavigationOptions(int n) {
        this.navigation = n;
    }

    public void setPropertyNotification(boolean bl) {
        this.notifyImpl = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setWizardPanelImpl(WizardPanelImpl wizardPanelImpl) {
        this.impl = wizardPanelImpl;
    }
}

