/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;

public class BorderPanel
extends Panel {
    public static final Color DEFAULT_BORDER_COLOR = Color.blue;
    private int thickness = 0;
    private Color borderColor = DEFAULT_BORDER_COLOR;

    public void draw(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this.borderColor.brighter());
        int n = 0;
        while (n < this.thickness / 2) {
            graphics.drawRect(rectangle.x + n, rectangle.y + n, rectangle.width - 1 - n * 2, rectangle.height - 1 - n * 2);
            ++n;
        }
        graphics.setColor(this.borderColor.darker().darker());
        n = this.thickness / 2;
        while (n < this.thickness) {
            graphics.drawRect(rectangle.x + n, rectangle.y + n, rectangle.width - 1 - n * 2, rectangle.height - 1 - n * 2);
            ++n;
        }
        graphics.setColor(color);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void paint(Graphics graphics) {
        this.draw(graphics, new Rectangle(this.getSize()));
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.repaint();
    }

    public void setThickness(int n) {
        this.thickness = n;
    }
}

