/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;

public class ISProgressBar
extends Panel {
    private int PROGRESS_WIDTH = 350;
    private final Insets border = new Insets(2, 2, 2, 2);
    private final int textPadding = 1;
    private int level = 0;
    private Dimension minSize;

    private void drawBorder(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(1, 1, dimension.width - 2, 1);
        graphics.drawLine(1, 1, 1, dimension.height - 2);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 2);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(0, dimension.height - 1, dimension.width, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, this.getPreferredSize().height);
    }

    public Dimension getPreferredSize() {
        Font font = this.getFont();
        Container container = this.getParent();
        while (font == null && container != null) {
            font = container.getFont();
            container = container.getParent();
        }
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            return new Dimension(this.PROGRESS_WIDTH, fontMetrics.getHeight() + this.border.top + this.border.bottom + 2);
        }
        return new Dimension(0, 0);
    }

    public int getProgress() {
        return this.level;
    }

    public synchronized void paint(Graphics graphics) {
        this.drawBorder(graphics);
        Dimension dimension = this.getSize();
        int n = this.border.left;
        int n2 = this.border.top;
        int n3 = dimension.width - this.border.left - this.border.right;
        int n4 = dimension.height - this.border.top - this.border.bottom;
        int n5 = (int)((float)this.level / 100.0f * (float)n3);
        graphics.setColor(this.getBackground());
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(this.getForeground());
        graphics.fillRect(n, n2, n5, n4);
        String string = String.valueOf(this.level) + "%";
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = fontMetrics.stringWidth(string);
        int n7 = dimension.width / 2 - n6 / 2;
        int n8 = n2 + fontMetrics.getAscent() + (n4 - fontMetrics.getAscent()) / 2 - 1;
        graphics.setClip(this.border.left, this.border.top, n5 + this.border.left, n4);
        graphics.setColor(this.getBackground());
        graphics.drawString(string, n7, n8);
        graphics.setClip(n5 + this.border.left, this.border.top, n3 - n5, n4);
        graphics.setColor(this.getForeground());
        graphics.drawString(string, n7, n8);
    }

    public void setProgress(int n) {
        if (n != this.level) {
            this.level = Math.max(0, Math.min(n, 100));
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

