/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;

public class Win32Platform {
    public static final int WINDOWS_ANY = 1;
    public static final int ARCH_ANY = 1;
    public static final int ARCH_X86 = 2;
    public static final int ARCH_IA64 = 3;

    public static boolean isCompatibleWith(int n, int n2) throws ServiceException {
        boolean bl = false;
        boolean bl2 = false;
        String string = System.getProperty("os.name");
        String string2 = "windows";
        if (string.length() >= string2.length() && string.substring(0, string2.length()).equalsIgnoreCase(string2)) {
            if (n == 1) {
                bl = true;
            } else {
                throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32Platform.unsupportedOSName", new String[]{string}));
            }
        }
        if (n2 != 1) {
            String string3 = System.getProperty("os.arch");
            if (n2 == 2) {
                if (string3.equalsIgnoreCase("x86") || string3.equalsIgnoreCase("i386") || string3.equalsIgnoreCase("i86pc")) {
                    bl2 = true;
                }
            } else if (n2 == 3) {
                bl2 = string3.equalsIgnoreCase("ia64");
            }
        } else {
            bl2 = true;
        }
        return bl && bl2;
    }

    public static boolean targetIsWindowsMachine() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }
}

