/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.report.editor;

import com.ibm.etools.fa.common.XMSegmentElement;
import com.ibm.etools.fa.report.editor.FAReportBrowser;
import com.ibm.etools.fa.util.NLS;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MiscInfoPage
extends FormPage {
    private XMSegmentElement rootElement = null;
    private XMSegmentElement epilogElement = null;
    private XMSegmentElement prologElement = null;
    private XMSegmentElement optionsElement = null;
    private FormToolkit toolkit = null;
    private ScrolledForm form = null;

    public MiscInfoPage(FormEditor editor, XMSegmentElement xmSegmentElement) {
        super(editor, MiscInfoPage.class.getName(), NLS.getString("MiscInfoPage.Title"));
        this.rootElement = xmSegmentElement;
    }

    private void initXMElements() {
        if (this.rootElement == null) {
            this.rootElement = new XMSegmentElement();
            this.rootElement.appendContent(NLS.getString("n/a"));
        }
        if (this.epilogElement == null) {
            this.epilogElement = new XMSegmentElement();
            this.epilogElement.appendContent(NLS.getString("n/a"));
        }
        if (this.prologElement == null) {
            this.prologElement = new XMSegmentElement();
            this.prologElement.appendContent(NLS.getString("n/a"));
        }
        if (this.optionsElement == null) {
            this.optionsElement = new XMSegmentElement();
            this.optionsElement.appendContent(NLS.getString("n/a"));
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.searchRequiredElement(this.rootElement);
        this.initXMElements();
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        this.form.getBody().setLayout((Layout)layout);
        ((FAReportBrowser)this.getEditor()).createBrowseDumpHyperLink(this.form.getBody(), this.toolkit);
        ((FAReportBrowser)this.getEditor()).createRichTextFormSectionWithoutExpansion(this.form.getBody(), NLS.getString("MiscInfoPage.OptionsSectionTitle"), NLS.getString("MiscInfoPage.OptionsSectionDesc"), this.optionsElement.getContents().toString(), this.toolkit);
        ((FAReportBrowser)this.getEditor()).createSectionWithLabel(this.form.getBody(), NLS.getString("MiscInfoPage.PrologTitle"), NLS.getString("MiscInfoPage.PrologDesc"), this.prologElement.getContents().toString(), false, this.toolkit, this.form);
        ((FAReportBrowser)this.getEditor()).createSectionWithLabel(this.form.getBody(), NLS.getString("MiscInfoPage.EpilogTitle"), NLS.getString("MiscInfoPage.EpilogDesc"), this.epilogElement.getContents().toString(), false, this.toolkit, this.form);
    }

    private void searchRequiredElement(XMSegmentElement root) {
        if (root == null) {
            return;
        }
        if (root.getStartTag().startsWith("<Epilog")) {
            this.epilogElement = root;
        } else if (root.getStartTag().startsWith("<Prolog")) {
            this.prologElement = root;
        } else if (root.getStartTag().startsWith("<OptionsInEffect")) {
            this.optionsElement = root;
        }
        ArrayList children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            this.searchRequiredElement((XMSegmentElement)children.get(i));
            ++i;
        }
    }
}

