/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.details;

import com.ibm.etools.fa.common.HistoryIndexFileEntry;
import com.ibm.etools.fa.pages.ColumnConfigSelectionPage;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.GUIUtility;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.details.ColumnConfigurationData;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import com.ibm.etools.fa.view.summary.SystemElement;
import com.ibm.etools.fa.view.summary.TreeElement;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailedHistoryFileView
extends ViewPart {
    public final String VIEW_READY_PROPERTY = "com.ibm.etools.fa.view.details.DetailedHistoryFileView.viewReady";
    public static final String ID = "com.ibm.etools.fa.view.details.DetailedHistoryFileView";
    public static final String HISTORY_INDEX_FILE_NAME = "$$INDEX";
    public static final String COLUMN_CONFIG_DATA_FILE_NAME = "columns.dat";
    private Text systemNameText;
    private Text histFileViewNameText;
    private Table histFileMemberTable = null;
    private TableViewer histFileMemberTableViewer = null;
    private ArrayList<ArrayList> histFileMemberContents = null;
    private Action columnConfigAction = null;
    ArrayList<ColumnConfigurationData> columnConfigDataList = this.getColumnConfigData();
    private ColumnConfigurationData selectedConfigData = this.columnConfigDataList.get(0);
    private ArrayList<FAHistoryFileViewData> currentHistFileViewDataList = null;
    private String currentHistFileViewDataName = null;

    public String getSystemAliasName() {
        return this.systemNameText.getText().trim();
    }

    public void createPartControl(Composite parent) {
        Composite mainComposite = GUIUtility.createComposite(parent, 1);
        this.createHistFileDetailsComposite(mainComposite);
        this.createTableArea(mainComposite);
        this.makeActions();
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IAction)this.columnConfigAction);
        bars.getToolBarManager().add((IAction)this.columnConfigAction);
        this.hookContextMenu();
        this.setPartName(this.selectedConfigData.getConfigDataName());
    }

    private void createHistFileDetailsComposite(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 2);
        GUIUtility.createLabel(composite, NLS.getString("SystemName"), 1);
        this.systemNameText = GUIUtility.createTextField(composite);
        this.systemNameText.setEditable(false);
        GUIUtility.createLabel(composite, NLS.getString("HistFileOrView"), 1);
        this.histFileViewNameText = GUIUtility.createTextField(composite);
        this.histFileViewNameText.setEditable(false);
    }

    private void createTableArea(Composite parent) {
        this.histFileMemberContents = new ArrayList();
        Composite tableComposite = GUIUtility.createComposite(parent, 1);
        GridData compData = new GridData(1808);
        compData.grabExcessHorizontalSpace = true;
        compData.grabExcessVerticalSpace = true;
        tableComposite.setLayoutData((Object)compData);
        this.histFileMemberTable = new Table(tableComposite, 65540);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.histFileMemberTable.setLayoutData((Object)gd);
        this.histFileMemberTable.setHeaderVisible(true);
        this.histFileMemberTable.setLinesVisible(true);
        int i = 0;
        while (i < this.selectedConfigData.getColumnCount()) {
            final TableColumn tc = this.createTableColumn(this.histFileMemberTable, i, "", 100);
            tc.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String headerText = tc.getText();
                    if (headerText.length() > 0) {
                        DetailedHistoryFileView.this.sortView(headerText);
                    }
                }
            });
            ++i;
        }
        this.setColumnHeaders();
        this.histFileMemberTableViewer = new TableViewer(this.histFileMemberTable);
        this.histFileMemberTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.histFileMemberTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ArrayList columns = (ArrayList)element;
                Object item = columns.get(columnIndex);
                if (item instanceof String) {
                    return (String)item;
                }
                return item.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.histFileMemberTableViewer.setInput(this.histFileMemberContents);
        this.histFileMemberTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectionIndex = DetailedHistoryFileView.this.histFileMemberTable.getSelectionIndex();
                if (selectionIndex != -1) {
                    System.setProperty("com.ibm.etools.fa.view.details.DetailedHistoryFileView.viewReady", "true");
                } else {
                    System.setProperty("com.ibm.etools.fa.view.details.DetailedHistoryFileView.viewReady", "false");
                }
            }
        });
    }

    protected TableColumn createTableColumn(Table table, int column, String text, int width) {
        TableColumn tc = new TableColumn(table, 16384, column);
        tc.setText(text);
        tc.setWidth(width);
        return tc;
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.columnConfigAction = new Action(NLS.getString("DetailedHistoryFileView.ConfigColumn"), 1){

            public void run() {
                ColumnConfigSelectionPage page = new ColumnConfigSelectionPage(Display.getCurrent().getActiveShell(), DetailedHistoryFileView.this.getColumnConfigData(), DetailedHistoryFileView.this.selectedConfigData);
                if (page.open() != 0) {
                    return;
                }
                int selectionIndex = page.getSelectionIndex();
                DetailedHistoryFileView.this.columnConfigDataList = page.getNewColumnConfigDataList();
                DetailedHistoryFileView.this.selectedConfigData = DetailedHistoryFileView.this.columnConfigDataList.get(selectionIndex);
                DetailedHistoryFileView.this.columnConfigDataList.remove(selectionIndex);
                DetailedHistoryFileView.this.columnConfigDataList.add(0, DetailedHistoryFileView.this.selectedConfigData);
                DetailedHistoryFileView.this.saveColumnConfigurationData(DetailedHistoryFileView.this.columnConfigDataList);
                DetailedHistoryFileView.this.setColumnHeaders();
                if (DetailedHistoryFileView.this.currentHistFileViewDataList != null && DetailedHistoryFileView.this.currentHistFileViewDataName != null) {
                    DetailedHistoryFileView.this.populateTable(DetailedHistoryFileView.this.currentHistFileViewDataList, DetailedHistoryFileView.this.currentHistFileViewDataName);
                }
                DetailedHistoryFileView.this.setPartName(DetailedHistoryFileView.this.selectedConfigData.getConfigDataName());
            }
        };
    }

    private void setColumnHeaders() {
        ArrayList<String> list = this.selectedConfigData.getDisplayColumnNames();
        int i = 0;
        while (i < this.selectedConfigData.getColumnCount()) {
            if (i < list.size()) {
                this.histFileMemberTable.getColumn(i).setText(list.get(i));
            } else {
                this.histFileMemberTable.getColumn(i).setText("");
            }
            ++i;
        }
        this.histFileMemberTable.redraw();
        this.histFileMemberTable.showColumn(this.histFileMemberTable.getColumn(0));
    }

    public void populateTable(ArrayList<FAHistoryFileViewData> histFileViewDataList, String histFileViewName) {
        ObjectInputStream input = null;
        this.histFileMemberContents.clear();
        this.currentHistFileViewDataList = histFileViewDataList;
        this.currentHistFileViewDataName = histFileViewName;
        this.systemNameText.setText(histFileViewDataList.get(0).getSystemAliasName());
        this.histFileViewNameText.setText(this.currentHistFileViewDataName);
        int i = 0;
        while (i < this.currentHistFileViewDataList.size()) {
            try {
                try {
                    input = new ObjectInputStream(new FileInputStream(this.currentHistFileViewDataList.get(i).getLocalFullPathHistFileName()));
                    ArrayList data = (ArrayList)input.readObject();
                    int j = 0;
                    while (j < data.size()) {
                        HistoryIndexFileEntry entry = (HistoryIndexFileEntry)data.get(j);
                        ArrayList<Object> tableEntry = this.selectedConfigData.getTableData(entry);
                        this.histFileMemberContents.add(tableEntry);
                        ++j;
                    }
                    this.histFileMemberTableViewer.refresh();
                }
                catch (Exception e) {
                    FAPlugin.getDefault().log(4, NLS.getString("DetailedHistoryFileView.TablePopulateErr"), e, true);
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    public void clearTableEntries() {
        this.currentHistFileViewDataList = null;
        this.currentHistFileViewDataName = null;
        this.systemNameText.setText("");
        this.histFileViewNameText.setText("");
        this.histFileMemberContents.clear();
        this.histFileMemberTableViewer.refresh();
    }

    public void clearTableEntriesIfAppropriate(String systemAliasName, TreeElement elementToBeDeleted) {
        if (elementToBeDeleted instanceof SystemElement) {
            if (this.systemNameText.getText().trim().toUpperCase().equals(systemAliasName.trim().toUpperCase())) {
                this.clearTableEntries();
            }
        } else if (this.systemNameText.getText().trim().toUpperCase().equals(systemAliasName.trim().toUpperCase()) && this.histFileViewNameText.getText().trim().toUpperCase().equals(elementToBeDeleted.getLabel().trim().toUpperCase())) {
            this.clearTableEntries();
        }
    }

    private void sortView(String columnName) {
        ArrayList<ArrayList> sortedList = new ArrayList<ArrayList>();
        int columnIndex = this.selectedConfigData.getColumnIndex(columnName);
        int i = 0;
        while (i < this.histFileMemberContents.size()) {
            ArrayList currentItem = this.histFileMemberContents.get(i);
            this.sortInsert(sortedList, columnIndex, currentItem);
            ++i;
        }
        this.histFileMemberContents.clear();
        i = 0;
        while (i < sortedList.size()) {
            this.histFileMemberContents.add(sortedList.get(i));
            ++i;
        }
        this.histFileMemberTableViewer.refresh();
    }

    private void sortInsert(ArrayList<ArrayList> sortedList, int columnIndex, ArrayList<String> newItem) {
        String newKey = newItem.get(columnIndex);
        int i = 0;
        while (i < sortedList.size()) {
            ArrayList currentItem = sortedList.get(i);
            String currentKey = (String)currentItem.get(columnIndex);
            if (newKey.compareTo(currentKey) < 0) {
                sortedList.add(i, newItem);
                return;
            }
            ++i;
        }
        sortedList.add(newItem);
    }

    /*
     * Loose catch block
     */
    private ArrayList<ColumnConfigurationData> getColumnConfigData() {
        ArrayList<ColumnConfigurationData> arrayList;
        ObjectInputStream input;
        ObjectOutputStream output;
        block34: {
            block32: {
                ArrayList<ColumnConfigurationData> arrayList2;
                block33: {
                    output = null;
                    input = null;
                    if (this.columnConfigDataList == null) break block32;
                    arrayList2 = this.columnConfigDataList;
                    if (output == null) break block33;
                    try {
                        output.close();
                    }
                    catch (Exception exception) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
                return arrayList2;
            }
            IPath path = FAPlugin.getPath().append(COLUMN_CONFIG_DATA_FILE_NAME);
            File configFile = path.toFile();
            if (!configFile.exists()) {
                this.columnConfigDataList = new ArrayList();
                this.columnConfigDataList.add(new ColumnConfigurationData(NLS.getString("Default")));
                this.selectedConfigData = this.columnConfigDataList.get(0);
                output = new ObjectOutputStream(new FileOutputStream(configFile));
                output.writeObject(this.selectedConfigData);
            } else {
                input = new ObjectInputStream(new FileInputStream(configFile));
                this.columnConfigDataList = new ArrayList();
                try {
                    ColumnConfigurationData data = (ColumnConfigurationData)input.readObject();
                    while (data != null) {
                        this.columnConfigDataList.add(data);
                        data = (ColumnConfigurationData)input.readObject();
                    }
                }
                catch (EOFException eOFException) {}
            }
            if (this.columnConfigDataList.size() == 0) {
                this.columnConfigDataList.add(new ColumnConfigurationData(NLS.getString("Default")));
            }
            this.selectedConfigData = this.columnConfigDataList.get(0);
            arrayList = this.columnConfigDataList;
            if (output == null) break block34;
            try {
                output.close();
            }
            catch (Exception exception) {}
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
        return arrayList;
        catch (Exception e) {
            ArrayList<ColumnConfigurationData> arrayList3;
            block35: {
                try {
                    FAPlugin.getDefault().log(2, NLS.getString("DetailedHistoryFileView.ColumnConfigErr"), e, false);
                    this.columnConfigDataList = new ArrayList();
                    this.columnConfigDataList.add(new ColumnConfigurationData(NLS.getString("Default")));
                    this.selectedConfigData = this.columnConfigDataList.get(0);
                    arrayList3 = this.columnConfigDataList;
                    if (output == null) break block35;
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            return arrayList3;
        }
    }

    private void saveColumnConfigurationData(ArrayList<ColumnConfigurationData> data) {
        ObjectOutputStream output = null;
        try {
            try {
                IPath path = FAPlugin.getPath().append(COLUMN_CONFIG_DATA_FILE_NAME);
                File configFile = path.toFile();
                output = new ObjectOutputStream(new FileOutputStream(configFile));
                int i = 0;
                while (i < data.size()) {
                    output.writeObject(data.get(i));
                    ++i;
                }
            }
            catch (Exception e) {
                FAPlugin.getDefault().log(2, NLS.getString("DetailedHistoryFileView.ColumnConfigErr"), e, false);
            }
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (Exception exception) {}
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)DetailedHistoryFileView.this.columnConfigAction);
                manager.add((IContributionItem)new Separator("Additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.histFileMemberTableViewer.getControl());
        this.histFileMemberTableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.histFileMemberTableViewer);
    }
}

