/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.summary;

import com.ibm.etools.fa.jobs.RetrieveHistFileInfoForViewnJob;
import com.ibm.etools.fa.jobs.RetrieveHistoryFileInformationJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.details.DetailedHistoryFileView;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import com.ibm.etools.fa.view.summary.FAViewContentProvider;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import com.ibm.etools.fa.view.summary.RootElement;
import com.ibm.etools.fa.view.summary.SystemElement;
import com.ibm.etools.fa.view.summary.ViewElement;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.ViewPart;

public class HistoryFilesView
extends ViewPart {
    public static final String ID = "com.ibm.etools.fa.view.summary.HistoryFilesView";
    private TreeViewer viewer = null;
    private FAViewContentProvider cotentProvider = null;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.cotentProvider = new FAViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.cotentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.cotentProvider);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.viewer.addDoubleClickListener(this.createDoubleClickListener());
        this.hookContextMenu();
        this.makeActions();
        this.cotentProvider.setContent(new RootElement(NLS.getString("HistoryFileView.RootLabel")));
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.refresh();
    }

    public void setFocus() {
    }

    private void makeActions() {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("Additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private IDoubleClickListener createDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                block9: {
                    Object selection = ((StructuredSelection)event.getSelection()).getFirstElement();
                    HistoryFilesView.this.expand(selection, 1);
                    if (selection instanceof HistoryFileElement) {
                        HistoryFileElement element = (HistoryFileElement)selection;
                        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (activePage.findView("com.ibm.etools.fa.view.details.DetailedHistoryFileView") != null) {
                            try {
                                DetailedHistoryFileView view = (DetailedHistoryFileView)activePage.showView("com.ibm.etools.fa.view.details.DetailedHistoryFileView");
                                ArrayList<FAHistoryFileViewData> viewList = new ArrayList<FAHistoryFileViewData>();
                                viewList.add(element.getHistoryFileData());
                                File file = new File(element.getHistoryFileData().getLocalFullPathHistFileName());
                                if (!file.exists()) {
                                    RetrieveHistoryFileInformationJob job = new RetrieveHistoryFileInformationJob(element.getHistoryFileData());
                                    job.runJob();
                                    break block9;
                                }
                                view.populateTable(viewList, element.getHistoryFileData().getHistFileName());
                            }
                            catch (Exception e) {
                                FAPlugin.getDefault().log(4, NLS.getString("HistoryFilesView.DetailedHistFileOpenErr"), e, true);
                            }
                        }
                    } else if (selection instanceof ViewElement) {
                        try {
                            ViewElement viewElement = (ViewElement)selection;
                            SystemElement systemElement = (SystemElement)viewElement.getParent().getParent();
                            RetrieveHistFileInfoForViewnJob job = new RetrieveHistFileInfoForViewnJob(systemElement.getLabel(), viewElement, false);
                            job.runJob();
                        }
                        catch (Exception e) {
                            FAPlugin.getDefault().log(4, NLS.getString("HistoryFilesView.OpenViewErr"), e, true);
                        }
                    }
                }
            }
        };
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void expand(Object element, int level) {
        this.viewer.refresh();
        if (element == null) {
            this.viewer.expandToLevel(level);
        } else {
            this.viewer.expandToLevel(element, level);
        }
    }
}

