/* API header Control and Diagnostics Management *********************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2006. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
 
#include <time.h>
#include <stdio.h>
#include <ctype.h>
 
/*|:h3.IDICH.H                                                       */
 
/*********************************************************************/
/*   API Structure forward declarations                              */
/*********************************************************************/
/* The following component common area forward declarations are      */
/* defined in the component internal only include file, they should  */
/* not contain data used for inter component communications.         */
/* Even within the components the data should be static in nature,   */
/* and shared across the component, such as the head of queues.      */
struct CCOMMON ;
struct DCOMMON ;
struct ECOMMON ;
struct HCOMMON ;
struct ICOMMON ;
struct KCOMMON ;
struct PCOMMON ;
struct VCOMMON ;
struct XCOMMON ;
typedef struct CCOMMON CCOMMON ;
typedef struct DCOMMON DCOMMON ;
typedef struct ECOMMON ECOMMON ;
typedef struct HCOMMON HCOMMON ;
typedef struct ICOMMON ICOMMON ;
typedef struct KCOMMON KCOMMON ;
typedef struct PCOMMON PCOMMON ;
typedef struct VCOMMON VCOMMON ;
typedef struct XCOMMON XCOMMON ;
 
struct DDT ;
typedef struct DDT DDT ;
#define DDT_DEF
 
struct XTL;
typedef struct XTL XTL;
 
struct XNL;
typedef struct XNL XNL;
 
struct XND;
typedef struct XND XND;
 
struct OPTS ;
typedef struct OPTS OPTS ;
 
struct GARRAY ;
typedef struct GARRAY GARRAY ;
 
struct CATBUF;
typedef struct CATBUF CATBUF;
 
struct PRMLBBUF_HDR;
typedef struct PRMLBBUF_HDR PRMLBBUF_HDR;
 
struct NLSINFO;
typedef struct NLSINFO NLSINFO;
 
struct CFG;
typedef struct CFG CFG;
 
struct TIMESTAMP;
typedef struct TIMESTAMP TIMESTAMP;
 
struct EANCHOR ;
typedef struct EANCHOR EANCHOR ;
 
struct KANCHOR ;
typedef struct KANCHOR KANCHOR ;
 
struct DDIR_DATA_HD;
typedef struct DDIR_DATA_HD DDIR_DATA_HD;
 
struct DDIR_SHDR;
typedef struct DDIR_SHDR DDIR_SHDR;
 
struct DDIR_DATA_HI ;
typedef struct DDIR_DATA_HI DDIR_DATA_HI ;
 
/* KENICHI
struct ACB;
typedef _Packed struct ACB ACB;
*/
#pragma pack(1)
struct ACB;
typedef struct ACB ACB;
#pragma pack(pop)
 
struct DCB;
typedef struct DCB DCB;
 
struct QSAM_REC;
typedef struct QSAM_REC QSAM_REC;
 
struct VSAM_REC;
typedef struct VSAM_REC VSAM_REC;
 
struct OPEN_FILEINFO;
typedef struct OPEN_FILEINFO OPEN_FILEINFO;
 
#define SHIFT_OUT 0x0e
#define SHIFT_IN  0x0f
 
struct X_TYPE;
typedef struct X_TYPE X_TYPE;
 
struct TOD2CHAR_TS;
typedef struct TOD2CHAR_TS TOD2CHAR_TS;
 
struct STOR_RANGE;
typedef struct STOR_RANGE STOR_RANGE;
 
struct DSUBSEG ;
typedef struct DSUBSEG DSUBSEG ;
 
/************************************************************************/
/* ACB -- Access Method Control Block (VSAM)                            */
/************************************************************************/
#pragma pack(1)
//KENICHI_Packed struct ACB {                  /* ACB for open VSAM file       */
struct ACB {                  /* ACB for open VSAM file       */
  char acb_id;                        /* ACB identifier X'A0'         */
  char acb_styp;                      /* ACB subtype                  */
  short acb_leng;                     /* ACB length                   */
  int acb_ambl;                       /* AMB list address             */
  int acb_inrtn;                      /* Data mgt interface address   */
  char acb_macr1;                     /* Macrf first byte             */
  char acb_macr2;                     /* Macrf second byte            */
  short acb_strno;                    /* No of concurrent req strings */
  short acb_bufnd;                    /* No of data record buffers    */
  short acb_bufni;                    /* No of index record buffers   */
  short filler1;                      /* Reserved                     */
  short acb_jbuf;                     /* No of journal buffers        */
  char acb_recfm;                     /* Record format                */
  char acb_cctyp;                     /* Control character type       */
  short acb_opt;                      /* Non-user options             */
  int filler2;                        /* Reserved                     */
  int acb_passw;                      /* Password address             */
  int acb_exlst;                      /* User exit list address       */
  union {
    struct {
      short _acb_tiot;                /* Offset into TIOT of TIOELNGH */
      char _acb_infl;                 /*                              */
      char _acb_ameth;                /* Access method type           */
      int _acb_deb;                   /* DEB address (24-bit)         */
    } _acb_struct1;
    char _acb_ddnam[8];               /* Name on DD statement         */
  } _acb_union1;
  char acb_oflgs;                     /* Open /close flags            */
  char acb_erflg;                     /* Error flags (before open)    */
  short acb_inflg;                    /* Indicator flags              */
  int acb_ujfcb;                      /* User JFCB address            */
  int acb_bufsp;                      /* Core available for buffers   */
  short acb_blksz;                    /* Blocksize                    */
  short acb_lrecl;                    /* Logical record length        */
  int acb_uaptr;                      /* User workarea address        */
  int acb_cbmwa;                      /* Control block workarea addr  */
  int acb_apid;                       /* Application id addr (VTAM)   */
};
#pragma pack(pop) 

#define acb_tiot            _acb_union1._acb_struct1._acb_tiot
#define acb_ddnam           _acb_union1._acb_ddnam
 
/************************************************************************/
/* DCB -- Data Control Block (DCB)                                      */
/*  $$PATCH could do with improving (eg. MACRF etc. many offsets        */
/*                                       used in FindQSAMRecords) zzzjb */
/************************************************************************/
struct DCB {                          /* DCB                          */
  char           filler1[20];         /* Unused                       */
  union {
    struct {
      unsigned int _dcb_bufno :8;     /* Number of buffers            */
      char         _dcb_bufca[3];     /* Address of buffer pool block */
    } _dcb_struct1;
    int          _dcb_bufca;          /* Address of buffer pool block */
  } _dcb_union1;
  char           filler2[2];          /* Unused                       */
  struct {
    unsigned int _dcb_dsgis :1;       /* Indexed sequential           */
    unsigned int _dcb_dsgps :1;       /* Physical sequential          */
    unsigned int _dcb_dsgda :1;       /* Direct                       */
    unsigned int filler1    :5;
  } _dcb_struct2;
  char           filler3[9];          /* Unused                       */
  struct {
    unsigned int _dcb_recf  :1;       /* Fixed length record          */
    unsigned int _dcb_recv  :1;       /* Variable record length       */
    unsigned int _dcb_recto :1;       /* Track overflow               */
    unsigned int _dcb_recbr :1;       /* Blocked records              */
    unsigned int _dcb_recsb :1;       /* F/Standard, V/Spanned        */
    unsigned int _dcb_recca :1;       /* ASA control characters       */
    unsigned int _dcb_reccm :1;       /* Machine control characters   */
    unsigned int _dcb_reckl :1;       /* Key length specified in DCB  */
  } _dcb_struct3;
  char           filler4[3];          /* Unused                       */
  union {
    struct {
      short      _dcb_tiot;           /* Offset into TIOT of TIOELNGH */
      char       filler5[6];          /* Unused                       */
    } _dcb_struct5;
    char _dcb_ddnam[8];               /* Name on DD statement         */
  } _dcb_union5;
  struct {
    unsigned int _dcb_oflwr :1;       /* Last I/O: 0=READ, 1=WRITE    */
    unsigned int _dcb_oflrb :1;       /* Last I/O was READ backward   */
    unsigned int filler1    :1;       /* Unused                       */
    unsigned int _dcb_ofopn :1;       /* OPEN successfully completed  */
    unsigned int filler2    :4;       /* Unused                       */
  } _dcb_struct5;
  char           filler6[3];          /* Unused                       */
  struct {
    unsigned int filler1    :4;
    unsigned int _dcb_optcd :1;       /* Track overflow               */
    unsigned int filler2    :3;
  } _dcb_struct4;
  char           filler7[9];          /* Unused                       */
  short          dcb_blksi;           /* Maximum block size           */
  char           filler8[4];          /* Unused                       */
  short          dcb_smsi;            /*                              */
  char           filler9[2];          /* Unused                       */
  union {
    struct {
      unsigned int _dcb_ncp   :8;     /* Num chan progs               */
      char         _dcb_eobad[3];     /* Last byte of current buf addr*/
    } _dcb_struct3;
    int          _dcb_eobad;          /* Last byte of current buf addr*/
  } _dcb_union3;
  union {
    struct {
      unsigned int _dcb_flag  :8;     /* Flag byte                    */
      char         _dcb_recad[3];     /* Next or current record addr  */
    } _dcb_struct4;
    int          _dcb_recad;          /* Next or current record addr  */
  } _dcb_union4;
  char           filler10[1];
  char           dcb_bufof;           /* ASCII buffer offset          */
  short int      dcb_lrecl;           /* Logical record length        */
};
 
/************************************************************************/
/* QSAM_REC                                                             */
/* An array of this struct is used to locate all records in all         */
/* available buffers. This array is pointed to from a xxx_FILEINFO      */
/* struct which also gives the no of elements (nrecs).                  */
/************************************************************************/
struct QSAM_REC {
  int address;                  /* logical address of record or segment */
  short length;                          /* length of record or segment */
  short recn;                       /* record sequence number -n..0..+n */
  short segn;                      /* segment sequence number -n..0..+n */
  char sdw_c;           /* segment position indicator if spanned record */
};
 
/************************************************************************/
/* VSAM_REC                                                             */
/* An array of this struct is used to locate all records in all         */
/* available buffers. This array is pointed to from a xxx_FILEINFO      */
/* struct which also gives the no of elements (nrecs).                  */
/* Note: this is the same as QSAM_REC and could be rationalised - zzzjb */
/************************************************************************/
struct VSAM_REC {
  int address;                  /* logical address of record or segment */
  short length;                          /* length of record or segment */
  short recn;                       /* record sequence number -n..0..+n */
  short segn;                      /* segment sequence number -n..0..+n */
  char sdw_c;           /* segment position indicator if spanned record */
};
 
/************************************************************************/
/* OPEN_FILEINFO                                                        */
/* This is abstracted from COBOL_FILEINFO and PLI_FILEINFO structs to   */
/* provide a common language-independent version. Its primary purpose   */
/* is to collect QSAM and VSAM info for non-event related open files    */
/* (see IDICOF : AddOpenFileKeydata). The common area allows            */
/* COBOL and PLI structs to be re-cast and updated by functions in      */
/* IDICOF.                                                              */
/************************************************************************/
struct OPEN_FILEINFO {
  /***                 start of common area                                ***/
  char ddname[9];            /* DD name                                      */
  char *dsname;              /* Blank-delimited dataset names                */
  int  status;               /* File status (not used)                       */
  char *reason;              /* File status reason (not used)                */
  int  RetCode;              /* VSAM Return Code                             */
  int  FuncCode;             /* VSAM Function Code                           */
  int  FeedBack;             /* VSAM Feedback Code                           */
  char func[9];              /* Function  (open, close, etc.)                */
  char  open;                /* File is open                                 */
  int   recl;                /* Record length for data set                   */
  short blksize;             /* Block size                                   */
  short keyl;                /* Key length                                   */
  short keyloc;              /* KEYLOC (VSAM)                                */
  short primkeyl;            /* Primary key length (VSAM)                    */
  short primkeyloc;          /* Primary KEYLOC (VSAM)                        */
  char  *dsbase;             /* Base (primary key) dataset name (VSAM)       */
  short reserved3;           /* Reserved (xxx_FILEINFO compatibility)        */
  int   ncp    :8;           /* Channel programs                             */
  int   bufno  :8;           /* Number of buffers                            */
  int   smsi   :8;           /* Index area                                   */
  int   bufof  :8;           /* ASCII buffer offset                          */
  void *currkey;             /* VSAM: key of current record                  */
  void *currrec;             /* VSAM: current record                         */
  int   currrecl;            /* VSAM: current record length                  */
  int   currpos;             /* VSAM: SLOT(RRDS) or RBA(ESDS)                */
  void *recs;                /* Pointer to QSAM/VSAM_REC array               */
  int   nrecs;               /* No of elements in recs                       */
  char  itype;               /* Info type (8=CICS, 9=DEB)                    */
  int   bof      : 1,        /* At beginning-of-file                         */
        eof      : 1,        /* At end-of-file                               */
        output   : 1,        /* Open for output                              */
        fixed    : 1,        /* Record format is fixed                       */
        prevwrap : 1,        /* Previous record n/a (buffer wrap-around)     */
        nextwrap : 1,        /* Next record n/a (buffer wrap-around)         */
        currnoba : 1,        /* Put locate r1 area consumed -- no current    */
                             /*  record build area, r1 is previous recotd    */
        path     : 1,        /* This file is a VSAM AIX PATH                 */
        noactplh : 1,        /* No active placeholder (VSAM)                 */
        norpl    : 1,        /* No valid RPL (VSAM)                          */
        nobuff   : 1,        /* No buffers (QSAM) or control interval (VSAM) */
        noiomod  : 1,        /* MVS I/O module not supported (QSAM/BSAM)     */
        asciivar : 1,        /* File is ASCII variable length (not supported)*/
        iopend   : 1,        /* I/O not complete (BSAM)                      */
                 : 2;        /* Spare                                        */
  /***                  end of common area                                 ***/
  struct {                   /* File organisation                            */
    unsigned int   _finf_iorgseq   : 1, /* Sequential                        */
                   _finf_iorgind   : 1, /* Indexed                           */
                   _finf_iorgrel   : 1, /* Relative                          */
                   _finf_iorgvsam  : 1, /* VSAM                              */
                   _finf_iorgolds  : 1, /* Old sequential file code = S      */
                   _finf_iorgiam   : 1, /* IAM                               */
                   _finf_spare     : 2; /* Spare                             */
  } _finf_org;
  struct {                   /* File access mode                             */
    unsigned int   _finf_iaccseq   : 1, /* Sequential                        */
                   _finf_iaccran   : 1, /* Random                            */
                   _finf_iaccdyn   : 1, /* Dynamic                           */
                   _finf_iaccbsam  : 1, /* BSAM                              */
                   _finf_spare     : 4; /* Spare                             */
  } _finf_acc;
  struct {                   /* File recording mode                          */
    unsigned int   _finf_irecf     : 1, /* Fixed                             */
                   _finf_irecv     : 1, /* Variable                          */
                   _finf_irecasci  : 1, /* track overflow or ASCII var length*/
                   _finf_irecbr    : 1, /* Blocked                           */
                   _finf_irecsb    : 1, /* For fixed length record format -  */
                                        /* standard blocks.                  */
                                        /* For variable length record fmt -  */
                                        /* spanned records.                  */
                   _finf_irecca    : 1, /* ASA control characters            */
                   _finf_ireccm    : 1, /* Machine control characters        */
                   _finf_ireckl    : 1; /* Key length specified in DCB       */
  } _finf_rcf;
  struct {                   /* Open verbs                                   */
    unsigned int   _finf_iverbinp  : 1, /* Input                             */
                   _finf_iverbout  : 1, /* Output                            */
                   _finf_iverbio   : 1, /* I-O                               */
                   _finf_iverbext  : 1, /* Extend                            */
                   _finf_iverbrev  : 1, /* Reversed                          */
                   _finf_iverbnrw  : 1, /* No rewind                         */
                   _finf_iverbcls  : 1, /* Close                             */
                   _finf_iverbrel  : 1; /* REEL/UNIT                         */
  } _finf_vrb;
};
 
#define finf_iorgseq        _finf_org._finf_iorgseq
#define finf_iorgind        _finf_org._finf_iorgind
#define finf_iorgrel        _finf_org._finf_iorgrel
#define finf_iorgvsam       _finf_org._finf_iorgvsam
#define finf_iorgiam        _finf_org._finf_iorgiam
#define finf_iorgolds       _finf_org._finf_iorgolds
#define finf_iaccseq        _finf_acc._finf_iaccseq
#define finf_iaccran        _finf_acc._finf_iaccran
#define finf_iaccdyn        _finf_acc._finf_iaccdyn
#define finf_iaccbsam       _finf_acc._finf_iaccbsam
#define finf_irecf          _finf_rcf._finf_irecf
#define finf_irecv          _finf_rcf._finf_irecv
#define finf_irecasci       _finf_rcf._finf_irecasci
#define finf_irecbr         _finf_rcf._finf_irecbr
#define finf_irecsb         _finf_rcf._finf_irecsb
#define finf_irecca         _finf_rcf._finf_irecca
#define finf_ireccm         _finf_rcf._finf_ireccm
#define finf_ireckl         _finf_rcf._finf_ireckl
#define finf_iverbinp       _finf_vrb._finf_iverbinp
#define finf_iverbout       _finf_vrb._finf_iverbout
#define finf_iverbio        _finf_vrb._finf_iverbio
#define finf_iverbext       _finf_vrb._finf_iverbext
#define finf_iverbrev       _finf_vrb._finf_iverbrev
#define finf_iverbnrw       _finf_vrb._finf_iverbnrw
#define finf_iverbcls       _finf_vrb._finf_iverbcls
#define finf_iverbrel       _finf_vrb._finf_iverbrel
 
struct HIST_CACHE_CTL;
typedef struct HIST_CACHE_CTL HIST_CACHE_CTL;
struct HD_AREA;
typedef struct HD_AREA HD_AREA;
 
/*****************************************************************************/
/*  In order to try and keep CPU I/O nd elapsed time required to work        */
/*  with the history file to a minimum, the use of and timing of the         */
/*  hist_cache_ctl data has become very complex.  We are trying to           */
/*  minimize all history file access for $$INDEX, in case it will be IDIS    */
/*  subsystem managed, however we must check the appropriate security        */
/*  read/write access in the local system before calling the subsystem       */
/*  so that we get the local users access intent.  We progressively build    */
/*  up the data in hist_cache_ctl depending on the final amount of work      */
/*  that happens in the abending address space as opposed to the             */
/*  subsystem.  This has again now been complicated by the realization       */
/*  that correct racroute request=auth checking will not happen unless       */
/*  we provide the volser of the DSN, if a discrete profile has been         */
/*  used.  The need to supply the volser means even for a subsystem          */
/*  cached $$INDEX we have to do a dynalloc to pull the volser in the        */
/*  abending asid.                                                           */
/*  The typical build up of data in the hist_cache_ctl for a new DSN is      */
/*  the dirDD and volser which is required for the racheck, then if          */
/*  there is a successful subsystem call the IDISrc and isPDSErc is set      */
/*  and also the cache data if subsystem handled the call. Else if it        */
/*  was not subsystem managed the indexDD allocation, fopen() for dsorg      */
/*  information and appropriate szENQ string is built.  For each of          */
/*  these staged changes a separate DSN is kept to see if there has been     */
/*  a DSN change since the last processing of the same data, otherwise       */
/*  the prior data can be used.  This is a lot of messy logic to keep        */
/*  opens and dynalloc's on the history file to a minimum.                   */
/*****************************************************************************/
 
struct HIST_CACHE_CTL {
  char          *dsn;        /* history file   data set name. May be - data set names which */
                             /* are blank-delimited and the string is null terminated when DDirHdCacheIndex set */
  DDIR_DATA_HD **HDcacheP;   /* Address of HD segment pointer array */
  int            HDcacheNum; /* Number of elements in HDcache pointer array */
  int            HDcacheMax; /* size of HDcache pointer array in elements */
  DDIR_DATA_HI  *pHI;        /* Address of HI segment element */
  HD_AREA       *HDa;        /* Pointer to the HD segmant storage management area */
  int            Req_refresh:1,        /* updateINDEX request control, normally 0. 1=refresh(merge directory) */
                 Req_ssGetCacheOnly:1, /* The updateINDEX call is for SubSystem GetCache, otherwise return SS rc. */
                 Req_ssGetChBestAvl:1, /* The updateINDEX call is from GetCacheBestAvailable */
                 Req_resv:29;          /* reserved for future use */
 
  char           SSsetDSN[45];/*the DSN set previously for SubSystem rc, dirDD and volser, +RACF acc. */
  char           dirDD[9];   /* DD allocated for directory/fileinfo read */
  char           volser[7];  /* dsn volser needed for RACF descrete profiles */
  char           resv3[3];   /* allignment padding */
  int            IDISrc;     /* prior return code (if any) from IDIS subsystem for this hcc->dsn. */
  int            DSNacc;     /* RACF_ATTR return code from ChkIndexAccess() */
  int            dynRC;      /* dynalloc error code, x'1708' = no data set. */
 
  char           setDSN[45]; /* the DSN set previously for ENQ and isIndexPDSE return code results. */
  char           szENQ[53];  /* SPFEDIT ENQ minor string. DSN for PDS, DSN-MEMBER for PDSE. */
  char           indexDD[9]; /* DD allocated for $$INDEX read/write */
  char           resv1[1];   /* allignment padding */
  int            isPDSErc;   /* prior return code (if any) from isIndexPDSE for this hcc->dsn. */
  int            isENQued:1, /* already SPFEDIT ENQued flag */
                 isIENQued:1;/* already IDIINDEX phase 1 ENQued flag */
  FILE          *dirfp;      /* for directory/fileinfo read */
  FILE          *fp;         /* for member read, including $$INDEX */
};
HIST_CACHE_CTL hist_cache_ctl;
 
struct HD_AREA {
  int            original;   /* Original HDa address base for HDcacheP pointers */
  int            nexta;      /* next address free */
  int            lasta;      /* last address free (actually last +1) */
  int            lost;       /* bytes lost due to DHrealloc() calls */
  char           data[1];    /* start of HD segment data, continues to lasta-1 */
};
 
/******************************************************************************/
/*|:h4.HDrealloc()                                                            */
/*$$doclink-IDICUSUB.C-|:h4.HDrealloc()-                                      */
/*|:xmp.*/
int HDrealloc( HIST_CACHE_CTL *hcc, DDIR_DATA_HD *pHD, int newsize, char *file, int line) ;
/*|:exmp.*/
#define HDrealloc( hcc, pHD, newsize) \
        HDrealloc( hcc, pHD, newsize, __FILE__,__LINE__)
 
/*********************************************************************/
/*|:h4.addDss()                                                      */
/*$$doclink-IDICUSUB.C-|:h4.addDss()-                                */
/*********************************************************************/
/*|:xmp.*/
DDIR_DATA_HD *addDss(HIST_CACHE_CTL *hcc, DDIR_DATA_HD *pHDt, DSUBSEG *pDss, char *file, int line) ;
/*|:exmp.*/
 
/******************************************************************************/
/*|:h4.GetView()                                                              */
/*|:p.GetView() reads the history file cache for a list of history DSN's.     */
/*|                                                                           */
/*|:dl break=fit.                                                             */
/*|:dt.hcc->dsn :dd.Pointer to a blank-delimited null-terminated list of      */
/*|             history file data set names to be cached under the one        */
/*|             hist_cache_ctl structure.                                     */
/*|:dt.hcc->pHI :dd.Returns a pointer to an array of HI segments, one per     */
/*|             history file data set read from $$INDEX at the same time      */
/*|             as the cached HD segments for that history file data set.     */
/*|             The elements in this array are indexed by DDirHdCacheIndex    */
/*|             into the dsn.  Other hcc elements are as normal.              */
/*|:edl.                                                                      */
/*|:p.                                                                        */
/*|For each DSN in the DSN list, call GetCache saving                         */
/*|the HI segment into the HI array and the HD segments into the HDcacheP     */
/*|setting their DDirHdCacheIndex to the DSN index they were read from.       */
/******************************************************************************/
/*|:xmp.*/
char *GetView(HIST_CACHE_CTL *hcc, char *file, int line) ;
/*|:exmp.*/
 
/******************************************************************************/
/*|:h4.GetCache()                                                             */
/*|:p.GetCache() reads the history file cache.                                */
/*|                                                                           */
/*|hcc          Pointer to a HIST_CACHE_CTL structure in which hcc->dsn       */
/*|             is pointing to null terminated histDSN.                       */
/*|                                                                           */
/*|:xmp.*/
int GetCache(HIST_CACHE_CTL *hcc, char *file, int line);
/*|:exmp.*/
 
/******************************************************************************/
/*|:h4.GetCacheBestAvailable()                                                */
/*|:p.GetCacheBestAvailable() reads the history file cache, most recent copy  */
/*|if $$INDEX ENQ not available.                                              */
/*|hcc          Pointer to a HIST_CACHE_CTL structure in which hcc->dsn       */
/*|             is pointing to null terminated histDSN.                       */
/*|                                                                           */
/*|:xmp.*/
int GetCacheBestAvailable(HIST_CACHE_CTL *hcc, char *file, int line);
/*|:exmp.*/
 
/******************************************************************************/
/*|:h4.RefreshCache()                                                         */
/*|:p.RefreshCache() reads the history file cache, does a merge of the PDS(E) */
/*|directory to insure any deleted/added members are discovered and the       */
/*|cache updated accordingly.                                                 */
/*|                                                                           */
/*|hcc          Pointer to a HIST_CACHE_CTL structure in which hcc->dsn       */
/*|             is pointing to null terminated histDSN.                       */
/*|                                                                           */
/*|:xmp.*/
int RefreshCache(HIST_CACHE_CTL *hcc, char *file, int line);
/*|:exmp.*/
 
/*********************************************************************/
/*|:h4.UpdateINDEX()                                                 */
/*$$doclink-IDICUSUB.C-|:h4.updateINDEX()-                           */
/*********************************************************************/
/*|:xmp.*/
int updateINDEX(HIST_CACHE_CTL *hcc, DDIR_DATA_HD *pHD, char *LocSFNDBuffer, char *file, int line);
/*|:exmp.*/
 
/*********************************************************************/
/*|:h4.ChkIndexAccess()                                              */
/*$$doclink-IDICUSUB.C-|:h4.ChkIndexAccess()-                        */
/*********************************************************************/
/*|:xmp.*/
int ChkIndexAccess(HIST_CACHE_CTL *hcc, char *file, int line);
/*|:exmp.*/
 
/*********************************************************************/
/*|:h4.ISIDIS()                                                      */
/*|:P.ISIDISS loads IDISASUB from a week external reference to       */
/*|determine if the environment is the IDIS Subsystem.               */
/*|:xmp.*/
int ISIDISS( void);
/*|:exmp.*/
 
/*|:h4.AddCache()                                                             */
/*|:p.AddCache()                                                              */
/*|Called with a pointer to a HD segment to be added to the current           */
/*|GetCache() array, this function returns the HDcacheP
Y index to the cache entry for success. */
/*|It will fail if the current GetCache array contains more than one          */
/*|DSNlist FAULT history data set name.                                       */
/*|:xmp.*/
int AddCache( HIST_CACHE_CTL *hcc, DDIR_DATA_HD *pHD) ;
/*|:exmp.*/
 
/*|:h4.ConvertHD()                                                   */
/*|:p.ConvertHD()                                                    */
/*|Convert older HD segments to the current level                    */
/*|Note: The conversion is done in place so it is assumed the data   */
/*|area following the HD segment is free and able to accomodate      */
/*|the extension (just a bit over 256 bytes for the level 2).        */
/*|:xmp.*/
void ConvertHD( DDIR_DATA_HD *pHD) ; /* convert older HD segments to the current level */
/*|:exmp.*/
 
/*|:h4.AddOpenFileKeydata()                                          */
/*|:p.AddOpenFileKeydata() sets up the key entries for any open      */
/*|files.                                                            */
/*|:xmp.*/
void AddOpenFileKeydata(void);
/*|:exmp.*/
 
/*|:h4.FindQSAMRecords                                                        */
/*|:p.FindQSAMRecords attempts to find the current, previous and next         */
/*|records in an open QSAM file.                                              */
/*|:xmp.*/
void FindQSAMRecords(DCB *mDCB, OPEN_FILEINFO *finfo);
/*|:exmp.*/
 
/*|:h4.FindVSAMRecords()                                                      */
/*|:p.FindVSAMrecords() attempts to find records in an open VSAM file.        */
/*|:xmp.*/
int FindVSAMRecords(ACB *mACB, OPEN_FILEINFO *finfo);
/*|:exmp.*/
 
/*|:h4.GetDSN                                                                 */
/*|:p.This external function returns a blank-delimited string of DSNs for a   */
/*|given TCB and ddname. It provides similar function to GetAllocDS() which   */
/*|operates in real-time only.                                                */
/*|:xmp.*/
char *GetDSN(int pTCB, char *ddname, int *flags);
/*|:exmp.*/
 
/*|:h4.GetDDName                                                              */
/*|:p.This external function returns a pointer to a ddname in the TIOT. It    */
/*|is passed a TCB address and TIOT offset.                                   */
/*|:xmp.*/
char *GetDDName(int pTCB, short offset);
/*|:exmp.*/
 
/*|:h4.KeySave()                                                              */
/*|p.KeySave() saves selected key data as history file 'KD' segments.         */
/*|:xmp.*/
void KeySave(void);
/*|:exmp.*/
 
/* Macro to force abend S0C4 for recovery testing purposes.
   The psz argument is compared with the current ZZTEST option
   setting, and if matching, then a S0C4 abend is forced. */
#define ZZS0C4(psz) {                                                    \
  int *iptr = 0;                                                         \
                                                                         \
  if (strncmp(opts.zztest, psz, sizeof(opts.zztest) - 1) == 0) {         \
    dprintf("ZZTEST(%s) matched - abend S0C4...\n", psz);                \
    *iptr = 0;  /* Abend S0C4 */                                         \
  }                                                                      \
}
 
/************************************************************************/
/* Macro to get null-terminated ddname string into DDNAME               */
/************************************************************************/
#define GET_DDNAME(OPEN, TCB, TIOT, DDNAM, DDNAME) { \
  char *blank; \
  int i; \
  if (OPEN) { \
    char *dd = GetDDName(TCB, TIOT); \
    if (dd) \
      memcpy(DDNAME, dd, 8); \
    else \
      *DDNAME = 0; \
  } \
  else \
    memcpy(DDNAME, DDNAM, 8); \
  DDNAME[8] = 0; \
  if ((blank = strchr(DDNAME, ' ')) != 0) \
    *blank = 0; \
  for (i = 0; i < strlen(DDNAME); i++) { \
    if (!isprint(DDNAME[i])) \
      DDNAME[i] = '.'; \
  } \
}
 
/************************************************************************/
/* Forward declarations used in SPC and in C go here and in IDICHSPC.H  */
/************************************************************************/
struct HISTBUFINFO ;
typedef struct HISTBUFINFO HISTBUFINFO;
 
/******************************************************************************/
/*   API Function and Structure Definitions                                   */
/******************************************************************************/
/*|:h4.FmtJulianDate()                                                        */
/*|:p.FmtJulianDate() is used to convert a Julian date in character           */
/*|format (YYYYDDD), which need not be null-terminated, to a TIMESTAMP        */
/*|structure.                                                                 */
/*|:xmp.*/
void FmtJulianDate(char *pJD, struct TIMESTAMP *pTS);
/*|:exmp.*/
 
/*|:h4.tm_date_locale()                                             */
/*|:p.tm_date_locale() is used to convert a tm struct (as defined in */
/*|time.h) value to a date in the current locale format.  The date   */
/*|is placed in datebuf, which must be a storage area of at least 11 */
/*|bytes, as a null-terminated string.                               */
/*|:xmp.                                                             */
/* Note: Typecasting of tm to (struct tm *) needed to avoid having to include time.h in all C parts */
char *tm_date_locale(void *tm, char *datebuf);
/*|:exmp.                                                            */
 
/*|:h4.tm_time_locale()                                             */
/*|:p.tm_time_locale() is used to convert a tm struct (as defined in */
/*|time.h) value to a time in the current locale format.  The time   */
/*|is placed in timebuf, which must be a storage area of at least 12 */
/*|bytes, as a null-terminated string.                               */
/*|:xmp.                                                             */
/* Note: Typecasting of tm to (struct tm *) needed to avoid having to include time.h in all C parts */
char *tm_time_locale(void *tm, char *timebuf);
/*|:exmp.                                                            */
 
/*|:h4.tod_tm()                                                      */
/*|:p.Convert TOD clock value to tm struct.                          */
/* Note: Typecasting of tm to (struct tm *) needed to avoid having to include time.h in all C parts */
/*|:xmp.                                                             */
int tod_tm(void *todval, void *tm);
/*|:exmp.                                                            */
 
/*|:h4.tod_date_locale()                                             */
/*|:p.tod_date_locale() is used to convert a TOD clock value to a    */
/*|date in the current locale format.  The date is placed in         */
/*|datebuf, which must be a storage area of at least 11 bytes, as a  */
/*|null-terminated string.                                           */
/*|:xmp.                                                             */
char *tod_date_locale(void *todval, char *datebuf);
/*|:exmp.                                                            */
 
/*|:h4.tod_time_locale()                                             */
/*|:p.tod_time_locale() is used to convert a TOD clock value to a    */
/*|time in the current locale format.  The time is placed in         */
/*|timebuf, which must be a storage area of at least 12 bytes, as a  */
/*|null-terminated string.                                           */
/*|:xmp.                                                             */
char *tod_time_locale(void *todval, char *timebuf);
/*|:exmp.                                                            */
 
/*|:h4.tod_date()                                                             */
/*|:p.tod_date() is used to convert a TOD clock value to a date in the        */
/*|format DD/MM/YYYY.  The date is placed in datebuf, which must be a storage */
/*|area of at least 11 bytes, as a null-terminated string.                    */
/*|:xmp.*/
char *tod_date(void *todval, char *datebuf);
/*|:exmp.*/
 
/*|:h4.tod_time()                                                             */
/*|:p.tod_time() is used to convert a TOD clock value to a time in the        */
/*|format HH:MM:SS.  The time is placed in timebuf, which must be a storage   */
/*|area of at least 9 bytes, as a null-terminated string.                     */
/*|:xmp.*/
char *tod_time(void *todval, char *timebuf);
/*|:exmp.*/
 
/*|:h4.tod_full()                                                             */
/*|:p.tod_full() is used to convert a TOD clock value to a time the full      */
/*|precision of the STCKCONV macro which is microseconds.                     */
/*|The formatted time is placed in timebuf which must be at least 16 bytes.   */
/*|The string is null-terminated.                                             */
/*|:xmp.*/
char *tod_full(void *todval, char *timebuf);
/*|:exmp.*/
 
/*|:h4.idi_error()                                                            */
/*|:p.idi_error() is used to signal that an internal problem has occurred     */
/*|which is likely to cause missing or incorrect analysis results.            */
/*|When this function is called, a key item named IDI_ERROR is                */
/*|created, containing the passed text.  The existence of this key            */
/*|name will cause a warning to be written to the analysis report.            */
/*|If ZZDEBUG is in effect, a dprintf is written.                             */
/*|If ZZDEV is in effect, the IDI_ERROR key items are listed at the           */
/*|top of the analysis report.                                                */
/*|To use this function, call it via the upper-cased macro name               */
/*|IDI_ERROR.                                                                 */
/*|:xmp.*/
void idi_error(int severity, char *fmt, ...);
/*|:exmp.*/
 
/*|:h4.IsRealTime()                                                           */
/*|:p.IsRealTime() is used to test if we are executing in the real-time       */
/*|mode.                                                                      */
/*|Returns 1 if executing in real-time mode, otherwise returns 0.             */
/*|:xmp.*/
#pragma map(IsRealTime,"ISREALTI")
int IsRealTime(void);
/*|:exmp.*/
 
/*|:h4.IsMVSDumpAnalysis()                                                    */
/*|:p.IsMVSDumpAnalysis() is used to test if we are analyzing an MVS dump     */
/*|data set without a history file entry.                                     */
/*|Returns 1 if yes, otherwise 0.                                             */
/*|:xmp.*/
int IsMVSDumpAnalysis(void);
/*|:exmp.*/
 
/*|:h4.IsSPC()                                                                */
/*|:p.IsSPC() is used to test if we are running in a system                   */
/*|programmer C environment or not.                                           */
/*|:xmp.*/
#pragma map(IsSPC,"ISSPC")
int IsSPC(void);
/*|:exmp.*/
 
/*|:h4.LangInstall()                                                          */
/*|:p.LangInstall() installs an NLS message file.                                */
/*|:xmp.*/
void LangInstall(char *langid);
/*|:exmp.*/
 
/*|:h4.OptsPtr()                                                              */
/*|:p.OptsPtr() returns the address of the opts structure in the common area.    */
/*|:xmp.*/
#pragma map(OptsPtr,"OPTSPTR")
OPTS *OptsPtr(void);
/*|:exmp.*/
 
/*|:h4.ModLoad()                                                              */
/*|:p.ModLoad() is used to load a module into storage.                           */
/*|:xmp.*/
void *ModLoad(char *name);
/*|:exmp.*/
 
/*|:h4.cConfigOpts()                                                          */
/*|:p.cConfigOpts() is used to process the parmlib configuration member.         */
/*|If a load module IDICNFUM is found in the standard MVS search              */
/*|path, it may contain the name of a data set and member that will           */
/*|replace the default parmlib configuration.                                 */
/*|If a data set name has been provided in CSECT IDICNFDS, use it             */
/*|when searching for the IDICNF00 config member.  Otherwise, the             */
/*|logical parmlib concatenation is searched.                                 */
/*|If the DDT pointer is NULL, a DDT may be allocated.  It is the caller's    */
/*|responsibility to free this DDT using DDT_free().                          */
/*|:xmp.*/
void cConfigOpts(DDT **pDDT);
/*|:exmp.*/
 
/*|:h4.DDT_free()                                                             */
/*|:p.DDT_free() is used to free a DDT.                                          */
/*|:xmp.*/
void DDT_free(DDT **pDDT);
/*|:exmp.*/
 
/*|:h4.DDT_add()                                                             */
/*|:p.DDT_add is used to add an entry to a DDT.                                  */
/*|:xmp.*/
void DDT_add(DDT **pDDT, char *ddname, char *dsnlist);
/*|:exmp.*/
 
/*|:h4.GetAllocDS()                                                           */
/*|:p.GetAllocDS() is used to get list of data sets allocated to a DDname.       */
/*|It is the caller's responsibility to free the string containing            */
/*|blank-delimited data set names returned.                                   */
/*|Note: This function is called from assembler as GETALLOC.                  */
/*|:xmp.*/
#pragma map(GetAllocDS,"GETALLOC")
char *GetAllocDS(char *szdd);
/*|:exmp.*/
 
/*|:h4.cOptDefaults()                                                        */
/*|:p.cOptDefaults() is used to set options defaults.                            */
/*|:xmp.*/
void cOptDefaults(void);
/*|:exmp.*/
 
/*|:h4.GetDSList()                                                           */
/*|:p.GetDSList() returns a blank-delimited string of data set names for a       */
/*|specified DDname.  The data sets were either pre-allocated or specified    */
/*|via the DATASETS option.                                                   */
/*|:xmp.*/
char *GetDSList(char *ddname);
/*|:exmp.*/
 
/*|:h4.testDSNisPDS()                                                        */
/*|:p.testDSNisPDS() returns 0 if the DSN is a PDS or PDS/E,                    */
/*|returns 1 for a VSAM data set and 2 for any nonVSAM non PDS/PDSE dataset,  */
/*|and -1 if the data set could not be opened.                                */
/*|:xmp.*/
int testDSNisPDS(char *DSN);
/*|:exmp.*/
 
/*|:h4.isHistPDSE()                                                  */
/*|:p.Passed HistDSN, member (may be null), __FILE,__LINE__.         */
/*|:p.Returns 0 not a return, it indicates the code is not yet set.  */
/*|           1 for PDSE                                             */
/*|           2 for PDS                                              */
/*|           3 for VSAM                                             */
/*|           9 for NOT PDS or PDSE or VSAM, but did open OK         */
/*|          -1 for open failed                                      */
/*|:xmp.*/
int isHistPDSE(char *histdsn, char *member, char *file, int line);
/*|:exmp.*/
 
/*|:h4.PrtTrace()                                                            */
/*|:p.PrtTrace()                                                                 */
/*|Write null-terminated string to IDITRACE.                                  */
/*|:xmp.*/
void PrtTrace(int indent, char *psz);
#pragma map(PrtTrace, "PRTTRACE")
/*|:exmp.*/
 
/*|:h4.ConvertNonPrint()                                                     */
/*|:p.ConvertNonPrint()                                                          */
/*|Convert non-printable characters to periods.                               */
/*|Exclude DBCS characters from conversion if dbcsflag is non-zero.           */
/*|:xmp.*/
void ConvertNonPrint(char *pText, int len, int dbcsflag);
/*|:exmp.*/
 
/*|:h4.COMITSEG()                                                            */
/*|:p.COMITSEG() returns pointer to the next segment build area and commits the  */
/*|current segment to the buffer.                                             */
/*|:xmp.*/
DDIR_SHDR *COMITSEG( HISTBUFINFO* ) ;
/*|:exmp.*/
 
/*|:h4.RDPDSDIR()                                                             */
/*|:p.RDPDSDIR() returns a malloc'ed array containing all of the              */
/*|membernames from the PDS/PDSE named in the input string.                   */
/*|The array is 9 bytes per entry null terminated and trailing blanks null.   */
/*|The last entry in the array is a null.                                     */
/*|The returned pointer is x'00000000' if the DSN is not a PDS/PDSE.          */
/*|It is the caller's responsibility to free the returned pointer.            */
/*|:xmp.*/
char *RDPDSDIR(char *DSN);
/*|:exmp.*/
 
/*|:h4.isMbrInPDS()                                                           */
/*|:p.isMbrInPDS() uses the cached cRDPDSDIR to determin is member name       */
/*|is in a PDS or the DSN is not even a PDS data set, or could not be opened. */
/*|The returned pointer is -1 if the DSN could not be opened (or error).      */
/*|The returned pointer is x'00000000' if the DSN is not a PDS/PDSE.          */
/*|The returned pointer points to a null if the member was not in the PDS or  */
/*|it points to the member name if found in the PDS.                          */
char *isMbrInPDS(char *mbr, char *DSN) ;
 
/*|:h4.check_exittype()                                                      */
/*|:p.check_exittype() checks if an exit has been specified for the              */
/*|requested type.                                                            */
/*|:xmp.*/
int check_exittype(char *exittype);
/*|:exmp.*/
 
/*|:h4.end_init()                                                            */
/*|:p.env_init() initializes the exit environment info.                          */
/*|:xmp.*/
void env_init(DDIR_DATA_HD *pHD);
/*|:exmp.*/
 
/*|:h4.getTODks()                                                            */
/*|:p.getTODks called to return the Time Of Day in K's (1024) of a     */
/*|second.                                                          */
/*|:xmp.*/
int getTODks(void) ;
/*|:exmp.*/
 
/*|:h4.prtTODelapsed()                                                       */
/*|:p.prtTODelapsed() takes CICS TOD elapsed double words and formats */
/*|to hh:mm:ss.sss format                                           */
/*|:xmp.*/
void prtTODelapsed(unsigned*, char*) ;
/*|:exmp.*/
 
/*|:h4.dumpSTKsz()                                                       */
/*|:p.dumpSTKsz() Revamp of DBGHEAP.H DumpStk():                                     */
/*|Perform a trace back of the stack frames and retun trace data, normal              */
/*|execution is resumed.  Pass an input buffer of at least 512 bytes for the output.  */
/*|Hide is normally 0.  Returns pointer to the buffer passed.                         */
/*|:xmp.*/
char *dumpSTKsz( char *sz, int hide) ;
/*|:exmp.*/
 
/*|:h4.LibDefPush()                                                      */
/*|:p.LibDefPush()                                                                    */
/*|This function is used to set up the correct ISPF message, panel,                   */
/*|and skeleton libraries depending on the LANGUAGE option in                         */
/*|effect.                                                                            */
/*|:xmp.*/
void LibDefPush(char *LangID);
/*|:exmp.*/
 
/*|:h4.LibDefPop()                                                      */
/*|:p.LibDefPop()                                                                     */
/*|This function is used to reinstate the previous ISPF libraries.                    */
/*|:xmp.*/
void LibDefPop(void);
/*|:exmp.*/
 
/*|:h4.WTOPRTF()                                                      */
/*|:p.WTOPRTF() WTO version of printf.                                                */
/*|:xmp.*/
int WTOPRTF(char *formatstr, ...);  /* need upper case because of longname support ..Rod*/
/*|:exmp.*/
 
/*|:h4.CHKDSNAC()                                                     */
/*|:p.CHKDSNAC() Check for READ access to a non-VSAM data set                 */
/*|Returns the SAF return code in R15 and RACF return and reason code in      */
/*|racf_rc and racf_reason respectively. Volser not required.                 */
/*|:xmp.*/
int CHKDSNAC(char *dsn, int *racf_rc, int *racf_reason);
/*|:exmp.*/
 
/*|:h4.cOptInit_ZZRT()                                               */
/*|:p.Moves the PARM= data into optbuf and looks for ZZRT parm.      */
/*|If ZZRT is found opts.realtime and opts.pHistBufInfo are set.     */
/*|:xmp.*/
void cOptInit_ZZRT(int argc, char *argv[]);
/*|:exmp.*/
 
/*|:h4.ISIDIZZD                                                      */
/*|:p.ISIDIZZD returns zero if //IDIZZDBG is present.                */
/*|:xmp.*/
int ISIDIZZD(void);
/*|:exmp.*/
 
/*|:h4.cOptions()                                                    */
/*|:p.cOptions is used to process options passed via parmlib config  */
/*|member, user options file, and JCL EXEC card parm field, and set  */
/*|appropriate values and flags in the opts structure.               */
/*|:p.The abendMsg parm is a message number to be used in case an    */
/*|abend is encountered during options processing in real-time.  As  */
/*|well as identifying the message number, this parm also indicates  */
/*|real-time processing and will cause options processing to be      */
/*|performed through the CPROTECT ESTAE routine.                     */
/*|:xmp.*/
int cOptions( char *abendMsg);
/*|:exmp.*/
 
/*|:h4.CPROTECT()                                                    */
/*|:p.Invokes C function with ESTAE protection.                      */
/*|:p.The address of the C function is in funcptr and the arguments  */
/*|for it are pointed to by parmptr.  The return value from the      */
/*|called function is passed back to the caller of CPROTECT.         */
/*|:xmp.                                                             */
int CPROTECT(int funcptr, int parmptr, int *abendword);
/*|:exmp.                                                            */
/*|:p.CPROTECT returns an abend word if the called function abended  */
/*|(system abend code in bits 8-19, user abend code in bits 20-31),  */
/*|otherwise abendword is set to 0.                                  */
 
/*|:h4.AddPeriod()                                                   */
/*|:p.Adds an NLS-sensitive period to the end of a string.           */
/*|:xmp.                                                             */
void AddPeriod(char *pszText);
/*|:exmp.                                                            */
 
/*|:h4.HDcompare()                                                   */
/*|:p.                                                               */
/*|:p.Logically compare a fault entry HD segment with a cache HD     */
/*|segment.                                                          */
/*|:xmp.*/
int HDcompare(DDIR_DATA_HD *pHDfault, DDIR_DATA_HD *pHDcache);
/*|:exmp.*/
 
#pragma linkage(IDIGETVA,OS)
int IDIGETVA(void);
#pragma linkage(IDIGETVB,OS)
int IDIGETVB(void);
int VSMFREE(int response[4]);
#pragma linkage(SETSTIMR,OS)
int SETSTIMR(HISTBUFINFO *pHistBufInfo, int initMS);
#pragma linkage(MONSTIMR,OS)
int MONSTIMR(HISTBUFINFO *pHistBufInfo, int mon_event);
#pragma linkage(CSVQRYEP,OS)
int CSVQRYEP(char *pLmodName);
#pragma linkage(CSVQRYLP,OS)
int CSVQRYLP(char *pLmodName);
 
/*|:p.                                                                        */
/*|The following common area is only for static style data.                   */
/*|It is used between all components.                                         */
/*|:xmp.*/
 
/* The following common area is only for static style data. */
/* Do not use for dynamic inter-process communication;      */
/* instead pass all arguments in parameter lists.           */
/* Initialization of these pointers serves as init switch.  */
CCOMMON  *pCcom ;      /* pointer to common for C (Control) */
DCOMMON  *pDcom ;      /* pointer to common for D (Dump Management) */
ECOMMON  *pEcom ;      /* pointer to common for E (inference Engine) */
HCOMMON  *pHcom ;      /* pointer to common for H (Help and message) */
ICOMMON  *pIcom ;      /* pointer to common for I (dump dIctionary) */
KCOMMON  *pKcom ;      /* pointer to common for K (Key information) */
PCOMMON  *pPcom ;      /* pointer to common for P (Presentation management) */
VCOMMON  *pVcom ;      /* pointer to common for V (program source View) */
XCOMMON  *pXcom ;      /* pointer to common for X (dump capture eXits) */
 
/* The value passed in the REALTIME option is the address of a HISTBUFINFO  structure */
struct CATBUF {
  int CatBufAddr;    /* Address of catalog buffer */
  int CatBufLen;     /* Length of catalog record buffer */
};
 
/* IDI message information structure */
/* IDICH.H $$SYNC IDIHMJPN.C ***********************************/
struct NLSINFO {
  char **msgs;             /* pointer to message array */
  int dbcsflag : 1;        /* on: messages may contain dbcs characters */
  char *language_name;     /* language name */
  NLSINFO *(*lmodaddr)();  /* address of fetched module */
  int msgnum;              /* number of 8-byte elements (excluding the ending NULL element) */
};
 
/*********************************************************************/
/* DDname table structure.                                           */
/* An entry is added to this table (which is pointed to via the OPTS */
/* struct) each time a new DDname is processed via the DATASETS      */
/* option.  The final concatenation order is the table entries       */
/* processed from last to first.                                     */
/*********************************************************************/
struct DDT {
  char ddname[9];      /* null-terminated DDname (last entry is NULL) */
  int free : 1,        /* free primary DD at end of processing (dynamically allocated) */
      deconcat : 1,    /* deconcatenate primary DD at end of processing (dynamically concatenated) */
      append : 1;      /* a second string has been appended to dsnlist, containing data sets with no READ access */
  char *dsnlist;       /* pointer to data set name list containing one or more blank delimited
                          data set or path names */
  char *temp_dd;       /* pointer to DDname list containing blank delimited DDnames to be unallocated
                          after the main ddname has been unallocated */
};
 
#define MAXXTYPEL 8  /* note: ensure that any increment is reflected in the report */
#define MAXXNAMEL 8
 
/* exit type list entry */
struct XTL {
  char type[MAXXTYPEL+1];         /* exit type */
  XNL *pXNL;                      /* pointer to exit name list */
};
 
/* exit details */
struct XND {
  char name[MAXXNAMEL+1];         /* exit name */
  char unused[3];
  int rexx : 1,                   /* REXX exit */
      call_attempted,             /* exit call was attempted */
      call_ok : 1;                /* exit call was successful */
  void *fetch_ptr;                /* load module fetch pointer */
};
 
/* exit name list entry */
struct XNL {
  int maxent;                     /* maximum number of entries */
  int curent;                     /* current number of entries */
  XND details[1];                 /* exit details */
};
 
#define CFGSTC 1             /* Job type STC (started task) */
#define CFGTSU 2             /* Job type TSU (TSO user) */
#define CFGJOB 3             /* Job type JOB (batch job) */
 
/* Note: This structure must match the CFG DSECT in IDICC.COPY */
/* IDICH.H $$SYNC IDICC.COPY ***********************************/
struct CFG {
  char cfgjobnm[9];          /* job name                                      */
  char cfgstepn[9];          /* job step name                                 */
  char cfgpgmnm[9];          /* program name                                  */
  char cfgusrid[9];          /* user ID                                       */
  char cfgclass;             /* job class                                     */
  unsigned char cfgjtype;    /* job type (CFGSTC | CFGTSU | CFGJOB)           */
  char cfgjnfld;             /* JCT field ACTJNFLD                            */
  char cfgaccnt[144];        /* JCT field ACTACCNT                            */
  char cfgjes[4];            /* JES component ID (JES2 or JES3)               */
  char cfgjesvr[8];          /* JES version/release                           */
};
 
struct FAULTINFO;
typedef struct FAULTINFO FAULTINFO;
 
/* Options settings structure. */
/* IDICH.H $$SYNC this structure must also be copied to IDIHPMSG.SPC */
struct OPTS {
  int   dumpdsn_o : 1;    /* DumpDSN option specified */
  int   ispf     : 1;     /* Interactive dump analysis mode */
  int   svc      : 1;     /* SVC option in effect */
  int   source   : 1;     /* SOURCE option in effect */
  int   pof_only : 1;     /* IDILANGX processing for Point of Failure only */
  int   no_prompt : 1;    /* prompting for listings or side files to stop      */
  int   zzpp     : 1;     /* Switch set with ZZPP option - must be on to show PP panels */
  int   sysloguen  : 1;   /* LANGUAGE(...,SYSLOGUPPERCASEENGLISH) option */
  int   swp_cb     : 1,   /* SYSTEMWIDEPREFERRED(CONTROLBLOCKS) */
        swp_of     : 1,   /* SYSTEMWIDEPREFERRED(OPENFILES) */
        swp_sa_hex : 1,   /* SYSTEMWIDEPREFERRED(STORAGEAREAS(HEX)) */
        swp_sa_fmt : 1,   /* SYSTEMWIDEPREFERRED(STORAGEAREAS(FMT)) */
        swp_m      : 1;   /* SYSTEMWIDEPREFERRED(MESSAGES) */
  int   linecount;        /* LINECOUNT report option */
  int   mmp;              /* Maximum number of 4K minidump pages per fault */
  int   ieps;             /* Interactive exit prompt seconds */
  int   analysis_seconds; /* Elapsed seconds to complete analysis (value to be compared against opts.ieps) */
  int   mfn;              /* Maximum fault number */
  char  faultid[9];       /* fault id */
  char  detail ;          /* DETAIL report option */
  char  language[4];      /* LANGUAGE option */
  char  listsearch;       /* 'F' = FIRST, 'B' = BEST */
  NLSINFO *nlsinfo;       /* NLS message info */
  HISTBUFINFO *pHistBufInfo; /* Pointer to HISTBUFINFO structure */
  int   realtime : 1;     /* Real-time execution mode */
  CATBUF *pCatMdump;      /* Pointer to Binder Catalogue data when appended to SYSMDUMP */
  char  debug[24];        /* debug component id character string */
  void *maindsaback;      /* main task DSA back chain for trace */
  char  ididsnprefix[27]; /* the IDI data set name prefix from parmlib config member */
  DDT  *pDDT;             /* address of DDname table (used for DATASETS option) */
  XTL  *pXTL;             /* Pointer to exit type list (used for Exits and DumpRegistrationExits options) */
  char  dumpdsn[1025] ;   /* the MVS file system Dump Data Set Name */
  int retaindump_auto  : 1;  /* RETAINDUMP(AUTO) */
  int retaindump_nodup : 1;  /* RETAINDUMP(AUTO,NODUP) */
  int retaindump_all   : 1;  /* RETAINDUMP(ALL) */
  int nodup_cicsfast_minutes; /* NODUP(CICSFAST(minutes)) */
  int nodup_normal_hours; /* NODUP(NORMAL(hours)) */
  int nodup_jobname : 1,  /* NODUP(NORMAL(hours,JOBNAME)) option */
      PrintInactiveCOBOL : 1, /* 0 = NOPrintInactiveCOBOL, 1 = PrintInactiveCOBOL */
      SpinIDIREPRT : 1;   /* 0 = NOSpinIDIREPRT, 1 = SpinIDIREPRT */
  char *quiet_msglist;    /* Message IDs for which no WTO messages will be issued */
  int exittrace : 1;      /* Exit tracing is in effect */
  int zzdev : 1;          /* Switch used to assist in development debugging */
  int tod ;               /* 31 bit millisecond TOD value */
  int lim_storage;        /* Storage allocation limit in bytes */
  char histcols[512];     /* Fault history file display columns */
  DDT *pDDT_iact;         /* IDI data sets for interactive reanalysis (passed via ZZISPF option) */
  int zzasid;             /* ASID to be analysed */
  int zztcb;              /* TCB to be analysed */
  int zzpriorTCB :1 ;     /* TCB that attached IDIDA in this dump, is to be analysed */
  int zzsqueeze[8];       /* SQUEEZE valuse for testing IEWBIND Binder storage usage formula (first 3 ints) */
  double LastClockCyles;  /* Used for displaying CPU usage */
  time_t LastTOD;         /* Used for displaying elapsed time */
  time_t InitialTOD;      /* Initial time.                    */
  char ISPFStatusMsg[54]; /* Message line for ISPF status popup */
  char *zzispf_histdsn;   /* Address of history file name for ZZISPF option */
  unsigned int spl_opt;   /* STORAGEPRINTLIMIT option value */
  unsigned int spl_tot;   /* Total bytes of associated storage areas for comparison against STORAGEPRINTLIMIT option */
  unsigned int pfw;       /* PREFERREDFORMATTINGWIDTH option value */
  char *locale;           /* Locale specified via LOCALE option */
  int   fadate : 1;       /* Override locale date with standard FA date (YYYY/MM/DD) */
  int zzrexxdbg : 1;      /* ZZREXXDBG option in effect */
  char zztest[129];       /* ZZTEST string */
  int zzNoStorageRange : 1;  /* Temporary option to bypass SPQE/SPQA processing under CICS */
  FAULTINFO *pPassedCFault; /* Structure containing details on current fault entry */
  int cicsdumptableexclude ; /* CICSDUMPTABLEEXCLUDE option */
  char *szPermitLangx;    /* Ptr to string containing blank-delimited msg IDs to be ignored during LANGX processing */
  char **pszErrorHandler; /* Pointer to array of pointers to error handler routine names (last element zero) */
  int deferredreport : 1; /* DeferredReport option set */
  int LoopProtection;     /* LoopProtection option set if not zero */
  int nodup_iecd;         /* NODUP(FAST(mins,IncludeExecCicsDump)) option */
  int nodup_imagefast_minutes; /* NODUP(IMAGEFAST(minutes)) */
  int CICSFAtasks_slot;   /* Max TCB execution slots (from DeferredReport(CICSFATasks(slots,waits))) */
  int CICSFAtasks_wait;   /* Max tasks waiting for slots (from DeferredReport(CICSFATasks(slots,waits))) */
  int imagefast_ims_select;  /* Pointer to linked list of NoDup(ImageFast(IMS(INCLUDE/EXCLUDE)))) criteria */
  char ISPFhistDSN[45];   /* Explicit history file data set name specified on invocation of IDIPDDIR */
};
 
OPTS opts;
 
/* Other */
int      eventnumber ;     /* the incremental event number */
int      AbendASID ;       /* the primary abend ASID, keep in sync with ABENDASID key data and ASIDKEY */
char    *curScript ;       /* name of the script currently dispatched */
EANCHOR *naddcurScript ;   /* EANCHOR address of the script currently dispatched (or null)*/
int      dodxprintf ;      /* switch used by dprintf, xprintf and dxprintf */
int      analysis_rc ;     /* the IDIDA analysis return code */
int      idida_rc ;        /* the IDIDA processing return code */
int      no_hist_rec;      /* no history file record found for this dump */
CFG      cfg;              /* job info */
char     error_file[21];   /* file information used by the IDI_ERROR macro allow 20 for CMS */
int      error_line;       /* line information used by the IDI_ERROR macro */
int      cur_storage;      /* Current storage allocation as total number of bytes */
int      max_storage;      /* Maximum storage allocation as total number of bytes */
char     faultID[9];       /* faultID of the fault being processed */
char     histDSN[47];      /* HISTory file Data Set Name of the fault being processed */
int      DispatchComplete; /* switch used to tell demandbind that dispatching is complete */
int      SuppressBind;     /* switch used to tell demandbind not to bind (used for 'dead' COBOL programs) */
int      setjmp_done;      /* If non-zero, setjmp() has been performed and fa_abort is initialized */
jmp_buf  fa_abort;         /* long_jmp save area used when aborting Fault Analyzer processing */
double   start_time;       /* CPU time from clock() at start of processing */
double   start_timeMS;     /* elapsed time in miliseconds at start of processing */
int      FaultEntryRefresh;/* Refresh of history file fault entry required */
char    *save_prtbuf;      /* Address of buffer used for accumulation of real-time report lines (synopsis capture) */
char    *pCDIR;            /* head of chain pointer to CDIR cached PDS directories kept by cRDPDSDIR() */
char     IDIszNULL[1];     /* a static x'00' NULL string byte for any to point to */
int      isDeferredRepSet; /* Is Deferred Report test has been called in this script cycle (opts.deferredreport proc*/
char     dupFaultID[9];    /* Fault ID of which the current fault is a duplicate */
/*|:exmp.*/
 
struct PRMLBBUF_HDR {
  int bufsize;  /* size of buffer including header */
  int numrecs;  /* number of records read into this buffer */
  int mbrsize;  /* required buffer size to contain entire member */
  int mbrrecs;  /* total number of records in the parmlib member */
  char reserved[8];
};
 
/******************************************************************************/
/* internal structures used by all components                                 */
struct GARRAY { /* grow array of pointers to int */
  int  next ;   /* next allocation element number (starting 2) */
  int  max ;    /* maximum element number */
  int *a[1] ;   /* start of array */
} ;
 
#ifndef SCOPE_DEF
  /* IDICENQ/IDICDEQ scope options */
  enum ENQDEQ_SCOPE {
    SCOPE_STEP,
    SCOPE_SYSTEM,
    SCOPE_SYSTEMS
  };
  #define SCOPE_DEF
#endif
 
#ifndef RET_DEF
  /* IDICENQ/IDICDEQ request type */
  enum ENQDEQ_REQUEST {
    RET_HAVE,
    RET_USE,
    RET_TEST
  };
  #define RET_DEF
#endif
 
struct TIMESTAMP {
  int Years;
  int Months;
  int Days;
  int Hours;
  int Minutes;
  int Seconds;
  int TenthsOfSeconds;
};
 
struct X_TYPE {
  char *specification;  /* DumpRegistationExits or RefreshExits suboption */
  char *internal_type;  /* Associated internal type */
};
 
struct ASIDKEY;
typedef struct ASIDKEY ASIDKEY;
/* Note: If the "ABENDASID" key data is only 4 bytes long, it only contains the ASID, this was the old format. */
struct ASIDKEY { /* key data structure for "ABENDASID" key. */
  int   ASID;    /* ASID for the abend under analysis */
  int   pASCB;   /* ASCB address for this ASID */
};
 
struct TOD2CHAR_TS {
  char year[4];
  char month[2];
  char day[2];
  char hour[2];
  char min[2];
  char sec[2];
  char tenths;
  char hundredths;
  char milli;
  char ten_thousandths;
  char hundred_thousandths;
  char micro;
  char null;
};
 
struct PPTOKEN;
typedef struct PPTOKEN PPTOKEN;
struct PPTOKEN {
  char *keyname;  /* Key name */
  char *buffer;   /* Pointer to dynamic panel buffer */
  int buflen;     /* Length of buffer */
  int datlen;     /* Length of data in buffer */
  int MainPanel;  /* Main Panel indicator     */
};
 
struct STOR_RANGE {
  unsigned int beg_addr;
  unsigned int end_addr;
};
 
/*|:h4.CHKXFTAC                                                       */
/*|:p. Check the XFACILIT class resource for the required access.     */
/*|Returns the SAF return code in R15 and RACF return and reason code */
/*|in racf_rc and racf_reason respectively.                           */
/*|:xmp.*/
int CHKXFTAC(char *resource, int attr, int *racf_rc, int *racf_reason);
 
enum RACF_ATTR {      // RACF access ATTR
  ATTR_NONE,          // 0
  ATTR_READ,          // 1
  ATTR_UPDATE,        // 2
  ATTR_CONTROL,       // 3
  ATTR_ALTER          // 4
};
/*|:exmp.*/
 
/*|:h4.Term0092Ex8()                                                 */
/*|:p.                                                               */
/*|:p.IDI0092x termination request with Exit(8).                     */
/*|                                                                  */
/*|:xmp.*/
void Term0092Ex8(void);
/*|:exmp.*/
 
#pragma linkage(CDESCAN,OS)
int CDESCAN(HISTBUFINFO *);
void  DBGHTALL(void );
char *GetDSListSym(char *ddname, char **var_list, char **val_list);
void cDSNalloc(DDT *pDDT, char *pszDDname);
void DDT_sym(DDT *pDDT, char **var_list, char **val_list);
int SPRODSER( int argc, char *argv[]) ;
void HBDDADD(char *pDDName);
void HBDDREM(char *pDDName);
int PDSMemberRename(char *pDSN, char *pOldName , char *pNewName);
void cDDfCloseP(void) ;
int  EnqHistINDEXOpenWrite(HIST_CACHE_CTL *hcc);
int  EnqHistINDEXOpenWriteNoWait(HIST_CACHE_CTL *hcc, char *file, int line);
int  EnqHistOpenWrite(char *histdsn, char *member);
int  WriteCache( HIST_CACHE_CTL *hcc);
void DDT_ReadAccessCheck(DDT *pDDT);
