
// change byte position for switching between Big-Endian and Little-Endian
//revbs  reverse bytes Short
//revbi  reverse bytes int

#if defined(LITTLE_ENDIAN)

#define revbs(A)  ((((short)(A) & 0xff00) >> 8) | \
                   (((short)(A) & 0x00ff) << 8))

#define revbi(A)  ((((int)(A) & 0xff000000) >> 24) | \
                   (((int)(A) & 0x00ff0000) >> 8)  | \
                   (((int)(A) & 0x0000ff00) << 8)  | \
                   (((int)(A) & 0x000000ff) << 24))

#else

#define revbs(A)  (A)
#define revbi(A)  (A)

#endif

