/* API header Key Information Management *****************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2006. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
/*|:h3.IDIKH.H                                                       */
 
 
/*********************************************************************/
/*   API Structure forward declarations                              */
/*********************************************************************/
 
/******************************************************************************/
/*   API Function and Structure Definitions                                   */
/******************************************************************************/
/*|:h4.keyadd()                                                               */
/*|The keyadd() call is used to add Key Information to the dump status.  The  */
/*|caller provides a zero terminated name for the type of data, a pointer and */
/*|length for the data, and a pointer to another KANCHOR if the data is to be */
/*|related to other key data.  The function returns a pointer to the new      */
/*|KANCHOR of the added data.                                                 */
/*|Key name, key data and author (if not NULL) are copied to malloc'ed        */
/*|storage.  If author is not specified (i.e. is NULL), the name of the       */
/*|currently executing script is used by default.                             */
/*|A related group can not contain multiple keys of exactly the same name,    */
/*|a keyadd() is internally converted to keymod() if this condition would     */
/*|occure from a keyadd().                                                    */
/*|:xmp.*/
/*|
/*|KANCHOR *keyadd(char *szKey, void *data, int length, KANCHOR *related, char *author) ;
/*|
/*|:exmp.*/
#define  keyadd(  szKey, data, length, related, author ) \
         keyxadd( szKey, data, length, related, author, __FILE__, __LINE__ )
KANCHOR *keyxadd(char *szKey, void *data, int length, KANCHOR *related, char *author, char *file, int line);
 
/*|:h4.keymod()                                                               */
/*|The keymod() call is used to modify existing Key Information.  The caller  */
/*|provides a pointer and length for the data, and a pointer to the KANCHOR   */
/*|of the original key data.  The function returns the original KANCHOR       */
/*|pointer.  The keymod() call would normally be used to change the data in   */
/*|this anchor.  New KANCHORs can be added to a related ring, they are        */
/*|never be removed, and can only be a member of one related group.           */
/*|An orphen (related only to its self) KANCHOR can be keymod() added to      */
/*|an existing related group.                                                 */
/*|Key data and author (if not NULL) are copied to malloc'ed storage.         */
/*|:xmp.*/
/*|
/*|KANCHOR *keymod(void *data, int length, KANCHOR *original, char *author, KANCHOR *related ) ;
/*|
/*|:exmp.*/
#define  keymod(  data, length, original, author, related ) \
         keyxmod( data, length, original, author, related, __FILE__, __LINE__ )
KANCHOR *keyxmod(void *data, int length, KANCHOR *original, char *author, KANCHOR *related, char *file, int line);
 
/*|:h4.keyLocate()                                                            */
/*|The keyLocate() call is used to ask Key Information to return the pointer  */
/*|to an item of key information.  It returns null if if no items of that     */
/*|Type exist.                                                                */
/*|:xmp.*/
/*|
/*|KANCHOR *keyLocate( char *szKey) ;
/*|
/*|:exmp.*/
/*|If successful the call returns a pointer to a KANCHOR of the requested     */
/*|key, otherwise null.  The KANCHOR may have related entries and/or          */
/*|duplicate entries linked to it.  The KANCHORs are chained together in a    */
/*|ring of duplicates by full key and seperate ring by generic key.  Full     */
/*|keys have a quoted suffix, generic keys have no suffix. There is           */
/*|also a seperate ring of related entries.  If an entry is the only one on a */
/*|ring, it points to it's self.  The generic key is the key excluding any    */
/*|quote (') and suffix portion of the key, or the whole key when there is    */
/*|no suffix.  When keyLocate() is called from a script execution             */
/*|it implecitly sets up notify linkages that insures the script is           */
/*|re-dispatched if the key's for which it has issued keyLocat are created    */
/*|or altered.                                                                */
#define  keyLocate(  szKey ) \
         keyxLocate( szKey, __FILE__, __LINE__ )
KANCHOR *keyxLocate( char *szKey, char *file, int line);
 
/*|:h4.keyRelLocate()                                                         */
/*|The keyRelLocate() call is used to run the chain of related keys looking   */
/*|for one equal to szkey and return a pointer to its KANCHOR or null for no  */
/*|no related key with that name.                                             */
/*|When keyLocate() is call from a script execution                           */
/*|it implecitly sets up notify linkages that insures the script is           */
/*|re-dispatched if the key's for which it has issued keyRelLocat are created */
/*|or altered.                                                                */
/*|:xmp.*/
/*|
/*|KANCHOR *keyRelLocate( char *szKey, KANCHOR* related) ;
/*|
/*|:exmp.*/
/*|:p.                                                                        */
/*|After keyRelLocate() is called, the returned item may have generic         */
/*|duplicates on the same related chain, in which case the GenRelDup chain    */
/*|may be traversed for the generic related duplicates of the returned        */
/*|KANCHOR.                                                                   */
/*|:xmp.*/
 
struct   KANCHOR {      /* Key Data Item anchor */
  KANCHOR *FullKeyDup ; /* next KANCHOR in chain of of full key duplicates */
  KANCHOR *GenKeyDup ;  /* next KANCHOR in chain generic duplicates, only compared up to the ' */
  KANCHOR *related ;    /* next KANCHOR in a related chain, or self if only one.*/
  KANCHOR *GenRelDup ;  /* next KANCHOR in chain generic duplicates in the same related chain. */
  char    *key ;        /* sz Key of item */
  void    *pdata ;      /* pointer to the data at address, for length, 0 for a shadow entry */
  int      length ;     /* length of pdata item */
  int      event ;      /* alteration event number */
  char    *author ;     /* pointer to string with name of function providing ID/address */
  GARRAY  *notify;      /* null or pointer to notify array */
  int      printflag:1 ;/* flag to manage diagnostic printing */
  int     *pRANCH;      /* internal use by key processing for Related groups */
} ;
 
/*|:exmp.*/
#define  keyRelLocate(  szKey, related ) \
         keyxRelLocate( szKey, related, __FILE__, __LINE__ )
KANCHOR *keyxRelLocate( char *szKey, KANCHOR* related, char *file, int line);
 
/******************************************************************************/
/*|:h4.dumpKey()                                                              */
/*|The dumpKey() function (macro), dumps Key Information KANCHOR structures.  */
/*|It is conditioned by the DEBUG() option providing dynamic control over     */
/*|the output for each component.  It dumps just the KANCHOR address          */
/*|passed, or all Key data if a null arguement is passed.                     */
/*| :xmp.                                                                     */
/*|                                                                           */
/*|void dumpKey( KANCHOR *key );                                              */
/*|                                                                           */
/*| :exmp.                                                                    */
 
#define dumpKey(key) { \
  if(opts.debug[0]!= '\0') \
     dumpxKey( key, __FILE__, __LINE__ ); }
void dumpxKey( KANCHOR *key, char *file, int line );
 
/******************************************************************************/
/*|:h4.iskanchor()                                                            */
/*|The iskanchor() function tests the address passed to see if it is a        */
/*|valid KANCHOR address, returns true 1 or fales 0.                          */
/*| :xmp.                                                                     */
 
int iskanchor( void *anchor );
 
/*| :exmp.                                                                    */
 
/*********************************************************************/
/*|:h4.stateKeyFmt()                                                 */
/*|:p.STATE key formatting for dumpKey and ZZKEY.                    */
/*********************************************************************/
/*| :xmp.                                                                     */
char *stateKeyFmt(KANCHOR *pKA);
/*| :exmp.                                                                    */
 
