/*********************************************************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2005.  All rights reserved.       */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/*********************************************************************/
/*|:h3.IDIVH.H                                                       */
/*|    IDIVH.H $$prereqs IDIIH.H IDIXH.H IDIEH.H                     */


/*********************************************************************/
/*   API Structure Definitions                                       */
/*********************************************************************/

struct OPER ;
typedef struct OPER OPER ;
struct DSM ;
typedef struct DSM DSM ;
struct LOCL ;
typedef struct LOCL LOCL ;
struct CDSINOTES;
typedef struct CDSINOTES CDSINOTES;
struct COBST;
typedef struct COBST COBST ;
struct PLISTG;
typedef struct PLISTG PLISTG ;
struct PLIARR;
typedef struct PLIARR PLIARR ;
struct BLKEY;
typedef struct BLKEY BLKEY;
struct PLISTGKEY;
typedef struct PLISTGKEY PLISTGKEY;
struct ASMSTG;
typedef struct ASMSTG ASMSTG ;
struct ASMARR;
typedef struct ASMARR ASMARR ;
struct ASMSTGKEY;
typedef struct ASMSTGKEY ASMSTGKEY;
struct IDXKEY;
typedef struct IDXKEY IDXKEY;
struct XREFH;
typedef struct XREFH XREFH ;
struct XREF;
typedef struct XREF XREF ;
struct OSVSCOB;
typedef struct OSVSCOB OSVSCOB ;
struct OSVSCOBS;
typedef struct OSVSCOBS OSVSCOBS ;
struct SRCL;
typedef struct SRCL SRCL ;
struct COBSTH;
typedef struct COBSTH COBSTH ;
struct PACKCNT;
typedef struct PACKCNT PACKCNT ;

/*********************************************************************/
/*   IDILANGX record structure definitions                           */
/*********************************************************************/

struct LXCONT ;
typedef struct LXCONT LXCONT ;
struct LXSOUR ;
typedef struct LXSOUR LXSOUR ;
struct LXMISC ;
typedef struct LXMISC LXMISC ;
struct LXSYLO ;
typedef struct LXSYLO LXSYLO ;
struct LXAOFF ;
typedef struct LXAOFF LXAOFF ;
struct LXSCOP ;
typedef struct LXSCOP LXSCOP ;
struct LXBASL ;
typedef struct LXBASL LXBASL ;
struct LXCSEC ;
typedef struct LXCSEC LXCSEC ;
struct LXFILI ;
typedef struct LXFILI LXFILI ;
struct LXVALI ;
typedef struct LXVALI LXVALI ;
struct DSNRES ;
typedef struct DSNRES DSNRES ;

/*********************************************************************/
/*   Internal Structure Definitions                                  */
/*********************************************************************/

struct LXCONT {                /* Controlling record                          */
  LXCONT   *nextProg;
  char     *dsname;             /* listing or sidefile DS name     */
  COBSTH   *cobstp;             /* pointer to COBSTH data          */
  int       maxbl;              /* max number of COBSTH available  */
  int       curbl;              /* current COBSTH                  */
  int       tgtlen;             /* COBOL TGT length                */
  int       wslen;              /* COBOL WS length                 */
  int       wdblang;
  int       staticcs;           /* static csect# for PL/I          */
  int       datdcs;             /* @DATD  csect# for PL/I          */
  int       optim;              /* Non-zero for optimized code     */
  int       storlin;            /* 0-stmt, 1-line for PL/I         */
  int       margl;
  int       margr;
  int       nosrc;              /* number of source records        */
  int       addr;
  char     *sourf;             /* First source record                         */
  int       souri;             /* 3 = source type 3, 4 = source type 4        */
  char     *sylop;             /* Pointer to Symbol Lookup table              */
  int       syloc;             /* Count of entries in Symbol Lookup table     */
  char     *baslp;             /* Pointer to Base Locator table               */
  int       baslc;             /* Count of entries in Base Locator table      */
  LXAOFF   *aoffp;             /* Pointer to LXAOFF records                   */
  int       aoffc;             /* count of LXAOFF entries                     */
  LXSCOP   *scopp;             /* Pointer to first LXSCOP entry               */
  int       scopc;             /* Number of LXSCOP entries                    */
  LXCSEC   *csecp;             /* Pointer to first LXCSEC record              */
  int       csecc;             /* count of LXCSEC records                     */
  char     *osvsp;             /* Pointer to IDILANGX OS/VS cobol record      */
  int       filic;             /* count of LXFILI records                     */
  LXFILI   *filip;             /* Pointer to first LXFILI record              */
  LXVALI   *valip;             /* Pointer to first LXVALI record              */
  int       valic;             /* count of LXVALI records                     */
  DSNRES   *filecrit;          /* pointer to search results                   */
  char     *CompOpts;          /* pointer to string of compiler options       */
  short     blnumb;            /* Base locator numbering - 0 Unknown          */
                               /*                        - 1 Decimal          */
                               /*                        - 2 Hex              */
  char      WdbProg[9];        /* member name                                 */
};

struct LXSOUR {                /* Source records                              */
  LXSOUR   *sosonp;            /* Pointer to next LXSOUR record               */
  LXSOUR   *sosopp;            /* Pointer to previous LXSOUR record           */
  char      sotext[1];         /* IDILANGX source record                      */
};

struct LXSYLO {                /* Symbol Lookup table                         */
  int       slid;              /* IDILANGX symbol id.                         */
  int       slflag;            /* miscellaneous use flag                      */
  char     *slsyp;             /* Pointer to IDILANGX symbol record           */
  LXMISC   *slmsp;             /* Pointer to LXMISC record                    */
};

struct LXMISC {                /* miscellaneous records hanging off symbol rec*/
  LXMISC     *msmsp;           /* Pointer to next LXMISC record               */
  int         msrt;            /* Record type                                 */
                               /*     1 - Structure record                    */
                               /*     2 - Array     record                    */
                               /*     3 - Xref      record                    */
                               /*     4 - Locates   record                    */
                               /*     5 - Plist     record                    */
                               /*     6 - Respecify record                    */
  char      mstext[1];         /* IDILANGX record according to record type    */
};

struct LXAOFF {                /* Assembler Offset (was C++ Text) record      */
  int       aofile;            /* file number                                 */
  int       aoline;            /* line number                                 */
  int       aooff;             /* offset                                      */
};

struct LXCSEC {                /* CSECT records                               */
  LXCSEC   *cscsp;             /* Pointer to next LXCSEC record               */
  char      cstext[1];         /* IDILANGX CSECT 0E or 45 record              */
};

struct LXBASL {                /* Base Locator table                          */
  int       blid;              /* Base Locator IDILANGX ident                 */
  char      blname[10];        /* Base Locator name                           */
};

struct LXSCOP {                /* Scope record                                */
  int       scstart;           /* Start of block                              */
  int       scend;             /* end of block                                */
  int       scowner;           /* owner of block                              */
  int       scident;           /* symbol Id of block                          */
};

struct LXFILI {                /* File Include record                         */
  LXFILI   *fifinp;            /* Pointer to next LXFILI record               */
  int       fifile;            /* file number                                 */
  int       fiincf;            /* Included From file number                   */
  int       fiincl;            /* Included From line number                   */
  char      finame[1];         /* file name                                   */
};

struct LXVALI {                /* Validation records                          */
  int       vatype;            /* type of validation record                   */
  int       valen;             /* Length of this validation item              */
  int       valoc;             /* Location of this validation item            */
};

struct DSNRES {
  short jcldd;             /* 1-DD from exit                           */
                           /* 2-DSN from concatenation                 */
                           /* 3-DD from IDILANGX conversion (temp DD)  */
  short pdsorseq;          /* 0 - PDS, 1 - sequential                  */
  short rating;
  short promptsw;          /* default 0, 1 if dsn entered thro' prompt */
  short tracesw;           /* set to 1 when trace output done          */
  short chkdate;           /* 0 - date check not done                  */
                           /* 1 - listing timestamp = load date        */
                           /* 2 - listing later than load date         */
                           /* 3 - listing earlier than load date       */
  short chktime;           /* 0 - time check not done                  */
                           /* 1 - listing time      = load time        */
                           /* 2 - listing time later than load time    */
                           /* 3 - listing time earlier than load time  */
  short chklength;         /* 0 - assembler inst length check not done */
                           /* 1 - assembler inst length check ok       */
                           /* 2 - assembler inst length check failed   */
  short chkcsect;          /* 0 - csect length check not done          */
                           /* 1 - csect length check ok                */
                           /* 2 - csect length check failed            */
  short chktgt;            /* 0 - tgt length test not done             */
                           /* 1 - tgt length test passed               */
                           /* 2 - tgt length test failed               */
  short chkws;             /* 0 - ws  length test not done             */
                           /* 1 - ws  length test passed               */
                           /* 2 - ws  length test failed               */
  int   tgtlolen;          /* tgt length from load module              */
  int   tgtlilen;          /* tgt length from listing/idilangx         */
  int   wslolen;           /* ws length from load module               */
  int   wslilen;           /* ws length from listing/idilangx          */
  int   cslolen;           /* csect length from load module            */
  int   cslilen;           /* csect length from listing/idilangx       */
  char  dddsn[57];
  char  repdsn[57];
  char  origdddsn[57];
  char  lodate[11];        /* YYYY/MM/DD load mod date                */
  char  lotime[9];         /* HH:MM:SS   load mod time                */
  char  lidate[11];        /* YYYY/MM/DD listing date                 */
  char  litime[9];         /* HH:MM:SS   listing time                 */
  char  tdate[10];
  char  ttime[8];
  char  fileformat;        /* 'X' - originally IDILANGX file           */
                           /* 'L' - originally listing  file           */
                           /* 'S' - originally SYSDEBUG file           */
                           /* 'T' - originally TEST option data        */
  char  processed;         /* 'N' - entry not processed                */
                           /* 'Y' - entry processed                    */
  char  dummyrec;          /* 'D' - dummy DSNRES not created through   */
                           /*       normal IDIVSIDE search for listing */
                           /*       type functions. i.e. PL/I TEST     */
} ;

/* BLKEY struct is used for keys WSS,BLF,BLK,BLL,BLV,BLX */
struct BLKEY {                 /* COBOL base locator     */
  LXCONT   *COp;               /* current source header  */
  int  nCOBST;                 /* number of COBSTs       */
  COBST *pCOBST;               /* ptr to first COBST     */
  int addr;                    /* base address           */
  int len;                     /* length (WS only)       */
};

/* PLISTGKEY struct is used for keys PLI_AUTO/PLI_STATIC */
struct PLISTGKEY {             /* PL/I base locator      */
  LXCONT   *COp;               /* current source header  */
  int  nPLISTG;                /* number of PLISTGs      */
  PLISTG *pPLISTG;             /* ptr to first PLISTG    */
  int addr;                    /* base address (R3/R13)  */
  int len;                     /* length                 */
};

/* ASMSTGKEY struct is used for keys ASM_CSECT/ASM_DSECT */
struct ASMSTGKEY {             /* storage (DSECT/CSECT)  */
  LXCONT *COp;                 /* current source header  */
  int nASMSTG;                 /* number of ASMSTGs      */
  ASMSTG *pASMSTG;             /* ptr to first ASMSTG    */
  int addr;                    /* base address           */
  int len;                     /* length                 */
};

struct IDXKEY {                /* COBOL table index      */
  LXCONT   *COp;               /* current source header  */
  int line;                    /* line defined           */
  int value;                   /* value of index         */
  int nCOBST;                  /* number of COBSTs (1)   */
  COBST *pCOBST;               /* ptr to first COBST     */
  COBST *table;                /* ptr to table COBST     */
};

struct CDSINOTES {
    unsigned int CondSet      : 1,   /* Condition code is set      */
                 IntrInst     : 1,   /* Interruptible instruction  */
                 NewcondLoaded: 1,   /* New condition code loaded  */
                 PrivInst     : 1,   /* Privileged instruction     */
                 SemiPrivInst : 1,   /* Semi privileged instruction*/
                 ExecDiffers  : 1,   /* Execution in problem and   */
                                     /*  supervisor state differs  */
                 CondMaySet   : 1,   /* Condition code may  be set */
                 CondUnpred   : 1;   /* Condition code may  be     */
                                     /* unpredicatble              */
 };


struct SRCL {
  int     srctot;                /* Total entries in array          */
  int     thisline;              /* Current entry in array          */
  LXSOUR *srcsrcp;               /* Ptr to LXSOUR record            */
} ;

struct LOCL {
  IANCHOR  *csectp;             /* pointer to IANCHOR              */
  int       displ;              /* displacement                    */
  int       actdispl;           /* displacement of source record   */
  int       blstmt;             /* Starting statement for block    */
  void     *srcaddr;            /* current  source record          */
  LXCONT   *lxcontp;            /* current control record          */
  LXSYLO   *symsymr;            /* current  symbol record          */
  int       indic;              /* indicator of result             */
  char     *textlp;             /* ptr to formatted source string  */
  void     *symptr;             /* pointer to symbol structure     */
                                /*  which is language specific     */
  int       lineind;            /* Is line to be used over stmt    */
  int       file;               /* source record file number       */
  int       line;               /* source record line number       */
  int       stmt;               /* source record statement number  */
  int       rfile;              /* reportable file number          */
  int       rline;              /* reportable line number          */
  int       rstmt;              /* reportable statement number     */
  int       linec;              /* No. of source lines to output   */
  SRCL     *srclptr;            /* Ptr to locatel source line data */
  int       indarr[7];          /* array indexes                   */
  int       margl;              /* left margin (PL1)               */
  int       margr;              /* right margin (PL1)              */
  SLINE    *pSL;                /* pointer to Source Line struct   */
  char     *dsap;               /* pointer to DSA for PLI          */
  XCSECT   *pXC;                /* pointer to csect structure      */
  XREFH    *xrefp;              /* pointer to cross references     */
  char     *xEPName;            /* entry point name from xCsectId  */
  char     *xCsectName;         /* csect       name from xCsectId  */
  char      symdim;             /* Symbol dimension, 0 if not array*/
  char      lastchar;           /* last non blank character of     */
                                /* formatted source string within  */
                                /* code (excluding sequence fields)*/
} ;

struct OPER {
  char  cpre;             /* Operand is present                  */
  char  cmod;             /* Operand is modified                 */
  char  cbrn;             /* Operand is a target of a branch     */
  char  ctyp;             /* Type of Operand                     */
  int   ival;             /* The register used if Type=1         */
                          /* The value if mask/immediate (Type=3)*/
  int   ibas;             /* The base register if Type=2         */
  int   iind;             /* The index register if Type=2        */
  int   idis;             /* The displacement if Type=2          */
  int   ilen;             /* The length of the Operand           */
  unsigned int bimpl : 1, /* 0 specified implies R0              */
               bpair : 1, /* "pair" register required            */
               bimlv : 1, /* Implicit length valid               */
               brnev : 1, /* Rn+1 referenced if Rn even          */
               bres1 : 1, /* reserved                            */
               bres2 : 1, /* reserved                            */
               bsnum : 1, /* Signed number                       */
               bnstr : 1, /* No storage reference                */
               gprln : 1; /* ilen specifies GPR number           */
};
struct DSM {
  int    idsrc;           /* return code                         */
  char  *userptr;         /* pointer for user to chain DSMs      */
  int    stjump;          /* storage skipped when stepping back  */
                          /* through instructions (in bytes)     */
  char  *instp;           /* pointer to instruction              */
                          /* always valid, even if idsrc is not 0*/
  char   cdsilen;         /* assembler instruction length 2,4,6  */
  char   cdsiform;        /* assembler instruction format        */
                          /*   0  - Invalid                      */
                          /*   1  - E                            */
                          /*   2  - RR                           */
                          /*   3  - QST                          */
                          /*   4  - QV                           */
                          /*   5  - RRE                          */
                          /*   6  - RS                           */
                          /*   7  - RX                           */
                          /*   8  - S                            */
                          /*   9  - SI                           */
                          /*   10 - VR                           */
                          /*   11 - VS                           */
                          /*   12 - VST                          */
                          /*   13 - VV                           */
                          /*   14 - RSE                          */
                          /*   15 - SS                           */
                          /*   16 - SSE                          */
                          /*   17 - RI                           */
                          /*   18 - RSI                          */
                          /*   19 - RRF                          */
                          /*   20 - RXE                          */
                          /*   21 - tba                          */
                          /*   22 - tba                          */
                          /*   23 - RXF                          */
                          /*   24 - tba                          */
  CDSINOTES cdsinotes;

  OPER   oper[4];         /* operands                            */
  char   adstxt[39];      /* instruction text string             */
} ;

struct COBST {
    int    sid   ;        /* symbol identifier                   */
    int    off   ;        /* offset                              */
    int    dcl   ;        /* statement no. of source declaration */
    int    len   ;        /* length of symbol                    */
    LXSOUR *recp ;        /* pointer to source record in storage */
    LXSYLO *symp ;        /* pointer to symbol record in storage */
    int    low   ;        /* low index for array                 */
    int    high  ;        /* high index for array                */
    int    mhigh ;        /* max high (OCCURS DEPENDING ON)      */
    int    data  ;        /* low level of structure indicator    */
    int    level ;        /* level of structure indicator        */
    int    strct ;        /* structure length                    */
    int    dim   ;        /* dimension of array                  */
    int    act   ;        /* working dimension of array          */
    int    rmdr  ;        /* Difference in offset work field     */
    char  *symb  ;        /* pointer to symbol name              */
    short  symbl ;        /* length of symbol name               */
    short  red   ;        /* redefines count field               */
} ;

struct PLISTG {
    int     sid   ;       /* symbol identifier                   */
    int     owner ;       /* symbol owner identifier             */
    int     off   ;       /* offset                              */
    int     pposn ;       /* parameter position - only used for  */
                          /*      enterprise PL/I                */
    int     dcl   ;       /* statement no. of source declaration */
    int     len   ;       /* length of symbol                    */
    LXSYLO *recp  ;       /* pointer to symbol record in storage */
    int     nodim ;       /* number of dimensions                */
    PLIARR *arrp  ;       /* pointer to array information        */
    int     data  ;       /* symbol to display contents          */
    int     level ;       /* level of structure indicator        */
    int     strct ;       /* structure length                    */
    char   *symb  ;       /* pointer to symbol name              */
    int     lptr  ;       /* ptr locates other symbols index     */
    int     work  ;       /* work offset used by report          */
    short   symbl ;       /* length of symbol name               */
    char    disp  ;       /* display field from IDILANGX symbol  */
    char    parm  ;       /* x'00' not a parameter, else it is   */
                          /*   a parameter                       */
    LXCONT *COp ;         /* LANGX control struct                */
} ;

struct PLIARR {
    int     low  ;        /* lower bound                         */
    int     high ;        /* higher bound                        */
} ;

struct ASMSTG {
    int     sid   ;       /* symbol identifier                   */
    int     owner ;       /* symbol owner identifier             */
    int     off   ;       /* offset                              */
    int     dcl   ;       /* statement no. of source declaration */
    int     len   ;       /* length of symbol                    */
    LXSOUR *recp  ;       /* pointer to source record in storage */
    LXSYLO *symp ;        /* pointer to symbol record in storage */
    int     nodim ;       /* number of dimensions                */
    ASMARR *arrp  ;       /* pointer to array information        */
    int     low   ;       /* low index for array                 */
    int     high  ;       /* high index for array                */
    int     data  ;       /* symbol to display contents          */
    int     strct ;       /* structure length                    */
    char   *symb  ;       /* pointer to symbol name              */
    short   symbl ;       /* length of symbol name               */
    char    disp  ;       /* display field from IDILANGX symbol  */
    char    parm  ;       /* x'00' not a parameter, else it is   */
                          /*   a parameter                       */
    LXCONT *COp ;         /* LANGX control struct                */
} ;

struct ASMARR {
    int     low  ;        /* lower bound                         */
    int     high ;        /* higher bound                        */
} ;

struct XREFH {
  int       noxref;             /* number of cross references      */
  int       sline;              /* source line number              */
  int       sstmt;              /* source stmt number              */
  LXCONT   *XSymHptr;           /* pointer to the header record    */
                                /* of the stored WDBLANGX records  */
} ;

struct XREF {
  int       XSymId;             /* Symbol Id of this reference     */
  LXSOUR   *XSymSptr;           /* pointer to the source record    */
  void     *XSymDptr;           /* pointer to symbol data          */
  int       XSymDisp;           /* displacement of symbol          */
  char      XBaseLoc[10];       /* base locator for symbol         */
  int       Xparm;              /* indicator for parm              */
  short     XIncI;              /* 0 - XSymDptr data complete      */
                                /* 1 - XSymDptr data incomplete    */
} ;

struct OSVSCOBS {
  short  rtype;                 /* type                            */
                                /* type 1 DCB base locator info    */
                                /* type 2 FIB base locator info    */
                                /* type 3 WS  base locator info    */
                                /* type 4 BLL base locator info    */
                                /* type 5 SBL   information        */
                                /* type 6 INDEX information        */
                                /* type 7 VLC   information        */
  short  numbr;                 /* Number of Base Locators         */
  short  start;                 /* Starting Base Locator number    */
  int    basel;                 /* offset into TGT                 */
} ;

struct OSVSCOB {
  int    tgtlen;                /* tgt length                      */
  int    fiboff;                /* Offset of FIBs in TGT           */
  int    dcboff;                /* Offset of DCBs in PGT           */
  int    noels;                 /* number of elements              */
  int    wsloc;                 /* Working Storage location        */
  int    wslen;                 /* Working Storage length          */
  OSVSCOBS elem[1];             /* elements                        */
} ;

struct COBSTH {
  char   csname[12];            /* BL name for this COBST          */
  COBST *csaddr;                /* pointer to a COBST table        */
  int    csnum;                 /* number of entries in this COBST */
} ;

struct PACKCNT {
  int    packedf;               /* 1 for a PACKed file               */
  int    frsttime;              /* switch for first call to PackRead */
  char  *irecp;                 /* input record current pointer      */
  char  *irecs;                 /* input record start                */
  char  *orecp;                 /* output record current pointer     */
  char  *orecs;                 /* output record start               */
  int    irecm;                 /* input record length               */
  int    orecm;                 /* output record length              */
  char   filetype;              /* file type V or F                  */
} ;

/*********************************************************************/
/*   API Function Definitions                                        */
/*********************************************************************/

/*|:h4.disassem()                                                    */
/*|:p.disassem() performs a disassembly of an assembler              */
/*|instruction, and passes back a DSM structure containing details   */
/*|of the instruction. The function is passed a pointer to code, and */
/*|a pointer to a DSM structure.                                     */
/*|:xmp.                                                             */
void  disassem(char *cdsiptr,DSM *dsmp) ;
/*|:exmp.                                                            */
/*|:h4.stepback()                                                    */
/*|:p.stepback() attempts to step back one assembler                 */
/*|instruction, and passes back a DSM structure containing details   */
/*|of the new instruction. The function is passed a pointer to code, */
/*|and a pointer to a DSM structure.                                 */
/*|:xmp.                                                             */
void  stepback(char *cdsiptr,DSM *dsmp) ;
/*|:exmp.                                                            */
/*|:h4.locateL()                                                     */
/*|:p.locateL() receives a pointer to a LOCL structure               */
/*|containing an address and a CSECT name. The function looks for a  */
/*|WDBLANGX file and if not found, attempts to create a WDBLANGX file*/
/*|from a LISTING file. Then source lines of code are extracted and  */
/*|built up in storage, and a pointer to the source line             */
/*|corresponding to the address (displacement within CSECT)          */
/*|passed back to the caller.                                        */
/*|:xmp.                                                             */
void locateL(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.locateFL()                                                    */
/*|:p.locateFL() is similar to locateL but is more suitable          */
/*|when locating a source line number or statement number            */
/*|associated with a register.                                       */
/*|:xmp.                                                             */
void locateFL(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.locateS()                                                     */
/*|:p.locateS() receives a pointer to a LOCL structure               */
/*|containing a CSECT name. The function looks for the first source  */
/*|line from the WDBLANGX file.                                      */
/*|:xmp.                                                             */
void locateS(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.lineF()                                                       */
/*|:p.lineF() receives a pointer to a LOCL structure                 */
/*|containing data gathered from a previous call to locateL. This    */
/*|function will return the next source line.                        */
/*|:xmp.                                                             */
void lineF(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.lineB()                                                       */
/*|:p.lineB() receives a pointer to a LOCL structure                 */
/*|containing data gathered from a previous call to locateL. This    */
/*|function will return the previous source line.                    */
/*|:xmp.                                                             */
void lineB(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.lineSF()                                                      */
/*|:p.lineSF() receives a pointer to a LOCL structure                */
/*|containing data gathered from a previous call to locateL. This    */
/*|function will return the next source line from the stored set     */
/*|of pointers to source records.                                    */
/*|:xmp.                                                             */
void lineSF(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.findCobSym()                                                  */
/*|:p.findCobSym locates the symbol record representing the variable */
/*|that corresponds to the displacement within a base register passed*/
/*|to this function.                                                 */
/*|:xmp.                                                             */
void findCobSym(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.findPliSym()                                                  */
/*|:p.findPliSym() receives a pointer to a LOCL structure with       */
/*|a pointer to a PL1 data area plus an offset. This may well have   */
/*|been as a result of a WhereAmI call. Returned will be data        */
/*|about the symbol found at that displacement.                      */
/*|:xmp.                                                             */
void findPliSym(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.findAsmSym()                                                  */
/*|:p.findAsmSym locates the symbol record representing the variable */
/*|that corresponds to the displacement within a CSECT passed        */
/*|to this function.                                                 */
/*|:xmp.                                                             */
void findAsmSym(LOCL *loclp, int csindex) ;
/*|:exmp.                                                            */
/*|:h4.findAsmRfy()                                                  */
/*|:p.findAsmRfy locates the symbol record representing the variable */
/*|that corresponds to the displacement within a DSECT that has an   */
/*|active USING for the passed register.                             */
/*|:xmp.                                                             */
void findAsmRfy(LOCL *loclp, int reg, int addr) ;
/*|:exmp.                                                            */
/*|:h4.gCobStore()                                                   */
/*|:p.gCobStore() will construct a table containing all the symbols  */
/*|for a given base locator.                                         */
/*|:xmp.                                                             */
void gCobStore(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.gPliStore()                                                   */
/*|:p.gPliStore() receives a pointer to a LOCL structure with        */
/*|a pointer to a Pl/1 data area. Returned will be a description of  */
/*|all the data items for the Pl/1 data area.                        */
/*|:xmp.                                                             */
void gPliStore(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.gCsectStore(LOCL *loclp, int csindex);                        */
/*|:p.gCsectStore() receives a pointer to a LOCL structure with      */
/*|a pointer to an assembler CSECT. Returned will be a description   */
/*|of all the data items in that section.                            */
/*|:xmp.                                                             */
void gCsectStore(LOCL *loclp, int csindex);
/*|:exmp.                                                            */
/*|:h4.gDsectStore(LOCL *loclp) ;                                    */
/*|:p.gDsectStore() receives a pointer to a LOCL structure with      */
/*|a pointer to an assembler DSECT. Returned will be a description   */
/*|of all the data items in that section and the length of the       */
/*|DSECT.                                                            */
/*|:xmp.                                                             */
int gDsectStore(LOCL *loclp, int ident);
/*|:exmp.                                                            */
/*|:h4.GetCsectNum(LOCL *loclp, IANCHOR *pIA);                       */
/*|:p.GetCsectNum receives a pointer to a CSECT IANCHOR and          */
/*|returns the number of the CSECT.                                  */
/*|:xmp.                                                             */
unsigned short GetCsectNum(LOCL *loclp, IANCHOR *pIA);
/*|:exmp.                                                            */
/*|:xmp.                                                             */
unsigned short GetNumCsects(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.GetNumCsects(LOCL *loclp) ;                                   */
/*|:p.GetNumCsect receives a pointer to a LOCL structure             */
/*|containing a pointer to an assembler program (CSECT). It returns  */
/*|the number of CSECTs in the program. This is then used to         */
/*|control calls to gAsmStore().                                     */
/*|:xmp.                                                             */
int *GetDsectInfo(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.GetDsectInfo(LOCL *loclp) ;                                   */
/*|:p.GetDsectInfo receives a pointer to a LOCL structure            */
/*|containing an assemblet stmt#. It returns a list of symbol IDs    */
/*|and using registers for any DSECTs that are 'in scope'.           */
/*|:xmp.                                                             */
void lineT(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.GetSymData()                                                  */
/*|:p.GetSymData() receives a pointer to an XCSECT                   */
/*|structure and a symbol name, and returns a pointer to the         */
/*|symbol value and its length.  Returns 1 if successful, 0 if not.  */
/*|:xmp.                                                             */
int GetSymData(XCSECT *pxc, char *symname, void **symvalue, int *symlen);
/*|:exmp.                                                            */
/*|:h4.cobolov()                                                     */
/*|:p.cobolov() locates the specific os/vs cobol record in IDILANGX  */
/*|file and returns a pointer to a formatted OSVSCOB structure.      */
/*|:xmp.                                                             */
OSVSCOB * cobolov(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.lookWDB()                                                     */
/*|:p.lookWDB() searches the chain of idilangx structures to         */
/*|to see if data for the passed CSECT has already been stored. If   */
/*|not, the IDILANGX file is found (or created), and records stored. */
/*|:xmp.                                                             */
LXCONT *lookWDB(LOCL *loclp);
/*|:exmp.                                                            */
/*|:h4.findLXCONT()                                                  */
/*|:p.findLXCONT() searches the chain of idilangx structures and     */
/*|TEST option information structures for the data matching the      */
/*|given CSECT IANCHOR. If successful, the LXCONT pointer is passed  */
/*|back.                                                             */
/*|:xmp.                                                             */
LXCONT *findLXCONT(LOCL *loclp);
/*|:exmp.                                                            */
/*|:h4.eFindXRefs()                                                  */
/*|:p.eFindXRefs() receives a pointer to a LOCL structure and        */
/*|returns a pointer to an XREHF structure containing xref symbol    */
/*|information for the line/stmt.                                    */
/*|:xmp.                                                             */
void eFindXRefs(LOCL *loclp);
/*|:exmp.                                                            */
/*|:h4.SetCOBSYM()                                                   */
/*|:p.SetCOBSYM() creates a COB_SYM structure containing             */
/*|symbol details for formatting the symbol.                         */
/*|:xmp.                                                             */
COB_SYM  *SetCOBSYM(LXSYLO *SLp, LXCONT *COp);
/*|:exmp.                                                            */
/*|:h4.SetPLISYM()                                                   */
/*|:p.SetPLISYM() creates a PLI_SYM structure containing             */
/*|Pli   attributes for a given symbol record.                       */
/*|:xmp.                                                             */
PLI_SYM  *SetPLISYM(LXCONT *COp,/*kenichi _Packed*/ struct symbol_rec5 *sr5ptr);
/*|:exmp.                                                            */
/*|:h4.SetASMSYM()                                                   */
/*|:p.SetASMSYM() creates a ASM_SYM structure containing             */
/*|assembler attributes for a given symbol record.                   */
/*|:xmp.                                                             */
ASM_SYM  *SetASMSYM(LXCONT *COp,/*kenichi _Packed*/ struct symbol_rec5 *sr5ptr);
/*|:exmp.                                                            */
/*|:h4.scanSource()                                                  */
/*|:p.scanSource() attempts to remove Cobol exit statements          */
/*|from a group of source records.                                   */
/*|:xmp.                                                             */
int       scanSource(int *recptr,int line_count);
/*|:exmp.                                                            */
/*|:h4.GetLength()                                                   */
/*|:p.GetLength() calculates the storage length of a symbol.         */
/*|:xmp.                                                             */
int       GetLength(/*keichi _Packed*/ struct symbol_rec5 *sr5ptr,int lang);
/*|:exmp.                                                            */
/*|:h4.transline()                                                   */
/*|:p.transline() unpacks a source line from IDILANGX.               */
/*|:xmp.                                                             */
char     *transline(LXCONT *COp,void *recptr,LOCL *loclp,int actual);
/*|:exmp.                                                            */
/*|:h4.Sym_to_Source()                                               */
/*|:p.Sym_to_Source() locates a Source record using the              */
/*|:statement declaration field from an IDILANGX symbol record.      */
/*|:xmp.                                                             */
LXSOUR   *Sym_to_Source(LXCONT *COp,int dcl);
/*|:exmp.                                                            */
/*|:h4.FindStart()                                                   */
/*|:p.FindStart() locates the starting record in the IDILANGX        */
/*|:file for source and symbol information.                          */
/*|:xmp.                                                             */
LXSOUR   *FindStart(LXCONT *COp,LOCL *loclp,char *wcsect,
                 int *csindexp, int *csectlp);
/*|:exmp.                                                            */
/*|:h4.CobXRefs()                                                    */
/*|:p.CobXRefs() reads all the cross reference records from          */
/*|the IDILANGX file and for the records matching the Cobol          */
/*|line in error, creates a table of matching symbol                 */
/*|information.                                                      */
/*|:xmp.                                                             */
void      CobXRefs(LXCONT *COp,LOCL *loclp);
/*|:exmp.                                                            */
/*|:h4.PliXRefs()                                                    */
/*|:p.PliXRefs() will look for all symbols from the failing          */
/*|:Pli   source line and return them in a table.                    */
/*|:xmp.                                                             */
void      PliXRefs(LXCONT *COp,LOCL *loclp);
/*|:exmp.                                                            */
/*|:h4.gHexBL()                                                      */
/*|:p.gHexBL() locates the base locator numbering system from the    */
/*|stored IDILANGX file (or TEST option data).                       */
/*|:xmp.                                                             */
void gHexBL(LOCL *loclp) ;
/*|:exmp.                                                            */
/*|:h4.FindBaseLoc()                                                 */
/*|:p.FindBaseLoc() finds the base locator of the passed             */
/*|symbol, and passes back the LXBASL structure and updates          */
/*|the offset of the symbol from the base locator.                   */
/*|:xmp.                                                             */
LXBASL *FindBaseLoc(LXCONT *COp,LXSYLO *SLp,int *off) ;
/*|:exmp.                                                            */
/*|:h4.compare2()                                                    */
/*|:p.compare2() is used in a binary search for quick access         */
/*|to a table of source record pointers.                             */
/*|:xmp.                                                             */
int compare2(const void *arg1, const void *arg2);
/*|:exmp.                                                            */
/*|:h4.sindSymbol()                                                  */
/*|:p.findSymbol() performs a binary search to find the              */
/*|correct Id entry in the Symbol Lookup table.                      */
/*|:xmp.                                                             */
LXSYLO *findSymbol(LXCONT *COp,int id );
/*|:exmp.                                                            */
/*|:h4.AddSepList()                                                  */
/*|:p.AddSepList() adds the list section of a separate side-file     */
/*|into storage to look the same as IDILANGX source records.         */
/*|:xmp.                                                             */
void    AddSepList(IANCHOR *pIAcs,char *progname,SFDATA *pInfo,int lcount,
        SFNAME *pside);
/*|:exmp.                                                            */
/*|:h4.AddSepSym()                                                   */
/*|:p.AddSepSym() adds the attributes table information of a         */
/*|separate side-file                                                */
/*|into storage to look the same as IDILANGX symbol records.         */
/*|:xmp.                                                             */
void    AddSepSym(IANCHOR *pIAcs,char *progname,SFDATA *pInfo);
/*|:exmp.                                                            */
/*|:h4.FmtPliDcl()                                                   */
/*|:p.FmtPliDcl() formats a PL/I declaration line.                   */
/*|:xmp.                                                             */
void    FmtPliDcl(PLISTG *pst, char *line);
/*|:exmp.                                                            */
/*|:h4.PackRead()                                                    */
/*|:p.PackRead() performs a basic fread function but takes into      */
/*|account whether the file has been PACKed via ISPF, and unpacks    */
/*|each record if it is.                                             */
/*|:xmp.                                                             */
int     PackRead(PACKCNT *PX, char *buf, int size, FILE *fcb) ;
/*|:exmp.                                                            */
/*|:h4.runEQAUEDAT()                                                 */
/*|:p.runEQAUEDAT() calls the user exit to see if there is an        */
/*|alternative dataset name to use for the TEST option sidefile.     */
/*|:xmp.                                                             */
int     runEQAUEDAT(char *dsn,char *compunm,int langcode,IANCHOR *pIAcs,
                    char *module);
/*|:exmp.                                                            */

/*|:h4.GetOprBL()
/*|:p.This external function return a string describing base locators referenced
/*|by the instruction operands given in the passed DSM struct.
/*|It returns a pointer to a presentation-ready string which the caller should f
/*|:xmp.*/

int GetOprBL(DSM *pDSM,
             KANCHOR *pKAgpr,
             IANCHOR *pIAcsect,
             char *bl_opr,
             int cobolo);

/*|:exmp.*/
