/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core;

import com.ibm.cdz.common.extnpt.api.IDiagnosticObject;
import com.ibm.cdz.common.extnpt.api.IGeneralObject;
import com.ibm.cdz.common.extnpt.api.IListingObject;
import com.ibm.cdz.common.extnpt.api.IRemoteCompileObject;
import com.ibm.ftt.language.manager.impl.Language;
import com.ibm.ftt.projects.core.logical.ILogicalFile;
import com.ibm.ftt.resources.core.physical.IPhysicalFile;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import java.util.StringTokenizer;
import java.util.Vector;

public class CPPLanguage
extends Language {
    public Vector getLibraries(boolean remote, IPhysicalFile source, Object editObject, String library) {
        return null;
    }

    public boolean doesSupportErrorFeedback(Object resource) {
        return true;
    }

    public String getCompileProcedureName(Object resource) {
        if (!this.isUsingC(resource)) {
            return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.MAINMODULE");
        }
        return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.CMAINMODULE");
    }

    public String getCompileStepName(Object resource) {
        if (!this.isUsingC(resource)) {
            return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.DATASETNAME");
        }
        return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.CDATASETNAME");
    }

    public String getErrorFeedbackQualifier(Object resource) {
        if (!this.isUsingC(resource)) {
            return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.SYSEVENT");
        }
        return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.CSYSEVENT");
    }

    public String getListingDataSetName(Object resource) {
        if (!this.isUsingC(resource)) {
            return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.LISTINGOUTPUT");
        }
        return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.CLISTINGOUTPUT");
    }

    public String getObjectDeckDataSetName(Object resource) {
        if (!this.isUsingC(resource)) {
            return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.OBJECTDECK");
        }
        return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.COBJECTDECK");
    }

    public String getSyslibDataSetName(Object resource) {
        if (!this.isUsingC(resource)) {
            return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.SYSLIB");
        }
        return this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.CSYSLIB");
    }

    public String getCompileOptions(Object resource) {
        return null;
    }

    private String getUserLibraries(Object resource, boolean isUsingC) {
        String[] libraries;
        String userLib;
        String string = userLib = !isUsingC ? this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.USERLIB") : this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.CUSERLIB");
        if (userLib != null && userLib.length() > 0 && (libraries = userLib.split(" ")) != null) {
            StringBuffer buffer = new StringBuffer(" LSEARCH(");
            int i = 0;
            while (i < libraries.length) {
                buffer.append("'" + libraries[i] + "'");
                if (i != libraries.length - 1) {
                    buffer.append(",\n");
                }
                ++i;
            }
            buffer.append(")");
            return buffer.toString();
        }
        return null;
    }

    private String getMacros(Object resource, boolean isUsingC) {
        String[] macros;
        String macroString;
        String string = macroString = !isUsingC ? this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.MACROS") : this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.CMACROS");
        if (macroString != null && macroString.length() > 0 && (macros = macroString.split(" ")) != null) {
            StringBuffer buffer = new StringBuffer(" DEFINE(");
            int i = 0;
            while (i < macros.length) {
                buffer.append(macros[i]);
                if (i != macros.length - 1) {
                    buffer.append(",");
                }
                ++i;
            }
            buffer.append(")");
            return buffer.toString();
        }
        return null;
    }

    public String getAdditionalJCL(Object resource) {
        String options = this.getOptions(resource);
        if (!this.isUsingC(resource)) {
            String add = this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.ADDITIONALJCL");
            add = add != null ? add : "";
            return String.valueOf(options) + add;
        }
        String add = this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.CADDITIONALJCL");
        add = add != null ? add : "";
        return String.valueOf(options) + add;
    }

    private String getOptions(Object resource) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("//OPTION DD DATA,DLM='@@'\n");
        boolean isUsingC = this.isUsingC(resource);
        String compileOptions = "";
        String options = !isUsingC ? this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.OPTIONS") : this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.COPTIONS");
        String userLib = this.getUserLibraries(resource, isUsingC);
        String macros = this.getMacros(resource, isUsingC);
        compileOptions = String.valueOf(options != null ? options : "") + (userLib != null ? userLib : "") + (macros != null ? macros : "");
        StringTokenizer tokenizer = new StringTokenizer(compileOptions);
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            buffer.append("\n");
        }
        buffer.append("@@\n");
        return buffer.toString();
    }

    public String getUserSubstitutionVariables(Object resource) {
        return this.manager.getPropertyOrOverride(resource, "CPP.USERVAR.PROPERTY");
    }

    private boolean isUsingC(Object resource) {
        String useC = this.manager.getPropertyOrOverride(resource, "CPP.COMPILE.USEC");
        if (useC != null) {
            return useC.equalsIgnoreCase("TRUE");
        }
        return false;
    }

    private boolean isCPPResource(Object resource) {
        String ext;
        String nameWithExt;
        String name;
        if (resource instanceof ILogicalFile && ((ILogicalFile)resource).getFileExtension() != null) {
            return ((ILogicalFile)resource).getFileExtension().equalsIgnoreCase("cpp");
        }
        if (resource instanceof MVSFileResource && !(name = ((MVSFileResource)resource).getName()).equals(nameWithExt = ((MVSFileResource)resource).getNameWithExt()) && (ext = nameWithExt.substring(name.length() + 1)) != null) {
            return ext.equals("cpp");
        }
        return false;
    }

    private StringBuffer writeOptions(Object resource, IRemoteCompileObject compileObj) {
        String define;
        StringBuffer parmString = new StringBuffer();
        parmString.append("//OPTION DD DATA,DLM=@@\n");
        String userIncludePath = compileObj.getGeneralObject().getIncludePath();
        if (userIncludePath != null && userIncludePath.length() > 0) {
            parmString.append("LSEARCH(");
            parmString.append(this.getSearchPath(userIncludePath));
            parmString.append(")\n");
        }
        if ((define = compileObj.getGeneralObject().getDEFINE()) != null && define.length() > 0) {
            parmString.append("DEFINE(");
            parmString.append(define);
            parmString.append(")\n");
        }
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isPPONLY(), "PPONLY", compileObj.getGeneralObject().getPPONLY_Filename());
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isCSECT(), "CSECT", compileObj.getGeneralObject().getCSECT_Text());
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isEXPORTALL(), "EXPORTALL", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isLONGNAME(), "LONGNAME", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isSTART(), "STA", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isXREF(), "XREF", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isOFFSET(), "OFFSET", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isSHOWINC(), "SHOWINC", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isEXPMAC(), "EXPMAC", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isSOURCE(), "SOURCE", compileObj.getListingObject().getFilename());
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isOPTIMIZE(), "OPT", compileObj.getGeneralObject().getOPTIMIZE_Level());
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isLIST(), "LIST", compileObj.getListingObject().getFilename());
        this.handleTESTProperty(parmString, resource, compileObj.getDiagnosticObject());
        if (this.isCPPResource(resource)) {
            this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isTEMPINC(), "TEMPINC", compileObj.getGeneralObject().getTEMPINC_Location());
            if (compileObj.getGeneralObject().isSEQNUMBER() && compileObj.getGeneralObject().isUseMN()) {
                parmString.append("SEQ(" + compileObj.getGeneralObject().getSEQ_M() + "," + compileObj.getGeneralObject().getSEQ_N() + ")\n");
            } else {
                this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isSEQNUMBER(), "SEQ", null);
            }
            this.handleATTRIBUTEOption(parmString, compileObj.getListingObject());
            this.handleINFOOption(parmString, compileObj.getDiagnosticObject());
            parmString.append(compileObj.getOtherObject().getCppOptions());
            parmString.append(compileObj.getOtherObject().getCOrCppOptions());
        } else {
            this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isSEQNUMBER(), "SEQ", String.valueOf(compileObj.getGeneralObject().getSEQ_M()) + "," + compileObj.getGeneralObject().getSEQ_N());
            this.handleDLLOption(parmString, compileObj.getGeneralObject());
            this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isRENT(), "RENT", null);
            this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isAGGREGATE(), "AGGREGATE", null);
            this.handleCHECKOUTOption(parmString, compileObj.getDiagnosticObject());
            parmString.append(compileObj.getOtherObject().getCOptions());
            parmString.append(compileObj.getOtherObject().getCOrCppOptions());
        }
        parmString.append("@@\n");
        return parmString;
    }

    private void handleCHECKOUTOption(StringBuffer parmString, IDiagnosticObject obj) {
        if (obj.isINFO()) {
            if (obj.isCHECKOUT_ALL()) {
                parmString.append("CHECKOUT(ALL)\n");
            } else if (obj.isCHECKOUT_NONE()) {
                parmString.append("CHECKOUT(NONE)\n");
            } else {
                parmString.append("CHECKOUT(");
                this.handleBooleanProperty(parmString, obj.isACCURACY(), "AC,", null);
                this.handleBooleanProperty(parmString, obj.isENUM(), "EN,", null);
                this.handleBooleanProperty(parmString, obj.isEXTERN(), "EX,", null);
                this.handleBooleanProperty(parmString, obj.isGENERAL(), "GE,", null);
                this.handleBooleanProperty(parmString, obj.isGOTO(), "GO,", null);
                this.handleBooleanProperty(parmString, obj.isINIT(), "I,", null);
                this.handleBooleanProperty(parmString, obj.isPARM(), "PAR,", null);
                this.handleBooleanProperty(parmString, obj.isPORT(), "POR,", null);
                this.handleBooleanProperty(parmString, obj.isPPC(), "PPC,", null);
                this.handleBooleanProperty(parmString, obj.isPPT(), "PPT,", null);
                this.handleBooleanProperty(parmString, obj.isTRUNC(), "TRU", null);
                parmString.append(")\n");
            }
        } else {
            parmString.append("NOCHECKOUT\n");
        }
    }

    private void handleDLLOption(StringBuffer parmString, IGeneralObject obj) {
        if (obj.isDLL()) {
            parmString.append("DLL(");
            this.handleBooleanProperty(parmString, obj.isCALLBACKANY(), "CBA", null);
            parmString.append(")");
        } else {
            parmString.append("NODLL ");
        }
        parmString.append("\n");
    }

    private void handleINFOOption(StringBuffer parmString, IDiagnosticObject obj) {
        if (obj.isINFO()) {
            if (obj.isINFO_ALL()) {
                parmString.append("INFO(ALL)\n");
            } else if (obj.isINFO_NONE()) {
                parmString.append("INFO(NONE)\n");
            } else {
                parmString.append("INFO(");
                this.handleBooleanProperty(parmString, obj.isCLS(), "CLS,", null);
                this.handleBooleanProperty(parmString, obj.isCMP(), "CMP,", null);
                this.handleBooleanProperty(parmString, obj.isCND(), "CND,", null);
                this.handleBooleanProperty(parmString, obj.isCNV(), "CNV,", null);
                this.handleBooleanProperty(parmString, obj.isCNS(), "CNS,", null);
                this.handleBooleanProperty(parmString, obj.isCPY(), "CPY,", null);
                this.handleBooleanProperty(parmString, obj.isEFF(), "EFF,", null);
                this.handleBooleanProperty(parmString, obj.isENU(), "ENU,", null);
                this.handleBooleanProperty(parmString, obj.isGEN(), "GEN,", null);
                this.handleBooleanProperty(parmString, obj.isGNR(), "GNR,", null);
                this.handleBooleanProperty(parmString, obj.isLAN(), "LAN,", null);
                this.handleBooleanProperty(parmString, obj.isPAR(), "PAR,", null);
                this.handleBooleanProperty(parmString, obj.isPOR(), "POR,", null);
                this.handleBooleanProperty(parmString, obj.isPPC(), "PPC,", null);
                this.handleBooleanProperty(parmString, obj.isPPT(), "PPT,", null);
                this.handleBooleanProperty(parmString, obj.isREA(), "REA,", null);
                this.handleBooleanProperty(parmString, obj.isRET(), "RET,", null);
                this.handleBooleanProperty(parmString, obj.isTRD(), "TRD,", null);
                this.handleBooleanProperty(parmString, obj.isUND(), "UND,", null);
                this.handleBooleanProperty(parmString, obj.isUSE(), "USE,", null);
                this.handleBooleanProperty(parmString, obj.isVFT(), "VFT", null);
                parmString.append(")\n");
            }
        } else {
            parmString.append("NOINFO\n");
        }
    }

    private void handleATTRIBUTEOption(StringBuffer parmString, IListingObject listingObject) {
        if (listingObject.isATTRIBUTE()) {
            parmString.append("ATTRIBUTE(");
            this.handleBooleanProperty(parmString, listingObject.isFULL(), "FULL", null);
            parmString.append(")\n");
        } else {
            parmString.append("NOATTRIBUTE\n");
        }
    }

    private void handleTESTProperty(StringBuffer buffer, Object resource, IDiagnosticObject obj) {
        if (obj.isTEST()) {
            if (this.isCPPResource(resource)) {
                buffer.append("TEST(");
                this.handleBooleanProperty(buffer, obj.isHOOK(), "HOOK", null);
                buffer.append(")");
            } else {
                buffer.append("TEST(");
                this.handleBooleanProperty(buffer, obj.isHOOK(), "HOOK,", null);
                this.handleBooleanProperty(buffer, obj.isSYM(), "SYM,", null);
                this.handleBooleanProperty(buffer, obj.isBLOCK(), "BLOCK,", null);
                this.handleBooleanProperty(buffer, obj.isLINE(), "LINE,", null);
                this.handleBooleanProperty(buffer, obj.isPATH(), "PATH", null);
                buffer.append(")");
            }
            buffer.append("\n");
        } else {
            buffer.append("NOTEST\n");
        }
    }

    private void handleBooleanPropertyWithNewLine(StringBuffer parmString, boolean booleanValue, String propertyName, String propertyValue) {
        this.handleBooleanProperty(parmString, booleanValue, propertyName, propertyValue);
        parmString.append('\n');
    }

    private void handleBooleanProperty(StringBuffer parmString, boolean booleanValue, String propertyName, String propertyValue) {
        if (booleanValue) {
            parmString.append(propertyName);
            if (propertyValue != null && propertyValue.length() > 0) {
                parmString.append("(");
                parmString.append(propertyValue);
                parmString.append(")");
            }
        } else {
            parmString.append("NO");
            parmString.append(propertyName);
        }
    }

    private String getSearchPath(String path) {
        String[] items = path.split(",");
        if (items != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                buffer.append("'");
                buffer.append(items[i]);
                buffer.append("'");
                if (i + 1 < items.length) {
                    buffer.append(",");
                }
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    public Vector getGlobalSubstitutionVariables(Object resource) {
        Vector<String> globalVarVector = null;
        String globalVars = this.manager.getPropertyOrOverride(resource, "CPP.GLOBALVAR.PROPERTY");
        if (globalVars != null) {
            globalVarVector = new Vector<String>();
            StringTokenizer st = new StringTokenizer(globalVars, ";");
            while (st.hasMoreTokens()) {
                globalVarVector.add(st.nextToken());
            }
        }
        return globalVarVector;
    }
}

