/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core;

import com.ibm.cdz.common.TraceUtil;
import com.ibm.cdz.remote.core.editor.DefaultResourceResolver;
import com.ibm.ftt.resources.core.impl.CacheManager;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.rse.mvs.client.subsystems.MVSFileSubSystem;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;

public class MVSResourceResolver
extends DefaultResourceResolver {
    public ISystemEditableRemoteObject getRemoteEditable(IFile file, boolean forceConnect) {
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        ISystemEditableRemoteObject editable = (ISystemEditableRemoteObject)properties.getRemoteFileObject();
        if (editable != null) {
            return editable;
        }
        String subsystemPath = properties.getRemoteFileSubSystem();
        String path = properties.getRemoteFilePath();
        if (path != null && path.length() > 0) {
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            ISubSystem subSystem = sr.getSubSystem(subsystemPath);
            String hostName = subSystem.getHost().getHostName();
            return this.getRemoteEditable(hostName, path, forceConnect);
        }
        return super.getRemoteEditable(file, forceConnect);
    }

    public Object getResource(String locationPath) {
        if (locationPath.startsWith("\\\\")) {
            locationPath = locationPath.substring(2, locationPath.length());
        } else if (locationPath.startsWith("\\")) {
            locationPath = locationPath.substring(1, locationPath.length());
        }
        String[] segs = locationPath.replace('\\', ',').replace('/', ',').split(",");
        String hostname = segs[0];
        String path = locationPath.substring(segs[0].length() + 1).replace('\\', '/');
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IHost[] connections = sr.getHosts();
        int i = 0;
        while (i < connections.length) {
            IHost con = connections[i];
            if (con.getHostName().equalsIgnoreCase(hostname) || con.getAliasName().equalsIgnoreCase(hostname)) {
                ISubSystem[] sses = con.getSubSystems();
                int s = 0;
                while (s < sses.length) {
                    ISubSystem ss = sses[s];
                    if (ss instanceof MVSFileSubSystem && ss.isConnected()) {
                        try {
                            return this.getRemoteFileObject((MVSFileSubSystem)ss, path);
                        }
                        catch (Exception exception) {}
                    }
                    ++s;
                }
            }
            ++i;
        }
        return super.getResource(locationPath);
    }

    private MVSFileResource getRemoteFileObject(MVSFileSubSystem system, String path) throws Exception {
        MVSFileResource res = system.getRemoteFileObject(path);
        if (res != null || res.getZOSResource() == null) {
            path = path.toUpperCase();
            res = system.getRemoteFileObject(path);
        }
        return res;
    }

    public ISystemEditableRemoteObject getRemoteEditable(String locationPath) {
        return this.getRemoteEditable(locationPath, false);
    }

    public ISystemEditableRemoteObject getRemoteEditable(String locationPath, boolean forceConnect) {
        if (locationPath.startsWith("\\\\")) {
            locationPath = locationPath.substring(2, locationPath.length());
        } else if (locationPath.startsWith("\\")) {
            locationPath = locationPath.substring(1, locationPath.length());
        }
        String[] segs = locationPath.replace('\\', ',').replace('/', ',').split(",");
        if (segs != null && segs.length > 1) {
            String hostname = segs[0];
            String path = locationPath.substring(segs[0].length() + 1).replace('\\', '/');
            return this.getRemoteEditable(hostname, path, forceConnect);
        }
        return null;
    }

    private ISystemEditableRemoteObject getCachedResource(String hostname, String path) {
        int slash = path.indexOf("/");
        if (slash != -1) {
            String dataset = path.substring(0, slash);
            String member = path.substring(slash + 1);
            IFolder folder = CacheManager.getFolder((String)hostname, (String)dataset);
            if (folder != null) {
                int dotIndex = member.lastIndexOf(46);
                if (dotIndex > 0) {
                    String baseName = member.substring(0, dotIndex).toUpperCase();
                    String ext = member.substring(dotIndex + 1);
                    member = String.valueOf(baseName) + '.' + ext;
                }
                IFile file = folder.getFile(member);
                SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
                ISystemEditableRemoteObject editable = (ISystemEditableRemoteObject)properties.getRemoteFileObject();
                return editable;
            }
        }
        return null;
    }

    public ISystemEditableRemoteObject getRemoteEditable(String hostname, String path, boolean forceConnect) {
        ISystemEditableRemoteObject cached = this.getCachedResource(hostname, path);
        if (cached != null) {
            return cached;
        }
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IHost[] connections = sr.getHosts();
        ArrayList<ISubSystem> disconnectedSubsystems = new ArrayList<ISubSystem>();
        int i = 0;
        while (i < connections.length) {
            IHost con = connections[i];
            if (con.getHostName().equalsIgnoreCase(hostname) || con.getAliasName().equalsIgnoreCase(hostname)) {
                ISubSystem[] sses = con.getSubSystems();
                int s = 0;
                while (s < sses.length) {
                    ISubSystem ss = sses[s];
                    if (ss instanceof MVSFileSubSystem) {
                        if (ss.isConnected()) {
                            String filePath = path;
                            try {
                                ISystemEditableRemoteObject remoteObject;
                                ISystemRemoteElementAdapter elementAdapter;
                                MVSFileSubSystem mvsSS = (MVSFileSubSystem)ss;
                                System.out.println("getRemoteFileObject " + filePath + "...");
                                long t1 = System.currentTimeMillis();
                                MVSFileResource resource = this.getRemoteFileObject(mvsSS, filePath);
                                long t2 = System.currentTimeMillis();
                                System.out.println("\ttime=" + (t2 - t1) + "ms");
                                if (resource != null && (elementAdapter = (ISystemRemoteElementAdapter)resource.getAdapter(ISystemRemoteElementAdapter.class)).canEdit((Object)resource) && (remoteObject = elementAdapter.getEditableRemoteObject((Object)resource)) != null && remoteObject.exists()) {
                                    remoteObject.checkOpenInEditor();
                                    return remoteObject;
                                }
                            }
                            catch (Exception e) {
                                TraceUtil.getInstance().write(((Object)((Object)this)).getClass().getName(), "File could not be located: e = " + e.getMessage());
                            }
                        } else {
                            disconnectedSubsystems.add(ss);
                        }
                    }
                    ++s;
                }
            }
            ++i;
        }
        int d = 0;
        while (d < disconnectedSubsystems.size() && forceConnect) {
            SubSystem dss = (SubSystem)disconnectedSubsystems.get(d);
            String filePath = path;
            if (dss instanceof FileServiceSubSystem) {
                filePath = String.valueOf('/') + path;
            }
            try {
                ISystemEditableRemoteObject remoteObject;
                ISystemRemoteElementAdapter elementAdapter;
                IAdaptable adaptable = (IAdaptable)dss.getObjectWithAbsoluteName(filePath);
                if (adaptable != null && (elementAdapter = (ISystemRemoteElementAdapter)adaptable.getAdapter(ISystemRemoteElementAdapter.class)).canEdit((Object)adaptable) && (remoteObject = elementAdapter.getEditableRemoteObject((Object)adaptable)) != null && remoteObject.exists()) {
                    return elementAdapter.getEditableRemoteObject((Object)adaptable);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++d;
        }
        return super.getRemoteEditable(hostname, path, forceConnect);
    }
}

