/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.ui.propertypages;

import com.ibm.ftt.cdz.ui.propertypages.CPPCompileOptionsDialog;
import com.ibm.ftt.cdz.ui.propertypages.CPPSettingsPropertyPage;
import com.ibm.ftt.cdz.ui.propertypages.GenericCPPSettingsPage;
import com.ibm.ftt.projects.core.logical.ILogicalResource;
import com.ibm.ftt.properties.ICategoryInstance;
import com.ibm.ftt.resources.core.IJCLProcedureConstants;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.ui.propertypages.JCLProcedure;
import com.ibm.ftt.ui.propertypages.JCLProcedureRoot;
import com.ibm.ftt.ui.propertypages.JCLProcedureStep;
import com.ibm.ftt.ui.propertypages.PBBaseTab;
import com.ibm.ftt.ui.propertypages.PropertyPageHelper;
import com.ibm.ftt.ui.propertypages.PropertyPagesResources;
import com.ibm.ftt.ui.propertypages.ZOSBuildPropertiesContentProvider;
import com.ibm.ftt.ui.propertypages.ZOSBuildPropertiesLabelProvider;
import com.ibm.ftt.ui.propertypages.core.PBPropertiesUtil;
import com.ibm.ftt.ui.propertypages.dialogs.JCLProcedureAddStepDialog;
import com.ibm.ftt.ui.propertypages.dialogs.UserStepDialog;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class CPPTab
extends PBBaseTab
implements IJCLProcedureConstants,
ICellModifier {
    private TableTreeViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private Button fEnableButton;
    private Button fDisableButton;
    private TableTree tableTree;
    private Table table;
    private TableLayout tableLayout;
    private Properties _fProperties = null;
    private static final String[] columnHeaders = new String[]{PropertyPagesResources.NewPropertiesTab_procColumnName, PropertyPagesResources.NewPropertiesTab_stepColumnName, PropertyPagesResources.NewPropertiesTab_enabledColumnName};
    private static ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(20, 80, true), new ColumnWeightData(20, 80, true), new ColumnWeightData(20, 80, true), new ColumnWeightData(55, 80, false)};
    private static final String P_PROC = "proc";
    private static final String P_STEP = "step";
    private static final String P_STATUS = "status";
    private static final String P_DUMMY = "dummy";
    private static final String[] tableColumnProperties = new String[]{"proc", "step", "status", "dummy"};
    private CellEditor enabledCellEditor;
    private CellEditor currCellEditor;
    private static final String[] enabledStateStrings = new String[]{PropertyPagesResources.NewPropertiesTab_disabled, PropertyPagesResources.NewPropertiesTab_enabled};
    private static final int COLUMN_ENABLED = 2;
    private static final boolean[] enabledStates = new boolean[]{Boolean.FALSE, Boolean.TRUE};
    private JCLProcedureRoot fRoot = new JCLProcedureRoot();
    private boolean calledFromMVSFiles = false;
    private String fDirName = "";
    private JCLProcedure cCompileProc;
    private JCLProcedure cppCompileProc;
    private ICategoryInstance instance;
    private PropertyPageHelper helper;

    public CPPTab(PropertyPageHelper helper) {
        this.helper = helper;
    }

    public void setCalledFromMVSFiles(boolean flag) {
        this.calledFromMVSFiles = flag;
    }

    public Control getControl(Composite ancestor) {
        this.fShell = ancestor.getParent().getShell();
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.createHorizontalFiller(parent, 1);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        this.tableTree = new TableTree(innerParent, 66308);
        this.tableTree.setLayoutData((Object)new GridData(1808));
        this.table = this.tableTree.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableLayout = new TableLayout();
        this.table.setLayout((Layout)this.tableLayout);
        this.fTableViewer = new TableTreeViewer(this.tableTree);
        this.createColumns();
        this.fTableViewer.setColumnProperties(tableColumnProperties);
        this.fTableViewer.setCellModifier((ICellModifier)this);
        CellEditor[] editors = new CellEditor[columnHeaders.length];
        editors[2] = this.enabledCellEditor = new ComboBoxCellEditor((Composite)this.table, enabledStateStrings, 8);
        this.fTableViewer.setCellEditors(editors);
        this.fTableViewer.setContentProvider((IContentProvider)new ZOSBuildPropertiesContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ZOSBuildPropertiesLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CPPTab.this.updateButtons();
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (CPPTab.this.fEditButton.isEnabled()) {
                    CPPTab.this.invokeEdit();
                }
                if (CPPTab.this.fAddButton.isEnabled()) {
                    CPPTab.this.invokeAdd();
                }
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(PropertyPagesResources.NewPropertiesTab_editButton);
        this.fEditButton.setLayoutData((Object)new GridData(768));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CPPTab.this.invokeEdit();
            }
        });
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(PropertyPagesResources.NewPropertiesTab_addButton);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CPPTab.this.invokeAdd();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText(PropertyPagesResources.NewPropertiesTab_removeButton);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CPPTab.this.invokeRemove();
            }
        });
        this.fUpButton = new Button(buttons, 8);
        this.fUpButton.setText(PropertyPagesResources.NewPropertiesTab_upButton);
        this.fUpButton.setLayoutData((Object)new GridData(768));
        this.fUpButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CPPTab.this.invokeUp();
            }
        });
        this.fDownButton = new Button(buttons, 8);
        this.fDownButton.setText(PropertyPagesResources.NewPropertiesTab_downButton);
        this.fDownButton.setLayoutData((Object)new GridData(768));
        this.fDownButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CPPTab.this.invokeDown();
            }
        });
        this.fEnableButton = new Button(buttons, 8);
        this.fEnableButton.setText(PropertyPagesResources.NewPropertiesTab_enableButton);
        this.fEnableButton.setLayoutData((Object)new GridData(768));
        this.fEnableButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CPPTab.this.invokeEnable();
            }
        });
        this.fDisableButton = new Button(buttons, 8);
        this.fDisableButton.setText(PropertyPagesResources.NewPropertiesTab_disableButton);
        this.fDisableButton.setLayoutData((Object)new GridData(768));
        this.fDisableButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CPPTab.this.invokeDisable();
            }
        });
        this.updateButtons();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ftt.cdz.core.procsteptab");
        return parent;
    }

    public Properties fillNewProperties() {
        this.setMvsFilesProperties();
        return this.getRememberedProperties();
    }

    public void initializeSystemPropertyPage(Properties fProperties, String dirName) {
        this.populatePageValues(fProperties, dirName);
    }

    public void rememberProperties(Properties props) {
        this._fProperties = props;
    }

    public Properties getRememberedProperties() {
        return this._fProperties;
    }

    public void populatePageValues(Properties props, String dirName) {
        if (props != null) {
            this.removeProcsAndSteps();
            Properties newProps = new Properties(props);
            this.fDirName = dirName;
            String cppCompileProcName = newProps.getProperty("CPP.COMPILE.MAINMODULE");
            this.cppCompileProc = new JCLProcedure(cppCompileProcName, 25);
            this.cppCompileProc.setEnabled(true);
            this.fRoot.addJCLProcedure(this.cppCompileProc);
            String cCompileProcName = newProps.getProperty("CPP.COMPILE.CMAINMODULE");
            this.cCompileProc = new JCLProcedure(cCompileProcName, 26);
            String useC = newProps.getProperty("CPP.COMPILE.USEC");
            if (useC.equalsIgnoreCase("true")) {
                this.cCompileProc.setEnabled(true);
                this.cppCompileProc.setEnabled(false);
            } else {
                this.cCompileProc.setEnabled(false);
                this.cppCompileProc.setEnabled(true);
            }
            this.fRoot.addJCLProcedure(this.cCompileProc);
            String cppCompileStepName = newProps.getProperty("CPP.COMPILE.DATASETNAME");
            this.createStepsFromProps(cppCompileStepName, 20, this.cppCompileProc);
            String cCompileStepName = newProps.getProperty("CPP.COMPILE.CDATASETNAME");
            this.createStepsFromProps(cCompileStepName, 20, this.cCompileProc);
            String listingDataset = newProps.getProperty("CPP.COMPILE.LISTINGOUTPUT");
            String objectDeck = newProps.getProperty("CPP.COMPILE.OBJECTDECK");
            String sysLibs = newProps.getProperty("CPP.COMPILE.SYSLIB");
            String userLibs = newProps.getProperty("CPP.COMPILE.USERLIB");
            String xmlDSHlq = newProps.getProperty("CPP.COMPILE.SYSEVENT");
            if (dirName != null && !dirName.equalsIgnoreCase("")) {
                if (listingDataset != null && listingDataset.startsWith("<")) {
                    listingDataset = PBPropertiesUtil.replaceTempHLQ((String)listingDataset, (String)dirName);
                }
                if (objectDeck != null && objectDeck.startsWith("<")) {
                    objectDeck = PBPropertiesUtil.replaceTempHLQ((String)objectDeck, (String)dirName);
                }
                if (sysLibs != null && sysLibs.startsWith("<")) {
                    sysLibs = PBPropertiesUtil.replaceTempHLQ((String)sysLibs, (String)dirName);
                }
                if (userLibs != null && userLibs.startsWith("<")) {
                    userLibs = PBPropertiesUtil.replaceTempHLQ((String)userLibs, (String)dirName);
                }
                if (xmlDSHlq != null && xmlDSHlq.startsWith("<")) {
                    xmlDSHlq = PBPropertiesUtil.replaceTempHLQ((String)xmlDSHlq, (String)dirName);
                }
            }
            newProps.setProperty("CPP.COMPILE.LISTINGOUTPUT", listingDataset);
            newProps.setProperty("CPP.COMPILE.OBJECTDECK", objectDeck);
            newProps.setProperty("CPP.COMPILE.SYSLIB", sysLibs);
            newProps.setProperty("CPP.COMPILE.USERLIB", userLibs);
            newProps.setProperty("CPP.COMPILE.SYSEVENT", xmlDSHlq);
            listingDataset = newProps.getProperty("CPP.COMPILE.CLISTINGOUTPUT");
            objectDeck = newProps.getProperty("CPP.COMPILE.COBJECTDECK");
            sysLibs = newProps.getProperty("CPP.COMPILE.CSYSLIB");
            userLibs = newProps.getProperty("CPP.COMPILE.CUSERLIB");
            xmlDSHlq = newProps.getProperty("CPP.COMPILE.CSYSEVENT");
            if (dirName != null && !dirName.equalsIgnoreCase("")) {
                if (listingDataset != null && listingDataset.startsWith("<")) {
                    listingDataset = PBPropertiesUtil.replaceTempHLQ((String)listingDataset, (String)dirName);
                }
                if (objectDeck != null && objectDeck.startsWith("<")) {
                    objectDeck = PBPropertiesUtil.replaceTempHLQ((String)objectDeck, (String)dirName);
                }
                if (sysLibs != null && sysLibs.startsWith("<")) {
                    sysLibs = PBPropertiesUtil.replaceTempHLQ((String)sysLibs, (String)dirName);
                }
                if (userLibs != null && userLibs.startsWith("<")) {
                    userLibs = PBPropertiesUtil.replaceTempHLQ((String)userLibs, (String)dirName);
                }
                if (xmlDSHlq != null && xmlDSHlq.startsWith("<")) {
                    xmlDSHlq = PBPropertiesUtil.replaceTempHLQ((String)xmlDSHlq, (String)dirName);
                }
            }
            newProps.setProperty("CPP.COMPILE.CLISTINGOUTPUT", listingDataset);
            newProps.setProperty("CPP.COMPILE.COBJECTDECK", objectDeck);
            newProps.setProperty("CPP.COMPILE.CSYSLIB", sysLibs);
            newProps.setProperty("CPP.COMPILE.CUSERLIB", userLibs);
            newProps.setProperty("CPP.COMPILE.CSYSEVENT", xmlDSHlq);
            this.rememberProperties(newProps);
            this.fTableViewer.setInput((Object)this.fRoot);
        }
    }

    private void createStepsFromProps(String stepNamesString, int defaultType, JCLProcedure proc) {
        int index = stepNamesString.indexOf(":");
        if (index > -1) {
            StringTokenizer st = new StringTokenizer(stepNamesString, ":");
            while (st.hasMoreTokens()) {
                int realType;
                String token = st.nextToken();
                int typeIndex = token.indexOf(44);
                if (typeIndex != -1) {
                    realType = Integer.decode(token.substring(typeIndex + 1));
                    token = token.substring(0, typeIndex);
                } else {
                    realType = defaultType;
                }
                JCLProcedureStep step = new JCLProcedureStep(token, realType);
                proc.addStep(step);
                step.setProc(proc);
            }
        } else {
            JCLProcedureStep step = new JCLProcedureStep(stepNamesString, defaultType);
            proc.addStep(step);
            step.setProc(proc);
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator it = selection.iterator();
        if (selection.size() > 1 || selection.size() == 0) {
            this.fAddButton.setEnabled(false);
            this.fEditButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
            this.fEnableButton.setEnabled(false);
            this.fDisableButton.setEnabled(false);
        }
        Object element = null;
        while (it.hasNext()) {
            element = it.next();
        }
        if (element != null && element instanceof JCLProcedure) {
            JCLProcedure proc = element;
            if (proc.isEnabled()) {
                this.fAddButton.setEnabled(true);
                this.fDisableButton.setEnabled(true);
                this.fEnableButton.setEnabled(false);
            } else {
                this.fAddButton.setEnabled(false);
                this.fDisableButton.setEnabled(false);
                this.fEnableButton.setEnabled(true);
            }
            this.fEditButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        }
        if (element != null && element instanceof JCLProcedureStep) {
            JCLProcedureStep step = element;
            this.fAddButton.setEnabled(false);
            this.fEnableButton.setEnabled(false);
            this.fDisableButton.setEnabled(false);
            if (step.getProc().isEnabled()) {
                this.fEditButton.setEnabled(true);
                this.fRemoveButton.setEnabled(true);
            } else {
                this.fEditButton.setEnabled(false);
                this.fRemoveButton.setEnabled(false);
            }
            this.updateUpAndDownButtons(element);
        }
    }

    public void invokeEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator it = selection.iterator();
        Object element = null;
        while (it.hasNext()) {
            element = it.next();
        }
        if (element instanceof JCLProcedureStep) {
            JCLProcedureStep step = element;
            int type = step.getType();
            if (type == 20) {
                JCLProcedure proc = step.getProc();
                if (proc.getType() == 25) {
                    CPPCompileOptionsDialog dialog = new CPPCompileOptionsDialog(this.fShell, proc, this.fDirName, this.getRememberedProperties(), false, this.instance, this.helper);
                    dialog.open();
                    this.rememberProperties(dialog.getChangedProperties());
                } else if (proc.getType() == 26) {
                    CPPCompileOptionsDialog dialog = new CPPCompileOptionsDialog(this.fShell, proc, this.fDirName, this.getRememberedProperties(), false, this.instance, this.helper);
                    dialog.open();
                    this.rememberProperties(dialog.getChangedProperties());
                }
            } else if (type == 21) {
                JCLProcedure proc = step.getProc();
                UserStepDialog dialog = new UserStepDialog(this.fShell, step, this.createMiniPropertiesFile(proc), "com.ibm.ftt.cdz.core.stepoptions");
                dialog.open();
                this.updateFullPropertiesFile(proc, dialog.getChangedProperties());
            }
        }
        this.fTableViewer.refresh();
    }

    private void updateFullPropertiesFile(JCLProcedure proc, Properties miniProps) {
        boolean isCProperties;
        Properties fullProps = this.getRememberedProperties();
        String options = miniProps.getProperty("COBOL.STEP.OPTIONS");
        String addJCL = miniProps.getProperty("COBOL.STEP.ADDITIONALJCL");
        if (options == null) {
            options = "";
        }
        if (addJCL == null) {
            addJCL = "";
        }
        boolean bl = isCProperties = proc.getType() == 26;
        if (this.instance == null) {
            fullProps.setProperty(isCProperties ? "CPP.STEP.COPTIONS" : "CPP.STEP.OPTIONS", options);
            fullProps.setProperty(isCProperties ? "CPP.STEP.CADDITIONALJCL" : "CPP.STEP.ADDITIONALJCL", addJCL);
        } else {
            this.setValue(this.instance, isCProperties ? "C_ADDED_STEP_OPTIONS" : "CPP_ADDED_STEP_OPTIONS", options);
            this.setValue(this.instance, isCProperties ? "C_ADDED_STEP_ADDITIONAL_JCL" : "CPP_ADDED_STEP_ADDITIONAL_JCL", addJCL);
        }
        this.rememberProperties(fullProps);
    }

    public void invokeAdd() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator it = selection.iterator();
        Object element = null;
        while (it.hasNext()) {
            element = it.next();
        }
        if (element instanceof JCLProcedure) {
            JCLProcedureAddStepDialog dialog = new JCLProcedureAddStepDialog(this.fShell, (JCLProcedure)element, this.createMiniPropertiesFile(element), "com.ibm.ftt.cdz.core.newstep");
            dialog.open();
            this.updateFullPropertiesFile(element, dialog.getChangedProperties());
        }
        this.fTableViewer.refresh();
    }

    private Properties createMiniPropertiesFile(JCLProcedure proc) {
        Properties miniProps = new Properties();
        Properties fullProps = this.getRememberedProperties();
        boolean isCProperties = proc.getType() == 26;
        String options = null;
        String addJCL = null;
        if (this.instance == null) {
            options = fullProps.getProperty(isCProperties ? "CPP.STEP.COPTIONS" : "CPP.STEP.OPTIONS");
            addJCL = fullProps.getProperty(isCProperties ? "CPP.STEP.CADDITIONALJCL" : "CPP.STEP.ADDITIONALJCL");
        } else {
            options = this.getInstanceValue(this.instance, isCProperties ? "C_ADDED_STEP_OPTIONS" : "CPP_ADDED_STEP_OPTIONS");
            addJCL = this.getInstanceValue(this.instance, isCProperties ? "C_ADDED_STEP_ADDITIONAL_JCL" : "CPP_ADDED_STEP_ADDITIONAL_JCL");
        }
        if (options == null) {
            options = "";
        }
        if (addJCL == null) {
            addJCL = "";
        }
        miniProps.setProperty("COBOL.STEP.OPTIONS", options);
        miniProps.setProperty("COBOL.STEP.ADDITIONALJCL", addJCL);
        return miniProps;
    }

    public void invokeRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator it = selection.iterator();
        Object element = null;
        while (it.hasNext()) {
            element = it.next();
        }
        if (element instanceof JCLProcedureStep && MessageDialog.openConfirm((Shell)this.fShell, (String)PropertyPagesResources.RemoveStepAction_removeStepTitle, (String)PropertyPagesResources.RemoveStepAction_removeStepMsg)) {
            JCLProcedureStep step = element;
            step.getProc().removeStep(step);
        }
        this.fTableViewer.refresh();
    }

    public void invokeUp() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator it = selection.iterator();
        Object element = null;
        while (it.hasNext()) {
            element = it.next();
        }
        if (element instanceof JCLProcedureStep) {
            JCLProcedureStep step = element;
            step.moveUp();
        }
        this.fTableViewer.refresh();
        this.updateUpAndDownButtons(element);
    }

    public void invokeDown() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator it = selection.iterator();
        Object element = null;
        while (it.hasNext()) {
            element = it.next();
        }
        if (element instanceof JCLProcedureStep) {
            JCLProcedureStep step = element;
            step.moveDown();
        }
        this.fTableViewer.refresh();
        this.updateUpAndDownButtons(element);
    }

    public void invokeEnable() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator it = selection.iterator();
        Object element = null;
        while (it.hasNext()) {
            element = it.next();
        }
        if (element instanceof JCLProcedure) {
            JCLProcedure proc = element;
            this.updateProcStatus(proc, true);
        }
        this.fTableViewer.refresh();
        this.updateButtons();
    }

    public void invokeDisable() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator it = selection.iterator();
        Object element = null;
        while (it.hasNext()) {
            element = it.next();
        }
        if (element instanceof JCLProcedure) {
            JCLProcedure proc = element;
            this.updateProcStatus(proc, false);
        }
        this.fTableViewer.refresh();
        this.updateButtons();
    }

    protected Properties setMvsFilesProperties() {
        Properties properties = this.getRememberedProperties();
        Vector v = this.fRoot.getJCLProcs();
        int i = 0;
        while (i < v.size()) {
            JCLProcedure proc = (JCLProcedure)v.elementAt(i);
            int type = proc.getType();
            Vector steps = proc.getSteps();
            String concatenatedSteps = "";
            int j = 0;
            while (j < steps.size()) {
                JCLProcedureStep step = (JCLProcedureStep)steps.elementAt(j);
                concatenatedSteps = String.valueOf(concatenatedSteps) + step.getStepName() + "," + step.getType() + ":";
                ++j;
            }
            switch (type) {
                case 25: {
                    if (this.instance == null) {
                        properties.setProperty("CPP.COMPILE.MAINMODULE", proc.getName());
                        properties.setProperty("CPP.COMPILE.DATASETNAME", concatenatedSteps);
                        break;
                    }
                    this.setValue(this.instance, "CPP_COMPILE_JCL_PROCEDURE_NAME", proc.getName());
                    this.setValue(this.instance, "CPP_COMPILE_JOB_STEPS", concatenatedSteps);
                    break;
                }
                case 26: {
                    if (this.instance == null) {
                        properties.setProperty("CPP.COMPILE.CMAINMODULE", proc.getName());
                        properties.setProperty("CPP.COMPILE.CDATASETNAME", concatenatedSteps);
                    } else {
                        this.setValue(this.instance, "C_COMPILE_JCL_PROCEDURE_NAME", proc.getName());
                        this.setValue(this.instance, "C_COMPILE_JOB_STEPS", concatenatedSteps);
                    }
                    if (properties == null) break;
                    if (proc.isEnabled()) {
                        if (this.instance == null) {
                            properties.setProperty("CPP.COMPILE.USEC", "TRUE");
                            break;
                        }
                        this.setValue(this.instance, "CPP_COMPILE_USEC", "TRUE");
                        break;
                    }
                    if (this.instance == null) {
                        properties.setProperty("CPP.COMPILE.USEC", "FALSE");
                        break;
                    }
                    this.setValue(this.instance, "CPP_COMPILE_USEC", "FALSE");
                    break;
                }
            }
            ++i;
        }
        this.rememberProperties(properties);
        return properties;
    }

    private void updateUpAndDownButtons(JCLProcedureStep step) {
        JCLProcedure proc = step.getProc();
        if (proc.isEnabled()) {
            int index = proc.stepIndex(step) + 1;
            int size = proc.getSteps().size();
            this.fUpButton.setEnabled(index != 1);
            this.fDownButton.setEnabled(index != size);
        } else {
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        }
    }

    public void setSystemPropPage(PropertyPage propPage) {
        this.page1 = propPage;
    }

    public void restoreDefaults() {
    }

    protected boolean validatePage() {
        boolean result = true;
        if (this.page != null) {
            this.page.setErrorMessage(null);
        }
        if (result && this.page != null) {
            this.page.setErrorMessage(null);
        }
        return result;
    }

    public void getDefaultValues(IPhysicalResource resource) {
        Properties newProps = new Properties(this.getRememberedProperties());
        newProps.setProperty("CPP.COMPILE.MAINMODULE", this.physicalManager.getDefaultValue("CPP.COMPILE.MAINMODULE", resource));
        newProps.setProperty("CPP.COMPILE.DATASETNAME", this.physicalManager.getDefaultValue("CPP.COMPILE.DATASETNAME", resource));
        newProps.setProperty("CPP.COMPILE.OPTIONS", this.physicalManager.getDefaultValue("CPP.COMPILE.OPTIONS", resource));
        newProps.setProperty("CPP.COMPILE.MACROS", this.physicalManager.getDefaultValue("CPP.COMPILE.MACROS", resource));
        newProps.setProperty("CPP.COMPILE.LISTINGOUTPUT", this.physicalManager.getDefaultValue("CPP.COMPILE.LISTINGOUTPUT", resource));
        newProps.setProperty("CPP.COMPILE.OBJECTDECK", this.physicalManager.getDefaultValue("CPP.COMPILE.OBJECTDECK", resource));
        newProps.setProperty("CPP.COMPILE.SYSEVENT", this.physicalManager.getDefaultValue("CPP.COMPILE.SYSEVENT", resource));
        newProps.setProperty("CPP.COMPILE.ADDITIONALJCL", this.physicalManager.getDefaultValue("CPP.COMPILE.ADDITIONALJCL", resource));
        newProps.setProperty("CPP.COMPILE.CMAINMODULE", this.physicalManager.getDefaultValue("CPP.COMPILE.CMAINMODULE", resource));
        newProps.setProperty("CPP.COMPILE.CDATASETNAME", this.physicalManager.getDefaultValue("CPP.COMPILE.CDATASETNAME", resource));
        newProps.setProperty("CPP.COMPILE.COPTIONS", this.physicalManager.getDefaultValue("CPP.COMPILE.COPTIONS", resource));
        newProps.setProperty("CPP.COMPILE.CMACROS", this.physicalManager.getDefaultValue("CPP.COMPILE.CMACROS", resource));
        newProps.setProperty("CPP.COMPILE.CLISTINGOUTPUT", this.physicalManager.getDefaultValue("CPP.COMPILE.CLISTINGOUTPUT", resource));
        newProps.setProperty("CPP.COMPILE.COBJECTDECK", this.physicalManager.getDefaultValue("CPP.COMPILE.COBJECTDECK", resource));
        newProps.setProperty("CPP.COMPILE.CSYSEVENT", this.physicalManager.getDefaultValue("CPP.COMPILE.CSYSEVENT", resource));
        newProps.setProperty("CPP.COMPILE.CADDITIONALJCL", this.physicalManager.getDefaultValue("CPP.COMPILE.CADDITIONALJCL", resource));
        newProps.setProperty("CPP.COMPILE.USEC", this.physicalManager.getDefaultValue("CPP.COMPILE.USEC", resource));
        this.populatePageValues(newProps, "");
    }

    public void getDefaultValues(ILogicalResource resource) {
        Properties newProps = new Properties(this.getRememberedProperties());
        newProps.setProperty("CPP.COMPILE.MAINMODULE", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.MAINMODULE"));
        newProps.setProperty("CPP.COMPILE.DATASETNAME", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.DATASETNAME"));
        newProps.setProperty("CPP.COMPILE.OPTIONS", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.OPTIONS"));
        newProps.setProperty("CPP.COMPILE.MACROS", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.MACROS"));
        newProps.setProperty("CPP.COMPILE.LISTINGOUTPUT", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.LISTINGOUTPUT"));
        newProps.setProperty("CPP.COMPILE.OBJECTDECK", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.OBJECTDECK"));
        newProps.setProperty("CPP.COMPILE.SYSLIB", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.SYSLIB"));
        newProps.setProperty("CPP.COMPILE.USERLIB", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.USERLIB"));
        newProps.setProperty("CPP.COMPILE.SYSEVENT", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.SYSEVENT"));
        newProps.setProperty("CPP.COMPILE.ADDITIONALJCL", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.ADDITIONALJCL"));
        newProps.setProperty("CPP.COMPILE.CMAINMODULE", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.CMAINMODULE"));
        newProps.setProperty("CPP.COMPILE.CDATASETNAME", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.CDATASETNAME"));
        newProps.setProperty("CPP.COMPILE.COPTIONS", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.COPTIONS"));
        newProps.setProperty("CPP.COMPILE.CMACROS", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.CMACROS"));
        newProps.setProperty("CPP.COMPILE.CLISTINGOUTPUT", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.CLISTINGOUTPUT"));
        newProps.setProperty("CPP.COMPILE.COBJECTDECK", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.COBJECTDECK"));
        newProps.setProperty("CPP.COMPILE.CSYSLIB", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.CSYSLIB"));
        newProps.setProperty("CPP.COMPILE.CUSERLIB", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.CUSERLIB"));
        newProps.setProperty("CPP.COMPILE.CSYSEVENT", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.CSYSEVENT"));
        newProps.setProperty("CPP.COMPILE.CADDITIONALJCL", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.CADDITIONALJCL"));
        newProps.setProperty("CPP.COMPILE.USEC", this.logicalManager.getDefaultValue(resource, "CPP.COMPILE.USEC"));
        this.populatePageValues(newProps, "");
    }

    public void setPropertyValues(IPhysicalResource resource) {
        Properties props = this.setMvsFilesProperties();
        this.physicalManager.setOverride(resource, "CPP.COMPILE.MAINMODULE", props.getProperty("CPP.COMPILE.MAINMODULE"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.DATASETNAME", props.getProperty("CPP.COMPILE.DATASETNAME"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.OPTIONS", props.getProperty("CPP.COMPILE.OPTIONS"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.MACROS", props.getProperty("CPP.COMPILE.MACROS"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.LISTINGOUTPUT", props.getProperty("CPP.COMPILE.LISTINGOUTPUT"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.OBJECTDECK", props.getProperty("CPP.COMPILE.OBJECTDECK"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.SYSLIB", props.getProperty("CPP.COMPILE.SYSLIB"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.USERLIB", props.getProperty("CPP.COMPILE.USERLIB"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.SYSEVENT", props.getProperty("CPP.COMPILE.SYSEVENT"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.ADDITIONALJCL", props.getProperty("CPP.COMPILE.ADDITIONALJCL"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.CMAINMODULE", props.getProperty("CPP.COMPILE.CMAINMODULE"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.CDATASETNAME", props.getProperty("CPP.COMPILE.CDATASETNAME"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.COPTIONS", props.getProperty("CPP.COMPILE.COPTIONS"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.CMACROS", props.getProperty("CPP.COMPILE.CMACROS"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.CLISTINGOUTPUT", props.getProperty("CPP.COMPILE.CLISTINGOUTPUT"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.COBJECTDECK", props.getProperty("CPP.COMPILE.COBJECTDECK"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.CSYSLIB", props.getProperty("CPP.COMPILE.CSYSLIB"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.CUSERLIB", props.getProperty("CPP.COMPILE.CUSERLIB"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.CSYSEVENT", props.getProperty("CPP.COMPILE.CSYSEVENT"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.CADDITIONALJCL", props.getProperty("CPP.COMPILE.CADDITIONALJCL"));
        this.physicalManager.setOverride(resource, "CPP.COMPILE.USEC", props.getProperty("CPP.COMPILE.USEC"));
        this.physicalManager.setOverride(resource, "CPP.STEP.OPTIONS", props.getProperty("CPP.STEP.OPTIONS"));
        this.physicalManager.setOverride(resource, "CPP.STEP.ADDITIONALJCL", props.getProperty("CPP.STEP.ADDITIONALJCL"));
        this.physicalManager.setOverride(resource, "CPP.STEP.COPTIONS", props.getProperty("CPP.STEP.COPTIONS"));
        this.physicalManager.setOverride(resource, "CPP.STEP.CADDITIONALJCL", props.getProperty("CPP.STEP.CADDITIONALJCL"));
    }

    public void setPropertyValues(ILogicalResource resource) {
        Properties props = this.setMvsFilesProperties();
        resource.setPersistentProperty("CPP.COMPILE.MAINMODULE", props.getProperty("CPP.COMPILE.MAINMODULE"));
        resource.setPersistentProperty("CPP.COMPILE.DATASETNAME", props.getProperty("CPP.COMPILE.DATASETNAME"));
        resource.setPersistentProperty("CPP.COMPILE.OPTIONS", props.getProperty("CPP.COMPILE.OPTIONS"));
        resource.setPersistentProperty("CPP.COMPILE.MACROS", props.getProperty("CPP.COMPILE.MACROS"));
        resource.setPersistentProperty("CPP.COMPILE.LISTINGOUTPUT", props.getProperty("CPP.COMPILE.LISTINGOUTPUT"));
        resource.setPersistentProperty("CPP.COMPILE.OBJECTDECK", props.getProperty("CPP.COMPILE.OBJECTDECK"));
        resource.setPersistentProperty("CPP.COMPILE.SYSLIB", props.getProperty("CPP.COMPILE.SYSLIB"));
        resource.setPersistentProperty("CPP.COMPILE.USERLIB", props.getProperty("CPP.COMPILE.USERLIB"));
        resource.setPersistentProperty("CPP.COMPILE.SYSEVENT", props.getProperty("CPP.COMPILE.SYSEVENT"));
        resource.setPersistentProperty("CPP.COMPILE.ADDITIONALJCL", props.getProperty("CPP.COMPILE.ADDITIONALJCL"));
        resource.setPersistentProperty("CPP.COMPILE.CMAINMODULE", props.getProperty("CPP.COMPILE.CMAINMODULE"));
        resource.setPersistentProperty("CPP.COMPILE.CDATASETNAME", props.getProperty("CPP.COMPILE.CDATASETNAME"));
        resource.setPersistentProperty("CPP.COMPILE.COPTIONS", props.getProperty("CPP.COMPILE.COPTIONS"));
        resource.setPersistentProperty("CPP.COMPILE.CMACROS", props.getProperty("CPP.COMPILE.CMACROS"));
        resource.setPersistentProperty("CPP.COMPILE.CLISTINGOUTPUT", props.getProperty("CPP.COMPILE.CLISTINGOUTPUT"));
        resource.setPersistentProperty("CPP.COMPILE.COBJECTDECK", props.getProperty("CPP.COMPILE.COBJECTDECK"));
        resource.setPersistentProperty("CPP.COMPILE.CSYSLIB", props.getProperty("CPP.COMPILE.CSYSLIB"));
        resource.setPersistentProperty("CPP.COMPILE.CUSERLIB", props.getProperty("CPP.COMPILE.CUSERLIB"));
        resource.setPersistentProperty("CPP.COMPILE.CSYSEVENT", props.getProperty("CPP.COMPILE.CSYSEVENT"));
        resource.setPersistentProperty("CPP.COMPILE.CADDITIONALJCL", props.getProperty("CPP.COMPILE.CADDITIONALJCL"));
        resource.setPersistentProperty("CPP.COMPILE.USEC", props.getProperty("CPP.COMPILE.USEC"));
        resource.setPersistentProperty("CPP.STEP.OPTIONS", props.getProperty("CPP.STEP.OPTIONS"));
        resource.setPersistentProperty("CPP.STEP.ADDITIONALJCL", props.getProperty("CPP.STEP.ADDITIONALJCL"));
        resource.setPersistentProperty("CPP.STEP.COPTIONS", props.getProperty("CPP.STEP.COPTIONS"));
        resource.setPersistentProperty("CPP.STEP.CADDITIONALJCL", props.getProperty("CPP.STEP.ADDITIONALJCL"));
    }

    public void initializePropertyTabValues(IPhysicalResource resource, CPPSettingsPropertyPage page1) {
        this.page1 = page1;
        Properties props = new Properties();
        String cppCompileProcName = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.MAINMODULE");
        props.setProperty("CPP.COMPILE.MAINMODULE", cppCompileProcName);
        this.cppCompileProc = new JCLProcedure(cppCompileProcName, 25);
        this.cppCompileProc.setEnabled(true);
        this.fRoot.addJCLProcedure(this.cppCompileProc);
        String cCompileProcName = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.CMAINMODULE");
        props.setProperty("CPP.COMPILE.CMAINMODULE", cCompileProcName);
        this.cCompileProc = new JCLProcedure(cCompileProcName, 26);
        String useC = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.USEC");
        if (useC.equalsIgnoreCase("true")) {
            this.cCompileProc.setEnabled(true);
            this.cppCompileProc.setEnabled(false);
        } else {
            this.cCompileProc.setEnabled(false);
            this.cppCompileProc.setEnabled(true);
        }
        this.fRoot.addJCLProcedure(this.cCompileProc);
        String cppCompileStepName = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.DATASETNAME");
        props.setProperty("CPP.COMPILE.DATASETNAME", cppCompileStepName);
        this.createStepsFromProps(cppCompileStepName, 20, this.cppCompileProc);
        String cCompileStepName = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.CDATASETNAME");
        props.setProperty("CPP.COMPILE.CDATASETNAME", cCompileStepName);
        this.createStepsFromProps(cCompileStepName, 20, this.cCompileProc);
        String str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.OPTIONS");
        if (str2 != null) {
            props.setProperty("CPP.COMPILE.OPTIONS", str2);
        }
        if ((str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.MACROS")) != null) {
            props.setProperty("CPP.COMPILE.MACROS", str2);
        }
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.LISTINGOUTPUT");
        props.setProperty("CPP.COMPILE.LISTINGOUTPUT", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.OBJECTDECK");
        props.setProperty("CPP.COMPILE.OBJECTDECK", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.SYSLIB");
        props.setProperty("CPP.COMPILE.SYSLIB", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.USERLIB");
        props.setProperty("CPP.COMPILE.USERLIB", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.SYSEVENT");
        props.setProperty("CPP.COMPILE.SYSEVENT", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.ADDITIONALJCL");
        props.setProperty("CPP.COMPILE.ADDITIONALJCL", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.COPTIONS");
        if (str2 != null) {
            props.setProperty("CPP.COMPILE.COPTIONS", str2);
        }
        if ((str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.CMACROS")) != null) {
            props.setProperty("CPP.COMPILE.CMACROS", str2);
        }
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.CLISTINGOUTPUT");
        props.setProperty("CPP.COMPILE.CLISTINGOUTPUT", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.COBJECTDECK");
        props.setProperty("CPP.COMPILE.COBJECTDECK", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.CSYSLIB");
        props.setProperty("CPP.COMPILE.CSYSLIB", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.CUSERLIB");
        props.setProperty("CPP.COMPILE.CUSERLIB", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.CSYSEVENT");
        props.setProperty("CPP.COMPILE.CSYSEVENT", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.CADDITIONALJCL");
        props.setProperty("CPP.COMPILE.CADDITIONALJCL", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.COMPILE.USEC");
        props.setProperty("CPP.COMPILE.USEC", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.STEP.OPTIONS");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.OPTIONS", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.STEP.ADDITIONALJCL");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.ADDITIONALJCL", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.STEP.COPTIONS");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.COPTIONS", str2);
        str2 = this.physicalManager.getPropertyOrOverride(resource, "CPP.STEP.CADDITIONALJCL");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.CADDITIONALJCL", str2);
        this.rememberProperties(props);
        this.fTableViewer.setInput((Object)this.fRoot);
    }

    public void initializePropertyTabValues(ILogicalResource resource, CPPSettingsPropertyPage page1) {
        this.page1 = page1;
        Properties props = new Properties();
        String cppCompileProcName = resource.getPersistentProperty("CPP.COMPILE.MAINMODULE");
        props.setProperty("CPP.COMPILE.MAINMODULE", cppCompileProcName);
        this.cppCompileProc = new JCLProcedure(cppCompileProcName, 25);
        this.cppCompileProc.setEnabled(true);
        this.fRoot.addJCLProcedure(this.cppCompileProc);
        String cCompileProcName = resource.getPersistentProperty("CPP.COMPILE.CMAINMODULE");
        props.setProperty("CPP.COMPILE.CMAINMODULE", cCompileProcName);
        this.cCompileProc = new JCLProcedure(cCompileProcName, 26);
        String useC = resource.getPersistentProperty("CPP.COMPILE.USEC");
        if (useC.equalsIgnoreCase("true")) {
            this.cCompileProc.setEnabled(true);
            this.cppCompileProc.setEnabled(false);
        } else {
            this.cCompileProc.setEnabled(false);
            this.cppCompileProc.setEnabled(true);
        }
        this.fRoot.addJCLProcedure(this.cCompileProc);
        String cppCompileStepName = resource.getPersistentProperty("CPP.COMPILE.DATASETNAME");
        props.setProperty("CPP.COMPILE.DATASETNAME", cppCompileStepName);
        this.createStepsFromProps(cppCompileStepName, 20, this.cppCompileProc);
        String cCompileStepName = resource.getPersistentProperty("CPP.COMPILE.CDATASETNAME");
        props.setProperty("CPP.COMPILE.CDATASETNAME", cCompileStepName);
        this.createStepsFromProps(cCompileStepName, 20, this.cCompileProc);
        String str2 = resource.getPersistentProperty("CPP.COMPILE.OPTIONS");
        if (str2 != null) {
            props.setProperty("CPP.COMPILE.OPTIONS", str2);
        }
        if ((str2 = resource.getPersistentProperty("CPP.COMPILE.MACROS")) != null) {
            props.setProperty("CPP.COMPILE.MACROS", str2);
        }
        str2 = resource.getPersistentProperty("CPP.COMPILE.LISTINGOUTPUT");
        props.setProperty("CPP.COMPILE.LISTINGOUTPUT", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.OBJECTDECK");
        props.setProperty("CPP.COMPILE.OBJECTDECK", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.SYSLIB");
        props.setProperty("CPP.COMPILE.SYSLIB", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.USERLIB");
        props.setProperty("CPP.COMPILE.USERLIB", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.SYSEVENT");
        props.setProperty("CPP.COMPILE.SYSEVENT", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.ADDITIONALJCL");
        props.setProperty("CPP.COMPILE.ADDITIONALJCL", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.COPTIONS");
        if (str2 != null) {
            props.setProperty("CPP.COMPILE.COPTIONS", str2);
        }
        if ((str2 = resource.getPersistentProperty("CPP.COMPILE.CMACROS")) != null) {
            props.setProperty("CPP.COMPILE.CMACROS", str2);
        }
        str2 = resource.getPersistentProperty("CPP.COMPILE.CLISTINGOUTPUT");
        props.setProperty("CPP.COMPILE.CLISTINGOUTPUT", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.COBJECTDECK");
        props.setProperty("CPP.COMPILE.COBJECTDECK", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.CSYSLIB");
        props.setProperty("CPP.COMPILE.CSYSLIB", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.CUSERLIB");
        props.setProperty("CPP.COMPILE.CUSERLIB", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.CSYSEVENT");
        props.setProperty("CPP.COMPILE.CSYSEVENT", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.CADDITIONALJCL");
        props.setProperty("CPP.COMPILE.CADDITIONALJCL", str2);
        str2 = resource.getPersistentProperty("CPP.COMPILE.USEC");
        props.setProperty("CPP.COMPILE.USEC", str2);
        str2 = resource.getPersistentProperty("CPP.STEP.OPTIONS");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.OPTIONS", str2);
        str2 = resource.getPersistentProperty("CPP.STEP.ADDITIONALJCL");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.ADDITIONALJCL", str2);
        str2 = resource.getPersistentProperty("CPP.STEP.COPTIONS");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.COPTIONS", str2);
        str2 = resource.getPersistentProperty("CPP.STEP.CADDITIONALJCL");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.CADDITIONALJCL", str2);
        this.rememberProperties(props);
        this.fTableViewer.setInput((Object)this.fRoot);
    }

    public void initializePropertyTabValues(ICategoryInstance instance, CPPSettingsPropertyPage page1) {
        this.instance = instance;
        this.page1 = page1;
        Properties props = new Properties();
        String cppCompileProcName = this.getInstanceValue(instance, "CPP_COMPILE_JCL_PROCEDURE_NAME");
        props.setProperty("CPP.COMPILE.MAINMODULE", cppCompileProcName);
        this.cppCompileProc = new JCLProcedure(cppCompileProcName, 25);
        this.cppCompileProc.setEnabled(true);
        this.fRoot.addJCLProcedure(this.cppCompileProc);
        String cCompileProcName = this.getInstanceValue(instance, "C_COMPILE_JCL_PROCEDURE_NAME");
        props.setProperty("CPP.COMPILE.CMAINMODULE", cCompileProcName);
        this.cCompileProc = new JCLProcedure(cCompileProcName, 26);
        String useC = this.getInstanceValue(instance, "CPP_COMPILE_USEC");
        if (useC.equalsIgnoreCase("true")) {
            this.cCompileProc.setEnabled(true);
            this.cppCompileProc.setEnabled(false);
        } else {
            this.cCompileProc.setEnabled(false);
            this.cppCompileProc.setEnabled(true);
        }
        this.fRoot.addJCLProcedure(this.cCompileProc);
        String cppCompileStepName = this.getInstanceValue(instance, "CPP_COMPILE_JOB_STEPS");
        props.setProperty("CPP.COMPILE.DATASETNAME", cppCompileStepName);
        this.createStepsFromProps(cppCompileStepName, 20, this.cppCompileProc);
        String cCompileStepName = this.getInstanceValue(instance, "C_COMPILE_JOB_STEPS");
        props.setProperty("CPP.COMPILE.CDATASETNAME", cCompileStepName);
        this.createStepsFromProps(cCompileStepName, 20, this.cCompileProc);
        String str2 = this.getInstanceValue(instance, "CPP_COMPILE_OPTIONS");
        if (str2 != null) {
            props.setProperty("CPP.COMPILE.OPTIONS", str2);
        }
        if ((str2 = this.getInstanceValue(instance, "CPP_COMPILE_MACROS")) != null) {
            props.setProperty("CPP.COMPILE.MACROS", str2);
        }
        str2 = this.getInstanceValue(instance, "CPP_LISTING_DATASET");
        props.setProperty("CPP.COMPILE.LISTINGOUTPUT", str2);
        str2 = this.getInstanceValue(instance, "CPP_OBJECT_DATASET");
        props.setProperty("CPP.COMPILE.OBJECTDECK", str2);
        str2 = this.getInstanceValue(instance, "CPP_COMPILE_SYSLIB");
        props.setProperty("CPP.COMPILE.SYSLIB", str2);
        str2 = this.getInstanceValue(instance, "CPP_COMPILE_USERLIB");
        props.setProperty("CPP.COMPILE.USERLIB", str2);
        str2 = this.getInstanceValue(instance, "CPP_COMPILE_SYSEVENT");
        props.setProperty("CPP.COMPILE.SYSEVENT", str2);
        str2 = this.getInstanceValue(instance, "CPP_COMPILE_ADDITIONALJCL");
        props.setProperty("CPP.COMPILE.ADDITIONALJCL", str2);
        str2 = this.getInstanceValue(instance, "C_COMPILE_OPTIONS");
        if (str2 != null) {
            props.setProperty("CPP.COMPILE.COPTIONS", str2);
        }
        if ((str2 = this.getInstanceValue(instance, "C_COMPILE_MACROS")) != null) {
            props.setProperty("CPP.COMPILE.CMACROS", str2);
        }
        str2 = this.getInstanceValue(instance, "C_LISTING_DATASET");
        props.setProperty("CPP.COMPILE.CLISTINGOUTPUT", str2);
        str2 = this.getInstanceValue(instance, "C_OBJECT_DATASET");
        props.setProperty("CPP.COMPILE.COBJECTDECK", str2);
        str2 = this.getInstanceValue(instance, "C_COMPILE_SYSLIB");
        props.setProperty("CPP.COMPILE.CSYSLIB", str2);
        str2 = this.getInstanceValue(instance, "C_COMPILE_USERLIB");
        props.setProperty("CPP.COMPILE.CUSERLIB", str2);
        str2 = this.getInstanceValue(instance, "C_COMPILE_SYSEVENT");
        props.setProperty("CPP.COMPILE.CSYSEVENT", str2);
        str2 = this.getInstanceValue(instance, "C_COMPILE_ADDITIONALJCL");
        props.setProperty("CPP.COMPILE.CADDITIONALJCL", str2);
        str2 = this.getInstanceValue(instance, "CPP_COMPILE_USEC");
        props.setProperty("CPP.COMPILE.USEC", str2);
        str2 = this.getInstanceValue(instance, "CPP_ADDED_STEP_OPTIONS");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.OPTIONS", str2);
        str2 = this.getInstanceValue(instance, "CPP_ADDED_STEP_ADDITIONAL_JCL");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.ADDITIONALJCL", str2);
        str2 = this.getInstanceValue(instance, "C_ADDED_STEP_OPTIONS");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.COPTIONS", str2);
        str2 = this.getInstanceValue(instance, "C_ADDED_STEP_ADDITIONAL_JCL");
        if (str2 == null) {
            str2 = "";
        }
        props.setProperty("CPP.STEP.CADDITIONALJCL", str2);
        this.rememberProperties(props);
        this.fTableViewer.setInput((Object)this.fRoot);
    }

    public void initializeWizardPage(Properties fProperties, String dirName, GenericCPPSettingsPage page) {
        this.page = page;
        this.populatePageValues(fProperties, dirName);
    }

    public void doCheckboxShading() {
        this.updateButtons();
    }

    public Object getValue(Object element, String property) {
        Object value = "";
        if (element instanceof JCLProcedure) {
            JCLProcedure proc = (JCLProcedure)element;
            value = proc.isEnabled() ? new Integer(1) : new Integer(0);
        }
        return value;
    }

    public boolean canModify(Object element, String property) {
        if (element instanceof JCLProcedure) {
            this.currCellEditor = this.enabledCellEditor;
            return true;
        }
        return false;
    }

    public void modify(Object element, String property, Object value) {
        TableTreeItem item = (TableTreeItem)element;
        if (item.getData() instanceof JCLProcedure) {
            JCLProcedure proc = (JCLProcedure)item.getData();
            Integer val = (Integer)value;
            boolean trueOrFalse = val != 0;
            this.updateProcStatus(proc, trueOrFalse);
            this.updateButtons();
            this.fTableViewer.update((Object)item, null);
            this.fTableViewer.refresh();
        }
    }

    private void updateProcStatus(JCLProcedure proc, boolean trueOrFalse) {
        String trueOrFalseString = "FALSE";
        if (trueOrFalse) {
            trueOrFalseString = "TRUE";
        }
        proc.setEnabled(trueOrFalse);
        Properties properties = this.getRememberedProperties();
        if (proc.getName().equals(this.cCompileProc.getName())) {
            properties.setProperty("CPP.COMPILE.USEC", trueOrFalseString);
            this.cppCompileProc.setEnabled(!trueOrFalse);
        } else {
            properties.setProperty("CPP.COMPILE.USEC", trueOrFalseString.equals("TRUE") ? "FALSE" : "TRUE");
            this.cCompileProc.setEnabled(!trueOrFalse);
        }
        this.rememberProperties(properties);
    }

    private void createColumns() {
        int i = 0;
        while (i < columnHeaders.length) {
            this.tableLayout.addColumnData(columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(CPPTab.columnLayouts[i].resizable);
            tc.setText(columnHeaders[i]);
            ++i;
        }
    }

    public void removeProcsAndSteps() {
        Vector v = this.fRoot.getJCLProcs();
        int i = 0;
        while (i < v.size()) {
            JCLProcedure proc = (JCLProcedure)v.elementAt(i);
            Vector steps = proc.getSteps();
            int j = 0;
            while (j < steps.size()) {
                JCLProcedureStep step = (JCLProcedureStep)steps.elementAt(j);
                int type = step.getType();
                switch (type) {
                    case 21: {
                        proc.removeStep(step);
                        break;
                    }
                    default: {
                        proc.removeStep(step);
                    }
                }
            }
            this.fRoot.removeJCLProcedure(proc);
        }
    }

    public void updateInstance() {
        if (this.instance != null) {
            this.setMvsFilesProperties();
        }
    }
}

