/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.ui.propertypages;

import com.ibm.cdz.remote.ui.Messages;
import com.ibm.cdz.remote.ui.composites.HierarchyChoiceComposite;
import com.ibm.ftt.cdz.ui.composites.RemoteIncludesForm;
import com.ibm.ftt.cdz.ui.propertypages.AbstractCPropertyPage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class RemoteIncludesPropertyPage
extends AbstractCPropertyPage {
    private RemoteIncludesForm _sysIncludesForm;
    private RemoteIncludesForm _usrIncludesForm;
    private HierarchyChoiceComposite _choiceComp;
    private boolean _useSSProperties;

    protected String getInitialSystemIncludes() {
        String sysincludesStr = this.getSubSystem().getVendorAttribute("com.ibm.cdz", "system.includes");
        if (sysincludesStr == null) {
            sysincludesStr = "/usr/include";
        }
        if (this.isPropertiesForFile() && !this._useSSProperties) {
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            String localsysincludesStr = this.getSubSystem().getVendorAttribute("com.ibm.cdz" + absolutePath, "system.includes");
            if (localsysincludesStr != null) {
                sysincludesStr = localsysincludesStr;
            }
        }
        return sysincludesStr;
    }

    protected String getInitialUserIncludes() {
        String userincludesStr = this.getSubSystem().getVendorAttribute("com.ibm.cdz", "user.includes");
        if (this.isPropertiesForFile() && !this._useSSProperties) {
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            String localuserincludesStr = this.getSubSystem().getVendorAttribute("com.ibm.cdz" + absolutePath, "user.includes");
            if (localuserincludesStr != null) {
                userincludesStr = localuserincludesStr;
            }
        }
        return userincludesStr;
    }

    protected void setSystemIncludes(String newIncludes) {
        if (this.isPropertiesForFile()) {
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            this.getSubSystem().setVendorAttribute("com.ibm.cdz" + absolutePath, "system.includes", newIncludes);
        } else {
            this.getSubSystem().setVendorAttribute("com.ibm.cdz", "system.includes", newIncludes);
        }
    }

    protected void setUserIncludes(String newIncludes) {
        if (this.isPropertiesForFile()) {
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            this.getSubSystem().setVendorAttribute("com.ibm.cdz" + absolutePath, "user.includes", newIncludes);
        } else {
            this.getSubSystem().setVendorAttribute("com.ibm.cdz", "user.includes", newIncludes);
        }
    }

    protected Control createContentArea(Composite parent) {
        if (this.isPropertiesForFile()) {
            this._choiceComp = new HierarchyChoiceComposite();
            this._choiceComp.createContents(parent);
            this._choiceComp.addSelectionChangedListener((Listener)this);
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            String useSubSystemProperties = this.getSubSystem().getVendorAttribute("com.ibm.cdz" + absolutePath, "Include.UseSubSystem.Properties");
            this._useSSProperties = useSubSystemProperties == null || useSubSystemProperties.equals("true");
            this._choiceComp.setUseSubSystemSettings(this._useSSProperties);
        }
        SystemWidgetHelpers.createLabel((Composite)parent, (String)Messages.RemoteIncludesForm_Verbage);
        String usrPrompt = Messages.RemoteIncludesForm_UserIncludes;
        this._usrIncludesForm = new RemoteIncludesForm(this.getMessageLine(), this.getSubSystem(), usrPrompt);
        this._usrIncludesForm.createContents(parent);
        String sysPrompt = Messages.RemoteIncludesForm_SystemIncludes;
        this._sysIncludesForm = new RemoteIncludesForm(this.getMessageLine(), this.getSubSystem(), sysPrompt);
        Control sysControl = this._sysIncludesForm.createContents(parent);
        this.initForms();
        return sysControl;
    }

    protected void initForms() {
        String sysincludesStr = this.getInitialSystemIncludes();
        this._sysIncludesForm.setIncludes(sysincludesStr);
        this._sysIncludesForm.updateIncludes();
        String userincludesStr = this.getInitialUserIncludes();
        this._usrIncludesForm.setIncludes(userincludesStr);
        this._usrIncludesForm.updateIncludes();
        this._sysIncludesForm.setEnabled(!this._useSSProperties);
        this._usrIncludesForm.setEnabled(!this._useSSProperties);
    }

    protected boolean verifyPageContents() {
        return true;
    }

    public boolean performOk() {
        if (this.isPropertiesForFile()) {
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            this.getSubSystem().setVendorAttribute("com.ibm.cdz" + absolutePath, "Include.UseSubSystem.Properties", this._useSSProperties ? "true" : "false");
        }
        if (!this.isPropertiesForFile() || !this._useSSProperties) {
            String sysincludes = this._sysIncludesForm.getIncludes();
            this.setSystemIncludes(sysincludes);
            String userincludes = this._usrIncludesForm.getIncludes();
            this.setUserIncludes(userincludes);
        }
        return true;
    }

    public void handleEvent(Event event) {
        this._useSSProperties = event.data == Boolean.TRUE;
        this.initForms();
    }
}

